/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMSD/MSDTYPE.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MSDTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  MSD Class device driver TYPEDEF  and flag definition  */
/*                      include file.                                         */
/*                                                                            */
/*   FUNCTION: This module is the MSD Class device driver                     */
/*             TYPEDEF and flag definition include file.                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark      yy/mm/dd  Programmer    Comment                                 */
/*  --------- --------  ----------    -------                                 */
/*            99/05/10  MB                                                    */
/* 18/01/2000 00/01/18  MB            Added device group definitions          */
/* 10/02/2000 00/10/02  MB            Added Newer Technology vendor/device    */
/*                                    ID definitions, updated timeout         */
/*                                    definitions                             */
/* LR0420     01/04/20  LR            Added Complete Initialization WaitTime. */
/* LR0531     01/05/31  LR            Increased Complete Initialization       */
/*                                    WaitTime to support boot from diskettes */
/*                                    on legacy free PC.                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

// initialization time message IDs
#define  INIT_MESSAGE_LOADED        0
#define  INIT_MESSAGE_NO_USBD       1
#define  INIT_MESSAGE_INVNUMERIC    2
#define  INIT_MESSAGE_UNKNOWNKWD    3
#define  INIT_MESSAGE_SETCTXFAILED  4
#define  INIT_MESSAGE_SETTMEFAILED  5
#define  INIT_MESSAGE_AREG_FAILED   6

// max no of messages in message queue
#define  MAX_INIT_MESSAGE_COUNT     2

#define  PARM_OFFSET                2

#define  MSD_DEVICE_RETRIES         5                                         
#define  MSD_TIMER_UNIT             18 // (==1 s)
// default timeout value for any USB MSD device in hundreds of ms (depending on MSD_TIMER_UNIT)

#define  MSD_PTH_TIMEOUT            15  // path through command timeout (s)  //  10/02/2000 MB
#define  MSD_DEF_TIMEOUT            100 // device timeout (s)
#define  MSD_NEWER_TIMEOUT          5   // device timeout used for Newer Technologies Floppy device // 10/02/2000 MB
#define  MSD_FTRACK_TIMEOUT         150 // format in progress  // 10/02/2000 MB
#define  MSD_SENSE_TIMEOUT          10  // sense data retrieve timeout (s)
#define  MSD_ATTACH_TIMEOUT         20  // device attach timeout (s)
#define  MSD_DETACH_TIMEOUT         1   // timeout used to cancel request on detached device
#define  MSD_DEBUG_TIMEOUT          15  // device debug timeout (s)
#define  MSD_COMPL_INIT_WAITTIME    10*1000  //LR0420,LR0531 Complete Initialization WaitTime (ms)

#define  UF_LARGE_FLOPPY            0x0400         // Treat removable as Large Floppy
#define  US_MEDIA_LARGE_FLOPPY      0x0004         // > 2.88 Floppies

//  'A' drive flag usage options
#define  AUSAGE_OFF                 0x00  // 'A' flag never used 
#define  AUSAGE_ON                  0x01  // 'A' flag always used
#define  AUSAGE_SEARCH              0x02  // used only if not reserved by other driver

#define  MAX_DEVICES                52    // max device table entry count

#define  MAX_BULK_BUFFSIZE          16384 // max buffer length passed to USBD
#define  MIN_BULK_BUFFSIZE          64    // min buffer length passed to USBD

// Mass Storage Device class subclass codes (command set codes)
#define  MSD_SUBCLASS_RBC           0x01  // Reduced Block Commands
#define  MSD_SUBCLASS_SFF8020I      0x02  // SFF 8020I command set
#define  MSD_SUBCLASS_QIC157        0x03  // QIC-157 command set
#define  MSD_SUBCLASS_UFI           0x04  // USB UFI command set
#define  MSD_SUBCLASS_SFF8070I      0x05  // SFF 8070I command set
#define  MSD_SUBCLASS_SCSI          0x06  // SCSI transparent command set

// Mass Storage Device class protocol codes
#define  MSD_PROTOCOL_CBI_I         0x00  // Control/Bulk/Interrupt (with interrupt on command complete)
#define  MSD_PROTOCOL_CBI_NI        0x01  // Control/Bulk/Interpret (with no interrupt on command complete)
#define  MSD_PROTOCOL_IOMEGA        0x50  // used by IOMEGA USB ZIP 100
#define  MSD_PROTOCOL_VENDOR_IDE    0xfe  // used for vendor IDE  // 05/17/2000 MB

// Winstation LS-120 vendor/device constants
#define  USB_VENDOR_WINSTATION      0x04e6   // Winstation
#define  WINSTATION_LS120           0x0001   // winstation LS120 USB product ID

// HP CD-Writer Plus 8200 vendor/device constants
#define  USB_VENDOR_HP              0x03f0   // Hewlett Packard
#define  HP_CDR_8200                0x0107   // HP CD-Writer Plus 8200 USB product ID

// SONY Spressa CD-RW vendor/device constants
#define  USB_VENDOR_SONY            0x55AA   // SONY
#define  SONY_SPRESSA_100           0x1234   // SONY Spressa CD-RW 100 USB product ID
#define  SONY_13GB_HD               0x0100   // USBGear HDD

// Fantom Drives vendor/device constants
#define  USB_VENDOR_FANTOM          0x05ab   // Fantom
#define  FANTOM_HDD                 0x0200   // Fantom HDD USB product ID

// Newer Technologies floppy vendor/device constants  // 10/02/2000 MB
#define  USB_VENDOR_NEWER           0x06ca   // Newer Technologies
#define  NEWER_FLPPY                0x3820   // Newer Technologies FDD USB product ID

#define  MAX_MSD_COMMANDS           1
#define  MAX_MSD_CMD_BUFFER        64
#define  MSD_INTERRUPT_LENGTH       2  // CBI MSD Interrupt Data Block Length
#define  MSD_INTERRUPT_TYPE         0  // index
#define  MSD_INTERRUPT_VALUE        1  // index
#define  MSD_INT_TYPE_COMPL         0  // command completion interrupt
#define  MSD_INT_VALUE_MASK         3  // index

#define  MSD_CB_STATUS_PASSED       0
#define  MSD_CB_STATUS_FAILED       1
#define  MSD_CB_STATUS_PHASERR      2  // phase error
#define  MSD_CB_STATUS_PERSFAIL     3  // persistent failure

// 18/01/2000 MB
typedef  struct   _groupDef_
{
   PSZ         driverName;          // 0  class driver name
   USHORT      defCount;            // 4  default no of devices in group if device class driver not installed
   USHORT      defCountDP;          // 6  default no of devices in group if device class driver is installed
   USHORT      firstIndex;          // 8  index to the 1st entry in device table belonging to this group
   USHORT      lastIndex;           // 10 index to the 1st entry in device table belonging to next group
   USHORT      count;               // 12 device count in this group
   USHORT      adapterDevBus;       // 14 group adapter bus type
   USHORT      unitType;            // 16 group unit type
   USHORT      unitFlags;           // 18 group unit flags
                                    // 20
}  DeviceGroup;

// 03/05/2000 MB - structure to store vendor specific device information
#define  MSD_SDEVICE_COUNT          5  // no of vendor specific devices in table
#define  MSD_ENTRY_NOTUSED          -1
typedef  struct   _sDevList_
{
   SHORT    bDeviceClass;           // (00) Class Code
   SHORT    bDeviceSubClass;        // (02) SubClass Code
   SHORT    bDeviceProtocol;        // (04) Protocol Code
   USHORT   idVendor;               // (06) Vendor ID
   USHORT   idProduct;              // (08) Product ID
   USHORT   bcdDevice;              // (10) Device release number
   UCHAR    subClass;               // (12) device subClass (comand set) code
   UCHAR    protocol;               // (13) device communication protocol code
   SHORT    altInterface;           // (14) device interface index
   SHORT    interfaceIndex;         // (16) device interface index
                                    // (18)
}  SDeviceList;

#define  MSD_DEVICE_GROUP_COUNT     6

#define  MSD_FLOPPY_GROUP           0
#define  MSD_REMOVABLE_GROUP        1
#define  MSD_FIXED_GROUP            2
#define  MSD_CD_GROUP               3
#define  MSD_OPTICAL_GROUP          4
#define  MSD_ATTACH_GROUP           5
// 18/01/2000 MB

//       Command Block Wrapper

#define  CBW_SIGNATURE  0x43425355L // = "USBC", Command Block Wrapper Signature
#define  CBW_FLAGS_IN         0x80  // Direction: data in
#define  CB_MAX_LENGTH          16  // Command Block Max Length

typedef  struct _CBWrapper
{                                // byte
   ULONG    dSignature;          // 0  = 0x43425355L = "USBC"
   ULONG    dTag;                // 4  is not interpreted or altered by the MSD and
                                 //    echoed by the MSD in the CSW
   ULONG    dDataTrLength;       // 8  in bytes; if is set to 0, no data will be transferred
   UCHAR    bFlags;              // C  Bit7-Direction: 0 = data out, 1 = data in; Bits 6...0 reserved
   UCHAR    bLUN;                // D  Logical Unit Number
   UCHAR    bCBLength;           // E  valid Length of the Command Block
   UCHAR    cb[CB_MAX_LENGTH];   // F  Command Block to be executed by the device

}  CBWrapper;

//       Command Status Wrapper

#define  CSW_SIGNATURE           0x53425355L // = "USBS", Command Status Wrapper Signature

typedef  struct _CSWrapper
{                          // byte
   ULONG    dSignature;    // 0  = 0x53425355L = "USBS"
   ULONG    dTag;          // 4  the MSD shall echo this value as received in the CBW
   ULONG    dDataResidue;  // 8  dDataTrLength - the actual amount transferred to/from the MSD
   UCHAR    bStatus;       // C  indicates the success or failure of the command

}  CSWrapper;

// Indexes into the Geometry[] table 
#define  DEVICE               0           // Max geometry for the drive    
#define  MEDIA                1           // Geometry of the current media
#define  LOGICAL              2           // logical geometry
#define  FORMAT               3           // media geometry (used in format requests)

//  MSD device entry data structure
typedef struct _deviceList
{
   DeviceInfo FAR             *pDeviceInfo;     // (00) far pointer to device data
   DeviceConfiguration FAR    *devConf;         // (04) far pointer to device configuration data
   SetupPacket                stdPacket;        // (08) setup packet buffer
   SetupPacket                cstPacket[4];     // (16) setup packet buffers to clear stalled endpoints
   UCHAR                      interfaceIndex;   // (48) device interface index
   UCHAR                      subClass;         // (49) device subClass (comand set) code
   UCHAR                      protocol;         // (50) device communication protocol code
   UCHAR                      blkInEndpoint;    // (51) bulk in endpoint address
   UCHAR                      blkOutEndpoint;   // (52) bulk out endpoint address
   UCHAR                      intrptEndpoint;   // (53) interrupt endpoint address
   USHORT                     entryIndex;       // (54) device data entry index
   USHORT                     attachStatus;     // (56) internal command index
   // IORB queue pointers
   PIORBH                     pIORB;            // (58) pointer current IORB
   PIORBH                     pHeadIORB;        // (62) pointer to the first IORB in queue
   PIORBH                     pFootIORB;        // (66) pointer to the last IORB in queue
   USHORT                     CommandCode;      // (70) current command code
   USHORT                     CommandModifier;  // (72) current command modifier code
   // state machine items
   USHORT                     status;           // (74) processing state
   USHORT                     errorCode;        // (76) request processing error code
   USHORT                     retryCount;       // (78) error retry count
   ULONG                      timeValue;        // (80) request timer value (s)
   ULONG                      calcTimeValue;    // (84) calculated request timeout value (s)
   // device flags and characteristics data                                           
   ULONG                      flags;            // (88) device status flags
   GEOMETRY                   Geometry[4];      // (92) Device geometry and media geometry
   USHORT                     motorOnDelay;     // (156) motor on delay in 1/10 s
   UCHAR                      devType;          // (158) device type code from INQUIRY command
   UCHAR                      altInterface;     // (159) reserved - alternate interface setting
   //   
   PUNITINFO                  pUnitInfo;        // (160) replacement UNITINFO from filter ADD
   // scatter/gather buffer information
   USHORT                     cSGList;          // (164) scatter/gather buffer item count
   PSCATGATENTRY              pSGList;          // (166) pointer to scatter gather list

   USHORT                     wNCommands;                //  (170) Number of Commands
   CBWrapper                  cbw[MAX_MSD_COMMANDS];     //  (172) Command Block  Wrappers
   PUCHAR                     pTrData;                   //  (203) far pointer to Transport Data
   USHORT                     wTrLength;                 //  (207) Transport data Length
   CSWrapper                  csw;                       //  (209) Command Status Wrapper
   USHORT                     wFlags;                    //  (222) transport layer 
   ULONG                      dTrCount;                  //  (224)  Transported byte Count
   UCHAR                      bIntData[MSD_INTERRUPT_LENGTH];// (228) CBI interrupt buffer
   SCSI_REQSENSE_DATA         senseData;                 // (230) unit sense data buffer
   UCHAR                      cmdDataBuffer[MAX_MSD_CMD_BUFFER];  // (248) data buffer
   VOID                       (*timerCBack)(struct _deviceList *pCurrDevice);   // (312)
   USHORT                     deviceGroupIndex;          // (314) 
   PDMDCBK                    dmdCallback; //   (316) address of device manager callback routine   // 28/01/2000 MB
   ULONG                      dmdDeviceId;               // (320) data used in DMD to identify current device  // 28/01/2000 MB
   ULONG                      blockCount; // (324) block count used in current execute i/o request // 08/01/2000 MB
   //   (328)
}  DeviceList;

// Device Flags definitions
#define UCBF_ALLOCATED        0x00000001L       // device is allocated
#define UCBF_LOCKED           0x00100000L       // device is locked  

// USB support flags
#define UCBF_ATTCOMPLETE      0x80000000L       // USB device attach process completed
#define UCBF_PGEOMRETR        0x40000000L       // physical geometry information retrieved
#define UCBF_MGEOMRETR        0x20000000L       // logical geometry information retrieved
#define UCBF_LGEOMRETR        0x10000000L       // user's logical geometry information set
#define UCBF_FGEOMRETR        0x08000000L       // format geometry set
#define UCBF_USBFLP           0x04000000L       // floppy device flag
#define UCBF_RETRYON          0x02000000L       // request retried
#define UCBF_USESENSEBUFF     0x01000000L       // if on sense buffer is used for internal data transfers
#define UCBF_CSWRETRY         0x00800000L       // on if error recovery
#define UCBF_REQSENSE         0x00400000L       // on if request sense running
#define UCBF_SENSEAVAIL       0x00200000L       // on if sense data available
#define UCBF_TIMEOUTRESET     0x00080000L       // on if reset after timeout is running
#define UCBF_TRESETCOMPL      0x00040000L       // on if reset after timeout is completed
#define UCBF_DEVICEDETACHED   0x00020000L       // device was detached
#define UCBF_ATTACHFAILED     0x00010000L       // attach process failed
#define UCBF_IORBMARKDONE     0x00008000L       // request block marked done before operation completed
#define UCBF_REMOVABLEMEDIA   0x00004000L       // removable media device
#define UCBF_ABORTINPROGRESS  0x00002000L       // abort on queue requests in progress
#define UCBF_DMDCALLED        0x00001000L       // DMD callback routine called
#define UCBF_FMT_INPRGSS      0x00000800L       // FORMAT in progress detected //   10/02/2000 MB
#define UCBF_EXE_DELAYED      0x00000400L       // execution delayed //   10/02/2000 MB

// clear stalled buffer indexes
#define  CLRSTALLED_BULKIN    0
#define  CLRSTALLED_BULKOUT   1
#define  CLRSTALLED_INTRPT    2
#define  CLRSTALLED_CONTRL    3

// state machine status values
#define  MSD_STATUS_START     0
#define  MSD_STATUS_WAIT      1
#define  MSD_STATUS_DONE      2
#define  MSD_STATUS_SUSPEND   3

// USB MSD class specific setup packet values
#define  MSD_DEFAULT_WVALUE   0
#define  MSD_RESET_WVALUE     1

//       Mass Storage Device Requests
#define  REQUEST_CBI_ADSC        0  // CBI transport - Accept Device-Specific Command
#define  REQUEST_BO_RESET     0xFF  // Bulk-Only transport - Reset

//       MSD Command Block
#define  CB_OPERATION_CODE       0  // index
#define  CB_BIT_SELF_TEST        4  // Send Diagnostic Command Block, Byte 1, Bit 2
//    = 1 = perform default self-test 
//    = 0 = perform special diagnostic test

//       Transport Flags
#define  WRITE_DATA_TOGGLE       1
#define  READ_DATA_TOGGLE        2
#define  READ_INTERRUPT_TOGGLE   4

//       IRQs
#define  MSD_IRQ_STATUS_SETCONF     0
#define  MSD_IRQ_RESET              1
#define  MSD_IRQ_COMMAND_SENT       2
#define  MSD_IRQ_DATA_SENT          3
#define  MSD_IRQ_STATUS_DATA_READ   4
#define  MSD_IRQ_INTERRUPT          5
#define  MSD_IRQ_CLEARED            6
#define  MSD_IRQ_STATUS_SETAINTF    7

/////////////////////////////////////////////////////////////////////
// command generator/convertor definitions                ///////////
/////////////////////////////////////////////////////////////////////

// attach command definition structure
typedef struct _attachCmds_
{
   VOID        (*fAttCMD)(DeviceList *pCurrDevice);
   USHORT      commandCode;            // SCSI command code
   UCHAR       execFlags;              // execution flags
   UCHAR       flags;                  // SCSI command flags
   ULONG       logicalBlockAddress;    // SCSI LBA value
   ULONG       blockLength;            // SCSI block count
   ULONG       cmdExtra;               // SCSI extra command data (like for CD commands)
   ULONG       dataLength;             // transfer byte count
}  AttachCommands;

// attach command sequence flags
#define  ATTACH_EFLAGS_LAST            0x80  // item is last in chain - no more commands will be executed
#define  ATTACH_EFLAGS_NULL            0x00  // no special features defined, sequence will be stopped if error
#define  ATTACH_EFLAGS_NEXTERR         0x01  // error will be ignored and next command will be executed
#define  ATTACH_EFLAGS_SBUF            0x02  // sense buffer must be used as data buffer
#define  ATTACH_EFLAGS_SKPIFERR        0x04  // skip next command if error
#define  ATTACH_EFLAGS_SKPIFNERR       0x08  // skip next command if no error

// command definition structure
typedef struct _protCmds_
{
   UCHAR       subClass;      // command subclass code
   UCHAR       flags;         // flags (last or chained command)
   UCHAR       cmdCode;       // SCSI command code
   UCHAR       classCmdCode;  // class specific command code
   UCHAR       direction;     // data transfer direction (1 - in, 0 - out)
   UCHAR       flagMask;      // command flag byte mask
   UCHAR       lbaLength;     // logical block address field length
   UCHAR       lbaOffset;     // lba field address offset
   ULONG       lbaMask;       // lba field mask
   UCHAR       lenLength;     // length of length field
   UCHAR       lenOffset;     // length field offset
   ULONG       lenMask;       // length field mask
   UCHAR       extLength;     // length of extra data
   UCHAR       extOffset;     // extra data offset
   ULONG       extMask;       // extra field mask
   UCHAR       maxLength;     // class command length
}  ClassCommands;

// SCSI mode sense header structure
typedef struct __ModeHeader_
{
   USHORT      dataLength;       // total data length in big endian form
   UCHAR       mediumTypeCode;   // medium type code
   UCHAR       flags;            // device specific parameters
   UCHAR       reserved[4];
} ModeHeader;

typedef struct _FlexibleDiskPage_
{
   UCHAR       pageCode;            // 0x05 - flexible disk page code
   UCHAR       pageLength;          // page length in bytes
   USHORT      transferRate;        // device transfer data rate
   UCHAR       noOfHeads;           // no of heads
   UCHAR       sectorsPerTrack;     // sector count per track
   USHORT      dataBytesPerSector;  // sector size in bytes in big endian form
   USHORT      noOfCylinders;       // no of cylinders in big endian form
   UCHAR       reserved1[9];
   UCHAR       motorOnDelay;        // motor on delay in 1/10 s
   UCHAR       motorOffDelay;       // motor off delay in 1/10 s
   UCHAR       reserved2[7];
   USHORT      mediumRotationRate;  // medium rotation rate in big endian form
   UCHAR       reserved3[2];
}  FlexibleDiskPage;

// command description flags
#define  CCMD_LAST                     0   // last command
#define  CCMD_CHAN                     1   // chained commands
#define  CCMD_MULL                     2   // command with length variations
#define  CCMD_LMUL                     CCMD_LAST | CCMD_MULL   // last with length variations
#define  CCMD_CMUL                     CCMD_CHAN | CCMD_MULL   // chained with length variations

#define  CMD_MASK                      0x1f  // SCSI command code mask

#define  CMD6_BLKADD_MASK              0x001fffff  // 6 byte SCSI command block address mask

#define  SCSI_MODE_FLEXIBLEDSK_PAGE    0x05  // mode sense flexible disk page ID
#define  SCSI_SELFTEST_DEFAULT_TEST    0x04  // perform default self test
#define  SCSI_SENSE_CURRENT_ERRORS     0x70  // current error sense data page
#define  SCSI_SENSE_DEFERRED_ERRORS    0x71  // deferred error sense data page
#define  SCSI_MEDIUM_CONTROL_LOCK      1     // lock medium
#define  SCSI_MEDIUM_CONTROL_UNLOCK    0     // unlock medium
#define  SCSI_MEDIUM_CONTROL_EJECT     2     // eject medium
#define  SCSI_UNIT_CTRL_START          1     // start unit
#define  ASC_MEDIUM_NOT_PRESENT        0x3a  // unit attention additional sense code
#define  ASC_CANNOT_READ_MEDIUM_UF     0x30  // medium error additional sense code (unknown format)
#define  ASCQ_BECOMING_READY           0x01  // 
#define  ASCQ_BECOMING_DEVICEISBUSY    0xff  // 
#define  MODE_SELECT_PF                0x10  // mode select uses SCSI-2 defined page formats 
#define  MODE_SELECT_PC_CHANGEABLE     0x40  // retrieve changeable parameters 

// format unit command flags and codes
#define  FORMAT_UNIT_FLAGS_FMTDATA     0x10  // defect information source not specified
#define  FORMAT_UNIT_FLAGS_CMPLSR      0x08  // complete list of defects specified  
#define  FORMAT_UNIT_FLAGS_DLSTFMT     0x07  // UFI defect list format

typedef struct _defectListHeader_
{
   UCHAR       reserved;      // not used
   UCHAR       flags;         // defect list flags
   USHORT      length;        // defect list length in big endian form
}  DefectListHeader;

typedef  struct _ufiFormatDescriptor_
{
   ULONG    numberOfBlocks;   // total number of blocks on media
   ULONG    blockLength;      // block (sector) length (MSB must be set to 0)
}  UFIFormatDescriptor;

#define  DEFECT_LIST_FLAGS_FOV         0x80  // format options valid
#define  DEFECT_LIST_FLAGS_DPRY        0x40  // disable primary
#define  DEFECT_LIST_FLAGS_DCRT        0x20  // disable certification
#define  DEFECT_LIST_FLAGS_STPF        0x10  // stop format option
#define  DEFECT_LIST_FLAGS_IP          0x08  // initialization pattern specified
#define  DEFECT_LIST_FLAGS_DSP         0x04  // disable saving parameters
#define  DEFECT_LIST_FLAGS_IMMED       0x02  // return status immediately
#define  DEFECT_LIST_FLAGS_VS          0x01  // vendor specific
#define  MAX_UFI_TRACK_NO              0xff  // max track no that can be used in format command
#define  MAX_SCSI_CMD_CODE             0x00ff   // max SCSI command code (including group code)

// RBC   FORMAT option flags
#define  RBC_FORMAT_FLAGS_IMMED        0x08  // return status immediately
#define  RBC_FORMAT_FLAGS_PROGRESS     0x04  // report format progress
#define  RBC_FORMAT_FLAGS_PERCENT      0x02  // reports in % (0 - in seconds)
#define  RBC_FORMAT_FLAGS_INCR         0x01  // reports every 1 unit (0 - 5 units)

// medium type codes & characteristics
#define  SCSI_MEDIA_100MB              0x1e // standard SCSI flexible media type 1 MB (720KB formatted) 
#define  SCSI_MEDIA_160MB              0x93 // UFI specific media type, 1.60 MB (1.25 MB formatted)
#define  SCSI_MEDIA_200MB              0x94 // UFI specific media type, 2.00 MB (1.44 MB formatted)
#define  SECTORS_PER_720K_MEDIA        1440   
#define  SECTORS_PER_144M_MEDIA        2880 
#define  SECTORS_PER_288M_MEDIA        5760 
#define  SECTORS_PER_LS120_MEDIA       246528
#define  MAX_BLKS_PER_VERIFY           127   // max blocks to be processed in the single verify request  // 08/01/2000 MB

// indexes in floppy geometry table
#define  FLOPPY_INDEX_NOT_FILTERED     0 
#define  FLOPPY_INDEX_FILTERED         1

// convert word(double word) value from big endian to small endian representation
#define  MAKEUSINTEL(w)                MAKEUSHORT(HIBYTE(w),LOBYTE(w))
#define  MAKEULINTEL(w)                MAKEULONG(MAKEUSINTEL(HIUSHORT(w)),MAKEUSINTEL(LOUSHORT(w)))

// status flags used in context thread processing
#define  ARM_STATUS_CLEARED            0x0000     // thread is not running or armed
#define  ARM_STATUS_ARMED              0x0001     // thread is running or armed
#define  ARM_STATUS_ARMING             0x0002     // arming in progress
#define  ARM_STATUS_REQ                0x0004     // arming required when thread ends

//  Shut Down Request Packet
typedef struct _RPSHDOWN
{               /* RPSHDOWN */

   RPH           rph;          // standard request packet header
   UCHAR         functionCode; // shutdown function code - start/end shutdown
   ULONG         reserved;     // reserved for future use
} RPSHDOWN;

#define  START_SHUTDOWN                0
#define  END_SHUTDOWN                  1

