/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMSD/MSDSTRAT.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MSDSTRAT.C                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  MSD Class driver strategy routine.                    */
/*                                                                            */
/*   FUNCTION: These routines handle the task time routines for the strategy  */
/*             entry point of MSD Class device driver.                        */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             MSDStrategy                                                    */
/*             CmdError                                                       */
/*             MSDInitComplete                                                */
/*             MSDGetUSBDIDC                                                  */
/*             MSDShutdown                                                    */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          99/05/10  MB                                                      */
/* LR0420   01/04/20  LR              Added registration within USBD at init  */
/*                                    time for boot through USB floppy drive. */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include        "msd.h"

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  MSDStrategy                                      */
/*                                                                    */
/* DESCRIPTIVE NAME:  Strategy 1 entry point for the USB MSD Class    */
/*                    device driver.                                  */
/*                                                                    */
/* FUNCTION:  The function of this routine is pass the OS/2 kernel    */
/*            request packet and to appropriate worker routine.       */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  MSDStrategy                                          */
/*    LINKAGE:  CALL FAR                                              */
/*                                                                    */
/* INPUT:  es:bx -> kernel request packet                             */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: None                                                      */
/*                                                                    */
/* INTERNAL REFERENCES:  CmdError                                     */
/*                       MSDInit                                      */
/*                       MSDInitComplete                              */
/*                       MSDShutdown                                  */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
#pragma optimize("eglt", off)
void far MSDStrategy()
{
   RPH        FAR  *pRP;
   USHORT       Cmd;

   _asm
   {
      mov word ptr pRP[0], bx
      mov word ptr pRP[2], es
   }

   Cmd = pRP->Cmd;

   pRP->Status = STATUS_DONE;
   Cmd = pRP->Cmd;

   if ( Cmd == CMDInitBase )
   {
      MSDInit( pRP );
   }
   else if ( Cmd == CMDInitComplete )
   {
      MSDInitComplete( pRP );
   }
   else if ( Cmd == CMDShutdown )
   {
      MSDShutdown( pRP );
   }
   else  // unsupported request
      CmdError( pRP );
}
#pragma optimize("", on)

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  CmdError                                         */
/*                                                                    */
/* DESCRIPTIVE NAME:  Command not supported in the device driver      */
/*                                                                    */
/* FUNCTION:  The function of this routine is to return command not   */
/*            supported for the request.                              */
/*                                                                    */
/* NOTES: This is an immediate command that is not put on the FIFO    */
/*        queue.                                                      */
/*                                                                    */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  CmdError                                             */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  pRP-> kernel request packet                                */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND       */
/*                                                                    */
/* INTERNAL REFERENCES:  None                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
void CmdError( RPH FAR *pRP)
{
#ifdef DEBUG
   dsPrint1( DBG_CRITICAL, "MSD : CmdError - Strategy Command = %d\r\n", pRP->Cmd );
#endif

   pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND;
   return;
}


/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  MSDInitComplete                                  */
/*                                                                    */
/* DESCRIPTIVE NAME:  Initialization complete                         */
/*                                                                    */
/* FUNCTION:  The function of this routine is to finish driver's      */
/*            initialization by registering them to USBD driver.      */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Initialization time                                       */
/*                                                                    */
/* ENTRY POINT:  MSDInitComplete                                      */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  pRP-> kernel request packet                                */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: pRP->Status = STATUS_DONE                                 */
/*                                                                    */
/* INTERNAL REFERENCES:                                               */
/*                       MSDGetUSBDIDC                                */
/*                                                                    */
/* EXTERNAL REFERENCES:                                               */
/*                       setmem                                       */
/*                       GetDS                                        */
/*                       USBCallIDC                                   */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/

void MSDInitComplete( RPH FAR *pRP )
{
   RP_GENIOCTL    rp;   // IOCtl Request Packet
   USBDClass      classRegData;

#ifdef DEBUG
   dsPrint( DBG_HLVLFLOW, "MSD : MSDInitComplete started\r\n" );
#endif

   pRP->Status = STATUS_DONE;

   if (gMSDUSBD == TRUE) return; //LR0420 already registered within USBD
   
   // register within USBD driver
   setmem((PSZ)&rp, 0, sizeof(rp));
   rp.rph.Cmd=CMDGenIOCTL;   // IOCTL
   rp.Category=USB_IDC_CATEGORY_USBD;
   rp.Function=USB_IDC_FUNCTION_REGISTER;
   rp.ParmPacket=(PVOID)&classRegData;
   classRegData.usbIDC=(PUSBIDCEntry)&MSDidc;
   classRegData.usbDS=GetDS();
   USBCallIDC( gpUSBDIDC, gdsUSBIDC, (RP_GENIOCTL FAR *)&rp );
   if (rp.rph.Status == USB_IDC_RC_OK) gMSDUSBD = TRUE;   //LR0420 registered within USBD

#ifdef DEBUG
   dsPrint1( DBG_HLVLFLOW, "MSD : MSDInitComplete ended. rc=%x\r\n", (USHORT)pRP->Status );
#endif
   return;
}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  MSDGetUSBDIDC                                    */
/*                                                                    */
/* DESCRIPTIVE NAME:  Retrieves USBD driver IDC routine address & ds  */
/*                                                                    */
/* FUNCTION:  Retrieves USBD driver IDC routine address & data        */
/*            segment value.                                          */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  MSDGetUSBDIDC                                        */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  none                                                       */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: Sets gpUSBDIDC and gdsUSBIDC with USBD driver IDC ref data*/
/*                                                                    */
/* INTERNAL REFERENCES:  None                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:                                               */
/*                       DevHelp_AttachDD                             */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
void MSDGetUSBDIDC(void)
{
   setmem((PSZ)&gDDTable, 0, sizeof(gDDTable));

   gpUSBDIDC=NULL;
   gdsUSBIDC=0;

   if (DevHelp_AttachDD( gUSBDriverName, (NPBYTE)&gDDTable))
      return;      /* Couldn't find USBD's IDC */

   gpUSBDIDC = (PUSBIDCEntry)gDDTable.ProtIDCEntry;
   gdsUSBIDC = gDDTable.ProtIDC_DS;
}


/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  MSDShutdown                                      */
/*                                                                    */
/* DESCRIPTIVE NAME:  MSD Shutdown routine                            */
/*                                                                    */
/* FUNCTION:  Processes shutdown request                              */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  MSDShutdown                                          */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  RPH FAR *pRP - FAR pointer to shutdown request packet      */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: Sets gSuspended = TRUE (disables IORB processing)         */
/*                                                                    */
/* INTERNAL REFERENCES:  None                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
VOID MSDShutdown(RPH FAR *pRP)
{
   RPSHDOWN FAR      *pShutRP=(RPSHDOWN FAR *)pRP;

   switch (pShutRP->functionCode)
   {
   case  END_SHUTDOWN:
      break;
   case START_SHUTDOWN:
      gSuspended=TRUE;  // don't accept more requests
      break;
   default:
      break;
   }
}


