; SCCSID = src/dev/usb/USBMSD/MSDSEGS.ASM, usb, c.basedd 98/07/10
;/*
;*   Licensed Material -- Property of IBM
;*
;*   (c) Copyright IBM Corp. 1999  All Rights Reserved
;*/
;/************************** START OF SPECIFICATIONS **************************/
;/*                                                                           */
;/*   SOURCE FILE NAME:  MSDSEGS.ASM                                          */
;/*                                                                           */
;/*   DESCRIPTIVE NAME:  MSD driver header segment definition                 */
;/*                                                                           */
;/*   FUNCTION: This file defines MSD driver header data and local utility    */
;/*             routines.                                                     */
;/*                                                                           */
;/*   NOTES: Utility routines defined in this file use C calling convention.  */
;/*                                                                           */
;/*      DEPENDENCIES: None                                                   */
;/*      RESTRICTIONS: None                                                   */
;/*                                                                           */
;/*   ENTRY POINTS:                                                           */
;/*             _GetTotalSectorCount                                          */
;/*             _GetTrackFromLBA                                              */
;/*             _GetLBAFromCHS                                                */
;/*             _GetHeadFromLBA                                               */
;/*                                                                           */
;/*   EXTERNAL REFERENCES:                                                    */
;/*             None                                                          */
;/*                                                                           */
;/* Change Log                                                                */
;/*                                                                           */
;/*  Mark    yy/mm/dd  Programmer      Comment                                */
;/*  ----    --------  ----------      -------                                */
;/*          98/05/10  MB              Original developer.                    */
;/*                                                                           */
;/**************************** END OF SPECIFICATIONS **************************/

        .XCREF
        .XLIST
         INCLUDE devhdr.inc
        .LIST
        .CREF

         EXTRN  _MSDStrategy:FAR
         EXTRN  _MSDidc:FAR

DDHEADER segment word public 'DDHEADER'
        EVEN
_headers    LABEL  WORD
            DW       -1                                 ; Device header pointer
            DW       -1                                 ; Device header pointer
            dw       DEV_CHAR_DEV OR DEVLEV_3           ; ATTRIBUTE
            dw       OFFSET   _MSDStrategy              ; POINTER TO STRATEGY ROUTINE
            dw       OFFSET   _MSDidc                   ; POINTER TO PDD-PDD IDC ROUTINE
            db       'USBMSD$ '                         ; DEVICE NAME
            DW       0                                  ; Protect-mode CS Strategy Selector
            DW       0                                  ; Protect-mode DS selector
            DW       0                                  ; Real-mode CS Strategy Segment
            DW       0                                  ; Real-mode DS segment
            dd      DEV_ADAPTER_DD OR DEV_INITCOMPLETE  ; CAPABILITIES BIT STRIP
DDHeader ends

_DATA   segment word public 'DATA'
_DATA   ends

CONST   segment word public 'CONST'
CONST   ends

_BSS    segment word public 'BSS'
_BSS    ends

RMCode  segment word public 'CODE'
RMCode  ends

Code    segment word public 'CODE'
Code    ends

_TEXT   segment word public 'CODE'
        ASSUME   cs:_TEXT
	PUBLIC	_GetTotalSectorCount
.386
;/******************* START OF SPECIFICATIONS *************************/
;/*                                                                   */
;/* SUBROUTINE NAME:  _GetTotalSectorCount                            */
;/*                                                                   */
;/* DESCRIPTIVE NAME:  Get total sector count                         */
;/*                                                                   */
;/* FUNCTION:  This routine calculates total sector count based on    */
;/*            sector count per track, no of heads, no of cylinders.  */
;/*                                                                   */
;/* NOTES: Routine uses C calling convention                          */
;/*                                                                   */
;/* CONTEXT: Task Time                                                */
;/*                                                                   */
;/* ENTRY POINT :  _GetTotalSectorCount                               */
;/*    LINKAGE  :  CALL NEAR                                          */
;/*                                                                   */
;/* INPUT:  UCHAR sectorsPerTrack - no of sectors per track           */
;/*         UCHAR noOfHeads - no of read/write heads                  */
;/*         USHORT noOfCylinders - no of cylinders                    */
;/*                                                                   */
;/* EXIT-NORMAL:  ULONG value of total number of sectors on volume    */
;/*                                                                   */
;/* EXIT-ERROR:  n/a                                                  */
;/*                                                                   */
;/* EFFECTS:  n/a                                                     */
;/*                                                                   */
;/* INTERNAL REFERENCES:  none                                        */
;/*    ROUTINES:                                                      */
;/*                                                                   */
;/* EXTERNAL REFERENCES:  none                                        */
;/*    ROUTINES:                                                      */
;/*                                                                   */
;/******************* END  OF  SPECIFICATIONS *************************/
_GetTotalSectorCount	PROC NEAR       ;       calculates total sector count by multiplying
;                                               sector per track, no heads and cylinder counts
sectorsPerTrack equ  [bp+4]
noOfHeads       equ  [bp+6]
noOfCylinders   equ  [bp+8]
;|*** ULONG NEAR GetTotalSectorCount( UCHAR sectorsPerTrack, UCHAR noOfHeads, USHORT noOfCylinders)
;|*** {
;|*** 	return(sectorsPerTrack*noOfHeads*noOfCylinders);
        push	bp
        mov	bp,sp
        mov	al,BYTE PTR sectorsPerTrack	;sectorsPerTrack
        mul	BYTE PTR noOfHeads	        ;*noOfHeads
        mul	WORD PTR noOfCylinders	        ;*noOfCylinders (result in dx:ax)
;|*** }
        leave	
        ret	

_GetTotalSectorCount	ENDP


;/******************* START OF SPECIFICATIONS *************************/
;/*                                                                   */
;/* SUBROUTINE NAME:  _GetTrackFromLBA                                */
;/*                                                                   */
;/* DESCRIPTIVE NAME:  Get track number from logical block address    */
;/*                                                                   */
;/* FUNCTION:  This routine calculates track number for a given       */
;/*            logical block address and device geometry.             */
;/*                                                                   */
;/* NOTES: Routine uses C calling convention                          */
;/*                                                                   */
;/* CONTEXT: Task Time                                                */
;/*                                                                   */
;/* ENTRY POINT :  _GetTrackFromLBA                                   */
;/*    LINKAGE  :  CALL NEAR                                          */
;/*                                                                   */
;/* INPUT:  ULONG lba - logical block address                         */
;/*         USHORT sectorsPerTrack - sectors per track                */
;/*         USHORT noOfHeads - no of read/write heads                 */
;/*                                                                   */
;/* EXIT-NORMAL:  ULONG value of track number                         */
;/*                                                                   */
;/* EXIT-ERROR:  n/a                                                  */
;/*                                                                   */
;/* EFFECTS:  n/a                                                     */
;/*                                                                   */
;/* INTERNAL REFERENCES:  none                                        */
;/*    ROUTINES:                                                      */
;/*                                                                   */
;/* EXTERNAL REFERENCES:  none                                        */
;/*    ROUTINES:                                                      */
;/*                                                                   */
;/******************* END  OF  SPECIFICATIONS *************************/
	PUBLIC	_GetTrackFromLBA
_GetTrackFromLBA	PROC NEAR       ;       calculates track (cylinder) number from LBA address
lba             equ  [bp+4]
sectorsPerTrack equ  [bp+8]
noOfHeads       equ  [bp+10]
;|*** ULONG NEAR GetTrackFromLBA( ULONG lba, USHORT sectorsPerTrack, USHORT noOfHeads )
;|*** {
;|*** 	return((lba/sectorsPerTrack)/noOfHeads);
        push	bp
        mov	bp,sp
        
        mov     eax,lba                 ;load lba
        xor     edx,edx
        xor     ebx,ebx                 ; load
        mov     bx,sectorsPerTrack      ; sectorsPerTrack
        div     ebx                     ; (lba/sectorsPerTrack)
        mov     bx,noOfHeads            ; load noOfHeads
        xor     edx,edx
        div     ebx                     ; (lba/sectorsPerTrack)/noOfHeads
        mov     edx,eax
        shr     edx,16                  ; msd word in dx
        
;|*** }
        leave	
        ret	

_GetTrackFromLBA	ENDP

;/******************* START OF SPECIFICATIONS *************************/
;/*                                                                   */
;/* SUBROUTINE NAME:  _GetLBAFromCHS                                  */
;/*                                                                   */
;/* DESCRIPTIVE NAME:  Get logical block address from CHS address     */
;/*                                                                   */
;/* FUNCTION:  This routine calculates logical block address for a    */
;/*            given CHS address and device geometry.                 */
;/*                                                                   */
;/* NOTES: Routine uses C calling convention                          */
;/*                                                                   */
;/* CONTEXT: Task Time                                                */
;/*                                                                   */
;/* ENTRY POINT :  _GetLBAFromCHS                                     */
;/*    LINKAGE  :  CALL NEAR                                          */
;/*                                                                   */
;/* INPUT:  ULONG chs - chs address                                   */
;/*         USHORT sectorsPerTrack - sectors per track                */
;/*         USHORT noOfHeads - no of read/write heads                 */
;/*                                                                   */
;/* EXIT-NORMAL:  ULONG value of logical block address                */
;/*                                                                   */
;/* EXIT-ERROR:  n/a                                                  */
;/*                                                                   */
;/* EFFECTS:  n/a                                                     */
;/*                                                                   */
;/* INTERNAL REFERENCES:  none                                        */
;/*    ROUTINES:                                                      */
;/*                                                                   */
;/* EXTERNAL REFERENCES:  none                                        */
;/*    ROUTINES:                                                      */
;/*                                                                   */
;/******************* END  OF  SPECIFICATIONS *************************/
	PUBLIC	_GetLBAFromCHS
_GetLBAFromCHS	PROC NEAR               ;       calculates LBA address from given CHS address
chs             equ  [bp+4]
sectorsPerTrack equ  [bp+8]
noOfHeads       equ  [bp+10]
;|*** ULONG NEAR GetLBAFromCHS( ULONG chs, USHORT sectorsPerTrack, USHORT noOfHeads )
;|*** {
;|*** 	return(((chs->Cylinder*noOfHeads)+chs->head)*sectorsPerTrackchs->sector);
        push	bp
        mov	bp,sp
        
        xor     eax,eax
        mov	ax,WORD PTR chs	        ;       chs->Cylinder
        xor     ebx,ebx
        mov     bx,WORD PTR noOfHeads   ;
        mul     ebx                     ;       *noOfHeads
        xor     ebx,ebx
        mov     bl,BYTE PTR chs+2
        add     eax,ebx                 ;       +chs->head
        mov     bx,WORD PTR sectorsPerTrack     ;       
        mul     ebx                     ;       *chs->sectorsPerTrack
        xor     ebx,ebx
        mov     bl,BYTE PTR chs+3
        add     eax,ebx                 ;       +chs->sector
        mov     edx,eax
        shr     edx,16                  ;       MSW in dx
        
;|*** }
        leave	
        ret	

_GetLBAFromCHS	ENDP

;/******************* START OF SPECIFICATIONS *************************/
;/*                                                                   */
;/* SUBROUTINE NAME:  _GetHeadFromLBA                                 */
;/*                                                                   */
;/* DESCRIPTIVE NAME:  Get head number from logical block address     */
;/*                                                                   */
;/* FUNCTION:  This routine calculates read/write head number for a   */
;/*            given logical block address and device geometry.       */
;/*                                                                   */
;/* NOTES: Routine uses C calling convention                          */
;/*                                                                   */
;/* CONTEXT: Task Time                                                */
;/*                                                                   */
;/* ENTRY POINT :  _GetHeadFromLBA                                    */
;/*    LINKAGE  :  CALL NEAR                                          */
;/*                                                                   */
;/* INPUT:  ULONG lba - lba address                                   */
;/*         USHORT sectorsPerTrack - sectors per track                */
;/*         USHORT noOfHeads - no of read/write heads                 */
;/*                                                                   */
;/* EXIT-NORMAL:  ULONG value of head number                          */
;/*                                                                   */
;/* EXIT-ERROR:  n/a                                                  */
;/*                                                                   */
;/* EFFECTS:  n/a                                                     */
;/*                                                                   */
;/* INTERNAL REFERENCES:  none                                        */
;/*    ROUTINES:                                                      */
;/*                                                                   */
;/* EXTERNAL REFERENCES:  none                                        */
;/*    ROUTINES:                                                      */
;/*                                                                   */
;/******************* END  OF  SPECIFICATIONS *************************/
	PUBLIC	_GetHeadFromLBA
_GetHeadFromLBA	PROC NEAR       ;       calculates head no from LBA address
lba             equ  [bp+4]
sectorsPerTrack equ  [bp+8]
noOfHeads       equ  [bp+10]
;|*** ULONG NEAR GetHeadFromLBA( ULONG lba, USHORT sectorsPerTrack, USHORT noOfHeads )
;|*** {
;|*** 	return((lba/sectorsPerTrack) % noOfHeads);
        push	bp
        mov	bp,sp
        
        mov     eax,lba         ;       load lba
        xor     edx,edx
        xor     ebx,ebx                 ; load
        mov     bx,sectorsPerTrack      ; sectorsPerTrack
        div     ebx                     ; (lba/sectorsPerTrack)
        mov     bx,noOfHeads            ; load noOfHeads
        xor     edx,edx
        div     ebx                     ; (lba/sectorsPerTrack)/noOfHeads
        mov     eax,edx                 ; remainder (head no) in ax
        shr     edx,16                  ; msd word in dx
        
;|*** }
        leave	
        ret	

_GetHeadFromLBA	ENDP
_TEXT    ends

; Programmer cannot control location of CONST and _BSS class segments
; being grouped.  They are always last.  Do not put anything in these
; segments since they will be truncated after device driver initialization.
DGROUP  GROUP   DDHeader, CONST, _BSS, _DATA
CGROUP  GROUP   RMCode, Code, _TEXT
        end
        
