/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMSD/MSDPROTO.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MSDPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Function prototypes provided by the MSD Class         */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the MSD Class device driver                     */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/01/31  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/* MSDSTRAT.C */
void FAR MSDStrategy();
void CmdError( RPH FAR *pRP);
void MSDInitComplete( RPH FAR *pRP);
void MSDGetUSBDIDC(void);
VOID MSDShutdown(RPH FAR *pRP);

/* MSDIDC.C */
void FAR MSDidc( PRP_GENIOCTL pRP_GENIOCTL );
void MSDDetachDevice( PRP_GENIOCTL pRP_GENIOCTL );
void MSDCheckForService( PRP_GENIOCTL pRP_GENIOCTL );
void MSDClearStalled( USHORT deviceIndex, USHORT pktIndex, UCHAR endPointId, USHORT irq, USHORT failedIRQ );

/* MSDINIT.C */
void MSDInit( RPH FAR *pRP );

/*----------------------------------------------------------------------------*
 * MSDIORB.C - IORB Queueing Entry Point                                     *
 *----------------------------------------------------------------------------*/
VOID FAR  _loadds ADDEntryPoint( PIORBH pNewIORB );
VOID NEAR IORBDone( PIORB pIORB, USHORT errorCode );
PIORB NEAR PreProcessIORBs( PIORB pIORB );
USHORT BlkSizeToN( USHORT usBlkSize );
USHORT NEAR GetDeviceTable( PIORB pNewIORB );
USHORT NEAR SaveDMDInfo( PIORB pNewIORB );   // 28/01/2000 MB

// USBCTX.COM

VOID FAR PASCAL MSDStateHookRtn( VOID );
VOID FAR MSDTimer();
VOID SafeArmCtxHook( ULONG hookHandle, ULONG armData, USHORT *statusFlag );
VOID ClearThreadStatus( ULONG hookHandle, ULONG armData, USHORT *statusFlag );

// MSDOSM.C
VOID MSDOsm( DeviceList *pDevice );
VOID StartProcessing( DeviceList *pDevice );
VOID ProcessingDone( DeviceList *pDevice );


// MSDIO.C
VOID ExecuteUSBIO( DeviceList *pCurrDevice );
PUCHAR GetBufferAddress(DeviceList *pCurrDevice, USHORT *length);
BOOL NeedImmediateReturn( USHORT CommandCode, USHORT CommandModifier );
VOID ExtractCmdParameters(PIORB_ADAPTER_PASSTHRU pIORB, PUSHORT commandCode,  PUSHORT flags,
                          PULONG logicalBlockAddress, PULONG blockLength, PULONG cmdExtra, PULONG dataLength);
VOID BuildCmd(DeviceList *pCurrDevice, USHORT commandCode,  UCHAR flags,
              ULONG logicalBlockAddress, ULONG blockLength, ULONG extra, ULONG dataLength);
VOID CopyCmd( PIORBH pIORB );
VOID FinishGeometry( DeviceList *pCurrDevice );
VOID FinishUSBIO(DeviceList *pCurrDevice);
VOID ProcessSenseData (DeviceList *pCurrDevice);

// MSDsegs.asm
ULONG NEAR GetTotalSectorCount( UCHAR sectorsPerTrack, UCHAR noOfHeads, USHORT noOfCylinders);
ULONG NEAR GetTrackFromLBA( ULONG lba, USHORT sectorsPerTrack, USHORT noOfHeads );
ULONG NEAR GetHeadFromLBA( ULONG lba, USHORT sectorsPerTrack, USHORT noOfHeads );
ULONG NEAR GetLBAFromCHS( ULONG chs, USHORT sectorsPerTrack, USHORT noOfHeads );

//   MSDIRQ.C
void MSDProcessIRQ (PRP_GENIOCTL pRP);
void WriteTransData (USHORT deviceIndex, USHORT irq, PUCHAR pData, USHORT length, BOOL physAddr);  // 08/01/2000 MB
void ReadTransData (USHORT deviceIndex, USHORT irq, PUCHAR pData, USHORT length, BOOL physAddr);   // 08/01/2000 MB
void FinishInquiry (DeviceList *pCurrDevice);
void FinishCapacity (DeviceList *pCurrDevice);
void InterruptTimeOut (DeviceList *pCurrDevice);

//   MSDTRANS.C
void ExecuteMSDCmd (DeviceList *pCurrDevice);
void RequestSense (USHORT deviceIndex);
void ResetMSD (USHORT deviceIndex);
void ReadCSW (USHORT deviceIndex);
void SetAltInterface (USHORT deviceIndex);

