/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMSD/MSDEXTRN.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MSDEXTRN.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  External data declarations for the MSD Class          */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the MSD Class device driver external            */
/*             data declarations include file. See msddata.c for the data     */
/*             items being externalized.                                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark       yy/mm/dd  Programmer   Comment                                 */
/*  ---------  --------  ----------   -------                                 */
/*             98/01/31  MB                                                   */
/* 18/01/2000  00/01/18  MB           Deleted gDevCount and gFlpCount         */
/*                                    variables                               */
/* LR0420      01/04/20  LR           Added gMSDUSBD (registered within USBD) */
/*                                                                            */
/* 257590      01/06/26  VC           Added gInstallFileName                  */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

extern USHORT         (*gStrat1[])();

extern PFN            Device_Help;

extern ULONG          RMFlags;
extern PFN            RM_Help0;
extern PFN            RM_Help3;

extern const char     gAdapterName[];
extern DRIVERSTRUCT   gDriverStruct;
extern ADAPTERSTRUCT  gAdapterStruct;

extern UCHAR          gpszRMFloppyName[];   // floppy drive resource name mask
extern UCHAR          gAUsage; // forces "A" letter usage for USB floppy device

extern HDRIVER        ghDriver;
extern HADAPTER       ghAdapter;
extern USHORT         gADDHandle;

extern CHAR           gOEMDriverName[];
extern CHAR           gUSBDriverName[];
extern CHAR           gInstallFileName[];// VC 06/26/01 257590
extern IDCTABLE       gDDTable;

extern PUSBIDCEntry   gpUSBDIDC;
extern USHORT         gdsUSBIDC;
extern BOOL           gMSDUSBD; //LR0420 registered within USBD

extern ULONG          gStateHookHandle; // state machine processing thread handle
extern USHORT         gStateHookStatus; // state machine processing thread status

extern USHORT         gBuffSize;  // buffer size for bulk I/O request

extern BOOL           gRemAsFlp;   // treat removables as large floppies flag
extern BOOL           gFloppyMax;  // report max size floppy geometry as physical device geometry
extern BOOL           gSuspended ; // suspend/active status flag

extern ClassCommands  gClassCommands[]; // class command definitions
extern AttachCommands gAttachCommands[]; // device attach process command definitions
extern GEOMETRY       gFloppySizes[];  // sector count table for devices to be processed as floppies
// Sense data map for mapping sense codes to IORB errors.
USHORT                gAddSenseDataMap[];
USHORT                gMaxAddSenseData;   // sense map data array size

#ifdef   DEBUG
extern   USHORT       gMSDMsgLevel;       // debug message level
#endif

extern USHORT         gMaxMSDDevices;

extern USHORT         gNoOfMSDDevices;
extern DeviceGroup    gDevGroups[MSD_DEVICE_GROUP_COUNT];   // 18/01/2000 MB
extern SDeviceList    gSDeviceList[MSD_SDEVICE_COUNT];      // 03/05/2000 MB
extern DeviceList     gMSDDevices[MAX_DEVICES];   // active device list served by MSD  // 18/01/2000 MB

extern BYTE           gInitDataStart;

extern USHORT         gVerbose;

extern USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT];
extern PSZ            gVMessages[];
extern USHORT         gMessageCount;

