/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMSD/MSDDATA.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MSDDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Mass Storage Device Class adapter driver data segment */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             Mass Storage Device Class adapter device driver.               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark       yy/mm/dd  Programmer   Comment                                 */
/*  -------    --------  ----------   -------                                 */
/*             98/05/10  MB                                                   */
/* 18/01/2000  00/01/18  MB           Added device group definitions, deleted */
/*                                    gDevCount and gFlpCount variables       */
/* 10/02/2000  00/10/02  MB           Expanded return code conversion table   */
/*                                    to include CDROM specific entries       */
/* LR0420      01/04/20  LR           Added gMSDUSBD (registered within USBD) */
/*                                                                            */
/* 257590      01/06/26  VC           Added gInstallFileName                  */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "msd.h"

PFN      Device_Help    = NULL;  /* devhelp entry point; used by dhcalls.lib */

/*----------------------------------------------*/
/* GLOBAL VARS FOR RM                           */
/*                                              */
/* RM.LIB needs these declared                  */
/*----------------------------------------------*/
ULONG       RMFlags     = 0L;
PFN         RM_Help0    = 0L;
PFN         RM_Help3    = 0L;

/*--------------------------------------------------------*/
/* Set the DRIVERSTRUCT and DETECTEDSTRUCT data areas     */
/*--------------------------------------------------------*/

char  near  gDDName[];                  /* device driver name */
char  near  gDDDesc[];                  /* device driver description */
char  near  gVendorID[];                /* vendor identification */
//extern char  near  gAdapterName[];             /* adapter name */

/*----------------------------------------------*/
/* Driver Description   (rmbase.h)              */
/*----------------------------------------------*/
DRIVERSTRUCT gDriverStruct =
{
   gDDName,                            /* DrvrName                */
   gDDDesc,                            /* DrvrDescript            */
   gVendorID,                          /* VendorName              */
   CMVERSION_MAJOR,                    /* MajorVer                */
   CMVERSION_MINOR,                    /* MinorVer                */
   2001,5,31,                          /* Date                    */
   DRF_STATIC,                         /* DrvrFlags               */
   DRT_ADDDM,                          /* DrvrType                */
   DRS_ADD,                            /* DrvrSubType             */
   NULL                                /* DrvrCallback            */
};

/*----------------------------------------------*/
/* Adapter Description                          */
/*----------------------------------------------*/
ADAPTERSTRUCT gAdapterStruct =
{
   (PSZ)gAdapterName,                  /* AdaptDescriptName; */
   AS_NO16MB_ADDRESS_LIMIT,            /* AdaptFlags;        */
   AS_BASE_MSD,                        /* BaseType;          */
   AS_SUB_FLPY,                        /* SubType;           */
   AS_INTF_GENERIC,                    /* InterfaceType;     */
   NULL,                               /* HostBusType;       */
   AS_BUSWIDTH_32BIT,                  /* HostBusWidth;      */
   NULL,                               /* pAdjunctList;      */
   NULL                                /* reserved           */
};

/*----------------------------------------------*/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables are assigned the handles for */
/* drivers, detected hardware and resources.    */
/*----------------------------------------------*/

HDRIVER        ghDriver     = NULL;        // global handle to driver
HADAPTER       ghAdapter    = NULL;        // global handle to adapter
USHORT         gADDHandle   = 0;

CHAR           gOEMDriverName[9] = "OEMHLP$ ";
CHAR           gUSBDriverName[9] = "USBD$   ";
CHAR           gInstallFileName[14] = "CHKFORCD.CMD\0"; // VC 06/26/01 257590

UCHAR          gpszRMFloppyName[] = "DSKT_*";   // floppy drive resource name mask
UCHAR          gAUsage = AUSAGE_SEARCH; // forces "A" letter usage for USB floppy device

IDCTABLE       gDDTable =  { { 0, 0, 0}, 0, 0};

PUSBIDCEntry   gpUSBDIDC = NULL;   
USHORT         gdsUSBIDC = 0;
BOOL           gMSDUSBD = FALSE; //LR0420 not registered within USBD

ULONG          gStateHookHandle  =  0; // state machine processing thread handle
USHORT         gStateHookStatus=ARM_STATUS_CLEARED;   // state machine processing thread status

USHORT         gBuffSize      = MAX_BULK_BUFFSIZE;  // buffer size for bulk I/O request

BOOL           gRemAsFlp      = FALSE; // treat removables as large floppies flag
BOOL           gFloppyMax     = FALSE; // report max size floppy geometry as physical device geometry
BOOL           gSuspended     = FALSE; // suspend/active status flag

ClassCommands  gClassCommands[]= // class command definitions
{
   // UFI class command definitions
   // class code          cdm flgs   rCode code  R  fMsk  L  O  LBA mask    L  O  len mask    L  O  extra mask  cLen
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x00, 0x00, 0, 0xff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12, // test unit ready
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x03, 0x03, 1, 0xff, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 12, // request sense
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x04, 0x04, 0, 0xe0, 1, 2, 0xffffff00, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12, // format unit
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x12, 0x12, 1, 0xff, 1, 2, 0xffffff00, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 12, // inquiry
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x1b, 0x1b, 0, 0xfe, 0, 0, 0xffffffff, 1, 4, 0xfffffffc, 0, 0, 0xffffffff, 12,  // start/stop
   MSD_SUBCLASS_UFI     , CCMD_LMUL, 0x55, 0x55, 0, 0xee, 0, 0, 0xffffffff, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // mode select
   MSD_SUBCLASS_UFI     , CCMD_LMUL, 0x5a, 0x5a, 1, 0xf7, 1, 2, 0xffffff00, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // mode sense
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x1e, 0x1e, 0, 0xff, 1, 4, 0xfffffffe, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // prevent/allow medium removal
   MSD_SUBCLASS_UFI     , CCMD_MULL, 0x28, 0x28, 1, 0xe6, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // read(10)
   MSD_SUBCLASS_UFI     , CCMD_LMUL, 0xa8, 0xa8, 1, 0xe6, 4, 2, 0x00000000, 4, 6, 0x00000000, 0, 0, 0xffffffff, 12,  // read(12)
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x25, 0x25, 1, 0xfe, 4, 2, 0xffffffff, 1, 8, 0xfffffffe, 0, 0, 0xffffffff, 12,  // read capacity
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x23, 0x23, 1, 0xff, 0, 0, 0xffffffff, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // read format capacity
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x01, 0x01, 0, 0xff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // rezero unit
   MSD_SUBCLASS_UFI     , CCMD_LMUL, 0x2b, 0x2b, 0, 0xff, 4, 2, 0x00000000, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // seek(10)
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x1d, 0x1d, 0, 0xe8, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // send diagnostic
   MSD_SUBCLASS_UFI     , CCMD_MULL, 0x2a, 0x2a, 0, 0xe6, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // write(10)
   MSD_SUBCLASS_UFI     , CCMD_LMUL, 0xaa, 0xaa, 0, 0xe6, 4, 2, 0x00000000, 4, 6, 0x00000000, 0, 0, 0xffffffff, 12,  // write(12)
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x2e, 0x2e, 0, 0xec, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // write and verify
   MSD_SUBCLASS_UFI     , CCMD_LAST, 0x2f, 0x2f, 0, 0xec, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // verify
   // SCSI transparent class command definitions
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x00, 0x00, 0, 0xff, 4, 2, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06, // test unit ready
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x03, 0x03, 1, 0xff, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06, // request sense
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x04, 0x04, 0, 0xe0, 1, 2, 0xffffff00, 2, 3, 0x0000ffff, 0, 0, 0xffffffff, 06, // format unit
   MSD_SUBCLASS_SCSI    , CCMD_LMUL, 0x12, 0x12, 1, 0xfe, 1, 2, 0xffffff00, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06, // inquiry
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x1b, 0x1b, 0, 0xfe, 0, 0, 0xffffffff, 1, 4, 0xfffffffc, 0, 0, 0xffffffff, 06,  // start/stop
   MSD_SUBCLASS_SCSI    , CCMD_MULL, 0x15, 0x55, 0, 0xee, 0, 0, 0xffffffff, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10,  // mode select(10)
   MSD_SUBCLASS_SCSI    , CCMD_LMUL, 0x15, 0x15, 0, 0xee, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06,  // mode select(6)
   MSD_SUBCLASS_SCSI    , CCMD_MULL, 0x1a, 0x5a, 1, 0xf7, 1, 2, 0xffffff00, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10,  // mode sense(10)
   MSD_SUBCLASS_SCSI    , CCMD_LMUL, 0x1a, 0x1a, 1, 0xf7, 1, 2, 0xffffff00, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 06,  // mode sense(6)
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x1e, 0x1e, 0, 0xff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06,  // prevent/allow medium removal
   MSD_SUBCLASS_SCSI    , CCMD_MULL, 0x08, 0x28, 1, 0xed, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10,  // read(10)
   MSD_SUBCLASS_SCSI    , CCMD_LMUL, 0x08, 0x08, 1, 0xe0, 3, 1, 0xffe00000, 1, 1, 0xffffff00, 0, 0, 0xffffffff, 06,  // read(6)
   MSD_SUBCLASS_SCSI    , CCMD_MULL, 0x0a, 0x0a, 0, 0xe0, 3, 1, 0xffe00000, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06,  // write(6)
   MSD_SUBCLASS_SCSI    , CCMD_LMUL, 0x0a, 0x2a, 0, 0xed, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10,  // write(10)
   MSD_SUBCLASS_SCSI    , CCMD_LMUL, 0x0e, 0x2e, 0, 0xed, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10,  // write and verify
   MSD_SUBCLASS_SCSI    , CCMD_LMUL, 0x0f, 0x2f, 0, 0xed, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10,  // verify
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x25, 0x25, 1, 0xfe, 4, 2, 0xffffffff, 1, 8, 0xfffffffe, 0, 0, 0xffffffff, 10,  // read capacity
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x01, 0x01, 0, 0xff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06,  // rezero unit
   MSD_SUBCLASS_SCSI    , CCMD_MULL, 0x0b, 0x0b, 0, 0xff, 3, 1, 0xffe00000, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06,  // seek(6)
   MSD_SUBCLASS_SCSI    , CCMD_LMUL, 0x0b, 0x2b, 0, 0xff, 4, 2, 0x00000000, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 10,  // seek(10)
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x1d, 0x1d, 0, 0xe8, 0, 0, 0xffffffff, 2, 3, 0xffff0000, 0, 0, 0xffffffff, 06,  // send diagnostic
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x35, 0x35, 0, 0xfc, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10,  // synchronize cache
   MSD_SUBCLASS_SCSI    , CCMD_LAST, 0x3b, 0x3b, 0, 0xf8, 4, 2, 0x00000000, 3, 6, 0xff000000, 0, 0, 0xffffffff, 10,  // write buffer
   // RBC class command definitions
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x04, 0x04, 0, 0xff, 1, 2, 0xfffffff0, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06, // format unit
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x12, 0x12, 1, 0xfe, 1, 2, 0xffffff00, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06, // inquiry
   MSD_SUBCLASS_RBC     , CCMD_LMUL, 0x15, 0x15, 0, 0xee, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06,  // mode select
   MSD_SUBCLASS_RBC     , CCMD_LMUL, 0x1a, 0x5a, 1, 0xf7, 1, 2, 0xffffff00, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06,  // mode sense
   MSD_SUBCLASS_RBC     , CCMD_LMUL, 0x28, 0x28, 1, 0xff, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10, // read(10)
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x25, 0x25, 1, 0xff, 0, 0, 0xffffffff, 0, 0, 0xfffffffe, 0, 0, 0xffffffff, 10, // read capacity
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x1b, 0x1b, 0, 0xfe, 1, 4, 0xffffff0c, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06, // start/stop unit
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x35, 0x35, 0, 0xff, 0, 0, 0x00000000, 0, 0, 0xfff00000, 0, 0, 0xffffffff, 06, // synchronize cache
   MSD_SUBCLASS_RBC     , CCMD_LMUL, 0x2a, 0x2a, 1, 0xf7, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10, // write(10)
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x2f, 0x2f, 1, 0xff, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 10, // verify
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x1e, 0x1e, 0, 0xff, 1, 4, 0xfffffffc, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06,  // prevent/allow medium removal
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x03, 0x03, 1, 0xff, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06, // request sense
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x00, 0x00, 0, 0xff, 4, 2, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06, // test unit ready
   MSD_SUBCLASS_RBC     , CCMD_LMUL, 0x3b, 0x3b, 0, 0xf8, 0, 0, 0x00000000, 3, 6, 0xff000000, 0, 0, 0xffffffff, 10,  // write buffer
   MSD_SUBCLASS_RBC     , CCMD_LAST, 0x1d, 0x1d, 0, 0xe8, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // send diagnostic
   // SFF 8070I class command definitions
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x04, 0x04, 0, 0xe0, 1, 2, 0xffffff00, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12, // format unit
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x12, 0x12, 1, 0xff, 0, 0, 0xffffff00, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 12, // inquiry
   MSD_SUBCLASS_SFF8070I, CCMD_LMUL, 0x55, 0x55, 0, 0xee, 0, 0, 0xffffffff, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // mode select
   MSD_SUBCLASS_SFF8070I, CCMD_LMUL, 0x5a, 0x5a, 1, 0xff, 1, 2, 0xffffff00, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // mode sense
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x1e, 0x1e, 0, 0xff, 1, 4, 0xfffffffe, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // prevent/allow medium removal
   MSD_SUBCLASS_SFF8070I, CCMD_MULL, 0x28, 0x28, 1, 0xff, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // read(10)
   MSD_SUBCLASS_SFF8070I, CCMD_LMUL, 0xa8, 0xa8, 1, 0xff, 4, 2, 0x00000000, 4, 6, 0x00000000, 0, 0, 0xffffffff, 12,  // read(12)
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x25, 0x25, 1, 0xff, 0, 0, 0xffffffff, 0, 0, 0xfffffffe, 0, 0, 0xffffffff, 12,  // read capacity
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x23, 0x23, 1, 0xff, 0, 0, 0xffffffff, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // read format capacity
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x03, 0x03, 1, 0xff, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 12, // request sense
   MSD_SUBCLASS_SFF8070I, CCMD_LMUL, 0x2b, 0x2b, 0, 0xff, 4, 2, 0x00000000, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // seek(10)
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x1b, 0x1b, 0, 0xfe, 0, 0, 0xffffffff, 1, 4, 0xfffffffc, 0, 0, 0xffffffff, 12,  // start/stop
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x00, 0x00, 0, 0xff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12, // test unit ready
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x2f, 0x2f, 0, 0xfd, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // verify
   MSD_SUBCLASS_SFF8070I, CCMD_MULL, 0x2a, 0x2a, 0, 0xff, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // write(10)
   MSD_SUBCLASS_SFF8070I, CCMD_LMUL, 0xaa, 0xaa, 0, 0xff, 4, 2, 0x00000000, 4, 6, 0x00000000, 0, 0, 0xffffffff, 12,  // write(12)
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x2e, 0x2e, 0, 0xfd, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // write and verify
   MSD_SUBCLASS_SFF8070I, CCMD_LAST, 0x1d, 0x1d, 0, 0xe8, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // send diagnostic
   // SFF 8020I class command definitions
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x12, 0x12, 1, 0xff, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 12, // inquiry
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0xa6, 0xa6, 0, 0xfe, 0, 0, 0xffffffff, 1, 4, 0xfffffffc, 1, 8, 0xffffff00, 12, // load/unload
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0xbd, 0xbd, 1, 0xff, 0, 0, 0xffffffff, 2, 8, 0xffff0000, 0, 0, 0xffffffff, 12, // mechanism status
   MSD_SUBCLASS_SFF8020I, CCMD_LMUL, 0x55, 0x55, 0, 0xee, 0, 0, 0xffffffff, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12, // mode select
   MSD_SUBCLASS_SFF8020I, CCMD_LMUL, 0x5a, 0x5a, 1, 0xff, 1, 2, 0xffffff00, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12, // mode sense
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x4b, 0x4b, 0, 0xff, 0, 0, 0xffffffff, 1, 8, 0xfffffffe, 0, 0, 0xffffffff, 12, // pause/resume
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x45, 0x45, 0, 0xff, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12, // play audio
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x47, 0x47, 0, 0xff, 3, 3, 0xff000000, 3, 6, 0xff000000, 0, 0, 0xffffffff, 12, // play audio MSF
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0xbc, 0xbc, 0, 0xe1, 4, 2, 0x00000000, 4, 6, 0x00000000, 1,10, 0xffffff70, 12, // play CD(LBA)
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0xb4, 0xb4, 0, 0xe1, 3, 3, 0xff000000, 3, 6, 0xff000000, 1,10, 0xffffff70, 12, // play CD(MSF)
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x1e, 0x1e, 0, 0xff, 1, 4, 0xfffffffe, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // prevent/allow medium removal
   MSD_SUBCLASS_SFF8020I, CCMD_MULL, 0x28, 0x28, 1, 0xff, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // read(10)
   MSD_SUBCLASS_SFF8020I, CCMD_LMUL, 0xa8, 0xa8, 1, 0xff, 4, 2, 0x00000000, 4, 6, 0x00000000, 0, 0, 0xffffffff, 12,  // read(12)
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x25, 0x25, 1, 0xff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // read capacity
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0xbe, 0xbe, 1, 0xe6, 4, 2, 0x00000000, 3, 6, 0xff000000, 2, 9, 0xffff01f8, 12,  // read CD
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0xb9, 0xb9, 1, 0xe6, 3, 3, 0xff000000, 3, 6, 0xff000000, 2, 9, 0xffff01f8, 12,  // read CD MSF
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x44, 0x44, 1, 0xfd, 4, 2, 0x00000000, 2, 7, 0xffff0000, 0, 0, 0xffffffff, 12,  // read header
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x42, 0x42, 1, 0xfd, 2, 2, 0xffff6f00, 2, 7, 0xffff0000, 1, 6, 0xffffff00, 12,  // read sub-channel
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x43, 0x43, 1, 0xfd, 1, 2, 0xfffffff8, 2, 7, 0xffff0000, 1, 6, 0xffffff00, 12,  // read TOC
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x03, 0x03, 1, 0xff, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 12, // request sense
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0xba, 0xba, 0, 0xef, 4, 2, 0x00000000, 0, 0, 0xffffffff, 1, 9, 0xffffff6f, 12, // scan
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x2b, 0x2b, 0, 0xff, 4, 2, 0x00000000, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12, // seek
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0xbb, 0xbb, 0, 0xff, 2, 2, 0xffff0000, 2, 4, 0xffff0000, 0, 0, 0xffffffff, 12, // set speed
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x4e, 0x4e, 0, 0xff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12, // stop play/scan
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x1b, 0x1b, 0, 0xfe, 0, 0, 0xffffffff, 1, 4, 0xfffffffc, 0, 0, 0xffffffff, 12, // start/stop unit
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x00, 0x00, 0, 0xff, 4, 2, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12, // test unit ready
   MSD_SUBCLASS_SFF8020I, CCMD_LAST, 0x1d, 0x1d, 0, 0xe8, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // send diagnostic
   // QIC-157 class command definitions
   MSD_SUBCLASS_QIC157  , CCMD_LMUL, 0x19, 0x19, 1, 0xfc, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06, // inquiry
   MSD_SUBCLASS_QIC157  , CCMD_LMUL, 0x12, 0x12, 1, 0xfe, 1, 2, 0xffffff00, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06, // inquiry
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x1b, 0x1b, 0, 0xfe, 0, 0, 0xffffffff, 1, 4, 0xfffffffc, 0, 0, 0xffffffff, 06,  // load/unload
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x2b, 0x2b, 0, 0xfd, 4, 3, 0x00000000, 1, 8, 0xffffff00, 0, 0, 0xffffffff, 10,  // locate
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x4c, 0x4c, 0, 0xfd, 1, 2, 0xffffff00, 2, 7, 0xffffff00, 0, 0, 0xffffffff, 10,  // log select
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x4d, 0x4d, 1, 0xff, 1, 2, 0xffffff00, 2, 5, 0xffff0000, 2, 7, 0xffff0000, 10,  // log sense
   MSD_SUBCLASS_QIC157  , CCMD_LMUL, 0x15, 0x15, 0, 0xef, 0, 0, 0xffffffff, 2, 3, 0xffff0000, 0, 0, 0xffffffff, 06,  // mode select
   MSD_SUBCLASS_QIC157  , CCMD_LMUL, 0x1a, 0x5a, 1, 0xf7, 1, 2, 0xffffffc0, 2, 3, 0xffff0000, 0, 0, 0xffffffff, 06,  // mode sense
   MSD_SUBCLASS_QIC157  , CCMD_LMUL, 0x08, 0x08, 1, 0xfe, 0, 0, 0x00000000, 3, 2, 0xff000000, 0, 0, 0xffffffff, 06,  // read(6)
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x34, 0x34, 1, 0xff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 10,  // read position
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x03, 0x03, 1, 0xff, 0, 0, 0xffffffff, 1, 4, 0xffffff00, 0, 0, 0xffffffff, 06, // request sense
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x01, 0x01, 0, 0xfe, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06, // rewind
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x11, 0x11, 0, 0xf8, 0, 0, 0xffffffff, 3, 2, 0xff000000, 0, 0, 0xffffffff, 06, // space
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x00, 0x00, 0, 0xff, 4, 2, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 06, // test unit ready
   MSD_SUBCLASS_QIC157  , CCMD_LMUL, 0x0a, 0x0a, 0, 0xfe, 0, 0, 0x00000000, 3, 2, 0xff000000, 0, 0, 0xffffffff, 06,  // write(6)
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x10, 0x10, 0, 0xff, 0, 0, 0xffffffff, 1, 4, 0xfffffffe, 0, 0, 0xffffffff, 06,  // write file mark
   MSD_SUBCLASS_QIC157  , CCMD_LAST, 0x1d, 0x1d, 0, 0xe8, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 0, 0, 0xffffffff, 12,  // send diagnostic
   0,                     0,         0,    0,    0, 0,    0, 0, 0,          0, 0, 0,          0, 0,          0,  0
};

AttachCommands gAttachCommands[]= // device attach process command definitions
{
   NULL, SCSI_START_STOP_UNIT, ATTACH_EFLAGS_NULL|ATTACH_EFLAGS_NEXTERR, 0, 0, SCSI_UNIT_CTRL_START, 0, 0,
   &FinishInquiry,  SCSI_INQUIRY,       ATTACH_EFLAGS_NULL,0,0,sizeof(SCSI_INQDATA), 0, sizeof(SCSI_INQDATA),
   NULL, SCSI_TEST_UNIT_READY, ATTACH_EFLAGS_NULL|ATTACH_EFLAGS_SKPIFNERR, 0, 0, 0, 0, 0,
   &FinishCapacity, SCSI_READ_CAPACITY, ATTACH_EFLAGS_NULL|ATTACH_EFLAGS_SKPIFNERR, 0, 0, 0, 0, sizeof(UFIFormatDescriptor),
   &FinishGeometry, SCSI_MODE_SENSE_10, ATTACH_EFLAGS_LAST|ATTACH_EFLAGS_NEXTERR,0, 
   SCSI_MODE_FLEXIBLEDSK_PAGE,sizeof(ModeHeader) + sizeof(FlexibleDiskPage), 0,
   sizeof(ModeHeader) + sizeof(FlexibleDiskPage),
   &FinishCapacity, SCSI_READ_CAPACITY, ATTACH_EFLAGS_LAST|ATTACH_EFLAGS_NEXTERR, 0, 0, 0, 0, sizeof(UFIFormatDescriptor),
};

GEOMETRY       gFloppySizes[]=  // sector count table for devices to be processed as floppies
{
   SECTORS_PER_LS120_MEDIA,   512,  0, 8, 963,  32,
   SECTORS_PER_144M_MEDIA,    512,  0, 2, 80,   18,
   SECTORS_PER_720K_MEDIA,    512,  0, 2, 80,    9,
   SECTORS_PER_288M_MEDIA,    512,  0, 2, 80,   36,
   0
};

// Sense data map for mapping sense codes to IORB errors.
USHORT gAddSenseDataMap[] ={      /* Index = Sense Code from sense data      */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 00h No sense information                */
   IOERR_RBA_ADDRESSING_ERROR,    /* 01h No index/sector signal              */
   IOERR_RBA_ADDRESSING_ERROR,    /* 02h No seek complete                    */
   IOERR_RBA_CRC_ERROR,           /* 03h Write fault                         */
   IOERR_UNIT_NOT_READY,          /* 04h Drive not ready                     */
   IOERR_ADAPTER_DEVICE_TIMEOUT,  /* 05h LUN not selected                    */
   IOERR_RBA_ADDRESSING_ERROR,    /* 06h No track zero found                 */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 07h Multiple drives selected            */
   IOERR_ADAPTER_DEVICE_TIMEOUT,  /* 08h Logical unit communication failure  */
   IOERR_RBA_ADDRESSING_ERROR,    /* 09h Track following error               */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Ah Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Bh Reserved                            */
   IOERR_RBA_CRC_ERROR,           /* 0Ch Write Error                         */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Dh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Eh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Fh Reserved                            */
   IOERR_RBA_ADDRESSING_ERROR,    /* 10h ID CRC or ECC error                 */
   IOERR_RBA_CRC_ERROR,           /* 11h Unrecovered Read error              */
   IOERR_RBA_ADDRESSING_ERROR,    /* 12h No address mark found               */
   IOERR_RBA_ADDRESSING_ERROR,    /* 13h No addr mark in data field          */
   IOERR_RBA_ADDRESSING_ERROR,    /* 14h No record found                     */
   IOERR_RBA_ADDRESSING_ERROR,    /* 15h Seek positioning error              */
   IOERR_RBA_ADDRESSING_ERROR,    /* 16h Data synchronization mark error     */
   IOERR_RBA_CRC_ERROR,           /* 17h Recovered read w/ retries           */
   IOERR_RBA_CRC_ERROR,           /* 18h Recovered read data with correction */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 19h Defect list error                   */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 1Ah Parameter overrun                   */
   IOERR_ADAPTER_DEVICEBUSCHECK,  /* 1Bh Synchronous transfer err            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 1Ch Primary defect list not found       */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 1Dh Compare error                       */
   IOERR_RBA_ADDRESSING_ERROR,    /* 1Eh Recovered ID with ECC correction    */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 1Fh Reserved                            */
   IOERR_CMD_NOT_SUPPORTED,       /* 20h Invalid command op code             */
   IOERR_RBA_ADDRESSING_ERROR,    /* 21h Illegal logical blk addr            */
   IOERR_CMD_SYNTAX,              /* 22h Illegal func for dev type           */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 23h Reserved                            */
   IOERR_CMD_SYNTAX,              /* 24h Illegal field in CDW                */
   IOERR_CMD_SYNTAX,              /* 25h Invalid LUN                         */
   IOERR_CMD_SYNTAX,              /* 26h Invalid param list field            */
   IOERR_MEDIA_WRITE_PROTECT,     /* 27h Write protected                     */
   IOERR_MEDIA_CHANGED,           /* 28h Medium changed                      */
   IOERR_DEVICE_RESET,            /* 29h Power on reset or bus device reset  */
   IOERR_MEDIA_CHANGED,           /* 2Ah Mode select parameters changed      */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Bh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Ch Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Dh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Eh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Fh Reserved                            */
   IOERR_MEDIA_NOT_SUPPORTED,     /* 30h Incompatible cartridge              */
   IOERR_MEDIA_NOT_FORMATTED,     /* 31h Medium format corrupted             */
   IOERR_MEDIA_NOT_FORMATTED,     /* 32h No defect spare location available  */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 33h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 34h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 35h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 36h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 37h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 38h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 39h Reserved                            */
   IOERR_MEDIA_NOT_PRESENT,       /* 3Ah Medium Not Present                  */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 3Bh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 3Ch Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 3Dh Reserved                            */
   IOERR_UNIT_NOT_READY,          /* 3Eh LUN  not self-configured yet        */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 3Fh Reserved                            */
   IOERR_DEVICE_DIAGFAIL,         /* 40h RAM failure                         */
   IOERR_DEVICE_DIAGFAIL,         /* 41h Data path diagnostic failure        */
   IOERR_DEVICE_DIAGFAIL,         /* 42h Power-on diag failure               */
   IOERR_DEVICE_DEVICEBUSCHECK,   /* 43h Message reject error                */
   IOERR_DEVICE,                  /* 44h Internal controller error           */
   IOERR_UNIT_NOT_READY,          /* 45h Select/reselect failed              */
   IOERR_DEVICE_BUSY,             /* 46h Unsuccessful soft reset             */
   IOERR_DEVICE_DEVICEBUSCHECK,   /* 47h SCSI interface parity error         */
   IOERR_DEVICE_DEVICEBUSCHECK,   /* 48h Initiator detected error            */
   IOERR_DEVICE_DEVICEBUSCHECK,   /* 49h Inappropriate/illegal message       */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 4Ah Reserved                            */  // 10/02/2000 MB
   IOERR_ADAPTER_REFER_TO_STATUS, /* 4Bh Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 4Ch Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 4Dh Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 4Eh Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 4Fh Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 50h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 51h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 52h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 53h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 54h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 55h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 56h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 57h TOC Recovery fail                   */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 58h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 59h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 5Ah Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 5Bh Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 5Ch Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 5Dh Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 5Eh Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 5Fh Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 60h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 61h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 62h Reserved                            */           //
   IOERR_ADAPTER_REFER_TO_STATUS, /* 63h End User Area                       */           //
   IOERR_RBA_ADDRESSING_ERROR,    /* 64h Illegal Mode for Track              */           //
   IOERR_ADAPTER_REFER_TO_STATUS  /* > 64H - Reserved                        */  // 10/02/2000 MB
};

USHORT         gMaxAddSenseData   = sizeof(gAddSenseDataMap) / sizeof(USHORT);

#ifdef   DEBUG
USHORT         gMSDMsgLevel = DBG_CRITICAL;       // debug message level
#endif

USHORT         gMaxMSDDevices = MAX_DEVICES;

USHORT         gNoOfMSDDevices = 0;
DeviceGroup    gDevGroups[MSD_DEVICE_GROUP_COUNT]={
               "USBFLPPY.ADD", 1, 1, 0, 0, 0, AI_DEVBUS_FLOPPY | AI_DEVBUS_32BIT, UIB_TYPE_DISK, UF_REMOVABLE | UF_NOSCSI_SUPT | UF_LARGE_FLOPPY | UF_CHANGELINE,
               "USBRMV.ADD",   1, 1, 0, 0, 0, AI_DEVBUS_OTHER  | AI_DEVBUS_32BIT, UIB_TYPE_DISK, UF_REMOVABLE | UF_NOSCSI_SUPT | UF_CHANGELINE,
               "USBHDD.ADD",   0, 1, 0, 0, 0, AI_DEVBUS_OTHER  | AI_DEVBUS_32BIT, UIB_TYPE_DISK, UF_NOSCSI_SUPT | UF_USB_DEVICE,
               "USBCDROM.ADD", 0, 1, 0, 0, 0, AI_DEVBUS_OTHER  | AI_DEVBUS_32BIT, UIB_TYPE_CDROM, UF_REMOVABLE | UF_CHANGELINE | UF_NODASD_SUPT | UF_NOSCSI_SUPT | UF_USB_DEVICE,
               "USBOPTCL.ADD", 0, 1, 0, 0, 0, AI_DEVBUS_OTHER  | AI_DEVBUS_32BIT, UIB_TYPE_OPTICAL_MEMORY, UF_CHANGELINE | UF_NOSCSI_SUPT | UF_USB_DEVICE,
               NULL,           0, 0, 0,0,0,0,0,0};   // 18/01/2000  MB

// Vendor specific device list that follows standard specifications
SDeviceList    gSDeviceList[MSD_SDEVICE_COUNT]= {
               DEV_CLASS_VENDOR_SPECIFIC,MSD_ENTRY_NOTUSED,MSD_ENTRY_NOTUSED,USB_VENDOR_FANTOM,FANTOM_HDD,MSD_ENTRY_NOTUSED,MSD_SUBCLASS_SFF8020I, MSD_PROTOCOL_IOMEGA, 2, 0,
               DEV_CLASS_VENDOR_SPECIFIC, MSD_ENTRY_NOTUSED, MSD_ENTRY_NOTUSED, USB_VENDOR_WINSTATION, WINSTATION_LS120, MSD_ENTRY_NOTUSED, MSD_SUBCLASS_UFI, MSD_PROTOCOL_CBI_NI, MSD_ENTRY_NOTUSED, MSD_ENTRY_NOTUSED,
               DEV_CLASS_VENDOR_SPECIFIC, MSD_ENTRY_NOTUSED, MSD_ENTRY_NOTUSED, USB_VENDOR_HP, HP_CDR_8200, MSD_ENTRY_NOTUSED, MSD_SUBCLASS_SFF8070I, MSD_PROTOCOL_CBI_NI, MSD_ENTRY_NOTUSED, MSD_ENTRY_NOTUSED,
               DEV_CLASS_STORAGE, MSD_ENTRY_NOTUSED, MSD_ENTRY_NOTUSED, USB_VENDOR_SONY, SONY_SPRESSA_100, MSD_ENTRY_NOTUSED, MSD_SUBCLASS_SFF8070I, MSD_PROTOCOL_IOMEGA, MSD_ENTRY_NOTUSED, MSD_ENTRY_NOTUSED,
               DEV_CLASS_PHYSICAL_INTERFACE, MSD_ENTRY_NOTUSED, MSD_ENTRY_NOTUSED, USB_VENDOR_SONY, SONY_13GB_HD, MSD_ENTRY_NOTUSED, MSD_SUBCLASS_SFF8070I, MSD_PROTOCOL_CBI_NI, MSD_ENTRY_NOTUSED, MSD_ENTRY_NOTUSED
                                                }; // 18/01/2000 MB

DeviceList     gMSDDevices[MAX_DEVICES]={0};   // active device list served by MSD  // 18/01/2000 MB

BYTE           gInitDataStart = 0;  // Marks the end of the data segment

USHORT         gVerbose       = 0;  // output message level

#define MSG_REPLACEMENT_STRING  1178

USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT]={0};
USHORT         gMessageCount=0;
PSZ            gVMessages[]={ "IUSBMSD.ADD: USB Mass Storage Device Class driver v.%dd.%dd loaded",
   "EUSBMSD.ADD: USBD.SYS driver not loaded",
   "EUSBMSD.ADD: Invalid numeric value in CONFIG.SYS line at column %dddd",
   "EUSBMSD.ADD: Invalid key value in CONFIG.SYS line at column %dddd",
   "EUSBMSD.ADD: Failed to allocate CTX hook routine",
   "EUSBMSD.ADD: Failed to set Timer routine",
   "EUSBMSD.ADD: Failed to register device class"};

MSGTABLE       gInitMsg = { MSG_REPLACEMENT_STRING, 1, 0};

