/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMSD/MSD.H, usb, c.basedd 98/07/29" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MSD.H                                                 */
/*                                                                            */
/*   DESCRIPTIVE NAME:  MSD Class driver master include file.                 */
/*                                                                            */
/*   FUNCTION: This module is the MSD Class device driver master              */
/*             include file.                                                  */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          99/05/10  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

// USBD specific debug definitions
#ifdef   DEBUG
   #define         dsPrint(l,s)              dsPrint5x(gMSDMsgLevel,(l),(s),0,0,0,0,0)
   #define         dsPrint1(l,s,a)           dsPrint5x(gMSDMsgLevel,(l),(s),(a),0,0,0,0)
   #define         dsPrint2(l,s,a,b)         dsPrint5x(gMSDMsgLevel,(l),(s),(a),(b),0,0,0)
   #define         dsPrint3(l,s,a,b,c)       dsPrint5x(gMSDMsgLevel,(l),(s),(a),(b),(c),0,0)
   #define         dsPrint4(l,s,a,b,c,d)     dsPrint5x(gMSDMsgLevel,(l),(s),(a),(b),(c),(d),0)
#endif

#include "usbcmmon.h"         // USB stack common definitions and OS/2 includes
#include "usbmisc.h"          // common function definitons (usbmisc.lib)

#include "iorb.h"
#include "scsi.h"

#ifndef IOCM_SAVE_DMD_INFO
#define IOCM_SAVE_DMD_INFO        0x0008  /* O                         */  // 02/02/2000 MB
#define UF_USB_DEVICE    0x0800         // USB device - could deny any request until real device is attached //   02/02/2000 MB

/*                                                                    //   02/02/2000 MB   //
** DMD callback registration IORB                  (for IOCC_CONFIGURATION)                //
*/                                                                                         //
typedef USHORT  (FAR  _loadds  *PDMDCBK)(USHORT cmd, ULONG idData, ULONG cmdData);         //
// DMD callback routine call switches                                                      //
#define  USB_DMD_REINITIALIZE    1     // new device attached for existing driver letter   //
#define  USB_DMD_NEW_DEVICE      2     // new device attached (no drive letter)            //
#define  USB_DMD_DETACHED        3     // device detached                                  //
#define  USB_DMD_NEWDETACHED     4     // device detached (driver letter must be deleted)  //
#define  USB_DMD_SETBUSTYPE      5     // set device bus type (interface)                  //
                                                                                           //
typedef struct _IORB_SAVE_DMD   {  /* IOSAVEDMD */                                         //
                                                                                           //
  IORBH            iorbh;               /* IORB Header                  */                 //
  PDMDCBK          dmdCallback;         // far pointer to DMD callback routine             //
  ULONG            dmdDeviceId;         // data used by DMD to identify device             //
                                                                                           //
} IORB_SAVE_DMD, FAR *PIORB_SAVE_DMD, NEAR *NIORB_PSAVE_DMD;          //   02/02/2000 MB   //
#endif

#include "msdtype.h"          /* MSD Class Driver specific typedefs */
#include "msdproto.h"         /* function prototypes */
#include "msdextrn.h"         /* external data declarations */


