/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMOUSE/MOUSTRAT.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MOUSTRAT.C                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Mouse Device Driver strategy                      */
/*                                                                            */
/*   FUNCTION: These routines handle the task time routines for the strategy  */
/*             entry point of USB Mouse Device Driver.                        */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer         Comment                              */
/*  ----    --------  ----------         -------                              */
/*          98/01/29  Vjacheslav Chibis                                       */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include        "mouse.h" /* USB mouse DD master include file */

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  USBMOUSEStrategy                                 */
/*                                                                    */
/* DESCRIPTIVE NAME:  Strategy  entry point for the USB Mouse DD      */
/*                                                                    */
/* FUNCTION:    Processes strategy requests to USB mouse DD           */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  USBMOUSEStrategy                                     */
/*     LINKAGE:  CALL FAR                                             */
/*                                                                    */
/* INPUT:  es:bx -> kernel request packet                             */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: None                                                      */
/*                                                                    */
/* INTERNAL REFERENCES:  StatList                                     */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/

#pragma optimize("eglt", off)           
void far USBMOUSEStrategy()
{
   RPH          far *pRP; /* far pointer to the strategy request packet */
   USHORT       Cmd;      /* strategy command */

   /* let`s get the pointer to the request packet */
   _asm                                      
   {                                         
      mov word ptr pRP[0], bx                
      mov word ptr pRP[2], es                
   }             

   Cmd = pRP->Cmd;                           

   #ifdef DEBUG
   dsPrint2(DBG_HLVLFLOW,  "USBMOUSE Strategy: Entry: pRP = %x Command = %d\r\n", (ULONG)pRP, pRP->Cmd );
   #endif

   if (Cmd > MAX_USB_CMD)
   {
      #ifdef DEBUG      
      dsPrint(DBG_CRITICAL, "USBMOUSE : USBMOUSEStrategy : Cmd > MAX_USB_CMD");
      #endif
      pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND; /*  sets error status on 
                                                               invalid strategy command */
   }
   else
      (*StratList[Cmd])(pRP); /* processes strategy command */

   #ifdef DEBUG
   dsPrint1(DBG_HLVLFLOW, "USBMOUSEStrategy: Exit: pRP = %x\r\n", (ULONG)pRP );
   #endif
   return;
}
 #pragma optimize("", on)
/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  CmdError                                         */
/*                                                                    */
/* DESCRIPTIVE NAME:  Command not supported in the Device Driver      */
/*                                                                    */
/* FUNCTION:  The function of this routine is to return command not   */
/*            supported for the request.                              */
/*                                                                    */
/* NOTES:                                                             */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  CmdError                                             */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:   pRP-> kernel request packet                               */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND       */
/*                                                                    */
/* INTERNAL REFERENCES:  None                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/

void CmdError( RPH FAR *pRP)
{
#ifdef DEBUG
   dsPrint1(DBG_CRITICAL,  "usbmouse.sys: CmdError - Strategy Command = %d\r\n", pRP->Cmd );
#endif
   pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND;
   return;
}


/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  usbmouseInitComplete                             */
/*                                                                    */
/* DESCRIPTIVE NAME:  Initialization complete                         */
/*                                                                    */
/* FUNCTION:  The function of this routine is to clear the global     */
/*            initialization time flag.                               */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  usbmouseInitComplete                                 */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:                                                             */
/*                                                                    */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: pRP->Status = STATUS_DONE                                 */
/*                                                                    */
/* INTERNAL REFERENCES:  none                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  USBCallIDC, setmem, LMOUCallIDC              */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/

#pragma optimize("eglt", off)
void usbmouseInitComplete( RPH FAR *pRP)
{  
   RP_GENIOCTL  rp;
   USBDClass  classRegData;

   if (gpUSBHIDIDC && gdsUSBIDC) /* if HID attached succesfully  */
   {
      if (pLMOUSEIDC && dsLMOUSEIDC) /* and if Legacy Mouse DD attached succefully */
      {
         setmem((PSZ)&rp, 0, sizeof(rp));
         rp.rph.Cmd=CMDGenIOCTL;
         rp.Category=USB_IDC_CATEGORY_LEGACY;
         rp.Function=USB_IDC_FUNCTION_REGISTER;

         LMOUcallIDC( pLMOUSEIDC, dsLMOUSEIDC, (RP_GENIOCTL FAR *)&rp ); /* calls Legacy driver to register */

         //rp.rph.Status=STATUS_DONE;

         if (!rp.rph.Status) /* if invalid legacy mouse driver */
            rp.rph.Status=STERR;


         pRP->Status=STATUS_DONE|rp.rph.Status; 

      }
      else

         pRP->Status=STATUS_DONE|STERR;

      if (pRP->Status==STATUS_DONE)  /* if proper legacy mouse driver */
      {

#ifdef DEBUG
         dsPrint1(DBG_DETAILED, "USBMOUSE : Register Legacy Driver OK. Status=%x\r\n", rp.rph.Status);
#endif

         setmem((PSZ)&rp, 0, sizeof(rp));
         rp.rph.Cmd=CMDGenIOCTL;   // IOCTL
         rp.Category=USB_IDC_CATEGORY_CLASS; /* HID */
         rp.Function=USB_IDC_FUNCTION_REGISTER;  
         rp.ParmPacket=(PVOID)&classRegData;
         classRegData.usbIDC=(PUSBIDCEntry)&USBMOUSEidc;
         _asm
         { 
            mov classRegData.usbDS,ds   /* saves our DS */
         }  
         USBCallIDC( gpUSBHIDIDC, gdsUSBIDC, (RP_GENIOCTL FAR *)&rp ); /* calls HID */
         pRP->Status=rp.rph.Status;
      }

   }
   else  /* HID && legacy MDD attach failed */
      pRP->Status = STATUS_DONE | STERR;


#ifdef DEBUG
   if (pRP->Status==STATUS_DONE)
      dsPrint1(DBG_IRQFLOW, "USBMOUSE.SYS initialization completed sucessfully. Status=%x\r\n", pRP->Status);
   else
      dsPrint1(DBG_CRITICAL, "USBMOUSE.SYS initialization failed. Status=%x\r\n", pRP->Status);
#endif

   if ((pRP->Status==STATUS_DONE)&&(gMouseNo!=FULL_BYTE))  /* if we have to serve ONE mouse only */
   {
#ifdef DEBUG
      dsPrint1(DBG_CRITICAL, "USBMOUSE : IDC call Legacy: switch to single device mode DeviceNo=%d\r\n", gMouseNo);
#endif
      setmem((PSZ)&rp, 0, sizeof(rp));
      rp.rph.Cmd=CMDGenIOCTL;
      rp.Category=USB_IDC_CATEGORY_LEGACY; /* legacy mouse DD */
      rp.Function=USB_IDC_FUNCTION_SINGLE_DEVICE; /* function to prevent processing of legacy mouse */
      LMOUcallIDC( pLMOUSEIDC, dsLMOUSEIDC, (RP_GENIOCTL FAR *)&rp );
   }

   return;
}
  #pragma optimize("", on)

