/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMOUSE/MOUPROTO.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MOUPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Function prototypes provided by the USB Mouse         */
/*                      Device Driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the USB Mouse Device Driver                     */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer         Comment                              */
/*  ----    --------  ----------         -------                              */
/*          98/02/01  Vjacheslav Chibis                                       */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

void   far USBStrategy(); /* DD strategy processing routine */

void   CmdError( RPH FAR *pRP); /* Strategy command error processing routine  */

void   usbmouseInitComplete( RPH FAR *pRP); /* Strategy INITCOMPLETE */

void   FAR USBMOUSEidc( RP_GENIOCTL FAR *IOCtlR ); /* DD IDC processing routine */

void   USBMOUSEProcessIRQ( PRP_GENIOCTL pRP_GENIOCTL ); /* IDC PRCIRQ processing routine */

void   usbmouseInit( RPH FAR *pRP ); /* Strategy INIT */

void   FAR LMOUcallIDC( PUSBIDCEntry idcEntry, USHORT callingDS, RP_GENIOCTL FAR *pRP ); /* IDC call
                                                            to legacy driver processing */

void   CalculateItems(USHORT deviceIndex);  /* Calculates data we need
                                              to get items from Interrupt buffer */



USHORT CheckService(PRP_GENIOCTL pRP_GENIOCTL, UCHAR FAR *pInterface, UCHAR FAR *pReportID); /* checks if we can serve the device */
                                                   

USHORT SetActiveDevice(PRP_GENIOCTL pRP_GENIOCTL, UCHAR interface, UCHAR reportID); /*  adds
                                                        new mouse data to internal data stack */

USHORT ResetActiveDevice(PRP_GENIOCTL pRP_GENIOCTL); /* deletes mouse from internal data stack */


USHORT CheckTUsage(ItemFeatures FAR *pitemFeatures, ItemUsage FAR *pUsageData, USHORT IndexToUsageList, USHORT UsageID);

USHORT GetUsageType(PRP_GENIOCTL pRP_GENIOCTL, UCHAR ReportType, UCHAR ReportID, UCHAR interface, USHORT UsagePage, USHORT UsageID);

void CallLegasyIRQ(UCHAR DX, UCHAR DY, UCHAR Wheel, BOOL FAR *pButtons);


void   SetIdleTime( USHORT deviceIndex ); /* sets idle time */

void   ReadInterruptPipe( PRP_GENIOCTL pRP_GENIOCTL ); /* processes request
                                                      to read interrupt pipe */

void   ClearStalled( RP_GENIOCTL FAR *pRP_GENIOCTL);

void   SendLegacyIRQ(PRP_GENIOCTL pRP_GENIOCTL); /* sends Interrupt data from USB mouse 
                                                  to legacy driver */

USHORT (*StratList[])( RPH FAR *pRP ); /* Strategy command processing */

