/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBMOUSE/MOUINIT.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MOUINIT.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Mouse DD initialization routines                  */
/*                                                                            */
/*   FUNCTION: This file contains procedures we need during init time         */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:    usbmouseInit                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark      yy/mm/dd  Programmer       Comment                              */
/*  ------    --------  ----------       -------                              */
/*            98/01/30  Vjacheslav Chibis                                     */
/* 05/16/2000 00/05/16  MB            Changed init exit code to quiet exit if */
/*                                    USBHID.SYS driver is not installed.     */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "mouse.h"

static USHORT ParseCmdLine ( PSZ lineParms, PSZ key );
static BOOL   RMRegisterUSBMOUSE(void);

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  usbmouseInit                                     */
/*                                                                    */
/* DESCRIPTIVE NAME:  Initializes the USB Mouse Device Driver         */
/*                                                                    */
/* FUNCTION:  The function of this routine is to initialize the       */
/*            USB Mouse DD                                            */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Initialization time                                       */
/*                                                                    */
/* ENTRY POINT: usbmouseInit                                          */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  pRP-> kernel request packet                                */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS:  pRPO->CodeEnd = end of code segment                      */
/*           pRPO->DataEnd = end of data segment                      */
/*           pRP->Status = STATUS_DONE                                */
/*           pRP->Status = STDON + STERR + ERROR_I24_GEN_FAILURE      */
/*                                                                    */
/* INTERNAL REFERENCES:   NONE                                        */
/*                                                                    */
/* EXTERNAL REFERENCES:   RMCreateDriver                              */
/*                        RMCreateAdapter                             */
/*                        DevHelp_AttachDD                            */
/*                        TTYWrite                                    */     
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/

void usbmouseInit( RPH FAR *pRP)
{
   PRPINITOUT      pRPO;  /* output request packet far pointer */
   PRPINITIN       pRPI;  /* input request packet far pointer */
   PSZ             mouCmdLine; /* pointer to command line */
   ULONG           cmdRStatus, errColumn;  
   USHORT          cmdRc;

   /* Command line parameters */
   KeyData         keyData[2]={"V",CFSTR_TYPE_DEC,0,0, /* allow  verbose during init */
      "DEVICE:",CFSTR_TYPE_DEC,0,0};                  /* to switch to single device */
   /*                           */




#ifdef DEBUG
   dsPrint1(DBG_HLVLFLOW, "USBMOUSE init started. Command=%x\r\n", pRP->Cmd);
#endif

   pRP->Status = STATUS_DONE;           /* as default */

   if (ghDriver) // initilization already passed
      return;


   pRPI = (PRPINITIN) pRP;
   pRPO = (PRPINITOUT) pRP;

   Device_Help = ((PRPINITIN)pRP)->DevHlpEP;  /* save devhlp entry point */


   /*******************************/
   /* get pointer to command line */
   /*******************************/
   mouCmdLine=(PSZ) MAKEP( SELECTOROF(pRPI->InitArgs),
                           OFFSETOF(((PDDD_PARM_LIST)pRPI->InitArgs)) );


#ifdef DEBUG3
   dsPrint(0, "USBMOUSE : CmdLine=\"");

   for ( ;*mouCmdLine;mouCmdLine++ )
   {
      dsPrint1(0, "%d ", *mouCmdLine);
   }
   dsPrint(0, "\"\r\n");
#endif

   /* set command line processing statuses */
   cmdRStatus=ProcessConfigString(mouCmdLine, sizeof(keyData)/sizeof(keyData[0]), (KeyData FAR *)&keyData);
   cmdRc=LOUSHORT(cmdRStatus); errColumn=(ULONG)HIUSHORT(cmdRStatus);

   /* get  USB mouse # if it presents in command line */
   gMouseNo=((keyData[1].keyStatus!=CFSTR_STATUS_OK)||(!keyData[1].value)||(keyData[1].value>MAX_DEVICES))?(UCHAR)FULL_BYTE:(UCHAR)(--keyData[1].value);
   gMouseNoBak=gMouseNo;

   gVerbose= keyData[0].keyStatus!=CFSTR_STATUS_NOTFOUND; /* set  verbose variable */


#ifdef DEBUG
   dsPrint1(DBG_SPECIFIC, "USBMOUSE : gMouseNo=%d\r\n", gMouseNo);
#endif



   switch (cmdRc)
   {  // set cmd line processing errors
   case CFSTR_UNKWN_KEYS: /* invalid keys found in command line */
      SetLongValue( gVMessages[INIT_MESSAGE_UNKNOWNKWD], errColumn );
      gMessageCount=AddToMsgArray( gMessageIDs, INIT_MESSAGE_UNKNOWNKWD, gMessageCount, MAX_INIT_MESSAGE_COUNT );
      break;
   case CFSTR_CONVERR:  /* invalid key value found */
      SetLongValue( gVMessages[INIT_MESSAGE_INVNUMERIC], errColumn );
      gMessageCount=AddToMsgArray( gMessageIDs, INIT_MESSAGE_INVNUMERIC, gMessageCount, MAX_INIT_MESSAGE_COUNT );
      break;
   default:
      break;
   }


   setmem((PSZ)&DDTable, 0, sizeof(DDTable));   /* clear DDTable */

   /* try to attach HID and set  pRP->Status */
   if (!DevHelp_AttachDD( USBDriverName, (NPBYTE)&DDTable)  && DDTable.ProtIDCEntry && DDTable.ProtIDC_DS)
   {
      gpUSBHIDIDC = (PUSBIDCEntry)DDTable.ProtIDCEntry; /* save HID IDC entry point */
      gdsUSBIDC = DDTable.ProtIDC_DS; /* save HID`s data segment`s value */
      pRP->Status = STATUS_DONE;
   }
   else
   {
      pRP->Status = STATUS_DONE | STERR | ERROR_I24_QUIET_INIT_FAIL; // 05/16/2000 MB - exit code changed to quiet exit code
      /* initialize verbose msg "no HID"*/
      gMessageCount = AddToMsgArray( gMessageIDs, INIT_MESSAGE_NO_HID, gMessageCount, MAX_INIT_MESSAGE_COUNT );
   }

   /* try to attach legacy mouse driver and set  pRP->Status */
   if (pRP->Status == STATUS_DONE)
   {
      if (DevHelp_AttachDD( LMouseDriverName, (NPBYTE)&DDTable)  || !DDTable.ProtIDCEntry || !DDTable.ProtIDC_DS)
      {
         pRP->Status = STATUS_DONE | STERR | STATUS_ERR_UNKCMD;      /* Couldn't find OEMHLP's IDC */
#ifdef DEBUG
         dsPrint(DBG_CRITICAL, "USBMOUSE : Unable to initialize MOUSE.SYS\r\n");
#endif
         gMessageCount = AddToMsgArray( gMessageIDs, INIT_MESSAGE_NO_LEGACY, gMessageCount, MAX_INIT_MESSAGE_COUNT );

      }
      else
      {
         pLMOUSEIDC = (PUSBIDCEntry)DDTable.ProtIDCEntry; /* save legacy mouse DD IDC entry */
         dsLMOUSEIDC = DDTable.ProtIDC_DS; /* save legacy mouse DD data segment value */
      }

   }
   else
   {

#ifdef DEBUG
      dsPrint(DBG_CRITICAL, "USBMOUSE : Unable to initialize USBHID.SYS\r\n" );
#endif
   }


   /*---------------------------------------------------*/
   /* Register device driver with resource manager      */
   /*---------------------------------------------------*/

   if (pRP->Status==STATUS_DONE)
      if (RMRegisterUSBMOUSE())
         pRP->Status|=STATUS_DONE;


   if (pRP->Status == STATUS_DONE)
   {
      pRPO->CodeEnd = ((USHORT) &LastCode) - 1;  /* set end of code segment */
      pRPO->DataEnd = ((USHORT) &InitDataStart) - 1; /* set end of data segment */
      /*******************************/
      /* initialize verbose messages */
      /*******************************/
      SetLongValue( gVMessages[INIT_MESSAGE_LOADED], (ULONG)gDriverStruct.MajorVer );   
      SetLongValue( gVMessages[INIT_MESSAGE_LOADED], (ULONG)gDriverStruct.MinorVer );   
      gMessageCount=AddToMsgArray( gMessageIDs, INIT_MESSAGE_LOADED, gMessageCount, MAX_INIT_MESSAGE_COUNT );

   }
   else
   {
      pRPO->CodeEnd = 0; /* set end of code segment */
      pRPO->DataEnd = 0; /* set end of data segment */
#ifdef DEBUG
      dsPrint(DBG_CRITICAL, "USBMOUSE.SYS not installed.\r\n");
#endif 
   }

   TTYWrite(gVMessages, gMessageIDs, gMessageCount); /* output verbose messages */

#ifdef DEBUG
   if (pRP->Status==STATUS_DONE)
   {
      dsPrint(DBG_HLVLFLOW, "USBMOUSE : Init OK.\r\n");
   }
#endif
   return;
}

 
/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  RMRegisterUSBMOUSE                               */
/*                                                                    */
/* DESCRIPTIVE NAME: Register USB mouse DD with resource manager      */
/*                                                                    */
/* FUNCTION: Register  USB mouse device driver with resource manager  */
/*                                                                    */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT:                                                           */
/*                                                                    */
/* ENTRY POINT: RMRegisterUSBMOUSE                                    */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:                                                             */
/*                                                                    */
/* EXIT-NORMAL: TRUE                                                  */
/*                                                                    */
/* EXIT-ERROR: FALSE                                                  */
/*                                                                    */
/* EFFECTS: none                                                      */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* INTERNAL REFERENCES: none                                          */
/*                                                                    */
/* EXTERNAL REFERENCES: RMcreateDriver, RMcreateAdapter               */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
static BOOL RMRegisterUSBMOUSE( void )
{
   APIRET      rc=RMRC_SUCCESS;
   UCHAR       ResourceBuf[12];  
   ADJUNCT     AdjAdaptNum;
   PAHRESOURCE pResourceList = (PAHRESOURCE)ResourceBuf;

   rc=RMCreateDriver( &gDriverStruct, &ghDriver); /* call resource manager */

   if (rc==RMRC_SUCCESS) /* if create driver ok */
   {
      pResourceList->NumResource  = 0;
      gAdapterStruct.HostBusType  = AS_HOSTBUS_PCI;
      AdjAdaptNum.pNextAdj        = NULL;
      AdjAdaptNum.AdjLength       = sizeof(ADJUNCT);
      AdjAdaptNum.AdjType         = ADJ_ADAPTER_NUMBER;
      AdjAdaptNum.Adapter_Number  = 0;
      gAdapterStruct.pAdjunctList = &AdjAdaptNum;
      rc=RMCreateAdapter(ghDriver, &ghAdapter,  &gAdapterStruct, NULL, pResourceList);
   }

   return (rc==RMRC_SUCCESS);
}


