/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBKBD/KBDEXTRN.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  KBDEXTRN.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Keyboard driver external data declarations        */
/*                                                                            */
/*   FUNCTION: This module is the USB Keyboard driver external                */
/*             data declarations include file.                                */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/06/30  LR                                                      */
/*          99/01/29  LR              Modified to support Japanese (Kanji)    */
/*                                    keys.                                   */
/*  TM0528  99/05/28  LR              Modified to support time in ms.         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#ifdef DEBUG
extern USHORT gUKBDMsg;
#endif

extern PRPH    pRP;
extern PFN     Device_Help;

extern IDCTABLE      gIDCTable;
extern PUSBIDCEntry  gpHIDIDC;
extern USHORT        gdsHIDIDC;
extern PKBDDDIDC     gpLegKBDIDC;

extern BYTE gInitDataStart;

extern DRIVERSTRUCT  gDriverStruct;
extern ADAPTERSTRUCT gAdapterStruct;
extern DEVICESTRUCT  gDeviceStruct;

extern HDRIVER    ghDriver;
extern HADAPTER   ghAdapter;
extern HDEVICE    ghDevice;

extern char gDDName[];
extern char gDDDesc[];
extern char gVendorID[];
extern char gAdapterName[];

extern KBDList gKBD[];
extern USHORT  gNoOfKBDs;

extern BYTE gTypeDelay;
extern BYTE gTypeRate;
extern BYTE gScanCode[];
extern BYTE gKanjiSC[];
extern BYTE gVerbose;
extern BYTE gDevice;
extern BYTE gLEDs;

extern USHORT gKbdIndex;

extern PDDD_PARM_LIST pDDD_Parm_List;
extern MSGTABLE       gInitMsg;

extern USHORT  gMessageIDs[];
extern PSZ     gVMessages[];
extern USHORT  gMessageCount;

extern PULONG  gPTime;  //TM0528

