/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBKBD/KBDDATA.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  KBDDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Keyboard driver data segment                      */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             USB device driver.                                             */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/06/30  LR                                                      */
/*          99/01/29  LR              Modified to support Japanese (Kanji)    */
/*                                    keys.                                   */
/*  TM0528  99/05/28  LR              Modified to support time in ms.         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "kbd.h"

/*
    Variables
*/
HDRIVER  ghDriver = NULL;     // global handle to Driver
PRPH     pRP = NULL;          // pointer to Request Packet (Header)
PFN      Device_Help = NULL;  // pointer to DevHlp routines

IDCTABLE gIDCTable = {{ 0, 0, 0}, 0, 0}; //     structure used by DevHlp AttachDD

PUSBIDCEntry gpHIDIDC  = NULL;
USHORT       gdsHIDIDC = NULL;

PKBDDDIDC   gpLegKBDIDC = NULL;

/*
    GLOBAL VARS FOR RM. RM.LIB needs these declared
*/
ULONG RMFlags  = 0L;
PFN   RM_Help0 = 0L;
PFN   RM_Help3 = 0L;

DRIVERSTRUCT gDriverStruct = // Driver Description
{
   gDDName,                    // DrvrName
   gDDDesc,                    // DrvrDescript
   gVendorID,                  // VendorName
   CMVERSION_MAJOR,            // MajorVer
   CMVERSION_MINOR,            // MinorVer
   2001,4,30,                  // Date
   DRF_STATIC,                 // DrvrFlags
   DRT_OS2,                    // DrvrType
   DRS_CHAR,                   // DrvrSubType
   NULL                        // DrvrCallback
};
ADAPTERSTRUCT gAdapterStruct = // Adapter Description
{
   gAdapterName,                 // AdaptDescriptName
   AS_NO16MB_ADDRESS_LIMIT,      // AdaptFlags
   AS_BASE_INPUT,                // BaseType
   AS_SUB_KBD,                   // SubType
   AS_BASE_COMM,                 // InterfaceType
   NULL,                         // HostBusType
   AS_BUSWIDTH_32BIT,            // HostBusWidth
   NULL,                         // pAdjunctList
   NULL                          // reserved
};
HADAPTER ghAdapter      = NULL; // global handle to RM adapter

KBDList gKBD[MAX_KBDS]; // keyboard list
USHORT  gNoOfKBDs;
/*
    Legacy Keyboard Scan Codes [ USB Keyboard Usage Index ]

                Usage   Usage
                Index
*/
BYTE    gScanCode[UI_MAX+1] =
{
   NULL,          //  0   reserved (no event indicated)
   NULL,          //  1   reserved (ErrorRollOver)
   NULL,          //  2   reserved (POSTFail)
   NULL,          //  3   reserved (ErrorUndefined)
   SCAN_A,
   SCAN_B,
   SCAN_C,
   SCAN_D,
   SCAN_E,
   SCAN_F,
   SCAN_G,
   SCAN_H,
   SCAN_I,
   SCAN_J,
   SCAN_K,
   SCAN_L,
   SCAN_M,
   SCAN_N,
   SCAN_O,
   SCAN_P,
   SCAN_Q,
   SCAN_R,
   SCAN_S,
   SCAN_T,
   SCAN_U,
   SCAN_V,
   SCAN_W,
   SCAN_X,
   SCAN_Y,
   SCAN_Z,
   SCAN_1,
   SCAN_2,
   SCAN_3,
   SCAN_4,
   SCAN_5,
   SCAN_6,
   SCAN_7,
   SCAN_8,
   SCAN_9,
   SCAN_0,
   SCAN_ENTER,    // 40   keyboard Enter
   SCAN_ESC,
   SCAN_BACKSP,
   SCAN_TAB,
   SCAN_SP,
   SCAN_MINUS,
   SCAN_PLUS,
   SCAN_LBRACE,
   SCAN_RBRACE,
   SCAN_BACKSL,
   SCAN_BACKSL,   // 50   non-US # and ~
   SCAN_COLON,
   SCAN_APOSTR,
   SCAN_ACCENT,
   SCAN_COMMA,
   SCAN_POINT,
   SCAN_SLASH,
   SCAN_CLOCK,
   SCAN_F1,
   SCAN_F2,
   SCAN_F3,
   SCAN_F4,
   SCAN_F5,
   SCAN_F6,
   SCAN_F7,
   SCAN_F8,
   SCAN_F9,
   SCAN_F10,
   SCAN_F11,
   SCAN_F12,
   NULL,          // 70   PrintScreen
   SCAN_SLOCK,
   NULL,          // 72   Pause

   SCAN_INS,      // 73   with SCAN_E0 prefix
   SCAN_HOME,     // 74   with SCAN_E0 prefix
   SCAN_PGUP,     // 75   with SCAN_E0 prefix
   SCAN_DEL,      // 76   with SCAN_E0 prefix
   SCAN_END,      // 77   with SCAN_E0 prefix
   SCAN_PGDOWN,   // 78   with SCAN_E0 prefix
   SCAN_RIGHT,    // 79   with SCAN_E0 prefix
   SCAN_LEFT,     // 80   with SCAN_E0 prefix
   SCAN_DOWN,     // 81   with SCAN_E0 prefix
   SCAN_UP,       // 82   with SCAN_E0 prefix

   //      KEYPAD
   SCAN_NLOCK,
   SCAN_SLASH,    // 84   with SCAN_E0 prefix
   SCAN_ASTER,
   SCAN_KMINUS,
   SCAN_KPLUS,
   SCAN_ENTER,    // 88   with SCAN_E0 prefix
   SCAN_END,
   SCAN_DOWN,
   SCAN_PGDOWN,
   SCAN_LEFT,
   SCAN_K5,
   SCAN_RIGHT,
   SCAN_HOME,
   SCAN_UP,
   SCAN_PGUP,
   SCAN_INS,
   SCAN_DEL,

   SCAN_NUSBSL,   // 100  non-US \ and |
   SCAN_APPL      // 101  keyboard application (Microsoft Windows key), with SCAN_E0 prefix
};
BYTE    gKanjiSC[UI_KANJI_MAX-UI_KANJI_MIN+1] =
{
   SCAN_KANJI1,
   SCAN_KANJI2,
   SCAN_KANJI3,
   SCAN_KANJI4,
   SCAN_KANJI5,
   SCAN_KANJI6,
   SCAN_KANJI7
};

BYTE gLEDs = NULL;

BYTE gTypeDelay = DURATION_DELAY;    // OS/2 default = 250 ms
BYTE gTypeRate  = DURATION_RATE;     // OS/2 default = 18.5 times per second = 54 ms

PULONG   gPTime;  //TM0528 far Pointer to Time in milliseconds in the system info structure

#ifdef DEBUG
USHORT gUKBDMsg = DBG_CRITICAL;      // debug message level
#endif

USHORT gKbdIndex      = FULL_WORD;
BYTE   gDevice        = NULL;
BYTE   gInitDataStart = NULL;        // END OF THE DATA SEGMENT
BYTE   gVerbose       = NULL;

USHORT gMessageIDs[MAX_INIT_MESSAGE_COUNT];
USHORT gMessageCount = 0;
PSZ    gVMessages[] = {"IUSBKBD.SYS: USB Keyboard Client V.%dd.%dd installed (/DEVICE:%dd)",
   "EUSBKBD.SYS: USB HID Driver not found",
   "EUSBKBD.SYS: Invalid numeric value in CONFIG.SYS line at column %dd",
   "EUSBKBD.SYS: Invalid parameter in CONFIG.SYS line at column %dd",
   "EUSBKBD.SYS: Legacy Keyboard Driver not found"
};

#define MSG_REPLACEMENT_STRING  1178

MSGTABLE gInitMsg = {MSG_REPLACEMENT_STRING, 1, 0}; //  structure used to write out message during initialization

PDDD_PARM_LIST pDDD_Parm_List = { 0};

