/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/COM/COMPROTO.H, usb, c.basedd 98/10/26" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  COMPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Communication Device Class Driver                 */
/*                      function prototypes                                   */
/*                                                                            */
/*   FUNCTION: This module is the USB Communication Device Class Driver       */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/10/26  LR                                                      */
/*  LR0313  00/03/13  LR              Improved Input/Output Flush.            */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

// COMSTRAT.C
void FAR COMStrategy (void);
void     CmdError (PRPH pRP);
void     COMRead (PRPH pRP);
void     COMInStatus (PRPH pRP);
void     COMInFlush (PRPH pRP);
void     COMWrite (PRPH pRP);
void     COMOutStatus (PRPH pRP);
void     COMOutFlush (PRPH pRP);
void     COMOpen (PRPH pRP);
void     COMClose (PRPH pRP);
void     COMInitComplete (PRPH pRP);
void     SendCommand (USHORT length);
void     GetResponse (USHORT length);
void     SetFeature (USHORT feature);
void     GetFeature (void);
void     ClearFeature (void);
void     SetLineCoding (void);
void     GetLineCoding (void);
void     SetSignals (void);
void     SendBreak (USHORT duration, ULONG comIRQ);
/*
   COMIOCtl.C                        Category = 1, Function
*/   
void COMIOCtl (PRPH pRP);
void FuncError (PRP_GENIOCTL pRPIOCtl);
void SetBitRate (PRP_GENIOCTL pRPIOCtl);        // 0x41
void SetLine (PRP_GENIOCTL pRPIOCtl);           // 0x42
void SetBitRateExt (PRP_GENIOCTL pRPIOCtl);     // 0x43
void TransmitImm (PRP_GENIOCTL pRPIOCtl);       // 0x44
void SetBreakOff (PRP_GENIOCTL pRPIOCtl);       // 0x45
void SetMdmCtrl (PRP_GENIOCTL pRPIOCtl);        // 0x46
void StopTransmit (PRP_GENIOCTL pRPIOCtl);      // 0x47
void StartTransmit (PRP_GENIOCTL pRPIOCtl);     // 0x48
void SetBreakOn (PRP_GENIOCTL pRPIOCtl);        // 0x4B
void SetDCB (PRP_GENIOCTL pRPIOCtl);            // 0x53
void GetBitRate (PRP_GENIOCTL pRPIOCtl);        // 0x61
void GetLine (PRP_GENIOCTL pRPIOCtl);           // 0x62
void GetBitRateExt (PRP_GENIOCTL pRPIOCtl);     // 0x63
void GetStatus (PRP_GENIOCTL pRPIOCtl);         // 0x64
void GetTxStatus (PRP_GENIOCTL pRPIOCtl);       // 0x65
void GetModemOutput (PRP_GENIOCTL pRPIOCtl);    // 0x66
void GetModemInput (PRP_GENIOCTL pRPIOCtl);     // 0x67
void GetInQueue (PRP_GENIOCTL pRPIOCtl);        // 0x68
void GetOutQueue (PRP_GENIOCTL pRPIOCtl);       // 0x69
void GetError (PRP_GENIOCTL pRPIOCtl);          // 0x6D
void GetEvent (PRP_GENIOCTL pRPIOCtl);          // 0x72
void GetDCB (PRP_GENIOCTL pRPIOCtl);            // 0x73
void GetEnhMode (PRP_GENIOCTL pRPIOCtl);        // 0x74

// COMDATA.C
void (*gStratList[]) (PRPH pRP);
void (*gFuncList[]) (PRP_GENIOCTL pRPIOCtl);

// COMIDC.C
void FAR COMidc (PRP_GENIOCTL pRP_GENIOCTL);
void     MDMService (PRP_GENIOCTL pRP_GENIOCTL);
void     MDMDetach (PRP_GENIOCTL pRP_GENIOCTL);

FuncDescriptor FAR *GetFuncDescriptor (UCHAR FAR *configurationData,
                                       UCHAR bNumConfigurations,
                                       UCHAR configurationValue,
                                       UCHAR subtype);
void COMInfoInit (void);

void FlushOut (void);   //LR0313
void FlushIn (void);    //LR0313

// COMIRQ.C
void COMirq (PRP_GENIOCTL pRP_GENIOCTL);
void EnableNotifications (void);
void TransmitCommand (void);
void ReceiveData (void);
void SendData (void);
void SendByte (PUCHAR pByte, ULONG comIRQ);

// COMINIT.C
void COMInit (RPH FAR *pRP);

/*
LR0313
   USHORT APIENTRY DevHelp_Yield(); in DHCALLS.H causes
   warning C4071: 'DevHelp_Yield' : no function prototype given
*/
USHORT APIENTRY DevHelp_Yield(void);

