/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/COM/COMEXTRN.H, usb, c.basedd 98/10/26" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  COMEXTRN.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Communication Device Class Driver                 */
/*                      external data declarations                            */
/*                                                                            */
/*   FUNCTION: This module is the USB Communication Device Class Driver       */
/*             external data declarations include file. See comdata.c         */
/*             for the data items being externalized.                         */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/10/26  LR                                                      */
/*  LR0426  99/04/26  LR               Add support for multiple drivers and   */
/*                                     /M:n parameter                         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#ifdef   DEBUG
extern   USHORT   gCOMMsg;  // debug message level
#endif

extern char gDDName[];
extern char gDDDesc[];
extern char gVendorID[];
extern char gAdapterName[];

extern   DRIVERSTRUCT   gDriverStruct;
extern   ADAPTERSTRUCT  gAdapterStruct;

extern   HDRIVER        ghDriver;
extern   HADAPTER       ghAdapter;

extern   PFN            Device_Help;

extern   IDCTABLE       gIDCTable;
extern   PUSBIDCEntry   gpUSBDIDC;
extern   USHORT         gdsUSBDIDC;

extern BYTE           gInitDataStart;
extern USHORT         gVerbose;
extern USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT];
extern PSZ            gVMessages[];
extern USHORT         gMessageCount;

extern COMInfo    gCOM;
extern CHAR       gCOMn[];
extern DeviceList gMDM[];
extern UCHAR      gNoOfMDMs;
extern UCHAR      gMaxMDMs;   //LR0426

