/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/COM/COMDATA.C, usb, c.basedd 98/10/26" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  COMDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Communication Device Class Driver data segment    */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             USB Communication Device Class Driver.                         */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/10/26  LR                                                      */
/*  LR0426  99/04/26  LR              Added support for multiple drivers and  */
/*                                    /M:n parameter.                         */
/*  LR0518  00/05/18  LR              Updated to support allocated I/O queues.*/
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "usbcom.h"

COMInfo     gCOM;
DeviceList  gMDM[MAX_MDMS];   // modem list served by USB COM driver
UCHAR       gNoOfMDMs;
UCHAR       gMaxMDMs;         //LR0426
/*
   Dispatch table for strategy commands
*/
void (*gStratList[])() =
{
   COMInit,          // 0x00  initialize device driver
   CmdError,         // 0x01  check the media
   CmdError,         // 0x02  build BPB
   CmdError,         // 0x03  reserved
   COMRead,          // 0x04  read
   CmdError,         // 0x05  non-destructive read
   COMInStatus,      // 0x06  input status
   COMInFlush,       // 0x07  input flush
   COMWrite,         // 0x08  write
   COMWrite,         // 0x09  write with verify
   COMOutStatus,     // 0x0A  output status
   COMOutFlush,      // 0x0B  flush output
   CmdError,         // 0x0C  reserved
   COMOpen,          // 0x0D  open
   COMClose,         // 0x0E  close
   CmdError,         // 0x0F  removable media
   COMIOCtl,         // 0x10  generic IOCTL
   CmdError,         // 0x11  reset uncertain media
   CmdError,         // 0x12  get Logical Drive Map
   CmdError,         // 0x13  set Logical Drive Map
   CmdError,         // 0x14  de-Install this device
   CmdError,         // 0x15  reserved
   CmdError,         // 0x16  get number of partitions
   CmdError,         // 0x17  get unit map
   CmdError,         // 0x18  no caching read
   CmdError,         // 0x19  no caching write
   CmdError,         // 0x1A  no caching write/verify
   CmdError,         // 0x1B  initialize base device driver
   CmdError,         // 0x1C  reserved for Request List code
   CmdError,         // 0x1D  get driver capabilities
   CmdError,         // 0x1E  reserved
   COMInitComplete   // 0x1F  initialization complete
};
/*
   Dispatch table for IOCtl functions
*/
void (*gFuncList[])() =
{
   SetBitRate,        // 0x41  set bit rate
   SetLine,           // 0x42  set line characteristics (data bits, parity, stop bits)
   SetBitRateExt,     // 0x43  extended set bit rate
   TransmitImm,       // 0x44  transmit byte immediate
   SetBreakOff,       // 0x45  set break off
   SetMdmCtrl,        // 0x46  set modem control signals
   StopTransmit,      // 0x47  behave as if XOFF received (stop  transmit)
   StartTransmit,     // 0x48  behave as if XON  received (start transmit)
   FuncError,         // 0x49  reserved
   FuncError,         // 0x4A
   SetBreakOn,        // 0x4B  set break on
   FuncError,         // 0x4C
   FuncError,         // 0x4D
   FuncError,         // 0x4E
   FuncError,         // 0x4F
   FuncError,         // 0x50
   FuncError,         // 0x51
   FuncError,         // 0x52
   SetDCB,            // 0x53  set Device Control Block (DCB) info
   FuncError,         // 0x54  set enhanced mode parameters
   FuncError,         // 0x55
   FuncError,         // 0x56
   FuncError,         // 0x57
   FuncError,         // 0x58
   FuncError,         // 0x59
   FuncError,         // 0x5A
   FuncError,         // 0x5B
   FuncError,         // 0x5C
   FuncError,         // 0x5D
   FuncError,         // 0x5E
   FuncError,         // 0x5F
   FuncError,         // 0x60
   GetBitRate,        // 0x61  query current bit rate
   GetLine,           // 0x62  query line characteristics
   GetBitRateExt,     // 0x63  extended query bit rate
   GetStatus,         // 0x64  query status
   GetTxStatus,       // 0x65  query transmit data status
   GetModemOutput,    // 0x66  query modem control output signals (MCR)
   GetModemInput,     // 0x67  query current modem input  signals (MSR)
   GetInQueue,        // 0x68  query number of characters in receive  queue
   GetOutQueue,       // 0x69  query number of characters in transmit queue
   FuncError,         // 0x6A
   FuncError,         // 0x6B
   FuncError,         // 0x6C
   GetError,          // 0x6D  query error information
   FuncError,         // 0x6E
   FuncError,         // 0x6F
   FuncError,         // 0x70
   FuncError,         // 0x71
   GetEvent,          // 0x72  query event information
   GetDCB,            // 0x73  query Device Control Block (DCB) parameters
   GetEnhMode         // 0x74  query enhanced mode parameters
};
PFN   Device_Help = NULL;  // pointer to DevHlp routines

PUSBIDCEntry   gpUSBDIDC = NULL;
USHORT         gdsUSBDIDC = NULL;

#ifdef DEBUG
USHORT   gCOMMsg = DBG_CRITICAL;   // debug message level
#endif
///////////////////////////////////////////////////////////////////////////
// INIT DATA INIT DATA INIT DATA INIT DATA INIT DATA INIT DATA INIT DATA //
///////////////////////////////////////////////////////////////////////////
BYTE     gInitDataStart = NULL;
IDCTABLE gIDCTable = {{ 0, 0, 0}, 0, 0}; //	structure used by DevHlp AttachDD
USHORT   gVerbose       = NULL;
USHORT   gMessageCount  = NULL;
USHORT   gMessageIDs[MAX_INIT_MESSAGE_COUNT];
PSZ      gVMessages[] =
{  //                                                                      DrivName
   "IUSBCOM.SYS: USB Communication Device Class Driver V.%dd.%dd loaded at $$$$$$$$",
   "IUSBCOM.SYS: Input queue: %ddK bytes, Output queue: %ddK bytes", //LR0518
   "EUSBCOM.SYS: USBD Driver not found",
   "EUSBCOM.SYS: I/O queue not allocated",   //LR0518
   "EUSBCOM.SYS: Invalid parameter in CONFIG.SYS line at column %dd",
   "EUSBCOM.SYS: Invalid numeric value in CONFIG.SYS line at column %dd"
};
MSGTABLE gInitMsg = {MSG_REPLACEMENT_STRING, 1, 0}; // structure used to write out message during initialization
/*
    Resource Manager (RM) Data.
    The RMCALLS.LIB references the following four variables:
     
PFN   Device_Help = NULL; // see above
*/
ULONG RMFlags  = 0UL;
PFN   RM_Help0 = NULL;
PFN   RM_Help3 = NULL;

HDRIVER      ghDriver = 0;    // global handle to Driver
DRIVERSTRUCT gDriverStruct =
{
   gDDName,                   // DrvrName
   gDDDesc,                   // DrvrDescript
   gVendorID,                 // VendorName
   CMVERSION_MAJOR,           // MajorVer
   CMVERSION_MINOR,           // MinorVer
   2000,5,18,                 //LR0518 Date     
   DRF_STATIC,                // DrvrFlags
   DRT_OS2,                   // DrvrType
   DRS_CHAR,                  // DrvrSubType
   NULL                       // DrvrCallback
};
HADAPTER      ghAdapter = 0;  // global handle to Adapter
ADAPTERSTRUCT gAdapterStruct =
{
   gAdapterName,              // AdaptDescriptName
   AS_NO16MB_ADDRESS_LIMIT,   // AdaptFlags
   AS_BASE_COMM,              // BaseType
   AS_SUB_SERIAL,             // SubType
   AS_BASE_COMM,              // InterfaceType
   NULL,                      // HostBusType
   AS_BUSWIDTH_32BIT,         // HostBusWidth
   NULL,                      // pAdjunctList
   NULL                       // reserved
};

