/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  usbextrn.h                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME: global external definitions for USBAUDIO DD            */
/*                                                                            */
/*                                                                            */
/*   FUNCTION:   global external definitions for USBAUDIO DD                  */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:	N/A     										               */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*       2000/01/26   Vjacheslav Chibis   USB audio input added               */
/* 08/01/2000 00/08/01 MB                 Added variable to fix file handle   */
/*                                      processing instream registration call */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/


//  FUNCTIONS DEFINITION BLOCK //


extern   Strategy();			// IOCTL entry point
extern   VOID CancelBuffers(PSTREAM pStream); // cancel all active buffers
extern   VOID ReportBuffer(PSTREAM pStream); // report free buffer to the stream handler
extern   VOID ReportEvent(PSTREAM pStream, BOOL bResetEvent);	// reports events to the stream handler
extern   VOID GetUSBDIDC();  // gets USB driver IDc routine entry point
extern   VOID SetStreamState(PSTREAM pStream, USHORT usState);	// sets active stream state
extern   ServeIDCCall();				  // Device driver command entry point
extern   VOID FAR USBDIDCEntry(); // USB  driver IDC processing routine
extern   USHORT   RegisterDriver();	// registrates USB Audio driver within USBD
extern   VOID   USBAUDIOProcessIRQ(); // process USB interrupts from Audio devices 
extern   USHORT DetachDevice(); // process device detach idc call
extern   VOID SetUnitControl( USHORT deviceIndex, UCHAR bControlSelector, UCHAR  ucChannelNo, USHORT wBufferSize, PUCHAR pData);	// sets unit control value for the specified value
extern   VOID FAR PASCAL CTXReportBuffer( VOID ); // re : report free buffer
extern   VOID GetUnitControl( USHORT deviceIndex, UCHAR bControlSelector, UCHAR  ucChannelNo, USHORT wBufferSize, PUCHAR pData, UCHAR ucRequest, BOOL notificationRequired); // get the ranges for the unit control values // 04/05/2000 MB
extern   VOID USBSetInterface( USHORT deviceIndex, USHORT altInterface, PSTREAM pStream, BOOL bEnablePlay, USHORT usByPass );	// sets interface for the secified device
extern   VOID USBAUDIOClearStalled( PRP_GENIOCTL pRP );// processes USB data transmittion error
extern   ULONG   Audio_IOCTL_Capability(PREQPACKET pPR);	// IOCTL capability routine
extern   RC InitNewDevice( UCHAR  ucActiveDeviceIndex, PSTREAM pStream ); // initializes new attached devices  // 04/05/2000 MB
extern   UCHAR    CreateStream(ULONG ulSysFileNum); // creates new stream with associated sysfilenum
extern   UCHAR    DestroyStream(USHORT usSysFileNum);	// destoys stream
extern   RC       StartDevice(PSTREAM pStream);	// initialize isohronous data transmitting interface for the specified device
extern   RC       ResumeDevicePlay(PSTREAM pStream); // resume USB Audio device playing
extern   PULONG GetStreamTime (PSTREAM pStream);  // What is present time in stream
extern   ULONG    GetBuffSize(PSTREAM pStream);	// calculates USB related data buffer size
extern   SHORT SetSystemTimer(USHORT);	// sets system timer for the specified valu  of interrupts in second
extern   USHORT DevHlp_ResetTimer (PVOID TimerHandler);	// resets system timer irq handler
extern   VOID FAR TimerInterruptHandler(VOID); // system timer irq handler
extern   RC MixerIOCTL(); // mixer IO controls
extern   BOOL     CheckChannelFeature( FUnitDescriptor FAR *featureDesc, USHORT feature, UCHAR channel);	// sets cahnnel capabilities
extern   UCHAR    GetChannelCount( FUnitDescriptor FAR *featureDesc); //  gets device channel number
extern   VOID     SetControlCapabilities(UCHAR deviceIndex, PULONG pulFlags); // sets device control capabilities global data
extern   VOID     SetChannelsCapabilities(USHORT deviceIndex, FUnitDescriptor FAR *featureDesc); // sets channel capabilities for the device in globl data structures
extern   VOID GenerateDetach(UCHAR    controllerId,  UCHAR    deviceAddress);	 // emulates detach procedure
extern   RC (*gAudioIOCTLFuncs[])(PREQPACKET pRP);	// generic IOCTL`s processing routine 
extern   RC ISOOpen( PSTREAM pStream, USHORT usFrameLength); // opens isohronous data transfer for USB
extern   RC ISOSendBuffer( PSTREAM , USHORT); // sends data buffer to the USB Audio device
extern   RC ISOSend(PSTREAM paStream);
extern   RC ISOGetBuffer( PSTREAM , USHORT); // sends data buffer to the USB Audio device
extern   RC ISOClose(PSTREAM pStream); // closes isohrounous data transfer pipe for the device  // 04/05/2000 MB
extern   RC ISOStatus( PSTREAM pStream, PUCHAR FAR *ppBuffer, PUSHORT usBytes); // returns current status of iso buffer having played
extern   RC ISOCancel( PSTREAM pStream, PCHAR FAR * ppBuffer, PUSHORT ulBytes); // cancels device to play remained buffers // 04/05/2000 MB
extern   BOOL GetBestFit( PUCHAR    configurationData, // calculates best fit for the current active device and current stream data format
								  UCHAR     bNumConfigurations,
								  UCHAR     bConfigurationValue,
								  UCHAR     interface,
								  PULONG    dataType,
								  PULONG    samplingRate,
								  PULONG    channels,
								  PULONG    bitsPerSample,
								  PUCHAR    altInterface
								);
extern   USHORT GetUnitControlValue(USHORT usValue, USHORT usMinValue, USHORT usMaxValue ); // gets current unit control value for the device

extern   UCHAR GetActiveDeviceIndex(ULONG ulOperation);
extern   PADEVICE GetActiveDevice(ULONG ulOperation);
extern   RC FindDevice(UCHAR devAddr, PUCHAR  pucIndex);
VOID     CloseISODevice(UCHAR ucDeviceIndex, ULONG ulOperation);   // 04/05/2000 MB

#ifdef CONVERTER
extern   void SignConverter(PULONG pBuffer, USHORT usBuffLen);	// converter  PCM8->PCM and vv
#endif




//  STRUCTURES DEFINITIONS BLOCK //
extern   GLOBAL GlobalTable; // Gloabl variables table
extern   IDCTABLE gDDTable;  // Device Driver table
extern   HRESOURCE hResPorts[];	  // global handles to port resources
extern   AudioDevice gAudioDevices[MAX_AUDIO_DEVICES];	// active device list served by USBAUDIO
extern   USB_AUDIO_CHANGE gUSBAC; // audio cahnge control block for USB Audio
extern   EVENT_QUEUE aEventQueue[DEFAULTSTREAMS][MAX_EVENT_QUEUE]; // Events queue
extern   USBSetConf gSC; // Set configuration control block
extern   SetupPacket gSetupPacket[]; // Setup packet control block
extern   SetupPacket gReadSetupPacket[]; // Setup packet control block
extern   SetupPacket gsp ;	// Setup packet control block
extern   USBDetach gDetachData; // Detach data
extern   RP_GENIOCTL gRP; // Generic IOCTL request packet
extern   PRP_GENIOCTL gpRP; // poiner to the Generic IOCTL request packet
extern   DRIVERSTRUCT gDriverStruct; // driver`s structure 




//   VARIABLES DEFINITIONS //

extern   ULONG gPCMTable[NUMFREQS][BPSTYPES][MONOSTEREO]; // PCM datatypes 3d array
extern   ULONG gALaw[NUMFREQS][MONOSTEREO]; // ALAW datatypes 2D array
extern   ULONG gMuLaw[NUMFREQS][MONOSTEREO];	// MULAW datatypes 2D array
extern   ULONG gRBHandle; // RB handle
extern   ULONG gulSysFileNum;  // 08/01/2000 MB

extern   USHORT gMaxAudioIOCTLFuncs; // number of audio IOCTL functions
extern   USHORT gTicks;	// system timer ticks value
extern   USHORT gMessageIDs[]; // Verbose messages
extern   USHORT gMessageCount; // Verbose messages counter
extern   USHORT EndOfData;	 // end of data pointer
extern   USHORT gVerbose; // Verbose parameter
extern   UCHAR  gNoOfActiveAudioDevices; // number of active USB Audio devices
extern   USHORT gUSBDds; // USB Driver Data segment value

extern   ULONG    gulVolume;
extern   ULONG    gulBalance;
extern   ULONG    gulTreble;
extern   ULONG    gulBass;

extern   CHAR   gUSBDName[]; // USB driver name
extern   UCHAR  gSPIdx;	 // setup packet index
extern   UCHAR  gReadSPIdx; // read setup packet index
extern          LastCode;	// `end of data` pointer


extern   BOOL   gbTimerIntHooked; // shows, if system timer` int is hooked
extern   BOOL   gbISOOpened; // shows if isohrounous pipe is open
extern   BOOL   gbByPassBuffer; // shows, have we to bypass next data bufffer or not (if all USB Audio devices are detached )
extern   BOOL   gStartReject;	// shows, if we have to start reject buffers ( for ALL attached devices)

extern   PSZ    gVMessages[];	 // Verbose messages
extern   PFN    Device_Help; // devhlp entry handler
extern   PUSBIDCEntry   gpUSBDIDC; // USB driver IDC entry point handler
extern   PSTREAM pStreamVirt;	  // virtual address of the stream saved in InitStreams()
#ifdef DEBUG
extern USHORT gAMsg;	// debug print message level
#endif



