/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  usbaud.h                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Master Driver header                                  */
/*                                                                            */
/*                                                                            */
/*   FUNCTION: USB Audio device driver`s master include file                  */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES:	OS/2 standard header files	:				            */
/*                           os2medef.h                                       */
/*                           ssm.h                                            */
/*                           shdd.h                                           */
/*                           devcmd.h                                         */
/*                           meerror.h                                        */
/*                           audio.h                                          */
/*				                                                                  */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*       2000/01/26   Vjacheslav Chibis   USB audio input added               */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

// Debug print functions macros definitions                                                           
#ifdef   DEBUG
   #define         dsPrint(l,s)              dsPrint5x(gAMsg,(l),(s),0,0,0,0,0)
   #define         dsPrint1(l,s,a)           dsPrint5x(gAMsg,(l),(s),(a),0,0,0,0)
   #define         dsPrint2(l,s,a,b)         dsPrint5x(gAMsg,(l),(s),(a),(b),0,0,0)
   #define         dsPrint3(l,s,a,b,c)       dsPrint5x(gAMsg,(l),(s),(a),(b),(c),0,0)
   #define         dsPrint4(l,s,a,b,c,d)     dsPrint5x(gAMsg,(l),(s),(a),(b),(c),(d),0)
#endif


#include "usbcmmon.h" // Common definitions for USB drivers stack
#include "usbmisc.h"  // miscellanious USB driver stack definitions 
#include "usbdebug.h" // Debug definitions 
//#include "usbchid.h"  // HID class definitions

#ifdef DEBUG
   extern USHORT gAMsg; // global debug message level variable
#endif


#include <os2medef.h>  // OS/2 definitions for multimedia DD
#include <ssm.h>       // Sync Stream Manager
#include <shdd.h>      // Stream Handler Device Driver definitions
#include <devcmd.h>    // device driver strategy commands
#include <meerror.h>   // MultiMedia errors codes definitions
#include <audio.h>     // audio class devices definitions

#include "usbaudio.h"  // master include file
#include "audiodat.h"  // data structires definitions
#include "rmhelp.h"    // Resource Manager Helper routines header file
#include "audiodd.h"   // Basic USB Audio device driver definitions
#include "cdevhlp.h"   // OS/2 devhelp routines 
#include "usbextrn.h"    // global variables definitions
#include "audiocom.h"  // communications with base USB stack definitions






