;/*
;*   Licensed Material -- Property of IBM
;*
;*   (c) Copyright IBM Corp. 1998-2000  All Rights Reserved
;*/
;/************************** START OF SPECIFICATIONS ***************************/
;/*                                                                            */
;/*   SOURCE FILE NAME:  STARTUP.ASM                                            */
;/*                                                                            */
;/*   DESCRIPTIVE NAME:   Audio device driver PDD 'ASM' startup module for 'C' */
;/*                                                                            */
;/*                                                                            */
;/*   FUNCTION: Provides the user's "main" routine with the address of         */
;                the request packet.                                              
;                                                                                 
;                Satisfies the C EXTRN for __acrtused, which prevents the startup 
;/*             logic from being included from the standard C library.          */
;/*                                                                            */
;/*   NOTES:                                                                   */
;/*      DEPENDENCIES: None                                                    */
;/*      RESTRICTIONS: None                                                    */
;/*                                                                            */
;/*   ENTRY POINTS:                                                            */
;/*                                                                            */
;/*                                                                            */
;/*   EXTERNAL REFERENCES:						       */
;/*				                                               */
;/*                                                                            */
;/* Change Log                                                                 */
;/*                                                                            */
;/*  Mark    yy/mm/dd  Programmer          Comment                             */
;/*  ----    --------  ----------          -------                             */
;/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
;/*        2000/01/26  Vjacheslav Chibis   USB audio input added               */
;/*                                                                            */
;/**************************** END OF SPECIFICATIONS ***************************/        
        
        PAGE    80,132

        TITLE  USB Audio OS/2 Warp Device Driver
        .seq                                      ; Use segments in order listed
        .286p                                     ; Allow priviledged instruct



;********************** START OF SPECIFICATIONS *********************
;*
;* SOURCE FILE NAME:  STARTUP.ASM
;*
;* DESCRIPTIVE NAME:  Audio device driver PDD 'ASM' startup module for 'C'.
;*
;* Copyright (c) International Business Machines Corporation  1998
;*                        All Rights Reserved
;*
;* FUNCTION: Provides the user's "main" routine with the address of
;*           the request packet.
;*
;*           Satisfies the C EXTRN for __acrtused, which prevents the startup
;*           logic from being included from the standard C library.
;*
;*********************** END OF SPECIFICATIONS **********************

;******************************************************************************
;                            S E G M E N T S
;******************************************************************************



DDHEADER SEGMENT WORD PUBLIC 'DDHEADER' 
DDHEADER ENDS

_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_ENDDATA   SEGMENT WORD PUBLIC 'ENDDATA'
  PUBLIC  _EndOfData
_ENDDATA   ENDS


Code    SEGMENT WORD PUBLIC 'CODE'
Code    ENDS



_TEXT   SEGMENT WORD PUBLIC 'CODE'
        EXTRN  _StrategyEntry:NEAR
        EXTRN  _StreamManagerIDCCall:NEAR
        PUBLIC _ServeIDCCall
;        PUBLIC __acrtused
        PUBLIC _Strategy
        ifdef CONVERTER
                PUBLIC _SignConverter
        endif
        
_TEXT   ENDS

RMCode  SEGMENT WORD PUBLIC 'CODE'
RMCode  ENDS

_ENDTEXT SEGMENT WORD PUBLIC 'ENDCODE'
      PUBLIC _LastCode
_ENDTEXT ENDS

DGROUP    GROUP   DDHEADER, CONST, _BSS, _DATA, _ENDDATA
CGROUP    GROUP   RMCODE,  Code, _TEXT, _ENDTEXT
 
_ENDTEXT   SEGMENT WORD PUBLIC 'ENDCODE'
           ASSUME ds:DGROUP, es:NOTHING, ss:NOTHING        ; MASM 6.00           

_LastCode proc far
_LastCode endp        


_ENDTEXT   ENDS


INCLUDE devhdr.inc
DDHEADER segment word public 'DDHEADER' 
  EVEN
_headers    LABEL  WORD


            DW       -1                   ; Device header pointer
            DW       -1                   ; Device header pointer
            dw       DEV_CHAR_DEV or DEV_IOCTL or DEV_SHARE or DEV_30 or DEVLEV_2 or DEV_GIOCTL or DEVLEV_3 ; ATTRIBUTE
            dw       OFFSET   _Strategy ; POINTER TO STRATEGY ROUTINE
            dw       OFFSET   _ServeIDCCall      ; POINTER TO PDD-PDD IDC ROUTINE
            db       'USBAUD1$'           ; DEVICE NAME
            DW       0                    ; Protect-mode CS Strategy Selector
            DW       0                    ; Protect-mode DS selector
            DW       0                    ; Real-mode CS Strategy Segment
            DW       0                    ; Real-mode DS segment
            dd       DEV_ADAPTER_DD OR DEV_INITCOMPLETE ; CAPABILITIES BIT STRIP
DDHeader ends





_ENDDATA   SEGMENT WORD PUBLIC 'ENDDATA'
ASSUME ds:DGROUP, es:NOTHING, ss:NOTHING
 _EndOfData  DB 0
_ENDDATA ENDS

;******************************************************************************
;  C O D E   S E G M E N T
;******************************************************************************
_TEXT   SEGMENT WORD PUBLIC 'CODE'
        ASSUME CS: CGROUP, ds:DGROUP, es:NOTHING, ss:NOTHING        ; MASM 6.00



;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: Strategy
;*
;* DESCRIPTIVE NAME: Audio PDD Strategy Routine
;*
;* ENTRY POINTS:  Strategy
;*
;* INPUT:  DS    = DD Data Segment
;*         ES:BX -> Pointer to the Request Packet
;*
;*            The Request Packet:
;*            ------------------
;*            HEADER:                 ; Request Header
;*              BYTE    .PktLen       ;   length of request packet
;*              BYTE                  ;   Block Device unit code (unused)
;*              BYTE    .PktCmd       ;   command code
;*              WORD    .PktStatus    ;   return status
;*              DWORD   .PktDevLink   ;   ReqPkt queue linkage
;*                                    ;
;*            DATA:                   ;
;*              ????                  ; Depends on function requested
;*
;* EXIT-NORMAL: .PktStatus  = 0100h ( No Error              )
;*                            0300h ( Device Busy, No Error )
;*
;* EXIT-ERROR:  .PktStatus  = 8101h ( Unknown Unit          )
;*                            8102h ( Device Not Ready      )
;*                            8103h ( Unknown command       )
;*                            810Ch ( General Failure       )
;*                            8111h ( Char_Call_Interrupted )
;*                            8112h ( No Monitor Support    )
;*                            8113h ( Invalid Parameter     )
;*
;*********************** END OF SPECIFICATIONS **********************
_Strategy proc far
;__acrtused label byte                           ; Label for linker, eliminates
                                                ; inclusion of C runtime startup
        push    es                              ; Push address of request
        push    bx                              ; packet (parm to C routine)
        
        call    _StrategyEntry
        
        pop     bx                              ; Restore stack frame and
        pop     es                              ; restore pointer to request
                                                ; packet.
        mov     WORD PTR es:[bx+3],ax           ; plug in status word
        ret                                     ; Return to kernel
_Strategy endp


; ULONG far ServeIDCCall(VOID *bufP)
;    This function serves as the entry point into the driver for idc calls
; from other pdd's.
;    The parameter 'bufP' is a pointer to information specific to each request.
;    The function return a value specific to the request in dx:ax.

_ServeIDCCall proc far
public _ServeIDCCall
        .386p
BUFP_LOW equ <[bp+6]>
BUFP_HIGH equ <[bp+8]>

    ; point to parameters
        push   bp
        mov    bp,sp

    ; save registers
        push   ds
        push   es
        push   ecx
        push   ebx
        push   esp
        push   ebp
        push   esi
        push   edi
        pushfd

    ; set up data segment
        mov    ax,DGROUP
        mov    ds,ax

    ; ensure interrupts are enabled
        sti

    ; service the request
        push   word ptr BUFP_HIGH
        push   word ptr BUFP_LOW
        call   _StreamManagerIDCCall
        add    sp,4

    ; restore registers
        popfd
        pop    edi
        pop    esi
        pop    ebp
        pop    esp
        pop    ebx
        pop    ecx
        pop    es
        pop    ds
        pop    bp

    ; return
        ret
        .286p
_ServeIDCCall endp


ifdef CONVERTER
;void Converter(PULONG pBuffer, USHORT usBuffLen)
;Converts signed data to unsigned & vv
_SignConverter	PROC NEAR

pBuffer   EQU <[bp+4]>
usBuffLen EQU <[bp+8]>
 
 	push	bp
        mov	bp,sp
        push    cx
        push    es
 	push	si
        
 	mov	cx,WORD PTR usBuffLen
 	jmp	SHORT @@st
        
;@@loop:
        ;les	si,DWORD PTR pBuffer
        ;.386p
        ;xor	DWORD PTR es:[si], 80808080h
        ;.286p
        ;add	WORD PTR pBuffer, 4
 ;@@st:
  ;      sub  cx, 3        
   ;     loop @@loop


        

@@loop:
        les	si,DWORD PTR pBuffer
        xor	BYTE PTR es:[si], 80h
        add	BYTE PTR pBuffer, 1
        ;inc     si
 @@st:
        loop @@loop
@@cnvdone:        


        pop  si
        pop  es
        pop  cx
        pop  bp
  	ret	

_SignConverter	ENDP
endif

        .386p
	PUBLIC	_GetUSBLevel
_GetUSBLevel	PROC NEAR	;  COMDAT
;|*** 
;|*** short GetUSBLevel ( short pmValue, short usbMin, short usbMax)
;|*** {
pmValue EQU     <[bp+4]>
usbMin  EQU     <[bp+6]>
usbMax  EQU     <[bp+8]>
	push	bp
	mov	bp,sp
;	pmValue = 4
;	usbMin = 6
;	usbMax = 8
	mov	ax,WORD PTR usbMin	;usbMin
        cwde
        mov	ebx,eax	;usbMin

;|*** 	return((short)(pmValue*(usbMax-usbMin)/0x7fff+usbMin));
; Line 35
	mov	ax,WORD PTR usbMax	;usbMax
        cwde
	sub	eax,ebx
        xor     ecx,ecx
        mov	cx,WORD PTR pmValue	;usbMax
	imul	ecx	;pmValue
	mov	cx,32767	;7fffH
	cdq	
        idiv	ecx
	add	eax,ebx
;|*** }; Line 36
	leave	
	ret	

_GetUSBLevel	ENDP


_TEXT   ENDS
        END
