/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  CDEVHELP.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  C functional prototype interface for OS/2 DevHlp      */
/*                      services.                                             */
/*                                                                            */
/*   FUNCTION:                                                                */
/*                                                                            */
/*                                                                            */
/*   NOTES:            Uses 'C' calling conventions                           */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:   N/A                                                      */
/*                                                                            */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*       2000/01/26   Vjacheslav Chibis   USB audio input added               */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
#define VIDEO_PAUSE_ON  1
#define VIDEO_PAUSE_OFF 0


//  allocates Global Descriptor table selector
USHORT  DevHlp_AllocGDTSelector ( ULONG ulNumGDTSelectors, PVOID paGDTSel );
// allocates physical memory 
USHORT  DevHlp_AllocPhys ( ULONG  BlockSize, USHORT Location, PVOID pRetAddr );
// gets tick count from the timer
USHORT DevHlp_TickCount (PVOID TimerHandler, USHORT tickCount);
USHORT DevHlp_VideoPause (UCHAR ucVideoPauseFlag);
// converts physical address to Global Descriptor Table selector
USHORT  DevHlp_PhysToGDTSelector (  PVOID  PhysAddress, ULONG  ByteLength, USHORT Selector );
// converts physical address to virtual
USHORT  DevHlp_PhysToVirt (  PVOID  PhysAddress, LONG Size, PVOID pRetAddress );
// registers Physical device driver
USHORT  DevHlp_RegisterPDD (  NPSZ  pszPDDName, PVOID pfnPDDFunction );
// converts virtual adress to linear
USHORT  DevHlp_VirtToLin (  USHORT  Selector, ULONG OffsetAddress, PVOID pRetLinAddress);
// converts virtual address to physical
USHORT  DevHlp_VirtToPhys ( PVOID  VirtAddress, PVOID pRetPhysAddress );
// resets timer int handler
USHORT  DevHlp_ResetTimer  ( PVOID TimerHandler );
