/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  AUDSUBS.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Audio device driver subroutines header                */
/*                                                                            */
/*                                                                            */
/*   FUNCTION: Audio device driver subroutines header                         */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  N/A                                                       */
/*                                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:													               */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*       2000/01/26   Vjacheslav Chibis   USB audio input added               */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/*
** Reference file audsubs.c for information
** on these routines.
*/

/*
** Updates stream position to account for completion
** of present operation and returns a pointer to
** present position (counter).
*/

PULONG   GetStreamTime (   PSTREAM pStream);	 // gets current stream time
VOID     SetStreamTime (   PSTREAM pStream, ULONG ulSetPos);  // sets current stream time
VOID     SetStreamState(   PSTREAM pStream, USHORT usState); // sets state for the current stream
VOID     DevClose      (   ULONG ulSysFileNum);	// closes the device driver
VOID     DevChange     (   PSTREAM pStream, LPMCI_AUDIO_CHANGE pRP_AC);			// Change device type   // 04/05/2000 MB
USHORT   DevOpen       (   ULONG ulSysFileNum);	 // opens the device driver
RC FindDevice(UCHAR devAddr, PUCHAR  pucIndex);

SHORT SetSystemTimer(USHORT);	 // sets system timer for the specified interrupt time 

USHORT DevHlp_TickCount (PVOID TimerHandler, USHORT tickCount);

// adds event in events queue
RC EnqueueEvent (HEVENT hEvent, ULONG ulCuePoint, PSTREAM pStream);
// removes the event form the events queue
RC DequeueEvent (HEVENT hEvent, PSTREAM pStream);

// searchs for the stream 
PSTREAM GetFileStream (ULONG SysFileNum );

// gets best fit values for the specified audio data format in according with device capabilities
BOOL GetBestFit( PUCHAR    configurationData,
					  UCHAR     bNumConfigurations,
					  UCHAR     bConfigurationValue,
					  UCHAR     interface,
					  PULONG    dataType,
					  PULONG    samplingRate,
					  PULONG    channels,
					  PULONG    bitsPerSample,
					  PUCHAR    altInterface
					);

// checks if the channel can perform the specified operation
BOOL CheckChannelFeature( FUnitDescriptor FAR *featureDesc, USHORT feature, UCHAR channel);

// Gets max channel count  for the device
UCHAR GetChannelCount( FUnitDescriptor FAR *featureDesc);

//sets control capabilities in device global data structures
VOID SetControlCapabilities(UCHAR deviceIndex, PULONG pulFlags);               

//sets channels control capabilities in device global data structures
VOID SetChannelsCapabilities(USHORT deviceIndex, FUnitDescriptor FAR *featureDesc); 

//transforms control value to USB format
USHORT GetUnitControlValue(USHORT usValue, USHORT usMinValue, USHORT usMaxValue );
