/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  AUDIOCOM.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Audio communication                                   */
/*                                                                            */
/*                                                                            */
/*   FUNCTION: The function of this file is to support  communication with    */
/*                basic USB device drivers                                    */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  N/A                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES:	USBDIDCEntry  - USB Driver IDC entry point         */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*       2000/01/26   Vjacheslav Chibis   USB audio input added               */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

VOID     GetUSBDIDC( VOID ); // Get USB Driver IDC entry point

VOID     FAR USBDIDCEntry( PRP_GENIOCTL pRP_GENIOCTL );	// USB driver IDc routine entry point

VOID     CheckForService( PRP_GENIOCTL pRP_GENIOCTL ); // Check new attached device for Audio class 

VOID     USBAUDIOProcessIRQ( PRP_GENIOCTL pRP_GENIOCTL ); // USB interrupts processing routine

VOID     SetUnitControl( USHORT deviceIndex,		 // Sets control settings e.g. volume, bass, treble etc.
								 UCHAR  bControlSelector,
								 UCHAR  ucChannelNo,
								 USHORT wBufferSize,
								 PUCHAR pData);

VOID     GetUnitControl( USHORT deviceIndex,	 // Gets possible setting`s range for the specified conrol e.g. volume, bass, treble
								 UCHAR  bControlSelector,
								 UCHAR  ucChannelNo,
								 USHORT wBufferSize,
								 PUCHAR pData,
								 UCHAR  ucRequest,
                         BOOL   notificationRequired);   // 04/05/2000 MB

VOID     USBSetInterface( USHORT  deviceIndex,  // Sets interface for specified USB Audio device
								  USHORT  altInterface,
								  PSTREAM pStream,
								  BOOL    bEnablePlay,
								  USHORT  usByPass);

VOID     USBAUDIOClearStalled( PRP_GENIOCTL pRP_GENIOCTL );	 // Processes error in data transmition
VOID     GenerateDetach( UCHAR controllerId,  
								 UCHAR deviceAddress);	// Emulates detach operation for the specified device

USHORT   DetachDevice( PRP_GENIOCTL pRP_GENIOCTL ); // Detaches the specified device

USHORT   RegisterDriver( VOID );	 // Registrates USBAUDIO.SYS with USB Driver 

RC       GetNextBuffer( PSTREAM pStream );	 // Gets next buffer to play

static   FUnitDescriptor FAR * GetFeatureUnitDesc( PUCHAR configurationData,	 // get feauturre unit descriptor value
																 UCHAR  bNumConfigurations,
																 UCHAR  bConfigurationValue,
																 UCHAR  interface);
