/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBADD/ADDTYPE.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  ADDTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  ADD Class device driver TYPEDEF  and flag definition  */
/*                      include file.                                         */
/*                                                                            */
/*   FUNCTION: This module is the ADD Class device driver                     */
/*             TYPEDEF and flag definition include file.                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark      yy/mm/dd  Programmer    Comment                                 */
/*  --------- --------  ----------    -------                                 */
/*            00/08/10  MB                                                    */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

// initialization time message IDs
#define  INIT_MESSAGE_LOADED        0
#define  INIT_MESSAGE_NO_USBD       1
#define  INIT_MESSAGE_INVNUMERIC    2
#define  INIT_MESSAGE_UNKNOWNKWD    3
#define  INIT_MESSAGE_NO_MSD        4

// max no of messages in message queue
#define  MAX_INIT_MESSAGE_COUNT     2

#define  DEFAULT_DEVICE_COUNT       1

// CONFIG.SYS key count definition
#define  MAX_ADD_KEYS               2

#define  MAX_CONFIG_BUFFER_SIZE     256
#define  USBMSD_DRIVER_FNAME        "USBMSD.ADD"

// driver dependent string/message definitions
#ifdef   USBHDD
#define  DRIVER_LOADED_MESSAGE      "IUSBHDD.ADD: USB Fixed Disk Class driver v.%dd.%dd loaded"
#define  NO_USBD_MESSAGE            "EUSBHDD.ADD: USBD.SYS driver not loaded"
#define  CFG_INVALID_NUMERIC        "EUSBHDD.ADD: Invalid numeric value in CONFIG.SYS line at column %dddd"
#define  CFG_INVALID_KEY            "EUSBHDD.ADD: Invalid key value in CONFIG.SYS line at column %dddd"
#define  NO_MSD_MESSAGE             "EUSBHDD.ADD: USBMSD.ADD driver not loaded"
#define  PDRIVER_NAME               "USBHDD.ADD"
#define  PDRIVER_DESCRIPTION        "USB Fixed Disk Class Adapter driver"
#define  PDRIVER_VENDOR             "IBM OS/2"
#define  PADAPTER_NAME              "USB Fixed Disk Device Class driver"
#define  DEVCOUNT_KEY               "FIXED_DISKS:"
#else
#ifdef   USBFLPPY
#define  DRIVER_LOADED_MESSAGE      "IUSBFLPPY.ADD: USB Floppy Disk Class driver v.%dd.%dd loaded"
#define  NO_USBD_MESSAGE            "EUSBFLPPY.ADD: USBD.SYS driver not loaded"
#define  CFG_INVALID_NUMERIC        "EUSBFLPPY.ADD: Invalid numeric value in CONFIG.SYS line at column %dddd"
#define  CFG_INVALID_KEY            "EUSBFLPPY.ADD: Invalid key value in CONFIG.SYS line at column %dddd"
#define  NO_MSD_MESSAGE             "EUSBFLPPY.ADD: USBMSD.ADD driver not loaded"
#define  PDRIVER_NAME               "USBFLPPY.ADD"
#define  PDRIVER_DESCRIPTION        "USB Floppy Disk Class Adapter driver"
#define  PDRIVER_VENDOR             "IBM OS/2"
#define  PADAPTER_NAME              "USB Floppy Disk Device Class driver"
#define  DEVCOUNT_KEY               "FLOPPIES:"
#else
#ifdef   USBRMV
#define  DRIVER_LOADED_MESSAGE      "IUSBRMV.ADD: USB Removable Disk Class driver v.%dd.%dd loaded"
#define  NO_USBD_MESSAGE            "EUSBRMV.ADD: USBD.SYS driver not loaded"
#define  CFG_INVALID_NUMERIC        "EUSBRMV.ADD: Invalid numeric value in CONFIG.SYS line at column %dddd"
#define  CFG_INVALID_KEY            "EUSBRMV.ADD: Invalid key value in CONFIG.SYS line at column %dddd"
#define  NO_MSD_MESSAGE             "EUSBRMV.ADD: USBMSD.ADD driver not loaded"
#define  PDRIVER_NAME               "USBRMV.ADD"
#define  PDRIVER_DESCRIPTION        "USB Removable Disk Class Adapter driver"
#define  PDRIVER_VENDOR             "IBM OS/2"
#define  PADAPTER_NAME              "USB Removable Disk Device Class driver"
#define  DEVCOUNT_KEY               "REMOVABLES:"
#else
#ifdef   USBOPTCL
#define  DRIVER_LOADED_MESSAGE      "IUSBOPTCL.ADD: USB Optical Disk Class driver v.%dd.%dd loaded"
#define  NO_USBD_MESSAGE            "EUSBOPTCL.ADD: USBD.SYS driver not loaded"
#define  CFG_INVALID_NUMERIC        "EUSBOPTCL.ADD: Invalid numeric value in CONFIG.SYS line at column %dddd"
#define  CFG_INVALID_KEY            "EUSBOPTCL.ADD: Invalid key value in CONFIG.SYS line at column %dddd"
#define  NO_MSD_MESSAGE             "EUSBOPTCL.ADD: USBMSD.ADD driver not loaded"
#define  PDRIVER_NAME               "USBOPTCL.ADD"
#define  PDRIVER_DESCRIPTION        "USB Optical Disk Class Adapter driver"
#define  PDRIVER_VENDOR             "IBM OS/2"
#define  PADAPTER_NAME              "USB Optical Disk Device Class driver"
#define  DEVCOUNT_KEY               "OPTICALS:"
#else
#define  DRIVER_LOADED_MESSAGE      "IUSBCDROM.ADD: USB CDROM Class driver v.%dd.%dd loaded"
#define  NO_USBD_MESSAGE            "EUSBCDROM.ADD: USBD.SYS driver not loaded"
#define  CFG_INVALID_NUMERIC        "EUSBCDROM.ADD: Invalid numeric value in CONFIG.SYS line at column %dddd"
#define  CFG_INVALID_KEY            "EUSBCDROM.ADD: Invalid key value in CONFIG.SYS line at column %dddd"
#define  NO_MSD_MESSAGE             "EUSBCDROM.ADD: USBMSD.ADD driver not loaded"
#define  PDRIVER_NAME               "USBCDROM.ADD"
#define  PDRIVER_DESCRIPTION        "USB CDROM Class Adapter driver"
#define  PDRIVER_VENDOR             "IBM OS/2"
#define  PADAPTER_NAME              "USB CDROM Device Class driver"
#define  DEVCOUNT_KEY               "CDS:"
#endif
#endif
#endif
#endif




