; SCCSID = src/dev/usb/USBADD/ADDSEGS.ASM, usb, c.basedd 98/07/10
;/*
;*   Licensed Material -- Property of IBM
;*
;*   (c) Copyright IBM Corp. 2000  All Rights Reserved
;*/
;/************************** START OF SPECIFICATIONS **************************/
;/*                                                                           */
;/*   SOURCE FILE NAME:  ADDSEGS.ASM                                          */
;/*                                                                           */
;/*   DESCRIPTIVE NAME:  ADD driver header segment definition                 */
;/*                                                                           */
;/*   FUNCTION: This file defines ADD driver header data and local utility    */
;/*             routines.                                                     */
;/*                                                                           */
;/*   NOTES: Utility routines defined in this file use C calling convention.  */
;/*                                                                           */
;/*      DEPENDENCIES: None                                                   */
;/*      RESTRICTIONS: None                                                   */
;/*                                                                           */
;/*   ENTRY POINTS:                                                           */
;/*             none                                                          */
;/*                                                                           */
;/*   EXTERNAL REFERENCES:                                                    */
;/*             None                                                          */
;/*                                                                           */
;/* Change Log                                                                */
;/*                                                                           */
;/*  Mark    yy/mm/dd  Programmer      Comment                                */
;/*  ----    --------  ----------      -------                                */
;/*          00/08/10  MB              Original developer.                    */
;/*                                                                           */
;/**************************** END OF SPECIFICATIONS **************************/

        .XCREF
        .XLIST
         INCLUDE devhdr.inc
        .LIST
        .CREF

         EXTRN  _ADDStrategy:FAR

DDHEADER segment word public 'DDHEADER'
        EVEN
_headers    LABEL  WORD
            DW       -1                                 ; Device header pointer
            DW       -1                                 ; Device header pointer
            dw       DEV_CHAR_DEV OR DEVLEV_3           ; ATTRIBUTE
            dw       OFFSET   _ADDStrategy              ; POINTER TO STRATEGY ROUTINE
            dw       0                                  ; POINTER TO PDD-PDD IDC ROUTINE
ifdef           USBHDD        
            db       'USBHDD$ '                         ; DEVICE NAME
elseifdef       USBFLPPY
            db       'USBFLPP$'                         ; DEVICE NAME
elseifdef       USBTYPE
            db       'USBREMV$'                         ; DEVICE NAME
elseifdef     USBOPTCL
            db       'USBOPTI$'                         ; DEVICE NAME
else
            db       'USBCDRM$'                         ; DEVICE NAME
endif
            DW       0                                  ; Protect-mode CS Strategy Selector
            DW       0                                  ; Protect-mode DS selector
            DW       0                                  ; Real-mode CS Strategy Segment
            DW       0                                  ; Real-mode DS segment
            dd      DEV_ADAPTER_DD                      ; CAPABILITIES BIT STRIP
DDHeader ends

_DATA   segment word public 'DATA'
_DATA   ends

CONST   segment word public 'CONST'
CONST   ends

_BSS    segment word public 'BSS'
_BSS    ends

RMCode  segment word public 'CODE'
RMCode  ends

Code    segment word public 'CODE'
Code    ends

_TEXT   segment word public 'CODE'
_TEXT    ends

; Programmer cannot control location of CONST and _BSS class segments
; being grouped.  They are always last.  Do not put anything in these
; segments since they will be truncated after device driver initialization.
DGROUP  GROUP   DDHeader, CONST, _BSS, _DATA
CGROUP  GROUP   RMCode, Code, _TEXT
        end
#ifdef   USBHDD
#ifdef   USBFLPPY
#ifdef   USBRMV
#ifdef   USBOPT
        
