/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBADD/ADDINIT.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  ADDINIT.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Human Interface Device Class driver initialization    */
/*                      routines.                                             */
/*                                                                            */
/*   FUNCTION: These routines handle ADD driver initialization process.       */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             ADDInit                                                        */
/*             RegisterADD                                                    */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark       yy/mm/dd  Programmer   Comment                                 */
/*  --------- --------  ----------    -------                                 */
/*            00/08/10  MB                                                    */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "add.h"

static BOOL RegisterADD(void);

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  ADDInit                                          */
/*                                                                    */
/* DESCRIPTIVE NAME:  Initializes ADD Class device driver.            */
/*                                                                    */
/* FUNCTION:  The function of this routine is to initialize the       */
/*            USB port device driver.                                 */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Initialization time                                       */
/*                                                                    */
/* ENTRY POINT:  ADDInit                                              */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  pRP-> kernel request packet                                */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS:  pRPO->CodeEnd = end of code segment                      */
/*           pRPO->DataEnd = end of data segment                      */
/*           pRP->Status = STATUS_DONE                                */
/*           pRP->Status = STDON + STERR + ERROR_I24_GEN_FAILURE      */
/*                                                                    */
/* INTERNAL REFERENCES:  ADDGetUSBDIDC                                */
/*                       RegisterADD                                  */
/*                                                                    */
/* EXTERNAL REFERENCES:  none                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
void ADDInit( RPH FAR *pRP)
{
   PRPINITOUT      pRPO;          /* output request packet far pointer */
   PRPINITIN       pRPI;          /* input request packet far pointer  */
   KeyData         keyData[MAX_ADD_KEYS]={"V",           CFSTR_TYPE_DEC,0,0,  //  (0)
                                          DEVCOUNT_KEY,  CFSTR_TYPE_DEC,0,0}; //  (1)
   PSZ             cmdLine;
   ULONG           cmdRStatus, errColumn;
   USHORT          cmdRc;
   USHORT          deviceCount=DEFAULT_DEVICE_COUNT;
   UCHAR           configString[1];
   USHORT          cStrLength;
   APIRET          rmRc;

#ifdef   DEBUG
   dsPrint(DBG_HLVLFLOW, "ADD : ADDInit started\r\n");
#endif

   pRP->Status = STATUS_DONE;
   if (ghDriver) // initialization already passed
      return;

   pRPI = (PRPINITIN) pRP;
   pRPO = (PRPINITOUT) pRP;
   Device_Help = ((PRPINITIN)pRP)->DevHlpEP;  /* save devhlp entry point */

   //////////////////////////////////////////////
   // process CONFIG.SYS BASEDEV= line parameters
   cmdLine=(PSZ) MAKEP( SELECTOROF(pRPI->InitArgs),
                        OFFSETOF(((PDDD_PARM_LIST)pRPI->InitArgs)->cmd_line_args) );
   cmdRStatus=ProcessConfigString(cmdLine, sizeof(keyData)/sizeof(keyData[0]), (KeyData FAR *)&keyData);
   cmdRc=LOUSHORT(cmdRStatus); errColumn=(ULONG)HIUSHORT(cmdRStatus);
   switch (cmdRc)  // set cmd line processing errors
   {
   case CFSTR_UNKWN_KEYS:
      SetLongValue( gVMessages[INIT_MESSAGE_UNKNOWNKWD], errColumn );
      gMessageCount=AddToMsgArray( gMessageIDs, INIT_MESSAGE_UNKNOWNKWD, gMessageCount, MAX_INIT_MESSAGE_COUNT );
      pRP->Status = STATUS_DONE | STERR | ERROR_I24_QUIET_INIT_FAIL;
      break;
   case CFSTR_CONVERR:
      SetLongValue( gVMessages[INIT_MESSAGE_INVNUMERIC], errColumn );
      gMessageCount=AddToMsgArray( gMessageIDs, INIT_MESSAGE_INVNUMERIC, gMessageCount, MAX_INIT_MESSAGE_COUNT );
      break;
   default:
      break;
   }
   gVerbose= keyData[0].keyStatus!=CFSTR_STATUS_NOTFOUND;

   if(keyData[1].keyStatus==CFSTR_STATUS_OK)
      deviceCount=(USHORT)keyData[1].value;
   else
   {
      keyData[1].value=(ULONG)deviceCount;
      keyData[1].keyStatus=CFSTR_STATUS_OK;
   }

   if(!deviceCount)
      pRP->Status = STATUS_DONE | STERR | ERROR_I24_QUIET_INIT_FAIL; //  no - fail to install quietly

   if(pRP->Status == STATUS_DONE)   // check presence of USBD.SYS driver
   {                                // fail to install if USBD not loaded
      if (DevHelp_AttachDD( gUSBDriverName, (NPBYTE)&gDDTable) || !gDDTable.ProtIDCEntry)
      {
         gMessageCount=AddToMsgArray( gMessageIDs, INIT_MESSAGE_NO_USBD, gMessageCount, MAX_INIT_MESSAGE_COUNT );
         pRP->Status = STATUS_DONE | STERR | ERROR_I24_QUIET_INIT_FAIL; //  no - fail to install quietly
      }
   }

   if (pRP->Status == STATUS_DONE)
   {
      if(!RegisterADD())
         pRP->Status = STATUS_DONE | STERR | ERROR_I24_QUIET_INIT_FAIL; //  no - fail to install quietly
   }

   if (pRP->Status == STATUS_DONE)
   {
      cStrLength=sizeof(configString);
      rmRc=RMGetCommandLine(USBMSD_DRIVER_FNAME, (PSZ)configString, &cStrLength, 0, RM_CMD_BASE);
      if(rmRc==RMRC_SEARCH_FAILED)
      {
         gMessageCount=AddToMsgArray( gMessageIDs, INIT_MESSAGE_NO_MSD, gMessageCount, MAX_INIT_MESSAGE_COUNT );
         pRP->Status = STATUS_DONE | STERR | ERROR_I24_QUIET_INIT_FAIL; //  no - fail to install quietly
      }
   }

   if (pRP->Status == STATUS_DONE)
   {
      pRPO->CodeEnd = ((USHORT) &ADDInit) - 1;        /* set end of code segment */
      pRPO->DataEnd = ((USHORT) &gInitDataStart) - 1; /* set end of data segment */
      SetLongValue( gVMessages[INIT_MESSAGE_LOADED], (ULONG)gDriverStruct.MajorVer );   
      SetLongValue( gVMessages[INIT_MESSAGE_LOADED], (ULONG)gDriverStruct.MinorVer );   
      gMessageCount=AddToMsgArray( gMessageIDs, INIT_MESSAGE_LOADED, gMessageCount, MAX_INIT_MESSAGE_COUNT );
   }
   else
   {
      pRPO->CodeEnd = 0; /* set end of code segment */
      pRPO->DataEnd = 0; /* set end of data segment */
      RMDestroyDriver( ghDriver );  // de-register driver if failed to initialize
   }

   TTYWrite(gVMessages, gMessageIDs, gMessageCount);

#ifdef   DEBUG
   dsPrint2(DBG_HLVLFLOW, "ADD : ADDInit ended. Status = %x, devices=%d\r\n", pRP->Status, deviceCount );
#endif
}


/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  RegisterADD                                      */
/*                                                                    */
/* DESCRIPTIVE NAME:  ADD Class driver RM resource registration       */
/*                                                                    */
/* FUNCTION:  The function of this routine register ADD Class driver  */
/*            and corresponding adapter resources.                    */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Initialization time                                       */
/*                                                                    */
/* ENTRY POINT:  RegisterADD                                          */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  none                                                       */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS:  ghDriver, ghAdapter recieves RM handles                  */
/*                                                                    */
/* INTERNAL REFERENCES:  none                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  none                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
static BOOL RegisterADD(void)
{
   APIRET      rc=RMRC_SUCCESS;
   UCHAR       ResourceBuf[ 12 ];  
   ADJUNCT     AdjAdaptNum;
   PAHRESOURCE pResourceList = (PAHRESOURCE)ResourceBuf;

   rc=RMCreateDriver( &gDriverStruct, &ghDriver);
   if (rc==RMRC_SUCCESS)
   {
      pResourceList->NumResource = 0;

      gAdapterStruct.HostBusType = AS_HOSTBUS_PCI;
      AdjAdaptNum.pNextAdj       = NULL;
      AdjAdaptNum.AdjLength      = sizeof(ADJUNCT);
      AdjAdaptNum.AdjType        = ADJ_ADAPTER_NUMBER;
      AdjAdaptNum.Adapter_Number = 0;
      gAdapterStruct.pAdjunctList = &AdjAdaptNum;

      rc=RMCreateAdapter(ghDriver, &ghAdapter,  &gAdapterStruct,
                         NULL, pResourceList);
   }

   if (rc!=RMRC_SUCCESS && ghDriver)
      RMDestroyDriver( ghDriver );

   return (rc==RMRC_SUCCESS);
}

