/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/USBADD/ADDDATA.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  ADDDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Mass Storage Device Class adapter driver data segment */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             Mass Storage Device Class adapter device driver.               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark       yy/mm/dd  Programmer   Comment                                 */
/*  -------    --------  ----------   -------                                 */
/*             00/08/10  MB                                                   */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "add.h"

BYTE           gInitDataStart = 0;  // Marks the end of the data segment

PFN      Device_Help    = NULL;  /* devhelp entry point; used by dhcalls.lib */

/*----------------------------------------------*/
/* GLOBAL VARS FOR RM                           */
/*                                              */
/* RM.LIB needs these declared                  */
/*----------------------------------------------*/
ULONG       RMFlags     = 0L;
PFN         RM_Help0    = 0L;
PFN         RM_Help3    = 0L;

/*--------------------------------------------------------*/
/* Set the DRIVERSTRUCT and DETECTEDSTRUCT data areas     */
/*--------------------------------------------------------*/

char  near  gDDName[];                  /* device driver name */
char  near  gDDDesc[];                  /* device driver description */
char  near  gVendorID[];                /* vendor identification */
//extern char  near  gAdapterName[];             /* adapter name */

/*----------------------------------------------*/
/* Driver Description   (rmbase.h)              */
/*----------------------------------------------*/
DRIVERSTRUCT gDriverStruct =
{
   gDDName,                            /* DrvrName                */
   gDDDesc,                            /* DrvrDescript            */
   gVendorID,                          /* VendorName              */
   CMVERSION_MAJOR,                    /* MajorVer                */
   CMVERSION_MINOR,                    /* MinorVer                */
   2000,8,10,                          /* Date                    */
   DRF_STATIC,                         /* DrvrFlags               */
   DRT_ADDDM,                          /* DrvrType                */
   DRS_ADD,                            /* DrvrSubType             */
   NULL                                /* DrvrCallback            */
};

/*----------------------------------------------*/
/* Adapter Description                          */
/*----------------------------------------------*/
ADAPTERSTRUCT gAdapterStruct =
{
   (PSZ)gAdapterName,                  /* AdaptDescriptName; */
   AS_NO16MB_ADDRESS_LIMIT,            /* AdaptFlags;        */
   AS_BASE_MSD,                        /* BaseType;          */
   AS_SUB_IPI,                        /* SubType;           */
   AS_INTF_GENERIC,                    /* InterfaceType;     */
   NULL,                               /* HostBusType;       */
   AS_BUSWIDTH_32BIT,                  /* HostBusWidth;      */
   NULL,                               /* pAdjunctList;      */
   NULL                                /* reserved           */
};

/*----------------------------------------------*/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables are assigned the handles for */
/* drivers, detected hardware and resources.    */
/*----------------------------------------------*/

HDRIVER        ghDriver     = NULL;        // global handle to driver
HADAPTER       ghAdapter    = NULL;        //   global handle to adapter

CHAR           gOEMDriverName[9] = "OEMHLP$ ";
CHAR           gUSBDriverName[9] = "USBD$   ";

IDCTABLE       gDDTable =  { { 0, 0, 0}, 0, 0};

#ifdef   DEBUG
USHORT         gADDMsgLevel=0xff;//DBG_CRITICAL;       // debug message level
#endif

USHORT         gVerbose       = 0;  // output message level

#define MSG_REPLACEMENT_STRING  1178

USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT]={0};
USHORT         gMessageCount=0;
PSZ            gVMessages[]={ DRIVER_LOADED_MESSAGE, NO_USBD_MESSAGE, CFG_INVALID_NUMERIC, CFG_INVALID_KEY, NO_MSD_MESSAGE };

MSGTABLE       gInitMsg = { MSG_REPLACEMENT_STRING, 1, 0};
