/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/UHCI/UHCPROTO.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  UHCPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Function prototypes provided by the UHCI compliant    */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the UHCI compliant USB device driver            */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark       yy/mm/dd  Programmer   Comment                                 */
/*  ---------- --------  ----------   -------                                 */
/*             96/03/01  MB                                                   */
/*  02/17/2000 02/17/00  MB           Added SetScheduleItem and               */
/*                                    USBExecutionBlock prototypes            */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/* UHCSTRAT.C */
void FAR UHCIStrategy();
void CmdError( RPH FAR *pRP);

/* UHCDATA.C */
USHORT (*gStratList[])( RPH FAR *pRP );

/* USBIDC.C */
void FAR UHCIidc( RP_GENIOCTL FAR *pRP_GENIOCTL );
void UHCIAcceptIO( RP_GENIOCTL FAR *pRP_GENIOCTL );
void AccNonIsoReq( RP_GENIOCTL FAR *pRP_GENIOCTL );   // 15/10/98 MB
BOOL CheckBandwidth( QH *topQH, ULONG packetTime );
void AccIsoReq( RP_GENIOCTL FAR *pRP_GENIOCTL );   // 15/10/98 MB
ISOINFO FAR *CreateIsoStruct( USBRB FAR *ioRB );   // 15/10/98 MB
VOID ReleaseIsoStruct( ISOINFO FAR *isoInfo );     // 15/10/98 MB
VOID AddIsoBuffsToSchedule( void );                // 16/10/98 MB
BOOL IsIsoInterrupt( void );
VOID ProcessIsoIRQ( void );
VOID CancelIsoRequests(UCHAR deviceAddress, UCHAR endPointId);
void UHCIFinIO( RP_GENIOCTL FAR *pRP_GENIOCTL );   // only for debug
void DetachQH(QH *qh);
VOID FreeTDsQH( TD *firstTD, BOOL disableInterrupts );

// UHCLONG.ASM
ULONG PacketTTime(USHORT maxPacketSize, BOOL lowSpeedDevice, ULONG token, USHORT queType);
ULONG CreateTokenAddress( UCHAR deviceAddress, UCHAR endPointId );
VOID SetScheduleItem( PULONG itemAddress, ULONG itemData ); // 02/17/2000 MB

// USBCCANIO.C
void UHCICancelIO( RP_GENIOCTL FAR *pRP_GENIOCTL );
void UHCICancelAll( void );

/* UHCINIT.C */
void UHCIInit( RPH FAR *pRP );

/* UHCCOMPL.C  */
void UHCIInitComplete( RPH FAR *pRP);
void UHCIGetUSBDIDC(void);
void UHCIResetHost( RP_GENIOCTL FAR *pRP_GENIOCTL );
void UHCIShutDown( RPH FAR *pRP );

/* usbcheck.c  */
VOID CallOEMHlp( VOID (FAR *pFunctionCall)(VOID), USHORT oemHelpDS, PRPH pRPH );
BOOL CheckPCI(void);
BOOL NEAR FindPCIDevice( UCHAR maxPCIBuses );

// UHCPCI.C (functions moved from UHCINIT.C)
BOOL NEAR ReadPCIConfigSpace( UCHAR BusNum, UCHAR DevFunc,
                              UCHAR ConfigReg,
                              PULONG Data, USHORT Size );
BOOL NEAR WritePCIConfigSpace(  UCHAR HWMech, UCHAR BusNum, UCHAR DevFunc,
                                UCHAR ConfigReg,
                                ULONG Data, UCHAR Size );
BOOL PciSetReg( UCHAR HWMech, UCHAR DevFunc, UCHAR ConfigReg, ULONG val, USHORT size );
void PciSetRegMech2( USHORT regmask, UCHAR index, ULONG val, USHORT size );
void PciSetRegMech1( USHORT regmask, UCHAR index, ULONG val, USHORT size );

/* usbIRQ.c */
void FAR UHCIInterrupt();
void DefAddrTimeOut(void);
void CheckQHs(void);
BOOL FinshIO(TD *tdList, BOOL cancelled);

/* uhcirhub.c  */
void AccRootHubReq( RP_GENIOCTL FAR *pRP_GENIOCTL );
void UHCIRootHub( RP_GENIOCTL FAR *pRP_GENIOCTL );

/* uhctime.c   */
void  IODelay( void );
void  TimeExecutionStall( USHORT delay );
void  USBExecutionStall( USHORT delay );
void  USBExecutionBlock( USHORT delay, ULONG procID );   // 02/17/2000 MB
void FAR UHCIRootHubTimer();

/* UHCCTX.C */
VOID FAR PASCAL UHCICtxHookRtn( VOID );
VOID FAR PASCAL RHubCtxHookRtn( VOID );
VOID FAR PASCAL AddIsoHookRtn( VOID );
VOID FAR PASCAL IsoIRQHookRtn( VOID );
VOID SafeArmCtxHook( ULONG hookHandle, ULONG armData, USHORT *statusFlag );  // 31/05/1999 MB
VOID ClearThreadStatus( ULONG hookHandle, ULONG armData, USHORT *statusFlag );  // 31/05/1999 MB

