; SCCSID = src/dev/usb/UHCI/UHCLONG.ASM, usb, c.basedd 98/07/10
;
;   Licensed Material -- Property of IBM
;
;   (c) Copyright IBM Corp. 1997, 1998, 2000  All Rights Reserved
;
; Change Log                                                                 
;                                                                            
;  Mark      yy/mm/dd  Programmer    Comment                                 
;  ----      --------  ----------    -------                                
; 02/17/2000 04/09/99  MB            Added SetScheduleItem routine
;
.386
.seq

_TEXT	SEGMENT  WORD USE16 PUBLIC 'CODE'
        ASSUME   cs:_TEXT
;/******************* START OF SPECIFICATIONS **************************/
;/*                                                                    */
;/* SUBROUTINE NAME:  PacketTTime                                      */
;/*                                                                    */
;/* DESCRIPTIVE NAME:  Packet transfer time                            */
;/*                                                                    */
;/* FUNCTION:  This routine calculates packet transfer time (ns).      */
;/*                                                                    */
;/* NOTES: see details in USB Specification Revision 1.0 p.66          */
;/*                                                                    */
;/* CONTEXT: Task Time                                                 */
;/*                                                                    */
;/* ENTRY POINT :  PacketTTime                                         */
;/*    LINKAGE  :  CALL NEAR                                           */
;/*                                                                    */
;/* INPUT:  USHORT    maxPacketSize - packet size in bytes             */
;/*         BOOL      lowSpeedDevice - TRUE for low speed devices      */
;/*         ULONG     token - packet type - IN, OUT, SETUP             */
;/*         USHORT    queType - request queing type (isohronous,       */
;/*                          interrupt, control or bulk)               */
;/*                                                                    */
;/* EXIT-NORMAL:  packet transfer time in ns                           */
;/*                                                                    */
;/* EXIT-ERROR:  n/a                                                   */
;/*                                                                    */
;/* EFFECTS:  none                                                     */
;/*                                                                    */
;/* INTERNAL REFERENCES:  none                                         */
;/*    ROUTINES:                                                       */
;/*                                                                    */
;/* EXTERNAL REFERENCES:  None                                         */
;/*    ROUTINES:                                                       */
;/*                                                                    */
;/******************* END  OF  SPECIFICATIONS **************************/
	PUBLIC	_PacketTTime
_PacketTTime	PROC NEAR
;|*** // packet transmission time calculation constants
;|***    #define  TTIME_FULLSPEED_NONISO_CDELAY    9107L
;|***    #define  TTIME_FULLSPEED_ISOIN_CDELAY     7268L
;|***    #define  TTIME_FULLSPEED_ISOUT_CDELAY     6265L
;|***    #define  TTIME_LOWSPEED_IN_CDELAY         64060L
;|***    #define  TTIME_LOWSPEED_OUT_CDELAY        64107L
;|*** 
;|***    #define  TTIME_FULLSPEED_BITSTUFF_MUL     8354L
;|***    #define  TTIME_LOWSPEED_BITSTUFF_IN_MUL   67667L
;|***    #define  TTIME_LOWSPEED_BITSTUFF_OUT_MUL  66700L
;|*** 
;|***    #define  TTIME_BITSTUFF_ADDCON            3167L
;|***    #define  TTIME_BITSTUFF_MUL               9334L
;|***    
;|***    #define  USB_ZERO_PACKET            0x7ff // packet length used to indicate empty packet
;|***    
;|***    #define  TD_TOKEN_PID_IN                 0x00000069  // IN packet
;|***    #define  TD_TOKEN_PID_OUT                0x000000e1  // OUT packet
;|***    #define  TD_TOKEN_PID_SETUP              0x0000002d  // SETUP packet
;|***    
;|*** // packet transmission time calculation constants
;|***    #define  TTIME_HOST_DELAY            0L
;|***    #define  TTIME_HUB_LS_SETUP          4000L
;|***    
;|***    #define  USRB_FLAGS_DET_ISOHR    0x8000  
;|*** 
;|*** unsigned long near PacketTTime(unsigned short maxPacketSize, short lowSpeedDevice, unsigned long token, unsigned short queType)
;|*** {
; Line 28
packetByteCount equ  [bp-4]
currPTime       equ  [bp-8]
bitStuffTime    equ  [bp-12]
bMult           equ  [bp-16]
queType         equ  [bp+12]
token           equ  [bp+8]
lowSpeedDevice  equ  [bp+6]
maxPacketSize   equ  [bp+4]

	enter	16,0
;	packetByteCount = -4
;	currPTime = -8
;	bitStuffTime = -12
;	bMult = -16
;	queType = 12
;	token = 8
;	lowSpeedDevice = 6
;	maxPacketSize = 4
;|***    unsigned long    packetByteCount;
;|***    unsigned long    currPTime, bitStuffTime, bMult;
;|***  
;|***    if (maxPacketSize==USB_ZERO_PACKET+1)   // empty packet length specified
; Line 32
	cmp	WORD PTR maxPacketSize,2048	;0800H	;maxPacketSize
	jne	SHORT $I114
;|***       packetByteCount=0;
; Line 33
	mov	DWORD PTR packetByteCount,0	;packetByteCount
;|***    else
; Line 34
	jmp	SHORT $I115
	nop	
					$I114:
;|***       packetByteCount=maxPacketSize;
; Line 35
	mov	ax,WORD PTR maxPacketSize	;maxPacketSize
	mov	WORD PTR packetByteCount,ax	;packetByteCount
	mov	WORD PTR [bp-2],0
					$I115:
;|*** 
;|***    bitStuffTime=TTIME_BITSTUFF_ADDCON+packetByteCount*TTIME_BITSTUFF_MUL;
; Line 37
	mov	eax,DWORD PTR packetByteCount	;packetByteCount
	mov	ecx,9334	;00002476H
	mul	ecx
	add	eax,3167	;00000c5fH
;|***    bitStuffTime/=1000;
; Line 38
	mov	ecx,1000	;000003e8H
	xor	edx,edx
	div	ecx
	mov	DWORD PTR bitStuffTime,eax	;bitStuffTime
;|***    currPTime=0;
; Line 39
	sub	eax,eax
	mov	DWORD PTR currPTime,eax	;currPTime
;|***    if (lowSpeedDevice)
; Line 40
	cmp	WORD PTR lowSpeedDevice,ax	;lowSpeedDevice
	je	SHORT $I116
;|***    {
;|***       switch (token)
; Line 42
	mov	ax,WORD PTR token	;token
	mov	dx,WORD PTR [bp+10]
	cmp	dx,0
	jne	$SD135
	sub	ax,45	;002dH
	je	SHORT $SC122
	sub	ax,60	;003cH
	je	SHORT $SC121
	sub	ax,120	;0078H
	je	SHORT $SC122
;|***       {
;|***       case TD_TOKEN_PID_IN:
;|***          bMult=TTIME_LOWSPEED_BITSTUFF_IN_MUL;
;|***          currPTime=TTIME_LOWSPEED_IN_CDELAY+TTIME_HUB_LS_SETUP+TTIME_HUB_LS_SETUP+TTIME_HOST_DELAY;
;|***          break;
;|***       case TD_TOKEN_PID_OUT:
;|***       case TD_TOKEN_PID_SETUP:
;|***          bMult=TTIME_LOWSPEED_BITSTUFF_OUT_MUL;
;|***          currPTime=TTIME_LOWSPEED_OUT_CDELAY+TTIME_HUB_LS_SETUP+TTIME_HUB_LS_SETUP+TTIME_HOST_DELAY;
;|***          break;
;|***       default:
;|***          break;
; Line 54
	jmp	SHORT $SD135
	nop	
	nop	
;|***       case TD_TOKEN_PID_IN:
; Line 44
					$SC121:
;|***          bMult=TTIME_LOWSPEED_BITSTUFF_IN_MUL;
; Line 45
	mov	DWORD PTR bMult,67667	;00010853H	;bMult
;|***          currPTime=TTIME_LOWSPEED_IN_CDELAY+TTIME_HUB_LS_SETUP+TTIME_HUB_LS_SETUP+TTIME_HOST_DELAY;
; Line 46
	mov	WORD PTR currPTime,6524	;197cH	;currPTime
					$L139:
	mov	WORD PTR [bp-6],1
;|***          break;
;|***       case TD_TOKEN_PID_OUT:
;|***       case TD_TOKEN_PID_SETUP:
;|***          bMult=TTIME_LOWSPEED_BITSTUFF_OUT_MUL;
;|***          currPTime=TTIME_LOWSPEED_OUT_CDELAY+TTIME_HUB_LS_SETUP+TTIME_HUB_LS_SETUP+TTIME_HOST_DELAY;
;|***          break;
;|***       default:
;|***          break;
;|***       }
;|***    }
;|***    else
; Line 57
	jmp	SHORT $SD135
;|***       case TD_TOKEN_PID_OUT:
; Line 48
					$SC122:
;|***       case TD_TOKEN_PID_SETUP:
;|***          bMult=TTIME_LOWSPEED_BITSTUFF_OUT_MUL;
; Line 50
	mov	DWORD PTR bMult,66700	;0001048cH	;bMult
;|***          currPTime=TTIME_LOWSPEED_OUT_CDELAY+TTIME_HUB_LS_SETUP+TTIME_HUB_LS_SETUP+TTIME_HOST_DELAY;
; Line 51
	mov	WORD PTR currPTime,6571	;19abH	;currPTime
	jmp	SHORT $L139
;|***          break;
;|***       default:
; Line 53
	nop	
					$I116:
;|***          break;
;|***       }
;|***    }
;|***    else
;|***    {
;|***       bMult=TTIME_FULLSPEED_BITSTUFF_MUL;
; Line 59
	mov	WORD PTR bMult,8354	;20a2H	;bMult
	mov	WORD PTR [bp-14],ax
;|***       switch (token)
; Line 60
	mov	ax,WORD PTR token	;token
	mov	dx,WORD PTR [bp+10]
	cmp	dx,0
	jne	SHORT $SD135
	sub	ax,45	;002dH
	je	SHORT $SC132
	sub	ax,60	;003cH
	je	SHORT $SC129
	sub	ax,120	;0078H
	je	SHORT $SC132
	jmp	SHORT $SD135
;|***       {
;|***       case TD_TOKEN_PID_IN:
; Line 62
					$SC129:
;|***          if (queType!=USRB_FLAGS_DET_ISOHR)
; Line 63
	cmp	WORD PTR queType,-32768	;8000H	;queType
	jne	SHORT $L138
;|***             currPTime=TTIME_FULLSPEED_NONISO_CDELAY+TTIME_HOST_DELAY;
;|***          else
;|***             currPTime=TTIME_FULLSPEED_ISOIN_CDELAY+TTIME_HOST_DELAY;
; Line 66
	mov	WORD PTR currPTime,7268	;1c64H	;currPTime
					$L140:
	mov	WORD PTR [bp-6],0
;|***          break;
; Line 67
	jmp	SHORT $SD135
	nop	
;|***       case TD_TOKEN_PID_OUT:
; Line 68
					$SC132:
;|***       case TD_TOKEN_PID_SETUP:
;|***          if (queType!=USRB_FLAGS_DET_ISOHR)
; Line 70
	cmp	WORD PTR queType,-32768	;8000H	;queType
	je	SHORT $I133
;|***             currPTime=TTIME_FULLSPEED_NONISO_CDELAY+TTIME_HOST_DELAY;
; Line 71
					$L138:
	mov	WORD PTR currPTime,9107	;2393H	;currPTime
	jmp	SHORT $L140
					$I133:
;|***          else
;|***             currPTime=TTIME_FULLSPEED_ISOUT_CDELAY+TTIME_HOST_DELAY;
; Line 73
	mov	WORD PTR currPTime,6265	;1879H	;currPTime
	jmp	SHORT $L140
	nop	
;|***          break;
;|***       default:
; Line 75
					$SD135:
;|***          break;
;|***       }
;|***    }
;|*** 
;|***    currPTime+=bMult*bitStuffTime/100;
; Line 80
	mov	eax,DWORD PTR bMult	;bMult
	mul	DWORD PTR bitStuffTime	;bitStuffTime
	mov	ecx,100	;00000064H
	xor	edx,edx
	div	ecx
	add	DWORD PTR currPTime,eax	;currPTime
;|***    return (currPTime);
; Line 81
	mov	ax,WORD PTR currPTime	;currPTime
	mov	dx,WORD PTR [bp-6]
;|*** }
; Line 82
	leave	
	ret	

_PacketTTime	ENDP

;/******************* START OF SPECIFICATIONS **************************/
;/*                                                                    */
;/* SUBROUTINE NAME:  CreateTokenAddress                               */
;/*                                                                    */
;/* DESCRIPTIVE NAME:  Creates TD Token address fields                 */
;/*                                                                    */
;/* FUNCTION:  This routine fills in TD token field with device and    */
;/*            endpoint addresses.                                     */
;/*                                                                    */
;/* NOTES: 2Word token is filled with addresses according to UHCI      */
;/*        requirements - 00000000 00000eee eaaaaaaa 00000000          */
;/*                                                                    */
;/* CONTEXT: Task Time                                                 */
;/*                                                                    */
;/* ENTRY POINT :  CreateTokenAddress                                  */
;/*    LINKAGE  :  CALL NEAR                                           */
;/*                                                                    */
;/* INPUT:  UCHAR deviceAddress - 7 bit device address                 */
;/*         UCHAR endPointId - 4 bit endpoint address                  */
;/*                                                                    */
;/* EXIT-NORMAL:  TD token                                             */
;/*                                                                    */
;/* EXIT-ERROR:  none                                                  */
;/*                                                                    */
;/* EFFECTS:  none                                                     */
;/*                                                                    */
;/* INTERNAL REFERENCES:  None                                         */
;/*    ROUTINES:                                                       */
;/*                                                                    */
;/* EXTERNAL REFERENCES:  None                                         */
;/*    ROUTINES:                                                       */
;/*                                                                    */
;/******************* END  OF  SPECIFICATIONS **************************/
	PUBLIC	_CreateTokenAddress
_CreateTokenAddress	PROC NEAR
;|*** 
;|*** ULONG CreateTokenAddress( UCHAR deviceAddress, UCHAR endPointId )
;|*** {
endPointId              equ  [bp+6]
deviceAddress           equ  [bp+4]
DEV_ENDPT_ADDRMASK      equ  0fh
USB_MAX_DEVICE_ADDRESS  equ  7fh

      push	bp
      mov	bp,sp
      
      ; ax = 0000 0eee  e000 0000
      mov	al,endPointId
      and	ax,DEV_ENDPT_ADDRMASK
      shl	ax,7
      ; dx = 0000 0000  0aaa aaaa
      mov	dl,deviceAddress
      and	dx,USB_MAX_DEVICE_ADDRESS
      
      or	ax,dx   ;       ax = 0000 0eee  eaaa aaaa
      sub       dh,dh
      mov	dl,ah   ;       dx = 0000 0000  0000 0eee
      mov       ah,al
      sub       al,al   ;       ax = eaaa aaaa  0000 0000
      
      leave
      ret	

_CreateTokenAddress	ENDP

;/******************* START OF SPECIFICATIONS **************************/
;/*                                                                    */
;/* SUBROUTINE NAME:  SetScheduleItem                                  */
;/*                                                                    */
;/* DESCRIPTIVE NAME:  Set host schedule item                          */
;/*                                                                    */
;/* FUNCTION:  This routine stores schedule item data (QH/TD physical  */
;/*            address) into schedule                                  */
;/*                                                                    */
;/* NOTES:                                                             */
;/*                                                                    */
;/* CONTEXT: Task Time                                                 */
;/*                                                                    */
;/* ENTRY POINT :  SetScheduleItem                                     */
;/*    LINKAGE  :  CALL NEAR                                           */
;/*                                                                    */
;/* INPUT:  PULONG itemAddress - schedule item address                 */
;/*         ULONG itemData - item data (QH/TD physical address)        */
;/*                                                                    */
;/* EXIT-NORMAL:  none                                                 */
;/*                                                                    */
;/* EXIT-ERROR:  none                                                  */
;/*                                                                    */
;/* EFFECTS:  none                                                     */
;/*                                                                    */
;/* INTERNAL REFERENCES:  None                                         */
;/*    ROUTINES:                                                       */
;/*                                                                    */
;/* EXTERNAL REFERENCES:  None                                         */
;/*    ROUTINES:                                                       */
;/*                                                                    */
;/******************* END  OF  SPECIFICATIONS **************************/
	PUBLIC	_SetScheduleItem
_SetScheduleItem	PROC NEAR
;|*** 
;|*** VOID SetScheduleItem( PULONG itemAddress, ULONG itemData )
;|*** {
itemData        equ  [bp+8]
itemAddress     equ  [bp+4]
      enter	0,0
      les	bx,itemAddress          ;       load item address
      mov       eax,itemData            ;       load item data
      mov       es:[bx],eax             ;       set item data
      leave
      ret

_SetScheduleItem	ENDP


_TEXT   ends

        end
        
