/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/UHCI/UHCDATA.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  UHCDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  UHCI compliant USB host device driver data segment    */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             UHCI compliant USB host device driver.                         */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark       yy/mm/dd  Programmer      Comment                              */
/*  -------    --------  ----------      -------                              */
/*             98/01/31  MB                                                   */
/*  31/05/1999 99/05/31  MB              Added context thread status          */
/*                                       variable definitions                 */
/*  02/17/2000 00/02/17  MB              PCI device data moved out of init    */
/*                                       time data, added gHwMech variable    */
/*  01/08/2000 00/08/01  ML              Added initial host status variable   */
/*                                       definition.                          */
/*  LR0420     01/04/20  LR              Added gUHCUSBD (registered with USBD)*/
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "uhci.h"

/*--------------------------------------------------------*/
/* Dispatch table for strategy commands (pre FIFO queue)  */
/*--------------------------------------------------------*/
USHORT (*gStratList[])() =
{                     /*--------------------------------------*/
   CmdError,          /* 0x00  initialize device driver       */
   CmdError,          /* 0x01  check the media                */
   CmdError,          /* 0x02  build BPB                      */
   CmdError,          /* 0x03  reserved                       */
   CmdError,          /* 0x04  read                           */
   CmdError,          /* 0x05  non-destructive read           */
   CmdError,          /* 0x06  input status                   */
   CmdError,          /* 0x07  input flush                    */
   CmdError,          /* 0x08  write                          */
   CmdError,          /* 0x09  write with verify              */
   CmdError,          /* 0x0A  get output status              */
   CmdError,          /* 0x0B  flush output                   */
   CmdError,          /* 0x0C  reserved                       */
   CmdError,          /* 0x0D  open                           */
   CmdError,          /* 0x0E  close                          */
   CmdError,          /* 0x0F  removable media                */
   CmdError,          /* 0x10  generic IOCTL                  */
   CmdError,          /* 0x11  reset uncertain media          */
   CmdError,          /* 0x12  get Logical Drive Map          */
   CmdError,          /* 0x13  set Logical Drive Map          */
   CmdError,          /* 0x14  de-Install this device         */
   CmdError,          /* 0x15  reserved                       */
   CmdError,          /* 0x16  get number of partitions       */
   CmdError,          /* 0x17  get unit map                   */
   CmdError,          /* 0x18  no caching read                */
   CmdError,          /* 0x19  no caching write               */
   CmdError,          /* 0x1A  no caching write/verify        */
   UHCIInit,          /* 0x1B  initialize device driver       */
   UHCIShutDown,      /* 0x1C  shutdown                       */
   CmdError,          /* 0x1D  get driver capabilities        */
   CmdError,          /* 0x1E  reserved                       */
   UHCIInitComplete   /* 0x1F  initialization complete        */
};                    /*--------------------------------------*/

PFN      Device_Help    = NULL;  /* devhelp entry point; used by dhcalls.lib */

/*----------------------------------------------*/
/* GLOBAL VARS FOR RM                           */
/*                                              */
/* RM.LIB needs these declared                  */
/*----------------------------------------------*/
ULONG       RMFlags     = 0L;
PFN         RM_Help0    = 0L;
PFN         RM_Help3    = 0L;

/*--------------------------------------------------------*/
/* Set the DRIVERSTRUCT and DETECTEDSTRUCT data areas     */
/*--------------------------------------------------------*/

char  near  gDDName[];                  /* device driver name */
char  near  gDDDesc[];                  /* device driver description */
char  near  gVendorID[];                /* vendor identification */
char  near  gAdapterName[];             /* adapter name */

/*----------------------------------------------*/
/* Driver Description   (rmbase.h)              */
/*----------------------------------------------*/
DRIVERSTRUCT gDriverStruct =
{
   gDDName,                            /* DrvrName                */
   gDDDesc,                            /* DrvrDescript            */
   gVendorID,                          /* VendorName              */
   CMVERSION_MAJOR,                    /* MajorVer                */
   CMVERSION_MINOR,                    /* MinorVer                */
   2001,6,12,                          /* Date             LR0612 */
   DRF_STATIC,                         /* DrvrFlags               */
   DRT_OS2,                            /* DrvrType                */
   DRS_CHAR,                           /* DrvrSubType             */
   NULL                                /* DrvrCallback            */
};

/*----------------------------------------------*/
/* Adapter Description                          */
/*----------------------------------------------*/
ADAPTERSTRUCT gAdapterStruct =
{
   gAdapterName,                       /* AdaptDescriptName; */
   AS_NO16MB_ADDRESS_LIMIT,            /* AdaptFlags;        */
   AS_BASE_INPUT,                      /* BaseType;          */
   AS_SUB_OTHER,                       /* SubType;           */
   AS_BASE_COMM,                       /* InterfaceType;     */
   NULL,                               /* HostBusType;       */
   AS_BUSWIDTH_32BIT,                  /* HostBusWidth;      */
   NULL,                               /* pAdjunctList;      */
   NULL                                /* reserved           */
};

/*----------------------------------------------*/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables are assigned the handles for */
/* drivers, detected hardware and resources.    */
/*----------------------------------------------*/

HDRIVER        ghDriver     = NULL;          // global handle to driver
HADAPTER       ghAdapter    = NULL;          // global handle to adapter
UCHAR          gusbIRQ = 0;                  // UHC IRQ number
UCHAR          gusbPIN = 0;                  // UHC interrupt pin number
USHORT         gusbIOBase = 0;               // USB IO Space Base Address
USHORT         gusbCmdReg = 0;               // USB Command register address
USHORT         gusbStsReg = 0;               // USB Status register address
USHORT         gusbIntrReg = 0;              // USB Interrupt Enable register address
USHORT         gusbFrnumReg = 0;             // Frame Number register
USHORT         gusbBaseAddReg = 0;           // Frame List Base Address
USHORT         gusbSofModReg = 0;            // Start of Frame Modify register
USHORT         gusbPortSc1Reg = 0;           // Port 0 Status & Control
USHORT         gusbPortSc2Reg = 0;           // Port 1 Status & Control

HRESOURCE      girqResource = NULL;          // IRQ resource handle
HRESOURCE      gioResource = NULL;           // I/O address space resource handle
PUSBIDCEntry   gpUSBDIDC = NULL;             // USBD driver's IDC routine address
USHORT         gdsUSBIDC = 0;                // USBD driver's DS value
BOOL           gUHCUSBD = FALSE;             //LR0420 not registered within USBD
UCHAR          ghcdID;                       // host controller driver ID
UCHAR          gRootHubAddress=0;            // software implemented root hub address
UCHAR          gRootHubConfig=0;             // root hub configuration value
BOOL           gHostReset=FALSE;             // set to TRUE if host controller reset completed
BOOL           gIRQSet=FALSE;                // set to TRUE if IRQ processing rtne set // 31/05/1999 MB

CHAR           gOEMDriverName[9] = "OEMHLP$ "; 
CHAR           gUSBDriverName[9] = "USBD$   ";

// root hub structure definitons
DeviceDescriptor     gRootDescriptor=  {
   sizeof(gRootDescriptor),DESC_DEVICE, 0x0100, // size, type, version
   DEV_CLASS_HUB,DEV_SUBCLASS_HUBSUBCLASS,
   0,8,  // device protocol, max packet size for endpoint 0
   0x0000,0x0000,0x0100,  // Vendor ID, Product ID, Device Release number
   0, 0, 0, // description string indexes for manufacturer, product, serial
   1  // Number of possible configurations
};

RootHubConfiguration gRootConfiguration={ // DeviceConfiguration
   sizeof(gRootConfiguration.configuration),DESC_CONFIGURATION,  // size, type
   sizeof(gRootConfiguration),  // total no of bytes returned
   1,1,   // no of interfaces, set configuration value
   0,0,0 // description index, config chars, power consumption
   ,  // DeviceInterface
   sizeof(gRootConfiguration.interface), DESC_INTERFACE,   // size, decriptor type
   0,0,  // interface, alternate setting
   1,    // no of endpoints
   0,0,0,   // interface class, subclass, protocol
   0        // descriptor string index
   ,  // DeviceEndpoint
   sizeof(gRootConfiguration.endpoints),DESC_ENDPOINT,     // size, type
   DEV_ENDPT_DIRIN|1, DEV_ENDPT_INTRPT, 8, 0xff  // enpoint addr, attributes, max pcket size, polling interval
};

HubDescriptor        gRootHubConfiguration={
   sizeof(gRootHubConfiguration)-62, DESC_HUB, // Size, type
   2, // number of downstream ports that this hub supports
   HUB_DESC_CHAR_POWER_NOSWTCH|HUB_DESC_CHAR_COMPOUND_DEV|
   HUB_DESC_CHAR_OCURRENT_NOPROT, //  hub characteristics
   0, // Delay time (in 2ms intervals) to be operational after power on
   0, // max current req for hub electronics in mA
   0xff,0xff   // 
};

RP_GENIOCTL          gRootHubRP[ROOT_MAX_REQ];             // structures to store
USBRB                gRootHubRB[ROOT_MAX_REQ];             // root hub I/O requests

ULONG                gCTXHookHandle=0;       // task time thread context hook handle
ULONG                gRHubHookHandle=0;      // task time thread context hook handle
ULONG                gAddIsoHookHandle=0;    // add buffers to schedule task time thread
ULONG                gIsoIrqHookHandle=0;    // iso IRQ processing task time thread
USHORT               gIRQTaskStatus=ARM_STATUS_CLEARED;   // IRQ processing context thread status   // 31/05/1999 MB
USHORT               gRHubHookStatus=ARM_STATUS_CLEARED;  // Root hub request processing context thread status   // 31/05/1999 MB
USHORT               gAddIsoStatus=ARM_STATUS_CLEARED;    // add buffers to schedule context thread status   // 31/05/1999 MB
USHORT               gIsoIrqStatus=ARM_STATUS_CLEARED;    // iso IRQ processing context thread status   // 31/05/1999 MB
UCHAR                gRootReqStatus=ROOT_HUB_NOREQ;  // root hub request status
ULONG                gInterruptFlags=0;      // last USB status register flags
USHORT               gMaxReclPktSize;        // max packet length that can be used in bandwidth reclamation

USHORT               g0Time=0;               // timer count for default address request
QH                   *g0QH=NULL;             // default address request QH

IDCTABLE       gDDTable =  { { 0, 0, 0}, 0, 0};

DEVICESTRUCT gDeviceStruct =
{
   gAdapterName,                    /* DevDescriptName;   */
   0,                                 /* DevFlags;          */
   DS_TYPE_IO,                        /* DevType;           */
   NULL                               /* pAdjunctList;      */
};

// UHCI host data area definitions, pointers and indexes
LONG           *gFrameListAddr;     // virtual frame list address
LONG           gPhyFrameListAddr;   // physical frame list address
TD             *gTDListStart;       // QH/TD array start address
USHORT         gTDCount;            // no of elements in QH/TD array
USHORT         gLastTDId=TOP_QH_COUNT;       // last used QH/TD element index
LONG           gFrameData[MAX_FRAME_LENGTH]; // buffer used for schedule and QH/TD array allocation
QH             *gFirstBottomQH;              // pointer to the first bottom level QH
QH             *gLastBottomQH;               // pointer to the last bottom level QH
QH             *gNextForIRQ;     // pointer to QH to be processed next during IRQ processing
BOOL           gInterruptsDisabled;    // TRUE if interrupts disabled during IRQ processing
ISOINFO FAR    *gFirstIso=NULL;  // pointer to the first isohronous request block
ISOINFO FAR    *gLastIso=NULL;   // pointer to the last isohronous request block
ULONG          gIsoPktSize=0;          // total isohronous request frame size

BOOL           gStopHostOnShutDown=FALSE; // if TRUE stops host during shutdown process

#ifdef DEBUG
USHORT         gUHCIMsgLevel = DBG_CRITICAL; // debug message level
#endif

BOOL           gIRQShared=TRUE;  // IRQ sharing supported

UCHAR          gBusNum=0;        // PCI bus number          // 02/17/2000 MB - moved out of init time data
UCHAR          gDevFunc=0;       // PCI device function     // 02/17/2000 MB - moved out of init time data
UCHAR          gHwMech=0;        // PCI hardware configuration mechanism // 02/17/2000 MB - added


USHORT         gusbCmdRegSave = 0;           // 01/08/2000 ML - added to store initial host status

//-------------initialization time data follows----------------------------------------------
BYTE           gInitDataStart = 0;     //   Marks the end of the data segment.

UCHAR          gPCIMajorVer = 0; // PCI bus release major version
UCHAR          gPCIMinorVer = 0; // PCI bus release minor version
UCHAR          gMaxPCIBuses = 0; // no of PCI buses detected
UCHAR          gRevision=0;      // Vendor's USB Host device revision
UCHAR          gDevicesFound=0;  // no of USB hosts detected

USHORT         gVerbose     = 0; // console message printout level

#define MSG_REPLACEMENT_STRING  1178


USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT]={0};  // console message indexes
USHORT         gMessageCount=0;                          // console message count
// initialization time messages
PSZ            gVMessages[]={ "IUSBUHCD.SYS: UHCI Compliant USB Host Controller driver v.%dd.%dd loaded",
   "IUSBUHCD.SYS: PCI slot %dd, I/O base = %xxxh, interrupt = %dddd",
   "EUSBUHCD.SYS: UHCI Compliant USB Host Controller not found on PCI bus",
   "EUSBUHCD.SYS: Additional UHCI Compliant USB Host Controller not found on PCI bus",
   "EUSBUHCD.SYS: PCI bus version %dd.%dd, bus count %dd, search index %dd",
   "EUSBUHCD.SYS: Failed to set IRQ processing routine",
   "EUSBUHCD.SYS: Failed to allocate CTX hook routine(s)",
   "EUSBUHCD.SYS: Failed to set Timer routine",
   "EUSBUHCD.SYS: Invalid numeric value in CONFIG.SYS line at column %dddd",
   "EUSBUHCD.SYS: Invalid key value in CONFIG.SYS line at column %dddd"};

MSGTABLE  gInitMsg = { MSG_REPLACEMENT_STRING, 1, 0};

