/* SCCSID = "src/dev/usb/OHCI/OHCTYPE.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 2001  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  OHCTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  OHCI compliant device driver TYPEDEF include file.    */
/*                                                                            */
/*   FUNCTION: This module is OHCI compliant device driver                    */
/*             TYPEDEF and flag definition include file.                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark       yy/mm/dd  Programmer   Comment                                 */
/*  -------    --------  ----------   -------                                 */
/*             00/01/27  MB                                                   */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
#ifndef  _ohctype_h_
   #define  _ohctype_h_

// initialization time message IDs
   #define  INIT_MESSAGE_LOADED        0
   #define  INIT_MESSAGE_LOADED_DET0   1
   #define  INIT_MESSAGE_NODEVICE      2
   #define  INIT_MESSAGE_NOSDEVICE     3
   #define  INIT_MESSAGE_PCISPECS      4
   #define  INIT_MESSAGE_SETIRQFAILED  5
   #define  INIT_MESSAGE_SETCTXFAILED  6
   #define  INIT_MESSAGE_SETTMEFAILED  7
   #define  INIT_MESSAGE_INVNUMERIC    8
   #define  INIT_MESSAGE_UNKNOWNKWD    9
   #define  INIT_MESSAGE_GDT_FAILED    10
   
// max no of messages in message queue
   #define  MAX_INIT_MESSAGE_COUNT     3

   #define  ROOT_HUB_TIME_INTERVAL     40    // time interval to serve root hub requests
   #define  ROOT_HUB_CHANGE_OWNER      100   // no of times to repeat 1 ms wait intervals to change host owner
   #define  ROOT_HUB_RESET_RETRIES     40   // no of times to repeat 1 ms wait intervals to finish host reset
   
   #define  ROOT_HUB_RESET_PORT        100   // no of times to repeat 1 ms wait intervals for the hub port power switch to operate
   #define  ROOT_HUB_RESET_ATTACH      100   // no of times to repeat 1 ms wait intervals for Vbus up to valid level
   #define  ROOT_HUB_RESET_CONNECTION  100   // no of times to repeat 1 ms wait intervals for connection
   #define  ROOT_HUB_RESET_DEVICE      10    // no of times to repeat 1 ms wait intervals for reset device
   #define  ROOT_HUB_RESET_RECOVERY    10    // no of times to repeat 1 ms wait intervals for reset recovery
   #define  ROOT_HUB_RESET_COMMON      ROOT_HUB_RESET_PORT+ROOT_HUB_RESET_ATTACH+ROOT_HUB_RESET_CONNECTION+ROOT_HUB_RESET_DEVICE+ROOT_HUB_RESET_RECOVERY
   
   #define  ROOT_HUB_FEATURE_RETRIES   5     // no of retries to enable root hub port
   #define  ROOT_MAX_REQ               3     // max requests to root hub
   #define  MAX_USB_CMD                0x1f  // max strategy command implemented

   #define  HCD_WBUF_LENGTH            4096+10000  // HCD work area buffer size
   #define  MAX_SCHEDULE_ENTRIES       100    // no of entries in HC schedule table
   #define  MAX_TBUFFER_SIZE           8192  // maximum buffer size for single TD
   
// payload section                                             
   #define  MAX_BYTES_PER_FFRAME       1500    // max no of client bytes in one frame for full-speed transfer
   #define  MAX_PAYLOAD_PER_FFRAME     64      //  max no of client bytes for full-speed transfer
   #define  MAX_PAYLOAD_PER_ISO        1023    //  max no of client bytes for isochronous transfer
      
      #define  MAX_BYTES_PER_FCONTR       832    //  max no of client bytes in one frame for full-speed control transfer
      #define  OVERHEAD_PER_FCONTR        45     //  no of bytes for protocol overhead for full-speed control transfer
      
      #define  MAX_BYTES_PER_CONTR        1023    //  max no of client bytes in one frame for isochronous transfer
      #define  OVERHEAD_PER_CONTR         9       //  no of bytes for protocol overhead for isochronous transfer

      #define  MAX_BYTES_PER_FINT         1216   //  max no of client bytes in one frame for full-speed interrupt transfer
      #define  OVERHEAD_PER_FINT          13     //  no of bytes for protocol overhead for full-speed interrupt transfer
      
      #define  MAX_BYTES_PER_BULK         1216   //  max no of client bytes in one frame for bulk transfer
      #define  OVERHEAD_PER_BULK          13     //  no of bytes for protocol overhead for bulk transfer
   
   #define  MAX_BYTES_PER_LFRAME       187    // max no of client bytes in one frame for low-speed transfer
   #define  MAX_PAYLOAD_PER_LFRAME     8      //  max no of client bytes for low-speed transfer
   
      #define  MAX_BYTES_PER_LCONTR       24     //  max no of client bytes in one frame for low-speed control transfer
      #define  OVERHEAD_PER_LCONTR        46     //  no of bytes for protocol overhead for low-speed control transfer

      #define  MAX_BYTES_PER_LINT         64     //  max no of client bytes in one frame for low-speed interrupt transfer
      #define  OVERHEAD_PER_LINT          13     //  no of bytes for protocol overhead for low-speed interrupt transfer

   #define  OHCI_ISO_PAGE_SIZE         4095  // page size
   #define  OHCI_NEW_ED_RATE           255
   #define  OHCI_TD_DELETE_TIME        20    // time needed to delete ed/td in ms
   #define  OHCI_BIT_RATE_TIME         6000  // bit time needed for slow control 8 byte packet with bit staffing
   
// OHCI TD Completion Codes
   #define  OHCI_TDERR_NOERROR            0x00  // 0000b // data packet processing completed with no detected errors
   #define  OHCI_TDERR_CRC                0x01  // 0001b // last data packet from endpoint contained a CRC error
   #define  OHCI_TDERR_BITSTUFFING        0x02  // 0010b // last data packet from endpoint contained a bit stuffing violation
   #define  OHCI_TDERR_DATATOGGLEMISMATCH 0x03  // 0011b // last data packet from endpoint had data toggle PID that did not match expected value
   #define  OHCI_TDERR_STALL              0x04  // 0100b // TD was moved to Done Queue because the endpoint returned a STALL PID
   #define  OHCI_TDERR_DEVICENOTRESP      0x05  // 0101b // device did not rspond to token (IN) or did not provide a handshake (OUT)
   #define  OHCI_TDERR_PIDCHECKFAILURE    0x06  // 0110b // check bits on PID from endpoint failed data PID (IN) or handshake (OUT)
   #define  OHCI_TDERR_UNEXPEDCTEDPID     0x07  // 0111b // receive PID was not valid when encountered or PID value is not defined
   #define  OHCI_TDERR_DATAOVERRUN        0x08  // 1000b // data packet processing completed with no detected errors
   #define  OHCI_TDERR_DATAUNDERRUN       0x09  // 1001b // data packet processing completed with no detected errors
   #define  OHCI_TDERR_BUFFEROVERRUN      0x0a  // 1100b // during an IN, HC received data from endpoint faster than it could be written to system memory
   #define  OHCI_TDERR_BUFFERUNDERRUN     0x0b  // 1101b // during an OUT, HC could not retrieve data from system memory fast enough to keep up with data USB data rate
   #define  OHCI_TDERR_NOACCESSED0        0x0e  // 1110b // this code is set by software before TD is placed on a list to be proesed by the HC
   #define  OHCI_TDERR_NOACCESSED1        0x0f  // 1111b // this code is set by software before TD is placed on a list to be proesed by the HC
   
//

// Host Controller Communications Area (256 bytes)
typedef struct _HCCA_
{
   ULONG    interruptTable[32];  // pointers to interrupt EDs
   USHORT   frameNumber;         // current frame number
   USHORT   pad1;                // set to 0 when HC updates frameNumber
   ULONG    doneHead;            // done TD queue head
   ULONG    reserved[29];        // reserved for use by HC
}  HCCA;

// Revision register flags (00)
#define  REVISION_REV_MASK          0x000000ff  // HCI interface version number mask
#define  REVISION_REV_L             0x00000100  // legacy support registers present flag

// Control register flags (04)
#define  CONTROL_CBSR_MAX           0x00000003  // Control/Bulk Service Ratio = 4 : 1
#define  CONTROL_CBSR_MASK          0x00000003  // Control Bulk Service Ratio
#define  CONTROL_PLE                0x00000004  // Periodic List Enable
#define  CONTROL_IE                 0x00000008  // Isochronous Enable
#define  CONTROL_CLE                0x00000010  // Control List Enable
#define  CONTROL_BLE                0x00000020  // Bulk List Enable
#define  CONTROL_HCFS_MASK          0x000000c0  // Host Controller Functional Status
#define  CONTROL_HCFS_RESET         0x00000000  // Host Controller in Reset state
#define  CONTROL_HCFS_RESUME        0x00000040  // Host Controller in Resume State
#define  CONTROL_HCFS_OPERATIONAL   0x00000080  // Host Controller in Operational state
#define  CONTROL_HCFS_SUSPEND       0x000000c0  // Host Controller in suspend state
#define  CONTROL_IR                 0x00000100  // Interrupt Routing
#define  CONTROL_RWC                0x00000200  // Remote Wakeup Connected
#define  CONTROL_RWE                0x00000400  // Remote Wakeup Enable

// Command Status register flags (08)
#define  CMD_STATUS_HCR             0x00000001  // Host Controller Reset
#define  CMD_STATUS_CLF             0x00000002  // Control List Filled
#define  CMD_STATUS_BLF             0x00000004  // Bulk List Filled
#define  CMD_STATUS_OCR             0x00000008  // Ownership Change Request
#define  CMD_STATUS_SOC_MASK        0x00030000  // Scheduling Overrun Count

// interrupt status/enable/disable register flags (0c)(10)(14)
#define  INTERRUPT_FLAG_SO          0x00000001  // Scheduling overrun
#define  INTERRUPT_FLAG_WDH         0x00000002  // Writeback done head
#define  INTERRUPT_FLAG_SF          0x00000004  // Start of Frame
#define  INTERRUPT_FLAG_RD          0x00000008  // Resume detect
#define  INTERRUPT_FLAG_UE          0x00000010  // Unrecoverable error
#define  INTERRUPT_FLAG_FNO         0x00000020  // Frame number overflow
#define  INTERRUPT_FLAG_RHSC        0x00000040  // Root hub status change
#define  INTERRUPT_FLAG_OC          0x40000000  // Ownership change
#define  INTERRUPT_FLAG_MIE         0x80000000  // master interrupt enable/disable

// HCCA register flags (18)
#define  HCCA_MIN_ADDRESS_MASK      0xffffff00
#define  HCCA_ALL_ONES              0xffffffff

// frame interval register (34)
#define  FMINTERVAL_FI_MASK         0x00003fff  // frame interval mask
#define  FMINTERVAL_FI_OFF          0           // frame interval bit offset
#define  FMINTERVAL_FSMPS_MASK      0x7fff0000  // FS largest data packet mask
#define  FMINTERVAL_FSMPS_OFF       16          // FS largest data packet bit offset
#define  FMINTERVAL_FIT             0x80000000  // frame interval toggle

// frame remaining register (38)
#define  FMREMAINING_FR_MASK        0x00003fff  // frame remaining
#define  FMREMAINING_FR_OFF         0           // frame remaining bit offset
#define  FMREMAINING_FRT            0x80000000  // frame remaining toggle

// frame number register (3c)
#define  FMNUMBER_FN_MASK           0x0000ffff  // frame number mask
#define  FMNUMBER_FN_ZERO           0x00010000  // frame number zero
#define  FMNUMBER_FN_OFF            0           // frame number mask bit offset

// periodic start register (40)
#define  PERIODIC_START_PS_MASK     0x00003fff  // periodic start register mask
#define  PERIODIC_START_PS_OFF      0           // periodic start register bit offset
#define  PERIODOC_TD_SERVICE_TIME   0x00003e67  // default value for periodic start

// low speed transaction threshold register (44)
#define  LST_THRESHOLD_LST_MASK     0x000007ff  // LST Threshold mask
#define  LST_THRESHOLD_LST_OFF      0           // LST Threshold bit offset

// Root Hub Decriptor register flags (48)
#define  RH_DESCRIPTOR_NDP          0x000000ff  // number of downstream ports
// Dimir bad specification may be registers NPS & PSM was replaced
#define  RH_DESCRIPTOR_PSM          0x00000100  // power switching mode
#define  RH_DESCRIPTOR_NPS          0x00000200  // no power switching
#define  RH_DESCRIPTOR_DT           0x00000400  // device type
#define  RH_DESCRIPTOR_OCPM         0x00000800  // over current protection mode
#define  RH_DESCRIPTOR_NOCP         0x00001000  // no overcurrent protection
#define  RH_DESCRIPTOR_POTPGT       0xff000000  // power on to power good time
#define  RH_DESCRIPTOR_POTPGT_OFF   24          // power on to power good time offset value

// Root hub status register flags (4c)
#define  RH_STATUS_LPS              0x00000001  // local power status/clear global power
#define  RH_STATUS_OCI              0x00000002  // over current indicator
#define  RH_STATUS_DRWE             0x00008000  // device remote wakup enable/set remote wakeup enable
#define  RH_STATUS_LPSC             0x00010000  // local power status change/set global power
#define  RH_STATUS_CCIC             0x00020000  // over current indicator change
#define  RH_STATUS_CRWE             0x80000000  // clear remote wakeup enable

// Root hub port status flags     (50)->
#define  RH_PORT_CCS                0x00000001  // current connect status/clear port enable
#define  RH_PORT_PES                0x00000002  // port enable status/set port enable
#define  RH_PORT_PSS                0x00000004  // port suspend status/set port suspend
#define  RH_PORT_POCI               0x00000008  // port over current indicator/clear suspend status
#define  RH_PORT_PRS                0x00000010  // port reset status/set port reset
#define  RH_PORT_PPS                0x00000100  // port power status/set port power
#define  RH_PORT_LSDA               0x00000200  // low speed device attached/clear port power
#define  RH_PORT_CSC                0x00010000  // connect status change
#define  RH_PORT_PESC               0x00020000  // port enable status change
#define  RH_PORT_PSSC               0x00040000  // port suspend status change
#define  RH_PORT_OCIC               0x00080000  // port over current indicator status change
#define  RH_PORT_PRSC               0x00100000  // port reset status change

// Host Controller Operational Registers (4KB area)
typedef struct _HCOR_
{
   ULONG    revision;            // (00)  HCI specification revison number
   ULONG    control;             // (04)  HC operating modes
   ULONG    commandStatus;       // (08)
   ULONG    interruptStatus;     // (0c)
   ULONG    interruptEnable;     // (10)
   ULONG    interruptDisable;    // (14)
   ULONG    hcca;                // (18)
   ULONG    periodCurrentED;     // (1c)
   ULONG    controlHeadED;       // (20)
   ULONG    controlCurrentED;    // (24)
   ULONG    bulkHeadED;          // (28)
   ULONG    bulkCurrentED;       // (2c)
   ULONG    doneHead;            // (30)
   ULONG    fmInterval;          // (34)
   ULONG    fmRemaining;         // (38)
   ULONG    fmNumber;            // (3c)
   ULONG    periodicStart;       // (40)
   ULONG    lsThreshold;         // (44)
   ULONG    rhDescriptorA;       // (48)
   ULONG    rhDescriptorB;       // (4c)
   ULONG    rhStatus;            // (50)
   ULONG    rhPortStatus[1];     // (54)
   ULONG    reserved1[42];       // (58)
   ULONG    eControl;            // (100) enable/control/status of emulation hardware
   ULONG    eInput;              // (104) legacy input buffer register
   ULONG    eOutput;             // (108) legacy output buffer register
   ULONG    eStatus;             // (10c) legacy status register
   ULONG    reserved[956];       // (110)
}  HCOR;

// General Transfer Descriptor
typedef struct _TD_
{  // OHCI required fields
   ULONG          ctrlStat;            // (00)
   ULONG          cbp;                 // (04) current buffer pointer
   ULONG          nextTD;              // (08) next TD address
   ULONG          be;                  // (0c) TD buffer end
   // common with ED
   ULONG          physAddr;            // (10) TD's physical address
   UCHAR          elementType;         // (14) element type - TD, several ED types
   UCHAR          category;            // (15) IRQ processing category (receiver ID)
   USHORT         deleteFrameNumber;   // (3c)
   // implementation defined fields
   struct _TD_    *virtNextTD;         // (16) Virtual Address of Link Pointer
   PUCHAR         virtBufferPointer;   // (18) Buffer's virtual address
   PUSBIDCEntry   usbIDC;              // (1c) IRQ extension IDC addr
   USHORT         usbDS;               // (20) extension IDC DS value
   struct _TD_    *virtFirstTD;        // (22) Virtual Address of Link Pointer
   ULONG          requestData1;        // (24) data to be stored within request
   ULONG          requestData2;        // (28) data to be stored within request
   ULONG          requestData3;        // (2c) data to be stored within request
   ULONG          pktBandwidth;        // (30) required bandwith to execute TD chain
   PVOID          virtEDAddr;          // (34)
   ULONG          initBuffPtr;         // (38)
   UCHAR          direction;           // (3e)
   UCHAR          waitForProces;
                                       // (40)
}  TD;

#define  TD_CTRLSTAT_R           0x00040000  // buffer rounding (short packet)
#define  TD_CTRLSTAT_DP_MASK     0x00180000  // direction/PID mask
#define  TD_CTRLSTAT_DP_SETUP    0x00000000  // SETUP
#define  TD_CTRLSTAT_DP_OUT      0x00080000  // OUT
#define  TD_CTRLSTAT_DP_IN       0x00100000  // IN
#define  TD_CTRLSTAT_DI_MASK     0x00e00000  // delay interrupt mask
#define  TD_CTRLSTAT_DI_NOINTRPT 0x00e00000  // interrupt suppressed
#define  TD_CTRLSTAT_DI_LONGINT  0x00c00000  // interrupt after 6 frame
#define  TD_CTRLSTAT_DI_IMMED    0x00000000  // no interrupt delay
#define  TD_CTRLSTAT_DI_OFF      21          // delay interrupt bit offset
#define  TD_CTRLSTAT_T_MASK      0x03000000  // data toggle mask
#define  TD_CTRLSTAT_T_TD        0x02000000  // use data toggle from TD
#define  TD_CTRLSTAT_T_ON        0x01000000  // TD data toggle on
#define  TD_CTRLSTAT_T_OFF       24          // data toggle bit offset
#define  TD_CTRLSTAT_EC_MASK     0x0c000000  // error count mask
#define  TD_CTRLSTAT_EC_OFF      26          // error count bit offset
#define  TD_CTRLSTAT_CC_MASK     0xf0000000  // condition code mask
#define  TD_CTRLSTAT_CC_OFF      28          // condition code bit offset
#define  TD_ADDR_MASK            0xffffffe0  // address mask

#define  OHCI_D_SETUP    0x0  // SETUP
#define  OHCI_D_OUT      0x1  // OUT
#define  OHCI_D_IN       0x2  // IN
#define  OHCI_D_OFF      19   // offset

// Isohronous Transfer Descriptor
typedef struct _TDI_
{  // OHCI required fields
   ULONG             ctrlStat;            // (00)
   ULONG             cbp;                 // (04) current buffer pointer
   ULONG             nextTD;              // (08) next TD address
   ULONG             be;                  // (0c) TD buffer end
   USHORT            offset[8];           // (10) data offsets in buffer
                                          // (20)
}  TDI;

#define  TDI_CTRLSTAT_SF_MASK     0x0000ffff  // Starting frame mask
#define  TDI_CTRLSTAT_DI_MASK     0x00e00000  // delay interrupt mask
#define  TDI_CTRLSTAT_DI_NOINTRPT 0x00e00000  // interrupt suppressed
#define  TDI_CTRLSTAT_DI_IMMED    0x00000000  // no interrupt delay
#define  TDI_CTRLSTAT_DI_OFF      21          // delay interrupt bit offset
#define  TDI_CTRLSTAT_FC_MASK     0x07000000  // Frame count mask
#define  TDI_CTRLSTAT_FC_OFF      24          // Frame count offset
#define  TDI_CTRLSTAT_CC_MASK     0xf0000000  // condition code mask
#define  TDI_CTRLSTAT_CC_OFF      28          // condition code bit offset
#define  TDI_PHI_PAGE_NUMBER      0xfffff000  // physical page number of the first byte
#define  TDI_ADDR_MASK            0xffffffe0  // address mask

// Endpoint Descriptor
typedef struct _EDI_
{
   ULONG       ctrlStat;            // (00)
   ULONG       tailP;               // (04)  TD queue tail pointer
   ULONG       headP;               // (08)  TD queue head pointer
   ULONG       nextED;              // (0c)  next endpoint descriptor
                                    // (10) TD's physical address
}  EDI;

#define  EDI_CTRLSTAT_READY_MASK       0x01  // ready condition code mask
#define  EDI_CTRLSTAT_READY            0x01  // ready condition code
#define  EDI_CTRLSTAT_READY_OFF        0x00  // ready condition code offset
#define  EDI_CTRLSTAT_NUMBER_MASK      0x7E  // last buffer number mask
#define  EDI_CTRLSTAT_NUMBER_OFF       0x01  // last buffer number offset
#define  EDI_CTRLSTAT_BUFFER_END       0x80  // flag means current buffer ends processing on this ED
#define  EDI_CTRLSTAT_BUFFER_END_MASK  0x80  // is end of buffer flag mask
#define  EDI_CTRLSTAT_BUFFER_END_OFF   0x07  // is end of buffer flag offset



// Endpoint Descriptor with data
typedef struct _ED_
{
   ULONG       ctrlStat;            // (00)
   ULONG       tailP;               // (04) TD queue tail pointer
   ULONG       headP;               // (08) TD queue head pointer
   ULONG       nextED;              // (0c) next endpoint descriptor
   // common with TD
   ULONG       phyTDAddr;           // (10) TD's physical address
   UCHAR       elementType;         // (14) element type - TD, several ED types
   UCHAR       category;            // (15) not used
   USHORT      deleteFrameNumber;   // (3c)
   // implementation defined fields
   UCHAR       deviceAddress;       // (16) device address
   UCHAR       endPointId;          // (17) device endpoint ID
   PULONG      edHeadPointer;       // (18)
   struct _ED_ *nextVirtED;         // (1c)
   struct _ED_ *prevVirtED;         // (1e)
   struct _TD_ *firstVirtTD;        // (20)
   struct _TD_ *lastVirtTD;         // (22)
   ULONG       pktBandwidth;        // (24) required bandwith to execute attached TD's
   ULONG       isStaticED;          // (28)
   ULONG       reqType;             // (2C)
   ULONG       mixIndex;            // (30) start index in HCCA interrupt table
   USHORT      interruptRate;       // 
   ULONG       res[2];              // (34)
                                    // (40)
}  ED;

#define  ED_CTRLSTAT_FA_MASK     0x0000007f  // function address mask
#define  ED_CTRLSTAT_EN_MASK     0x00000780  // endpoint number mask
#define  ED_CTRLSTAT_EN_OFF      7           // endpoint number bit offset
#define  ED_CTRLSTAT_D_MASK      0x00001800  // direction mask
#define  ED_CTRLSTAT_D_TD0       0x00000000  // get direction from TD
#define  ED_CTRLSTAT_D_OUT       0x00000800  // OUT
#define  ED_CTRLSTAT_D_IN        0x00001000  // IN
#define  ED_CTRLSTAT_D_TD1       0x00001800  // get direction from TD
#define  ED_CTRLSTAT_S           0x00002000  // low speed device flag
#define  ED_CTRLSTAT_K           0x00004000  // ED skip flag
#define  ED_CTRLSTAT_F           0x00008000  // isohronous TD flag
#define  ED_CTRLSTAT_MPS_MASK    0x07ff0000  // maximum packet size mask
#define  ED_CTRLSTAT_MPS_OFF     16          // maximum packet size bit offset
#define  ED_TAIL_H               0x00000001  // endpoint halted flag
#define  ED_TAIL_C               0x00000002  // toggle carry flag
#define  ED_ADDR_MASK            0xfffffff0  // tail/head/nextED address mask

// ED/TD element types
   #define  ELEMENT_TYPE_NOTUSED       0
   #define  ELEMENT_TYPE_TD            1
   #define  ELEMENT_TYPE_LASTD         2
   #define  ELEMENT_TYPE_ED            3
   #define  ELEMENT_TYPE_TOBEDEL       4
   #define  ELEMENT_TYPE_DUMMYTD       5

// root hub processing status definitions
   #define  ROOT_HUB_NOREQ             0
   #define  ROOT_HUB_PROCESSING        1
   #define  ROOT_HUB_REQ               2

typedef struct _root_hub_conf
{
   DeviceConfiguration  configuration;
   DeviceInterface      interface;
   DeviceEndpoint       endpoints;
}  RootHubConfiguration;

// default address request timeout value in root hub polling cycles
   #define  DEFADDR_TIME_OUT           10

// packet transmission time calculation constants
   #define  TTIME_HOST_DELAY            0L
   #define  TTIME_HUB_LS_SETUP          4000L


// data structures used for Isohronous request processing
// isohronous buffer information structure
typedef struct _isobuffs_
{
   PUCHAR         buffVirtAddr;  // (00) buffer virtual address
   USHORT         buffLength;    // (04) buffer length
   ULONG          buffPhysAddr;  // (06) buffer physical address
   ULONG          lastUsedAddr;  // (10) last scheduled data address
   ULONG          requestData1;  // (14) data to be stored within request
   ULONG          requestData2;  // (18) data to be stored within request
   ULONG          requestData3;  // (22) data to be stored within request
   USHORT         frameBuffersCount;  //(26)    buffer count
   USHORT         activeFrameBuffer;  // (30) last added to queue buffer
                                      // (32)
}  ISOBUFFS;

// isohronous request data structure
#define  ISO_BUFFER_UNDEFINED        -1  
#define  OHCI_ISO_SEG_SIZE           4096
#define  OHCI_MIN_INTERRUPT_RATE     32                // minimal rate for interrupts
#define  OHCI_INTERRUPT_RATE_MASK    31                // minimal rate mask for frame number
#define  OHCI_FRAME_COUNT_PER_TD     8                 // count of frames that service one TD
#define  OHCI_MAX_ISO_BUFFER_COUNT   8                // max count of isohronous buffers

#define  OHCI_ISO_CANCELED           1
#define  OHCI_ISO_NEED_RELEASE       2

typedef struct _isods_
{
   struct _isods_ FAR      *next;                     // (00)  pointer to next iso data block
   struct _isods_ FAR      *previous;                 // (04)  pointer to previous iso data block
   UCHAR                   deviceAddress;             // (08)  device address
   UCHAR                   endPointId;                // (09)  target endpoint address
   USHORT                  flags;                     // (10)  saved request flags (see IORB)
   ULONG                   physAddress;               // (12)  data block physical address
   SEL                     gdtSelector;               // (16)  data block GDT selector
   USHORT                  maxBuffers;                // (18)  buffInfo table length
   USHORT                  currBuffCount;             // (20)  current buffer count
   USHORT                  activeBuffIndex;           // (22)  last scheduled buffer index
   USHORT                  lastUnProcessedBuffIndex;  // (24)  last unprocessed buffer index
   ULONG                   lastUsedFrame;             // (26)  last schedule frame index
   USHORT                  isoFrameLength;            // (30)  no of bytes to be transfered during single frame
   ULONG                   tdProcessingTime;          // (32)  required frame bandwidth
   PUSBIDCEntry            usbIDC;                    // (36)  IRQ rtne address
   USHORT                  usbDS;                     // (40)  IRQ rtne DS value
   UCHAR                   category;                  // (42)  callers category
   ULONG                   requestData1;              // (43)  data to be stored within request
   ULONG                   requestData2;              // (47)  data to be stored within request
   ULONG                   requestData3;              // (51)  data to be stored within request
   USHORT                  direction;                 // (55)
   UCHAR                   needToRelease;             // (58)
   UCHAR                   EndOfBuffer;               // (59)
   UCHAR                   reserved[5];               // (60)
   TDI                     td[MAX_SCHEDULE_ENTRIES];  // (64)
   EDI                     isoEDI;                    // ()
   ULONG                   physEDAddress;             // (3D)
   ULONG                   tdPhyAddr;                 // () first TD physical address
   ULONG                   nextHeadTD;                // physical address to next ready head TD
   ULONG                   nextTailTD;                // physical address to next ready tail TD
   UCHAR                   nextEndOfBuffer;
   ISOBUFFS                bufInfo[OHCI_MAX_ISO_BUFFER_COUNT]; // () buffer information
}  ISOINFO;

typedef struct _notifData_
{
   PUCHAR                  buffVirtAddr;              // (00) processed buffer virtual address
   USHORT                  buffLength;                // (04) processed data length
   ULONG                   requestData1;              // (06) user data1
   ULONG                   requestData2;              // (10) user data2
   ULONG                   requestData3;              // (14) user data3
                                                      // (18)
}  NOTIFDATA;

#define  ISO_IRQ_DELAY     512   //
#define  ISO_SERVICE_DELAY 2    //

//
//  Shut Down Request Packet
//
typedef struct _RPSHDOWN  {               /* RPSHDOWN */

  RPH           rph;          // standard request packet header
  UCHAR         functionCode; // shutdown function code - start/end shutdown
  ULONG         reserved;     // reserved for future use
} RPSHDOWN;

#define  START_SHUTDOWN          0
#define  END_SHUTDOWN            1

// status flags used in context thread processing  // 31/05/1999 MB
#define  ARM_STATUS_CLEARED      0x0000     // thread is not running or armed
#define  ARM_STATUS_ARMED        0x0001     // thread is running or armed
#define  ARM_STATUS_ARMING       0x0002     // arming in progress
#define  ARM_STATUS_REQ          0x0004     // arming required when thread ends

#endif
