/* SCCSID = "src/dev/usb/OHCI/OHCSTRAT.C, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 2001  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  OHCSTRAT.C                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  OHCD device driver strategy routine.                  */
/*                                                                            */
/*   FUNCTION: These routines handle the task time routines for the strategy  */
/*             entry point of OHCD device driver.                             */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             OHCIStrategy                                                   */
/*             CmdError                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/01/27  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include        "ohci.h"

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  OHCIStrategy                                     */
/*                                                                    */
/* DESCRIPTIVE NAME:  Strategy 1 entry point for the OHCD device      */
/*                    driver.                                         */
/*                                                                    */
/* FUNCTION:  The function of this routine is pass the kernel         */
/*            request packet to strategy worker routine.              */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task/Initialization time                                  */
/*                                                                    */
/* ENTRY POINT:  OHCIStrategy                                         */
/*    LINKAGE:  CALL FAR                                              */
/*                                                                    */
/* INPUT:  es:bx -> kernel request packet                             */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: None                                                      */
/*                                                                    */
/* INTERNAL REFERENCES:  None                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
#pragma optimize("eglt", off)
void far OHCIStrategy()
{
   RPH FAR      *pRP;
   USHORT       Cmd;

   //  get request block address 
   _asm {
      mov word ptr pRP[0], bx
      mov word ptr pRP[2], es
   }

   Cmd = pRP->Cmd;
   #ifdef DEBUG
   dsPrint1(DBG_HLVLFLOW, "OHCI: OHCIStrategy entered: CMD=%x\r\n", (ULONG)Cmd);
   #endif

   if (Cmd > MAX_USB_CMD) {
      CmdError( pRP );
   } else {
      /*---------------------*/
      /* Call Worker Routine */
      /*---------------------*/
      (*gStratList[Cmd])(pRP);
   }
   #ifdef DEBUG
   dsPrint2(DBG_HLVLFLOW, "OHCI: OHCIStrategy Exit: CMD = %x, Status=%x\r\n", (ULONG)Cmd, pRP->Status);
   #endif

}
#pragma optimize("", on)

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  CmdError                                         */
/*                                                                    */
/* DESCRIPTIVE NAME:  Command not supported in the device driver      */
/*                                                                    */
/* FUNCTION:  The function of this routine is to return command not   */
/*            supported for the request.                              */
/*                                                                    */
/* NOTES: This is an immediate command that is not put on the FIFO    */
/*        queue.                                                      */
/*                                                                    */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  CmdError                                             */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  pRP-> kernel request packet                                */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND       */
/*                                                                    */
/* INTERNAL REFERENCES:  None                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
void CmdError(RPH FAR *pRP)
{
   #ifdef DEBUG
   dsPrint1(DBG_CRITICAL, "OHCI: CmdError - Strategy Command = %d\r\n", pRP->Cmd);
   #endif
   pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND;
   return;
} 
