/* SCCSID = "src/dev/usb/OHCI/OHCPROTO.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 2001 All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  OHCPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Function prototypes provided by the OHCI compliant    */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the OHCI compliant USB device driver            */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/01/27  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/* OHCSTRAT.C */
void FAR OHCIStrategy();
void CmdError( RPH FAR *pRP);

/* OHCDATA.C */
USHORT (*gStratList[])( RPH FAR *pRP );

/* OHCIDC.C */
void FAR OHCIidc( RP_GENIOCTL FAR *pRP_GENIOCTL );
void OHCIAcceptIO( RP_GENIOCTL FAR *const pRP_GENIOCTL );
void AccNonIsoReq( RP_GENIOCTL FAR *const pRP_GENIOCTL );   
ULONG PacketTTime(USHORT maxPacketSize, BOOL lowSpeedDevice, ULONG token, USHORT queType);
VOID SetDWORD( PULONG itemAddress, ULONG itemData );
VOID GetDWORD( PULONG itemAddress, PULONG targetAddress );
VOID SetFmInterval(PULONG fmInterval);
VOID SetPeriodicStart(PULONG fmInterval);
BOOL CheckBandwidth(const ULONG packetTime, const USHORT reqQueingType, const BOOL slowDevice, const UCHAR mixIndex, const UCHAR interruptRate);
VOID AccIsoReq( RP_GENIOCTL FAR *const pRP_GENIOCTL );   
ISOINFO FAR *CreateIsoStruct( USBRB FAR *const ioRB );
VOID ReleaseIsoStruct( ISOINFO FAR *const isoInfo );
VOID AddIsoBuffsToSchedule( void );                
BOOL IsNeedIsoProcessing( void );
VOID ProcessIsoIRQ( void );
VOID CancelIsoRequests(const UCHAR deviceAddress,UCHAR endPointId);
void OHCIFinIO( RP_GENIOCTL FAR *pRP_GENIOCTL );   // only for debug
VOID FreeTDsQH( TD *const firstTD, const BOOL disableInterrupts, const UCHAR deleteType);
BOOL FreeClaimed( void );

// USBCCANIO.C
void OHCICancelIO( RP_GENIOCTL FAR *const pRP_GENIOCTL );
void CancelEndpointReq(const UCHAR deviceAddress, const UCHAR endPointId, const BOOL directionIn, const BOOL cancelAllEPts );

/* OHCINIT.C */
void OHCIInit( RPH FAR *pRP );

/* OHCCOMPL.C  */
void OHCIInitComplete( RPH FAR *pRP);
void CreateStaticInterruptEDList(void);
void OHCIGetUSBDIDC(void);
void OHCIResetHost(const RP_GENIOCTL FAR *const pRP_GENIOCTL );
void OHCIShutDown( RPH FAR *pRP );
ED *GetDummyED( void );

/* usbcheck.c  */
VOID CallOEMHlp( VOID (FAR *pFunctionCall)(VOID), USHORT oemHelpDS, PRPH pRPH );
BOOL CheckPCI(void);
BOOL NEAR FindPCIDevice( UCHAR maxPCIBuses );
BOOL NEAR ReadPCIConfigSpace( UCHAR BusNum, UCHAR DevFunc,
                              UCHAR ConfigReg,
                              PULONG Data, USHORT Size );
BOOL NEAR WritePCIConfigSpace(  UCHAR HWMech, UCHAR BusNum, UCHAR DevFunc,
                                UCHAR ConfigReg,
                                ULONG Data, UCHAR Size );
BOOL PciSetReg( UCHAR HWMech, UCHAR DevFunc, UCHAR ConfigReg, ULONG val, USHORT size );
void PciSetRegMech2( USHORT regmask, UCHAR index, ULONG val, USHORT size );
void PciSetRegMech1( USHORT regmask, UCHAR index, ULONG val, USHORT size );

/* usbIRQ.c */
void FAR OHCIInterrupt();
void DefAddrTimeOut(void);
void CheckQHs(void);
BOOL FinishIO(TD *tdList, const BOOL cancelled);

/* ohcirhub.c  */
void AccRootHubReq( RP_GENIOCTL FAR *const pRP_GENIOCTL );
void OHCIRootHub( RP_GENIOCTL FAR *const pRP_GENIOCTL );

/* ohctime.c   */
void  IODelay( void );
void  TimeExecutionStall(const USHORT delay );
void FAR OHCIRootHubTimer();

/* OHCCTX.C */
VOID FAR PASCAL OHCICtxHookRtn( VOID );
VOID FAR PASCAL RHubCtxHookRtn( VOID );
VOID FAR PASCAL AddIsoHookRtn( VOID );
VOID FAR PASCAL IsoIRQHookRtn( VOID );
VOID SafeArmCtxHook(const ULONG hookHandle,const ULONG armData, USHORT *const statusFlag );
VOID ClearThreadStatus(const ULONG hookHandle,const ULONG armData, USHORT *const statusFlag );

// ohcaccio.c
TD *GetTDEDVirtAddrWithIso( ULONG physAddr);
TD *GetTDEDVirtAddr( const ULONG physAddr);
TD *AllocateTD(const UCHAR tdType,const BOOL disableInterrupts );
ED *SearchAllED(const UCHAR deviceAddress, const UCHAR endPointId, const BOOL directionIn);
ED *SearchED(const UCHAR deviceAddress, const UCHAR endPointId, const BOOL directionIn);
ED *SearchInterruptED(const UCHAR deviceAddress, const UCHAR endPointId, const BOOL directionIn);
void AddReqED(ED *const lastED, ED *const ed);
void RemoveED(ED *const ed);
void CheckTDAs( TD *const td, const UCHAR deleteType );
ULONG SearchDoneQueue(TDI FAR* FAR*const pTDI, TD* FAR*const pTD, const ULONG curPhysAddr, ISOINFO FAR* FAR*const pIso);

// ohciso.c
void DetachIsoTDs( ISOINFO FAR *const isoInfo );
void DeleteIsoTDFromDoneQueue( void );
void RecalculateBandwidth(const ULONG packetTime, const USHORT reqQueingType, const BOOL add, const UCHAR mixIndex, const UCHAR interruptRate);
void ReleaseIso( ISOINFO FAR *const isoInfo );
