/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/OHCI/OHCIDC.C, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  USBIDC.C                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB device driver inter-device driver                 */
/*                      communication routines.                               */
/*                                                                            */
/*   FUNCTION: These routines handle the PDD-PDD IDC for the                  */
/*             OHCI compliant USB Host device driver.                         */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             OHCIidc          PDD - PDD IDC Entry Point                     */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/01/27  MB              Original developer.                     */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "ohci.h"

/******************* START OF SPECIFICATIONS **************************/
/*                                                                    */
/* SUBROUTINE NAME:  OHCIidc                                          */
/*                                                                    */
/* DESCRIPTIVE NAME:  PDD-PDD IDC entry point and request router      */
/*                                                                    */
/* FUNCTION:  This routine is the PDD-PDD IDC entry point and         */
/*            request router..  IDC function requests are routed      */
/*            to the appropriate worker routine.  The address of      */
/*            this routine is returned to other device drivers via    */
/*            the DevHelp AttachDD call.                              */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task Time                                                 */
/*                                                                    */
/* ENTRY POINT :  OHCIidc                                             */
/*    LINKAGE  :  CALL FAR                                            */
/*                                                                    */
/* INPUT:  RP_GENIOCTL FAR *pRP_GENIOCTL                              */
/*                                                                    */
/* EXIT-NORMAL:  N/A                                                  */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS:  pRP_GENIOCTL->rph.Status - return code                   */
/*                                                                    */
/* INTERNAL REFERENCES:  OHCICancelIO                                 */
/*    ROUTINES:          OHCIAcceptIO                                 */
/*                       OHCIResetHost                                */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*    ROUTINES:                                                       */
/*                                                                    */
/******************* END  OF  SPECIFICATIONS **************************/
void FAR OHCIidc(RP_GENIOCTL FAR *pRP_GENIOCTL)
{
   if (!pRP_GENIOCTL)
      return;

   #ifdef   DEBUG
   dsPrint3(DBG_HLVLFLOW, "OHCI: OHCIidc entered: Category=%x, Function=%x, Status=%x\r\n",
      pRP_GENIOCTL->Category, pRP_GENIOCTL->Function, pRP_GENIOCTL->rph.Status);
   #endif
   
   pRP_GENIOCTL->rph.Status = USB_IDC_RC_OK;

   // check for correct command request and non-zero parameter packet address
   if (pRP_GENIOCTL->rph.Cmd != CMDGenIOCTL || !pRP_GENIOCTL->ParmPacket) {
      #ifdef   DEBUG
      dsPrint(DBG_CRITICAL, "OHCI: pRP_GENIOCTL->rph.Cmd!=CMDGenIOCTL || !pRP_GENIOCTL->ParmPacket");
      #endif
      pRP_GENIOCTL->rph.Status = USB_IDC_RC_PARMERR;
   } else {
      switch (pRP_GENIOCTL->Category) {
         case USB_IDC_CATEGORY_HOST:
            switch (pRP_GENIOCTL->Function) {
               case USB_IDC_FUNCTION_CANCEL:
                  #ifdef   DEBUG
                  dsPrint(DBG_HLVLFLOW, "OHCI: USB_IDC_FUNCTION_CANCEL\r\n");
                  #endif
                  OHCICancelIO(pRP_GENIOCTL);
                  break;
               case USB_IDC_FUNCTION_ACCIO:
                  #ifdef   DEBUG
                  dsPrint(DBG_HLVLFLOW, "OHCI: USB_IDC_FUNCTION_ACCIO\r\n");
                  #endif
                  OHCIAcceptIO(pRP_GENIOCTL);
                  break;
               case USB_IDC_FUNCTION_RSTHOST:
                  OHCIResetHost(pRP_GENIOCTL);
                  break;
               #ifdef   DEBUG
               case USB_IDC_FUNCTION_FINIO:
                  OHCIFinIO(pRP_GENIOCTL);
                  break;
               #endif
               default:
                  #ifdef   DEBUG
                  dsPrint(DBG_CRITICAL, "OHCI: USB_IDC_RC_WRONGFUNC\r\n");
                  #endif
                  pRP_GENIOCTL->rph.Status = USB_IDC_RC_WRONGFUNC;
                  break;
            }
            break;
         default:
            #ifdef   DEBUG
            dsPrint(DBG_CRITICAL, "OHCI: USB_IDC_RC_WRONGCAT\r\n");
            #endif
            pRP_GENIOCTL->rph.Status = USB_IDC_RC_WRONGCAT;
            break;
      }
   }
   pRP_GENIOCTL->rph.Status |= STATUS_DONE;
   #ifdef   DEBUG
   dsPrint3(DBG_HLVLFLOW, "OHCI: OHCIidc finished: Category=%x, Function=%x, Status=%x\r\n",
      pRP_GENIOCTL->Category, pRP_GENIOCTL->Function, pRP_GENIOCTL->rph.Status);
   #endif
}
