/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/OHCI/OHCI.H, usb, c.basedd 98/07/29" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  OHCI.H                                                */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Open Host Controller Interface (OHCI)                 */
/*                      structure and flag definitons.                        */
/*                                                                            */
/*   FUNCTION: This header file contains OHCI specific data structure and     */
/*                      flag definitions                                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/01/27  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
#ifndef _OHCI_h_
   #define _OHCI_h_

// OHCI specific debug definitions
   #ifdef   DEBUG
      #define         dsPrint(l,s)              dsPrint5x(gOHCIMsgLevel,(l),(s),0,0,0,0,0)
      #define         dsPrint1(l,s,a)           dsPrint5x(gOHCIMsgLevel,(l),(s),(a),0,0,0,0)
      #define         dsPrint2(l,s,a,b)         dsPrint5x(gOHCIMsgLevel,(l),(s),(a),(b),0,0,0)
      #define         dsPrint3(l,s,a,b,c)       dsPrint5x(gOHCIMsgLevel,(l),(s),(a),(b),(c),0,0)
      #define         dsPrint4(l,s,a,b,c,d)     dsPrint5x(gOHCIMsgLevel,(l),(s),(a),(b),(c),(d),0)
   #endif
   
   #include "usbcmmon.h"         //     common USB stack definitions, OS/2 standard includes
   #include "usbmisc.h"          //     common USB routine definitions (defined in usbmisc.lib)

   #include "ohctype.h"          /* OHCI specific typedefs */
   #include "usbpci.h"           /* PCI related definitions  */
   #include "ohcproto.h"         /* function prototypes */
   #include "ohcextrn.h"         /* external data declarations */

#endif
