/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/OHCI/OHCEXTRN.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  UHCEXTRN.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  External data declarations for the Open Host          */
/*                      Controller Interface compliant device driver.         */
/*                                                                            */
/*   FUNCTION: This module is the USBOHCD device driver external              */
/*             data declarations include file. See ohcdata.c for the data     */
/*             items being externalized.                                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/01/27  MB                                                      */
/*  LR0420  01/04/20  LR              Added gUHCUSBD (registered with USBD)   */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

extern   USHORT         (*gStrat1[])();   // Dispatch table for strategy commands (pre FIFO queue)

extern   PFN            Device_Help;      //  devhelp entry point; used by dhcalls.lib

extern   ULONG          RMFlags;          // RM.LIB needs these declared
extern   PFN            RM_Help0;         // RM.LIB needs these declared
extern   PFN            RM_Help3;         // RM.LIB needs these declared

extern   UCHAR          gDevName[8];      // driver's name

/*--------------------------------------------------------*/
/* Set the DRIVERSTRUCT and DETECTEDSTRUCT data areas     */
/*--------------------------------------------------------*/
extern   char  near     gDDName[];        // device driver name
extern   char  near     gDDDesc[];        // device driver description
extern   char  near     gVendorID[];      // vendor identification
extern   char  near     gAdapterName[];   // adapter name

extern   DRIVERSTRUCT   gDriverStruct;    // Driver Description
extern   ADAPTERSTRUCT  gAdapterStruct;   // Adapter Description

/*----------------------------------------------*/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables are assigned the handles for */
/* drivers, detected hardware and resources.    */
/*----------------------------------------------*/
extern   HDRIVER        ghDriver;          // global handle to driver
extern   HADAPTER       ghAdapter;         // global handle to adapter
extern   UCHAR          gusbIRQ;           // UHC IRQ number
extern   UCHAR          gusbPIN;           // UHC interrupt pin number
extern   ULONG          gusbIOBase;        // USB IO Spce Base Address
extern   USHORT         gPortBitmapLen;    // port bitmap length

extern   HRESOURCE      girqResource;
extern   HRESOURCE      gmemResource;      // memory space resource handle
extern   PUSBIDCEntry   gpUSBDIDC;
extern   USHORT         gdsUSBIDC;
extern   BOOL           gUHCUSBD;               //LR0420 registered within USBD
extern   UCHAR          ghcdID;
extern   UCHAR          gRootHubAddress;
extern   UCHAR          gRootHubConfig;
extern   BOOL           gHostReset;
extern   BOOL           gIRQSet;                // set to TRUE if IRQ processing rtne set

extern   CHAR           gOEMDriverName[9];
extern   CHAR           gUSBDriverName[9];

// root hub structure definitons
extern   DeviceDescriptor     gRootDescriptor;

extern   RootHubConfiguration gRootConfiguration;

extern   HubDescriptor        gRootHubConfiguration;
extern   RP_GENIOCTL          gRootHubRP[ROOT_MAX_REQ];  // structures to store
extern   USBRB                gRootHubRB[ROOT_MAX_REQ];  // root hub I/O requests

extern   ULONG                gCTXHookHandle;            // task time thread context hook handle
extern   ULONG                gRHubHookHandle;           // task time thread context hook handle
extern   ULONG                gAddIsoHookHandle;         // add buffers to schedule task time thread
extern   USHORT               gIRQTaskStatus;   // IRQ processing context thread status
extern   USHORT               gRHubHookStatus;  // Root hub request processing context thread status
extern   USHORT               gAddIsoStatus;    // add buffers to schedule context thread status
extern   USHORT               gIsoIrqStatus;    // iso IRQ processing context thread status
extern   UCHAR                gRootReqStatus;            // root hub request status
extern   ULONG                gIsoIrqHookHandle;         // iso IRQ processing task time thread
extern   ULONG                gInterruptFlags;           // last USB status register flags

extern   USHORT               g0Time;                    // timer count for default address request
extern   TD                   *g0TD;                     // default address request ED
extern   BOOL                 g0Cancel;         // true when default address request must be cancelled
extern   ED                   *g0ED;             // default address ED
extern   ED                   *gPeriodicED;
extern   ED                   *gControlED;
extern   ED                   *gBulkED;

extern   IDCTABLE       gDDTable;

extern   DEVICESTRUCT gDeviceStruct;

// OHCI host data area definitions, pointers and indexes
extern   ULONG          gPH1stTD;    // full address of the 1st TD
extern   ULONG          gPHLastTD;
extern   SEL            gHCORSel;      // host controller operational register GDT
extern   HCOR FAR       *gVirtHCORAddr;     // virtual frame list address
extern   SEL            gHCCASel;      // host controller communication area GDT
extern   HCCA FAR       *gVirtHCCAddr;       // virtual address of host controller communication area
extern   ULONG          gPhysHCCADDR;       // physical address of HCCA
extern   ULONG          gUnprocTD;     // physical address of unprocessed IN td
extern   TD             *gTDListStart;       // ED/TD array start address
extern   USHORT         gTDCount;            // no of elements in ED/TD array
extern   USHORT         gLastTDId;           // last used ED/TD element index
extern   LONG           gHCData[HCD_WBUF_LENGTH]; // buffer used for schedule and ED/TD array allocation
extern   UCHAR          gHCCABuff[2*sizeof(HCCA)]; // buffer used for HC communication area
extern   BOOL           gInterruptsDisabled; // TRUE if interrupts disabled during iso IRQ processing
extern   ISOINFO FAR    *gFirstIso;    // pointer to the 1st iso request information structure
extern   ISOINFO FAR    *gLastIso;     // pointer to the last iso request information structure

extern   ULONG          gIsoPktSize;   // total isohronous request frame size
extern   ULONG          gIntPktBandwidth[OHCI_MIN_INTERRUPT_RATE];    // allocated bandwidth
extern   ULONG          gCtrlPktBandwidth;        // allocated bandwidth

extern   BOOL           gStopHostOnShutDown; // if TRUE stops host during shutdown process

extern   UCHAR          gMixIndex;

#ifdef   DEBUG
extern   USHORT         gOHCIMsgLevel;   // debug message level
extern   ULONG          g_needView;
#endif

extern   UCHAR          gBusNum;    // PCI bus number
extern   UCHAR          gDevFunc;   // PCI device function
extern   UCHAR          gHwMech;    // PCI hardware configuration mechanism

//-------------initialization time data follows----------------------------------------------
extern   BYTE           gInitDataStart;   // Marks the end of the data segment.

extern   UCHAR          gPCIMajorVer;
extern   UCHAR          gPCIMinorVer;
extern   UCHAR          gMaxPCIBuses; // no of PCI buses detected
extern   UCHAR          gRevision;  // Vendor's USB Host device revision
extern   UCHAR          gDevicesFound;  // no of USB hosts detected
extern   BOOL           gIRQShared;  // IRQ sharing supported

extern   USHORT         gVerbose;   // console message printout level

#define MSG_REPLACEMENT_STRING  1178


extern   USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT];   // console message indexes
extern   USHORT         gMessageCount;                         // console message count
extern   PSZ            gVMessages[];

extern   MSGTABLE       gInitMsg;
