/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/HID/HIDTYPE.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  HIDTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  HID Class device driver TYPEDEF  and flag definition  */
/*                      include file.                                         */
/*                                                                            */
/*   FUNCTION: This module is the HID Class device driver                     */
/*             TYPEDEF and flag definition include file.                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark      yy/mm/dd  Programmer    Comment                                 */
/*  ------    --------  ----------    -------                                 */
/*            98/01/31  MB                                                    */
/* 02/17/2000 00/02/17  MB            Increased report buffer size to support */
/*                                    IBM Multi-Port USB Hub                  */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

//    max strategy command number
#define  MAX_USB_CMD             0x1f

// initialization time message IDs
#define  INIT_MESSAGE_LOADED     0
#define  INIT_MESSAGE_NO_USBD    1
#define  INIT_MESSAGE_INVNUMERIC 2
#define  INIT_MESSAGE_UNKNOWNKWD 3

// max no of messages in message queue
#define  MAX_INIT_MESSAGE_COUNT  2

#define  MAX_CLIENTS             8
#define  HID_MAX_REPORT_LENGTH   256   // 02/17/2000 MB
#define  HID_MAX_RPTBUFF_LENGTH  256   // 03/27/2000 MB
#define  HID_MAX_REQUESTS        32    // 03/27/2000 MB

#define  MAX_REP_ITEMS           64
#define  MAX_ITEM_USAGES         32
#define  MAX_ITEM_DESIGNATORS    16
#define  MAX_ITEM_STRINGS        16


// registered client driver data structure
typedef struct _driverList
{
   PUSBIDCEntry   clientIDCAddr;                // client's IDC routine address
   USHORT         clientDS;                     // client's data segment value
}  DriverList;

#define  MAX_DEVICES             16

// HID service data structure
typedef struct _deviceList
{
   DeviceInfo FAR             *pDeviceInfo;     // (00) far pointer to device data
   DeviceConfiguration FAR    *devConf;         // (04) far pointer to device configuration data
   SetupPacket                stdPacket;        // (08) setup packet buffer
   SetupPacket                cstPacket;        // (16) setup packet buffer to clear stalled
   USHORT                     versionFlags;     // (24) specific version flags (HID drafts)   
   USHORT                     reportItemIndex;  // (26) 1st report item index in report item table
   USHORT                     protocolSetIndex; // (28) 0xff when all protocols set to report protocol
   UCHAR                      configuration;    // (30) device status buffer
   UCHAR                      reportData[HID_MAX_REPORT_LENGTH];     // (31) HID report descriptor data
   UCHAR                      reportBuffer[HID_MAX_RPTBUFF_LENGTH];  // (31) report buffer   // 03/27/2000 MB
}  DeviceList;

// HID request data structure
typedef struct _hidRequestData
{
   UCHAR                      ctrlID;           // (00) controller ID
   UCHAR                      deviceAddress;    // (01) USB device address
   UCHAR                      endPointId;       // (02) in interrupt endpoint address
   UCHAR                      reportID;         // (03) report ID
   PUCHAR                     buffer1;          // (04) Virtual address of data buffer
   USHORT                     buffer1Length;    // (08) Buffer length in bytes
   PUSBIDCEntry               usbIDC;           // (10) Address of IRQ processing routine to be called for this request
   USHORT                     usbDS;            // (14) DS value for IRQ processing routine
   UCHAR                      category;         // (16) callers category (used in IRQ extension calls)
   ULONG                      requestData1;     // (17) data to be stored within request
   ULONG                      requestData2;     // (21) data to be stored within request
   ULONG                      requestData3;     // (25) data to be stored within request
   //                                           // (29)
}  HIDRequestData;

// I/O request flags used in HID processing
#define  HID_IRQ_STATUS_SETCONF        1
#define  HID_IRQ_STATUS_SETINTF        2
#define  HID_IRQ_STATUS_READINT        3
#define  HID_IRQ_STATUS_INTRCVED       4
#define  HID_IRQ_STATUS_SERVCLIENT     5
#define  HID_IRQ_STATUS_SETIDLE        6
#define  HID_IRQ_STATUS_SETPROTOCOL    7
#define  HID_IRQ_STATUS_REPRETRIEVED   8
#define  HID_IRQ_REPORT_RETRIEVED      9     // 03/27/2000 MB

