/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/HID/HIDPROTO.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  HIDPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Function prototypes provided by the HID Class         */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the HID Class device driver                     */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark      yy/mm/dd  Programmer    Comment                                 */
/*  --------- --------  ----------    -------                                 */
/*            98/01/31  MB                                                    */
/* 03/27/2000 00/03/27  MB            Added ReportDataRetrieved function      */
/*                                    definition                              */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/* HIDSTRAT.C */
void FAR HIDStrategy();
void CmdError( RPH FAR *pRP);
void HIDInitComplete( RPH FAR *pRP);
void HIDGetUSBDIDC(void);

/* HIDDATA.C */
USHORT (*gStratList[])( RPH FAR *pRP );

/* HIDIDC.C */
void FAR HIDidc( PRP_GENIOCTL pRP_GENIOCTL );
void HIDAcceptIO( PRP_GENIOCTL pRP_GENIOCTL );
void HIDDetachDevice( PRP_GENIOCTL pRP_GENIOCTL );
void HIDCheckForService( PRP_GENIOCTL pRP_GENIOCTL );
void HIDRegisterClient( PRP_GENIOCTL pRP_GENIOCTL );
void HIDClearStalled( RP_GENIOCTL FAR *pRP_GENIOCTL );

/* HIDINIT.C */
void HIDInit( RPH FAR *pRP );

/* HIDIRQ.C */
void HIDProcessIRQ( PRP_GENIOCTL pRP_GENIOCTL );
void ConfigurationSet( PRP_GENIOCTL pRP_GENIOCTL );
void GetHIDReport( PRP_GENIOCTL pRP_GENIOCTL, USHORT deviceIndex, UCHAR interfaceIndex );
void SetProtocol( PRP_GENIOCTL pRP_GENIOCTL );
void ProtocolSet( PRP_GENIOCTL pRP_GENIOCTL );
void AskClientsToServe( PRP_GENIOCTL pRP_GENIOCTL );
void ReportDataRetrieved( PRP_GENIOCTL pRP_GENIOCTL );   // 03/27/2000 MB

// HIDPREP.C
USHORT HIDProcessReport(USHORT startIndex, UCHAR interface, UCHAR *reportData, USHORT reportLength);
void FreeReportItems ( USHORT firstItemIndex );

