/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/HID/HIDEXTRN.H, usb, c.basedd 98/07/10" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  HIDEXTRN.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  External data declarations for the HID Class          */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the HID Class device driver external            */
/*             data declarations include file. See hiddata.c for the data     */
/*             items being externalized.                                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark         yy/mm/dd  Programmer Comment                                 */
/*  ---------    --------  ---------- -------                                 */
/*               98/01/31  MB                                                 */
/* 03/27/2000    00/03/27  MB         Added HID request data structure        */
/*                                    definition                              */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

extern USHORT         (*gStrat1[])();

extern PFN            Device_Help;

extern BYTE           gInitDataStart;

extern ULONG          RMFlags;
extern PFN            RM_Help0;
extern PFN            RM_Help3;

extern DRIVERSTRUCT   gDriverStruct;
extern ADAPTERSTRUCT  gAdapterStruct;

extern HDRIVER        ghDriver;
extern HADAPTER       ghAdapter;

extern CHAR           gOEMDriverName[];
extern CHAR           gUSBDriverName[];
extern IDCTABLE       gDDTable;

extern PUSBIDCEntry   gpUSBDIDC;
extern USHORT         gdsUSBIDC;


extern USHORT         gMaxClients;
extern USHORT         gMaxDevices;

extern USHORT         gNoOfRegisteredClients;
extern DriverList     gClientDrivers[MAX_CLIENTS];   // registered client driver table
extern USHORT         gNoOfActiveDevices;
extern DeviceList     gActiveDevices[MAX_DEVICES];   // active device list served by HID
extern HIDRequestData gHIDRequests[HID_MAX_REQUESTS];// input report request data array // 03/27/2000 MB

// report data storing
extern USHORT         gMaxRepItems;
extern USHORT         gMaxItemUsages;
extern USHORT         gMaxItemDesignators;
extern USHORT         gMaxItemStrings;

extern ReportItemData gReportItemData[MAX_REP_ITEMS];
extern ItemUsage      gItemUsage[MAX_ITEM_USAGES];
extern ItemDesignator gItemDesignator[MAX_ITEM_DESIGNATORS];
extern ItemString     gItemString[MAX_ITEM_STRINGS];

#ifdef   DEBUG
extern   USHORT       gHIDMsgLevel;       // debug message level
#endif

extern USHORT         gVerbose;
extern USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT];
extern PSZ            gVMessages[];
extern USHORT         gMessageCount;

