/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/ethr/ETHRXTRN.H, usb, c.basedd 00/08/31" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: ETHRXTRN.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME: USB ETHeRnet device driver eXTeRNal data declarations  */
/*                                                                            */
/*   FUNCTION: This module is the USB ETHeRnet DD external data declarations  */
/*             include file.                                                  */
/*                                                                            */
/*   NOTES: See ETHRDATA.C for the data items being externalized.             */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/08/31  LR                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#ifdef   DEBUG
extern   USHORT   gETHRmsg;  // debug message level
#endif

extern   struct   SysDev3  gHead;

extern   UCHAR    gMaxETHRs;
extern   UCHAR    gNETHRs;

extern   struct DeviceList    gETHR[];

extern   struct   CommonChars    gCCT;
extern   struct   MACSpecChars   gSCT;
extern   struct   MACSpecStatus  gSST;
extern   struct   MACUpperDisp   gUDT;
extern   struct   MCAddrList     gMCAL;
extern   struct   ETHRMCAddrList gEthrMCAL;

extern   struct   CommonChars    gProtCCT;
extern   struct   ProtLowerDisp  gProtLDT;

extern   struct   TCBufferQ      gTCQueue;
extern   struct   ETHRFrame      gTFrame;
extern   struct   ETHRFrame far *gpTFrame;
extern   struct   ETHRFrame      gRFrame[];
extern   struct   GenReqQ        gGenReqQ;

extern   PFN            Device_Help;

extern   IDCTABLE       gIDCTable;
extern   PUSBIDCEntry   gpUSBDIDC;
extern   USHORT         gdsUSBDIDC;

extern   BYTE           gInitDataStart;
extern   USHORT         gVerbose;
extern   USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT];
extern   PSZ            gVMessages[];
extern   USHORT         gMessageCount;
extern   USHORT         gETHRID[MAX_ETHR_ID][2];

extern   char  gDDName[];
extern   char  gDDFileName[];
extern   char  gDDDescr[];
extern   char  gVendorName[];
extern   char  gAdapterName[];
extern   char  gPMName[];

extern   DRIVERSTRUCT   gDriverStruct;
extern   ADAPTERSTRUCT  gAdapterStruct;
extern   ADJUNCT        gAdjunct;
extern   AHRESOURCE     gResourceList;

extern   HDRIVER        ghDriver;
extern   HADAPTER       ghAdapter;
extern   HFILE          ghPM;
extern   BYTE           gKeyword[MAX_ETHR_KEY][16];

////////////////////////////////////////////////////
// The KL5KUSB101 chip FirmWare from Kawasaki LSI //
////////////////////////////////////////////////////
extern   UCHAR    gKawaFWcode[0x0F19+7];
extern   UCHAR    gKawaFWfix[0x02CD+7];
extern   UCHAR    gKawaFWtrigger[1+7];

