/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/ethr/ETHRPROT.H, usb, c.basedd 00/08/31" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: ETHRPROT.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME: USB ETHeRnet device driver function PROTotypes         */
/*                                                                            */
/*   FUNCTION: This module is the USB ETHeRnet DD function prototype          */
/*             include file.                                                  */
/*                                                                            */
/*   NOTES:                                                                   */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/08/31  LR                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
/*
   ETHSTRAT.C - USB ETHeRnet device driver Strategy routine
*/
void far Strategy (void);
/*
   ETHRIDC.C - USB ETHeRnet device driver Inter-device Driver Communication
*/
void   FAR  IDComm (PRP_GENIOCTL pRP_GENIOCTL);
USHORT      SetConfiguration (USHORT ethrIndex, UCHAR configValue);
/*
   ETHRIRQ.C - USB ETHeRnet device driver Interrupt ReQuest Switch
*/
void IRQSwitch (PRP_GENIOCTL pRP);
/*
   ETHRPRIM.C - USB ETHeRnet Device Driver NDIS Primitives
*/   
WORD far pascal SystemRequest (DWORD param1, DWORD param2, WORD param3,
                                WORD opcode,  WORD targetDS);

WORD far pascal GeneralRequest (WORD protID,  WORD reqHandle,
                                WORD param1, DWORD param2,
                                WORD opcode,  WORD macDS);

WORD far pascal TransmitChain (WORD protID, WORD reqHandle, PTCBD pTCBufferD,
                               WORD macDS);

WORD far pascal TransferData (PUSHORT pBytesCopied, WORD frameOffset,
                              PTDBD pTDBufferD, WORD macDS);

WORD far pascal ReceiveRelease (WORD reqHandle, WORD macDS);

WORD far pascal IndicationOn  (WORD macDS);
WORD far pascal IndicationOff (WORD macDS);
WORD QueueGenReq (WORD protID, WORD reqHandle, WORD opcode, WORD param1, DWORD param2);
WORD ExecGenReq (WORD reqHandle);
/*
   ETHREQS.C - USB ETHeRnet device driver REQuestS
*/   
void KawaFWScan (PUCHAR pKawaFW);
void GetEthernetDescriptor (void);
void SetURBSize (USHORT size);
void SetSOFsToWait (USHORT number);
void SetMacAddress (PBYTE pMacAddr);
void SetEthernetMCFilters (void);
void SetEthernetPacketFilter (USHORT filter);
void TransmitFrame (void);
void ReceiveFrame (USHORT frameIndex);
void EnableNotifs (void);
void AdapterCheck (WORD reason);

