/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/ethr/ETHRDEFS.H, usb, c.basedd 00/08/31" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: ETHRDEFS.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME: USB ETHeRnet device driver DEFinitionS                 */
/*                                                                            */
/*   FUNCTION: This module is the USB ETHeRnet DD definition include file.    */
/*                                                                            */
/*   NOTES: Conforms to the Network Driver Interface Specification (NDIS)     */
/*          Version 2.0.1.                                                    */
/*          MAC stands for Media Access Control.                              */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/08/31  LR                                                      */
/*  LR1106  00/11/06  LR              Increased transmit queue depth and      */
/*                                    receive buffer count.                   */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#define  MAX_ETHRS               16 // MAXimum number of ETHeRnet adapterS
#define  MAX_ETHR_ID             16 // MAXimum number of ETHeRnet adapter IDs

#define  OUTPUT_DATA_LEN         64
#define  INPUT_DATA_LEN          64
/*
         Kawasaki KL5KUSB101 USB to Ethernet Controller
               Commands (USB Request Codes)
*/
#define  KAW_GET_ETHR_DESCR            0
#define  KAW_SET_ETHR_MC_FILTERS       1
#define  KAW_SET_ETHR_PACKET_FILTER    2
#define  KAW_GET_ETHR_STATISTICS       3
#define  KAW_GET_AUX_INPUTS            4
#define  KAW_SET_AUX_OUTPUTS           5
#define  KAW_SET_TEMP_MAC              6
#define  KAW_GET_TEMP_MAC              7
#define  KAW_SET_URB_SIZE              8
#define  KAW_SET_SOFS_TO_WAIT          9
#define  KAW_SET_EVEN_PACKETS         10
#define  KAW_SCAN                   0xFF

#define  KAW_URB_SIZE   4096  // USB Request Block Size
                              //  Never use a value smaller than 1600 bytes
#define  KAW_SOFS          1  // number of Start Of FrameS to wait
/*
         IRQ                    codes
*/
#define  IRQ_SET_CONFIG           0
#define  IRQ_KAW_FW_CODE          1
#define  IRQ_KAW_FW_FIX           2
#define  IRQ_KAW_FW_TRIGGER       3
#define  IRQ_GET_ETHR_DESCR       4
#define  IRQ_SET_URB_SIZE         5
#define  IRQ_SET_SOFS             6
#define  IRQ_GEN_REQ              7
#define  IRQ_OUTPUT_DATA          8
#define  IRQ_INPUT_DATA           9
#define  IRQ_NOTIFICATION        10
#define  IRQ_CLR_STALL           11
/*
     When transmitting each byte of
     the station address fields, the least significant (rightmost) bits are transmitted first.
*/
#define  STATION_ADDR_LEN        6  // bytes == 48 bits
#define  STATION_ADDR_MC         1  // MultiCast/individual = bit 0 of byte 0 is set to 1/0;
                                    //  a special kind of MultiCast is the BroadCast, in which
                                    //  all bits of the address field are set to 1.
#define  STATION_ADDR_LOCAL      2  // Locally/universally administered = bit 1 of byte 0 is set to 1/0
/*
   USB flags in gSST.flags
*/
#define  OUTPUT_DATA_TOGGLE      1
#define  INPUT_DATA_TOGGLE       2
#define  NOTIF_DATA_TOGGLE       4
#define  RESET_IN_PROGRESS       8
#define  GEN_REQ_IN_PROGRESS    16 

#define  MAX_BYTE    0xFF // MAXimum BYTE (unsigned char) value
/*
   Ethernet Networking Functional Descriptor
*/
struct EthernetDescriptor
{  // Vendor-specific (KLSI)           Class-specific (USB CDC v1.1)
   UCHAR    bFunctionLength;
   UCHAR    bReserved0;                   // bDescriptorType
   UCHAR    bReserved1;                   // bDescriptorSubtype
   UCHAR    bMACAddress[STATION_ADDR_LEN];// iMACAddress
   ULONG    bmEthernetStatistics;
   USHORT   wMaxSegmentSize;
   USHORT   wNumberMCFilters;
   UCHAR    bReserved2;                   // bNumberPowerFilters
};
/*
   USB ETHeRnet Adapter
*/
struct DeviceList
{
   UCHAR    bOutEndpoint;
   UCHAR    bInEndpoint;
   UCHAR    bIntEndpoint;
   USHORT   wMaxOutSize;
   USHORT   wMaxInSize;
   USHORT   wMaxIntSize;

   DeviceInfo FAR *pDeviceInfo;
};
#define  MAC_TYPE_NAME        "DIX+802.3"
#define  ETHR_MODULE_NAME     "USBETHR_NIF"
#define  ETHR_VENDORID_KEY    "VENDORID"
#define  ETHR_PRODUCTID_KEY   "PRODUCTID"
#define  ETHR_KEY_VENDORID    0
#define  ETHR_KEY_PRODUCTID   1
#define  MAX_ETHR_KEY         2
/*
                    Versions
*/
#define  MAJOR_NDIS_VERSION      2  // Network Driver Interface Specification v2.0.1
#define  MINOR_NDIS_VERSION      0
#define  MAJOR_USBETHR_VERSION   1  // USB ETHeRnet DD v1.1
#define  MINOR_USBETHR_VERSION   1
/*
            Flags, Status,... bits
*/
#define  CCTFLAG_BINDING_UPPER   1
/*
   gSCT.flags = Specific Characteristics Table flags (32 bits) indicate
   which optional functions are supported.
   When attempts are made to invoke unsupported functions,
   driver responds properly by returning INVALID_FUNCTION.
*/
#define  SCTFLAG_BROADCAST                 1 // BROADCAST supported
#define  SCTFLAG_MULTICAST                 2 // MULTICAST supported
#define  SCTFLAG_FUNC_GROUP_ADDR           4
#define  SCTFLAG_PROMISCUOUS_MODE          8
#define  SCTFLAG_SET_STN_ADDR           0x10 // software SETtable STatioN ADDRess
#define  SCTFLAG_STAT_ALWAYS_CURR       0x20 // Statistics are Always Current in gSST
#define  SCTFLAG_INIT_DIAGNOSTICS       0x40 // InitiateDiagnostics supported
#define  SCTFLAG_LOOPBACK               0x80 // Loopback is supported in the adapter hardware
#define  SCTFLAG_RECEIVE_CHAIN        0x0100 // driver does primarily ReceiveChain indications
#define  SCTFLAG_IBM_SOURCE_ROUT      0x0200
#define  SCTFLAG_RESET_MAC            0x0400 // Reset MAC supported
#define  SCTFLAG_OPEN_CLOSE           0x0800 // Open/Close adapter supported
#define  SCTFLAG_INTERRUPT_REQ        0x1000 // Interrupt Request supported
#define  SCTFLAG_SRC_ROUT_BRIDGE      0x2000
#define  SCTFLAG_GDT_VIRT_ADDR        0x4000 // GDT Virtual Addresses supported
#define  SCTFLAG_MULTIPLE_XFER_DATA   0x8000
#define  SCTFLAG_FRAME_SIZE_ZERO    0x010000
/*
   gSST.status = Specific Status Table status bits (32 bits)
*/
#define  SSTATUS_HW_MASK            7  // HardWare status Mask
#define  SSTATUS_HW_NOT_INSTALLED   0
#define  SSTATUS_HW_STARTUP_ERR     1  // HardWare failed Startup diagnostics
#define  SSTATUS_HW_CONFIG_ERR      2  // HardWare failed due to Configuration problem
#define  SSTATUS_HW_FAULT           3  // hardware not operational due to HardWare Fault
#define  SSTATUS_HW_SW_FAULTS       4  // HardWare operating marginally due to SoftWare Faults
#define  SSTATUS_HW_OK              7

#define  SSTATUS_BOUND              8
#define  SSTATUS_OPEN            0x10  // driver doesn't support open/close adapter,
                                       // set to 1 if hardware is functional
#define  SSTATUS_DIAGS_ON        0x20
/*
   NDIS v2.0.1 Packet Filter bitmap  (gSST.filter, SetPacketFilter NDIS General Request)
*/
#define  PACK_FILTER_DIRECT_MC      1  // and multicast or group and functional
#define  PACK_FILTER_BROADCAST      2
#define  PACK_FILTER_PROMISCS       4  // any packet on LAN (promiscuous)
#define  PACK_FILTER_ROUTING        8
#define  PACK_FILTER_RESERVED  0xFFF0
/*
   Ethernet Packet Filter bitmap (16 bits). SetEthernetPacketFilter
      USB CDC v1.1 and Kawasaki KL5KUSB101 USB to Ethernet Controller
      USB Request (wValue).
*/
#define  PACKET_TYPE_PROMISCUOUS    0x0001 // all frames received by the adapter are
                                           //  forwarded up to the host
#define  PACKET_TYPE_ALL_MULTICAST  0x0002 // All Multicast frames received by the adapter are
                                           //  forwarded up to the host, not just the ones enumerated
                                           //  in the adapter's multicast address list
#define  PACKET_TYPE_DIRECTED       0x0004 // Directed packets received containing
                                           //  a destination address equal to the MAC address are
                                           //  forwarded up to the host
#define  PACKET_TYPE_BROADCAST      0x0008 // all Broadcast packets received by the adapter are
                                           //  forwarded up to the host
#define  PACKET_TYPE_MULTICAST      0x0010 // Multicast packets enumerated in the adapter's
                                           //  multicast address list are forwarded up to the host
#define  PACKET_TYPE_RESERVED       0xFFE0
/*
   The upper and lower boundary protocol level and interface type
*/
#define  UPPER_PROTOCOL_MAC   1
#define  UPPER_INTERFACE_MAC  1
#define  LOWER_PROTOCOL_USB   0  // physical
#define  LOWER_INTERFACE_USB  0

#define  MAX_LINK_SPEED       10000000UL // 10 Mb/sec

#define  MAX_MC_ADDRS              32 // <= 128 for Kawasaki KL5KUSB101 USB to Ethernet Controller
#define  MAX_FRAME_SIZE          1514
/*
   Pointer type definitions
*/
typedef struct CommonChars far   *PCCT;   // Pointer to Common Characteristics Table
typedef struct MACSpecChars far  *PSCT;   // Pointer to MAC service-Specific Characteristics Table
typedef struct MCAddrList far    *PMCAL;  // Pointer to MultiCast Address List
typedef struct MACSpecStatus far *PSST;   // Pointer to MAC service-Specific Status Table
typedef struct MACUpperDisp far  *PUDT;   // Pointer to MAC Upper Dispatch Table
typedef struct ProtLowerDisp far *PLDT;   // Pointer to protocol Lower Dispatch Table

typedef struct TCBufferD far     *PTCBD;  // Pointer to TransmitChain Buffer Descriptor
typedef struct TDBufferD far     *PTDBD;  // Pointer to TransferData  Buffer Descriptor
typedef struct RCBufferD far     *PRCBD;  // Pointer to ReceiveChain  Buffer Descriptor
/*
       Common Characteristics table
*/
struct CommonChars
{
   WORD     size;             // size of common characteristics table (bytes)
   BYTE     majorNDISv;       // major NDIS version (2 BCD digits)
   BYTE     minorNDISv;       // minor NDIS version (2 BCD digits)
   WORD     reserved;         // reserved
   BYTE     majorV;           // major module Version (2 BCD digits)
   BYTE     minorV;           // minor module Version (2 BCD digits)
   DWORD	flags;            // module function flags (bitmask)
   BYTE  	name[16];         // module name (ASCIIZ)
   BYTE     protocolUpp;      // protocol level    at Upper boundary of module
   BYTE     interfaceUpp;     // type of interface at Upper boundary of module
   BYTE     protocolLow;      // protocol level    at Lower boundary of module
   BYTE     interfaceLow;     // type of interface at Lower boundary of module
   WORD     moduleID;         // module ID
   WORD     moduleDS;         // module DS
   PFN      pSysReq;          // System Request dispatch entry point
                              // Links to other NDIS characteristics tables
   PSCT     pSpecChars;       //  pointer to service-Specific Characteristics (NULL if none)
   PSST     pSpecStatus;      //  pointer to service-Specific Status (NULL if none)
   PUDT     pUppDisp;         //  pointer to Upper Dispatch table (NULL if none)
   PLDT     pLowDisp;         //  pointer to Lower Dispatch table (NULL if none)
   DWORD    pReserved1;       // Reserved (must be NULL)
   DWORD    pReserved2;       // Reserved (must be NULL)
};
/*
       MAC service-Specific Characteristics table
*/
struct MACSpecChars
{
   WORD     length;           // length of MAC service-specific characteristics table
   BYTE     typeName[16];     // type Name of MAC (ASCIIZ)
   WORD     lenStnAddrs;      // length of Station Addresses in bytes
   BYTE     permStnAddr[16];  // permanent Station Address must be obtained from the hardware.
                              // If there is no hardware based addressing scheme
                              // will it be possible to override the permanent station address.
   BYTE     currStnAddr[16];  // current Station Address will always reflect the current address
                              // as set by calling SetStationAddress
   DWORD	currFncAddr;      // current Functional Address of adapter (0 if none)
   PMCAL    pMCAddrList;      // pointer to MultiCast Address List
   DWORD	linkSpeed;        // link Speed (bits/sec)
   DWORD	flags;            // service flags (bitmask)
   WORD     maxFrameSz;       // maximum Frame Size which may be both sent and received
                              // The ETHeRnet adapter RAM is characterized by four parameters:
   DWORD	trBuffCap;        //  total transmission Buffer Capacity in the driver (bytes)
   WORD     trBlockSz;        //  transmission buffer allocation Block Size (bytes)
   DWORD	recBuffCap;       //  total reception Buffer Capacity in the driver (bytes)
   WORD     recBlockSz;       //  reception buffer allocation Block Size (bytes)
   BYTE     vendorCode[3];    // IEEE vendor Code
   BYTE     vendAdCode;       // vendor Adapter Code
   PSZ      pVendAdDescr;     // pointer to Vendor Adapter Description (!=0 for NDDK TestTool)
   WORD     irq;              // IRQ interrupt level used by adapter
   WORD     trQDepth;         // transmit Queue Depth
   WORD  	maxDataBlocks;    // maximum number of Data Blocks in buffer descriptors supported
                              // Vendor specific
   PBYTE    pCCB;             //  pointer to CCB (for NDDK TestTool, see NDIS.H)
                              //  USB ETHeRnet DD specific
   BYTE     ethrIndex;        //   USB ETHeRnet adapter Index

   SetupPacket setupPacket;
};
/*
       MultiCast Address List
*/
struct MCAddrList                      // NDIS
{
   WORD     maxMCAddrs;                // maximum number of MultiCast Addresses
   WORD     currMCAddrs;               // current number of MultiCast Addresses
   BYTE     mcAddr[MAX_MC_ADDRS][16];  // multicast Address
};
struct ETHRMCAddrList                  // USB ETHeRnet Adapter
{              
   WORD     maxMCAddrs;
   WORD     currMCAddrs;
   BYTE     mcAddr[MAX_MC_ADDRS][STATION_ADDR_LEN];
};
/*
       MAC service-Specific Status table
*/
struct MACSpecStatus
{
   WORD     length;           // length of status table
   DWORD	diagDT;           // Date/Time when diagnostics last run (0xFFFFFFFF if not run)
   DWORD	status;           // MAC status (bitmask)
   WORD     filter;  		  // current packet filter (bitmask)
                              // Statistics for MAC's
   DWORD    pSpecStats;       //  pointer to media-Specific Statistics table (may be NULL)
   DWORD	clearDT;          //  Date/Time when last ClearStatistics issued (0xFFFFFFFF if not kept)
   DWORD	recFrames;        //  total Frames received OK (mandatory)
   DWORD	recFrCRC;         //  total Frames with CRC error (mandatory)
   DWORD	recBytes;         //  total Bytes received
   DWORD	recFrNoBuff;      //  total Frames discarded - no buffer space
   DWORD	recMCFrames;      //  total MultiCast Frames received OK
   DWORD	recBCFrames;      //  total BroadCast Frames received OK
   DWORD	reserved1;        //  reserved (obsolete statistic)
   DWORD	reserved2;
   DWORD	reserved3;
   DWORD	reserved4;
   DWORD	reserved5;
   DWORD	recFrHW;          //  total Frames discarded - HardWare error
   DWORD	trFrames;         //  total Frames transmitted OK (mandatory)
   DWORD    trBytes;          //  total Bytes transmitted OK
   DWORD	trMCFrames;       //  total MultiCast Frames transmitted
   DWORD	trBCFrames;       //  total BroadCast Frames transmitted
   DWORD	reserved6;        //  reserved (obsolete statistic)
   DWORD	reserved7;
   DWORD	trFrTO;           //  total Frames not transmitted - Time-Out
   DWORD	trFrHW;           //  total Frames not transmitted - HardWare error
   WORD     flags;            // USB ETHeRnet DD specific
   BYTE     indiCount;        //  indication Count
   BYTE     temp[INPUT_DATA_LEN];
};
/*
       MAC Upper Dispatch table
*/
struct MACUpperDisp
{
   PCCT     pCommChars;       // back pointer to Common Characteristics table
                              // MAC entry points
   PFN      pGenReq;          //  General Request address
   PFN      pTransmitChain;   //  TransmitChain address
   PFN      pTransferData;    //  TransferData address
   PFN      pReceiveRelease;  //  ReceiveRelease address
   PFN      pIndicationOn;    //  IndicationOn address
   PFN      pIndicationOff;   //  IndicationOff address
};
/*
       Protocol Lower Dispatch table
*/
struct ProtLowerDisp
{
   PCCT     pCommChars;       // back pointer to protocol Common Characteristics table
   DWORD    interfaceFlags;   // interface Flags (used by Vector frame dispatch)
   /*
                     Protocol Entry Points
   */ 
   WORD (PASCAL FAR *pGenReqConfirm) // confirm completion of a previous GeneralRequest
   (WORD protID,    // module ID of protocol
    WORD macID,     // module ID of MAC
    WORD reqHandle, // unique Handle of original general request
    WORD status,    // final status  of original general request
    WORD opcode,    // original general request opcode
    WORD protDS);   // DS of called protocol module

   WORD (PASCAL FAR *pTransmitConfirm) // implies the completion of transmitting a frame
   (WORD protID,      // module ID of protocol
    WORD macID,       // module ID of MAC
    WORD reqHandle,   // unique request Handle from TransmitChain
    WORD status,      // status of original TransmitChain
    WORD protDS);     // DS of called protocol module

   WORD (PASCAL FAR *pReceiveLookahead) // indicates arrival of a received frame and offer lookahead data
   (WORD  macID,      // module ID of MAC
    WORD  frameSize,  // total Size of frame (0 if not known)
    WORD  bytesAvail, // bytes of lookahead Available in buffer
    PBYTE pBuffer,    // pointer to lookahead data Buffer
    PBYTE pIndicate,  // pointer to Indicate flag
    WORD  protDS);    // DS of called protocol module

   WORD (PASCAL FAR *pIndicationComplete) // allows protocol to do post-processing on indications
   (WORD macID,       // module ID of MAC
    WORD protDS);     // DS of called protocol module

   WORD (PASCAL FAR *pReceiveChain) // indicates reception of a frame in MAC-managed buffers
   (WORD  macID,      // module ID of MAC
    WORD  frameSize,  // total Size of frame (bytes)
    WORD  reqHandle,  // unique Handle for this request
    PRCBD pRCBufferD, // pointer to Receive Buffer Descriptor
    PBYTE pIndicate,  // pointer to Indicate flag
    WORD  protDS);    // DS of called protocol module

   WORD (PASCAL FAR *pStatusIndication) // informs the protocol of changes in MAC status
   (WORD  macID,      // module ID of MAC
    WORD  param1,     // opcode dependent parameter or 0
    PBYTE pIndicate,  // pointer to Indicate flag
    WORD  opcode,     // opcode of StatusIndication
    WORD  protDS);    // DS of called protocol module
};
/*
       Protocol Manager Request Block
*/
struct PMReqBlock
{
   USHORT   opcode;
   USHORT   status;
   PCH      pointer1;
   PCH      pointer2;
   USHORT   word1;
};
/*
      PM IOCTL request packet parameters
*/
#define  IOCTL_CAT_LAN_MANAGER   0x81  // LAN Manager Category code
#define  IOCTL_FUN_PM            0x58  // Protocol Manager Function code
/*
         Protocol Manager request Opcodes
*/
#define  PM_OP_GET_PM_INFO          1
#define  PM_OP_REGISTER_MODULE      2
/* 
   The Configuration Memory Image parsed from the PROTOCOL.INI file.
*/
struct Param
{
   WORD  pType;   // 0 = numeric, 1 = string of characters
   WORD  pLen;    // 4 for numeric or length of the string including the terminating 0
   union pV
   {
      LONG  num;
      BYTE  str[1];
   };
};
struct Keyword
{
   struct Keyword far *pNext;     // forward pointer
   struct Keyword far *pPrev;     // back    pointer
   BYTE                name[16];  // alphabetic chars will be uppercase
   WORD                nP;        // number of Parameters
   struct Param        param[1];
};
struct Module
{
   struct Module far *pNext;     // forward pointer
   struct Module far *pPrev;     // back    pointer
   BYTE               name[16];	 // module name given in brackets in the PROTOCOL.INI file
   struct Keyword     keyword[1];
};
/*
    NDIS System Request          opcodes
*/
#define  SYSTEM_REQUEST_BIND        2
/*
         NDIS General Request opcodes
*/
#define  INITIATE_DIAGNOSTICS       1
#define  READ_ERROR_LOG			    2
#define  SET_STATION_ADDRESS	    3
#define  OPEN_ADAPTER			    4
#define  CLOSE_ADAPTER			    5
#define  RESET_MAC				    6
#define  SET_PACKET_FILTER		    7
#define  ADD_MULTICAST_ADDRESS	    8
#define  DELETE_MULTICAST_ADDRESS 	9
#define  UPDATE_STATISTICS		   10
#define  CLEAR_STATISTICS		   11
#define  INTERRUPT_REQUEST		   12
#define  SET_FUNCTIONAL_ADDRESS	   13
#define  SET_LOOK_AHEAD			   14
/*
   NDIS StatusIndication opcodes
*/
#define  RING_STATUS                1
#define  ADAPTER_CHECK    		    2
#define  START_RESET	    		3
#define  INTERRUPT    		 	    4
#define  END_RESET	    		    5
/*
   Return Codes that are defined by the NDIS v2.0.1
*/
#define SUCCESS				 	   0
#define WAIT_FOR_RELEASE		   1 // The ReceiveChain completed successfully but
                                     // the protocol has retained control of the data buffer.
                                     // ReceiveRelease will be called to release the data buffers.
#define REQUEST_QUEUED			   2 // The TransmitChain or GeneralRequest has been queued.
                                     // If the request handle is non-zero the driver will call
                                     // TransmitConfirm or RequestConfirm when the request completes.
#define FRAME_NOT_RECOGNIZED	   3 // Returned from the protocol when the driver does the ReceiveChain
                                     // or ReceiveLookahead indication and
                                     // the frame does not make sense to the protocol.
#define FRAME_REJECTED			   4 // A received frame was recognized but it was discarded.
                                     // The buffer may be immediately re-used.
#define FORWARD_FRAME			   5 // A protocol wishes the received frame to be offered to other
                                     // protocols but wishes to receive an IndicationComplete.
#define OUT_OF_RESOURCE		 	   6 // The module is in a transient out of resource condition.
                                     // The current request was not completed.
#define INVALID_PARAMETER		   7
#define INVALID_FUNCTION		   8
#define NOT_SUPPORTED			   9
#define HARDWARE_ERROR			0x0A // this can be considered non-fatal
#define TRANSMIT_ERROR			0x0B // This is a non-fatal error and can be taken as a hint that
                                     // the packet should be retransmitted.
#define NO_SUCH_DESTINATION		0x0C // token ring specific
#define BUFFER_TOO_SMALL        0x0D
#define ALREADY_STARTED		 	0x20 // This error occurs when BindAndStart is called more than once.
#define INCOMPLETE_BINDING		0x21
#define DRIVER_NOT_INITIALIZED 	0x22
#define HARDWARE_NOT_FOUND		0x23 // This bind-time error occurs when
                                     // the ethernet adapter is not found by the driver.
#define HARDWARE_FAILURE		0x24 // This error can be considered fatal.
#define CONFIGURATION_FAILURE	0x25 // bind-time error
#define INTERRUPT_CONFLICT		0x26 // bind-time error
#define INCOMPATIBLE_MAC		0x27 // bind-time error
#define INITIALIZATION_FAILED	0x28
#define NETWORK_NOT_CONNECTED	0x2A // bind-time error
#define INCOMPATIBLE_OS_VERSION	0x2B
#define GENERAL_FAILURE		 	0xFF
/*
   USB ETHeRnet Adapter Check reason codes (for 802.3 MAC's)
*/
#define ADAPTER_INOPERATIVE	        0x8000   // adapter did not respond to command or could not be found
#define ADAPTER_COMMAND_TO	        0x4000   // ... Timed Out
#define ADAPTER_SQE_FAILURE         0x2000   // SQE Test Failure
#define ADAPTER_EXCESSIVE_COOLLS    0x1000   // transmission failed due to excessive collisions
#define ADAPTER_LOST_CARRIER        0x0800   // ... during transmission
#define ADAPTER_TDR_FAILURE         0x0400   // TDR test detected a short or open on the link
#define ADAPTER_TR_UNDERRUN   	    0x0020   // underrun occurred on transmission
#define ADAPTER_REC_OVERRUN		    0x0010   // overrun  occurred on reception

#define  MAX_DATA_BLOCK_COUNT    8
#define  MAX_IMMED_LEN          64
#define  TC_BUFFER_Q_DEPTH      32  //LR1106 8  // TransmitChain Buffer Queue Depth
#define  MAX_RC_BUFFER          16  //LR1106 4  // Max ReceiveChain Buffer count
#define  GEN_REQ_Q_DEPTH         4  // General Request Queue Depth

struct TDataBlock  // TransmitChain/TransferData Data Block
{
   BYTE  ptrType;  // pointer Type (0=Physical, 2=GDT)
   BYTE  resByte;  // reserved Byte, must be zero
   WORD  dataLen;  // data Length in bytes
   PBYTE pData;    // pointer to Data
};
struct TCBufferD   // TransmitChain Buffer Descriptor
{
   WORD  immedLen; // Length of immediate data, max is 64
   PBYTE pImmed;   // virtual address of Immediate data
   WORD  dbCount;  // Count of remaining data blocks, maximum is specified in the gSCT table

   struct TDataBlock db[MAX_DATA_BLOCK_COUNT];
};
struct TDBufferD   // TransferData Buffer Descriptor
{
   WORD  dbCount;  // Count of transfer data blocks, maximum is specified in the gSCT table

   struct TDataBlock db[];
};
struct RCDataBlock // ReceiveChain Data Block
{
   WORD  dataLen;  // data Length in bytes
   PBYTE pData;    // pointer to Data
};
struct RCBufferD   // ReceiveChain Buffer Descriptor
{
   WORD  dbCount;  // Count of receive data blocks, maximum is specified in the gSCT table

   struct RCDataBlock db[1];
};
struct TCBuffer      // TransmitChain Buffer
{
   WORD  protID;     // module ID of protocol
   WORD  reqHandle;  // TransmitChain request Handle

   struct TCBufferD	descr;       // TransmitChain Buffer descriptor

   BYTE  immed[MAX_IMMED_LEN];   // buffer for immediate data
};
struct TCBufferQ     // TransmitChain Buffer Queue
{
   WORD  count;      // number of busy buffers
   WORD  iIn;
   WORD  iOut;

   struct TCBuffer buffer[TC_BUFFER_Q_DEPTH];   
};
struct Frame8023     // IEEE 802.3 Frame
{
   BYTE  destination[STATION_ADDR_LEN];   // specifies the station to which the frame is being transmitted
   BYTE  source[STATION_ADDR_LEN];        // contains the unique address of the station transmitting the frame
   WORD  length;

   BYTE  data[MAX_FRAME_SIZE-2*STATION_ADDR_LEN-sizeof(WORD)];
};
struct ETHRFrame     // ETHeRnet Frame
{
   WORD              count;
   struct Frame8023  frame;
   BYTE              pad[OUTPUT_DATA_LEN-(MAX_FRAME_SIZE+sizeof(WORD))%OUTPUT_DATA_LEN];
   WORD              selector;   // GDT selector
};
struct GenReqEl      // General Request Element
{
   WORD  protID;
   WORD  reqHandle;
   WORD  opcode;
   WORD  param1;
   BYTE  addr[STATION_ADDR_LEN];
};
struct GenReqQ       // General Request Queue
{
   WORD  count;
   WORD  iIn;
   WORD  iOut;

   struct GenReqEl gr[GEN_REQ_Q_DEPTH];
};
/*
   Initialization time message IDs
*/
#define  INIT_MESSAGE_LOADED     0
#define  INIT_MESSAGE_NO_USBD    1
#define  INIT_MESSAGE_NO_PM      2
#define  INIT_MESSAGE_UNKNOWNKWD 3
#define  INIT_MESSAGE_INVNUMERIC 4

#define  MAX_INIT_MESSAGE_COUNT  2
#define  MSG_REPLACEMENT_STRING  1178

