/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/usb/ethr/ETHRDATA.C, usb, c.basedd 00/08/31" */
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: ETHRDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME: USB ETHeRnet device driver Data segment                */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             USB ETHeRnet Device Driver.                                    */
/*                                                                            */
/*   NOTES: See ETHRXTRN.H for the eXTeRNal data declarations.                */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          00/08/31  LR                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "ethr.h"

UCHAR    adapter[] = "USB ETHeRnet Adapter";

UCHAR    gMaxETHRs;  // Maximum number of ETHeRnet adapters
UCHAR    gNETHRs;    //         Number of ETHeRnet adapters

struct DeviceList gETHR[MAX_ETHRS]; // USB ETHeRnet Adapters

struct CommonChars gCCT = // Common Characteristics Table
{                         // ============================
   sizeof(struct CommonChars),
   MAJOR_NDIS_VERSION, MINOR_NDIS_VERSION,
   0, // reserved
   MAJOR_USBETHR_VERSION, MINOR_USBETHR_VERSION,
   CCTFLAG_BINDING_UPPER,
   ETHR_MODULE_NAME,
   UPPER_PROTOCOL_MAC, UPPER_INTERFACE_MAC,
   LOWER_PROTOCOL_USB, LOWER_INTERFACE_USB,
   0, // module ID
   0, // module DS
   SystemRequest,
   &gSCT, &gSST, &gUDT,
   0,   // the gCCT actually does not supply a lower dispatch table (the pointer to it is NULL)
   0, 0 // reserved 
};
struct MACSpecChars gSCT = // Specific Characteristics Table
{                          // ==============================
   sizeof(struct MACSpecChars)-sizeof(BYTE)-sizeof(SetupPacket),
   MAC_TYPE_NAME,
   STATION_ADDR_LEN,
   {-1, -1, -1, -1, -1, -1},   // permanent station address
   {-1, -1, -1, -1, -1, -1},   // current
   0,                          // current functional address = none
   &gMCAL,
   MAX_LINK_SPEED,

   SCTFLAG_BROADCAST |        // gSCT.flags
   SCTFLAG_MULTICAST |
   SCTFLAG_SET_STN_ADDR |
   SCTFLAG_STAT_ALWAYS_CURR |
   SCTFLAG_RECEIVE_CHAIN,

   MAX_FRAME_SIZE,
   sizeof(struct ETHRFrame),
   sizeof(struct ETHRFrame),
   sizeof(struct ETHRFrame)*MAX_RC_BUFFER,
   sizeof(struct ETHRFrame),
   {-1,-1,-1},                // without an IEEE vendor code)
   0,                         // undefined vendor adapter code
   (PSZ)adapter,              // pointer to Vendor Adapter Description
   0,
   TC_BUFFER_Q_DEPTH,
   MAX_DATA_BLOCK_COUNT,
   0,
   MAX_ETHRS
};
struct MCAddrList gMCAL = // NDIS MultiCast Address List
{                         // --------------------------- 
   MAX_MC_ADDRS, 0
};
struct ETHRMCAddrList gEthrMCAL = // USB ETHeRnet MultiCast Address List
{                                 // ----------------------------------- 
   MAX_MC_ADDRS, 0
};
struct MACSpecStatus gSST = // Specific Status Table
{                           // =====================
   sizeof(struct MACSpecStatus)-sizeof(WORD)-sizeof(BYTE)-sizeof(BYTE)*INPUT_DATA_LEN,
   -1,   // diagnostics not run
   0,    // status
   0,    // current packet filter
   0,    // no media-specific statistics table
   -1,   // date/time when last ClearStatistics not kept
   0,    // total Frames received OK (mandatory)
   0,    // total Frames with CRC error (mandatory)
   -1,
   0,    // total Frames discarded - no buffer space
   0,    // total MultiCast Frames received OK
   0,    // total BroadCast Frames transmitted
   -1,-1,-1,-1,-1,-1,
   0,    // total Frames transmitted OK (mandatory)
   -1,
   0,    // total MultiCast Frames transmitted
   0,    // total BroadCast Frames transmitted
   -1,-1,-1,
   0,    // total Frames not transmitted - HardWare error
   OUTPUT_DATA_TOGGLE |
   INPUT_DATA_TOGGLE  |
   NOTIF_DATA_TOGGLE,    // USB flags
   0     // indications enabled
};
struct MACUpperDisp gUDT = // Upper Dispatch Table
{                          // ====================
   &gCCT,                  // no dispatch address is allowed to be NULL
   GeneralRequest,
   TransmitChain,
   TransferData,
   ReceiveRelease,
   IndicationOn,
   IndicationOff
};
struct CommonChars   gProtCCT;   // Protocol Common Characteristics Table
struct ProtLowerDisp gProtLDT;   // Protocol Lower Dispatch Table
                                 //  no dispatch address is allowed to be NULL
struct TCBufferQ     gTCQueue;   // TransmitChain Buffer Queue
struct ETHRFrame     gTFrame;    // Transmit Frame
struct ETHRFrame far *gpTFrame = &gTFrame;
struct ETHRFrame     gRFrame[MAX_RC_BUFFER];    // Received Frames
struct GenReqQ       gGenReqQ;   // General Request Queue

PUSBIDCEntry   gpUSBDIDC  = NULL;
USHORT         gdsUSBDIDC = 0;

USHORT   gETHRID[MAX_ETHR_ID][2]; // USB vendor ID, manufacturer product ID

PFN      Device_Help = NULL;  // pointer to DevHelp routines
HDRIVER  ghDriver  = 0;       // handle to Driver (RM Data)

////////////////////////////////////////////////////
// The KL5KUSB101 chip FirmWare from Kawasaki LSI //
////////////////////////////////////////////////////
// v3.32
UCHAR gKawaFWcode[] =
{
    0xB6, 0xC3,   // signature
    0x19, 0x0F,   // length = sizeof(gKawaFWcode) - 7;
    0x02,         // type = replace interrupt vector with this data
    0x64,         // interrupt                                     
    0x9f, 0xcf, 0x9e, 0x08, 0xe7, 0x57, 0x00, 0x00,
    0x7a, 0x08, 0x97, 0xc1, 0xe7, 0x67, 0xff, 0x1f,
    0x28, 0xc0, 0xe7, 0x87, 0x00, 0x04, 0x24, 0xc0,
    0xe7, 0x67, 0xff, 0xf9, 0x22, 0xc0, 0x97, 0xcf,
    0xd7, 0x09, 0x00, 0xc0, 0xe7, 0x09, 0xa2, 0xc0,
    0x74, 0x08, 0x9f, 0xaf, 0x36, 0x00, 0xe7, 0x05,
    0x00, 0xc0, 0xa7, 0xcf, 0x72, 0x08, 0x97, 0xcf,
    0xe7, 0x57, 0x00, 0x00, 0x6e, 0x08, 0xa7, 0xa1,
    0x6e, 0x08, 0x97, 0xcf, 0xe7, 0x57, 0x00, 0x00,
    0xe4, 0x09, 0x0a, 0xc0, 0xe7, 0x57, 0x00, 0x00,
    0xa4, 0xc0, 0xa7, 0xc0, 0x2a, 0x08, 0x9f, 0xaf,
    0x60, 0x09, 0xe7, 0x07, 0x00, 0x00, 0xe4, 0x09,
    0xe7, 0x57, 0xff, 0xff, 0x70, 0x08, 0x9f, 0xa0,
    0x38, 0x00, 0xe7, 0x59, 0x70, 0x08, 0x74, 0x08,
    0x9f, 0xa0, 0x38, 0x00, 0xc8, 0x09, 0x80, 0x08,
    0x08, 0x62, 0x9f, 0xa1, 0x06, 0x0a, 0xc0, 0x09,
    0x26, 0x08, 0x00, 0x60, 0xa7, 0xc0, 0x2a, 0x08,
    0x9f, 0xaf, 0x26, 0x04, 0xe7, 0x57, 0x00, 0x00,
    0x6e, 0x08, 0xa7, 0xc1, 0x2a, 0x08, 0x9f, 0xaf,
    0x04, 0x00, 0xe7, 0x57, 0x00, 0x00, 0x3e, 0x08,
    0x0a, 0xc1, 0xe7, 0x09, 0x20, 0xc0, 0xde, 0x09,
    0xe7, 0xd0, 0xde, 0x09, 0xe7, 0x67, 0x40, 0x00,
    0xde, 0x09, 0x9f, 0xaf, 0xe6, 0x0e, 0xc0, 0x09,
    0x86, 0x08, 0x00, 0x60, 0x05, 0xc4, 0xc0, 0x59,
    0x74, 0x08, 0x02, 0xc0, 0x9f, 0xaf, 0xf6, 0x00,
    0x9f, 0xaf, 0x8e, 0x03, 0xef, 0x57, 0x00, 0x00,
    0xe2, 0x09, 0x9f, 0xa1, 0xce, 0x01, 0xe7, 0x57,
    0x00, 0x00, 0x56, 0x08, 0x9f, 0xa0, 0xd4, 0x03,
    0xa7, 0xcf, 0x2a, 0x08, 0x48, 0x02, 0xe7, 0x09,
    0x74, 0x08, 0x86, 0x08, 0xc8, 0x37, 0x04, 0x00,
    0x9f, 0xaf, 0x62, 0x04, 0x97, 0xcf, 0xe7, 0x57,
    0x00, 0x00, 0x84, 0x08, 0x97, 0xc0, 0xd7, 0x09,
    0x00, 0xc0, 0xc1, 0xdf, 0xc8, 0x09, 0x7c, 0x08,
    0x08, 0x62, 0x14, 0xc0, 0x27, 0x04, 0x7c, 0x08,
    0x10, 0x94, 0xf0, 0x07, 0xde, 0x09, 0x02, 0x00,
    0xc1, 0x07, 0x01, 0x00, 0x70, 0x00, 0x04, 0x00,
    0xf0, 0x07, 0x3a, 0x01, 0x06, 0x00, 0x50, 0xaf,
    0xe7, 0x07, 0xff, 0xff, 0x86, 0x08, 0xe7, 0x07,
    0x00, 0x00, 0x84, 0x08, 0xe7, 0x05, 0x00, 0xc0,
    0x97, 0xcf, 0xd7, 0x09, 0x00, 0xc0, 0xc1, 0xdf,
    0x48, 0x02, 0xd0, 0x09, 0x7c, 0x08, 0x27, 0x02,
    0x7c, 0x08, 0xe7, 0x05, 0x00, 0xc0, 0x97, 0xcf,
    0x48, 0x02, 0xc8, 0x37, 0x04, 0x00, 0x00, 0x0c,
    0x0c, 0x00, 0x00, 0x60, 0x21, 0xc0, 0xc0, 0x37,
    0x3e, 0x00, 0x23, 0xc9, 0xc0, 0x57, 0xb4, 0x05,
    0x1b, 0xc8, 0xc0, 0x17, 0x3f, 0x00, 0xc0, 0x67,
    0xc0, 0xff, 0x30, 0x00, 0x08, 0x00, 0xf0, 0x07,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0xc0, 0x17,
    0x4c, 0x00, 0x30, 0x00, 0x06, 0x00, 0xf0, 0x07,
    0xaa, 0x01, 0x0a, 0x00, 0x48, 0x02, 0xc1, 0x07,
    0x02, 0x00, 0xd7, 0x09, 0x00, 0xc0, 0xc1, 0xdf,
    0x51, 0xaf, 0xe7, 0x05, 0x00, 0xc0, 0x97, 0xcf,
    0x9f, 0xaf, 0x62, 0x04, 0x9f, 0xaf, 0xd4, 0x03,
    0x97, 0xcf, 0x9f, 0xaf, 0xd4, 0x03, 0xc9, 0x37,
    0x04, 0x00, 0xc1, 0xdf, 0xc8, 0x09, 0x50, 0x08,
    0x50, 0x02, 0x67, 0x02, 0x50, 0x08, 0xd1, 0x07,
    0x00, 0x00, 0x27, 0xd8, 0x5a, 0x08, 0xc0, 0xdf,
    0x9f, 0xaf, 0xce, 0x01, 0x97, 0xcf, 0xe7, 0x57,
    0x00, 0x00, 0x88, 0x08, 0x97, 0xc1, 0xe7, 0x57,
    0x01, 0x00, 0x58, 0x08, 0x97, 0xc0, 0xc8, 0x09,
    0x4e, 0x08, 0x08, 0x62, 0x97, 0xc0, 0x00, 0x02,
    0xc0, 0x17, 0x0e, 0x00, 0x27, 0x00, 0x34, 0x01,
    0x27, 0x0c, 0x0c, 0x00, 0x36, 0x01, 0xef, 0x57,
    0x00, 0x00, 0xe2, 0x09, 0x9f, 0xc0, 0xae, 0x02,
    0xe7, 0x57, 0x00, 0x00, 0x8c, 0x08, 0x97, 0xc1,
    0xe7, 0x09, 0x96, 0x08, 0x12, 0xc0, 0xe7, 0x77,
    0x00, 0x08, 0x20, 0xc0, 0x9f, 0xc1, 0xa6, 0x02,
    0xe7, 0x59, 0x96, 0x08, 0x12, 0xc0, 0x77, 0xc9,
    0xd7, 0x09, 0x00, 0xc0, 0xc1, 0xdf, 0xe7, 0x77,
    0x00, 0x08, 0x20, 0xc0, 0x2f, 0xc1, 0xe7, 0x07,
    0x00, 0x00, 0x42, 0xc0, 0xe7, 0x07, 0x05, 0x00,
    0x90, 0xc0, 0xc8, 0x07, 0x0a, 0x00, 0xe7, 0x77,
    0x04, 0x00, 0x20, 0xc0, 0x09, 0xc1, 0x08, 0xda,
    0x7a, 0xc1, 0xe7, 0x07, 0x00, 0x01, 0x42, 0xc0,
    0xe7, 0x07, 0x04, 0x00, 0x90, 0xc0, 0x1a, 0xcf,
    0xe7, 0x07, 0x01, 0x00, 0x58, 0x08, 0x00, 0xd8,
    0x27, 0x50, 0x34, 0x01, 0x17, 0xc1, 0xe7, 0x77,
    0x02, 0x00, 0x20, 0xc0, 0x79, 0xc1, 0x27, 0x50,
    0x34, 0x01, 0x10, 0xc1, 0xe7, 0x77, 0x02, 0x00,
    0x20, 0xc0, 0x79, 0xc0, 0x9f, 0xaf, 0xc8, 0x02,
    0xe7, 0x05, 0x00, 0xc0, 0x00, 0x60, 0x9f, 0xc0,
    0xce, 0x01, 0x97, 0xcf, 0xe7, 0x07, 0x01, 0x00,
    0x94, 0x08, 0x06, 0xcf, 0xe7, 0x07, 0x20, 0x0e,
    0x02, 0x00, 0xe7, 0x07, 0x50, 0xc3, 0x12, 0xc0,
    0xe7, 0x05, 0x00, 0xc0, 0x97, 0xcf, 0xe7, 0x07,
    0x01, 0x00, 0x94, 0x08, 0x97, 0xcf, 0xe7, 0x07,
    0x50, 0xc3, 0x12, 0xc0, 0xe7, 0x07, 0x20, 0x0e,
    0x02, 0x00, 0xe7, 0x07, 0x01, 0x00, 0x58, 0x08,
    0xe7, 0x07, 0x05, 0x00, 0x90, 0xc0, 0x97, 0xcf,
    0xe7, 0x07, 0x00, 0x01, 0x42, 0xc0, 0xe7, 0x07,
    0x04, 0x00, 0x90, 0xc0, 0xe7, 0x07, 0x00, 0x00,
    0x58, 0x08, 0xe7, 0x57, 0x0f, 0x00, 0x8e, 0x08,
    0x13, 0xc1, 0x9f, 0xaf, 0x02, 0x08, 0xca, 0x09,
    0x8a, 0x08, 0xf2, 0x17, 0x01, 0x00, 0x5c, 0x00,
    0xf2, 0x27, 0x00, 0x00, 0x5e, 0x00, 0xe7, 0x07,
    0x00, 0x00, 0x8e, 0x08, 0xe7, 0x07, 0x01, 0x00,
    0x90, 0x08, 0xc0, 0x07, 0xff, 0xff, 0x97, 0xcf,
    0x9f, 0xaf, 0x3c, 0x03, 0xc0, 0x69, 0x90, 0x08,
    0x57, 0x00, 0x9f, 0xde, 0x33, 0x00, 0xc1, 0x05,
    0x27, 0xd8, 0x8e, 0x08, 0x27, 0xd2, 0x90, 0x08,
    0xe7, 0x87, 0x01, 0x00, 0x90, 0x08, 0xe7, 0x67,
    0xff, 0x03, 0x90, 0x08, 0x00, 0x60, 0x97, 0xc0,
    0xe7, 0x07, 0x01, 0x00, 0x8c, 0x08, 0x27, 0x00,
    0x12, 0xc0, 0x97, 0xcf, 0xc0, 0x09, 0x92, 0x08,
    0x00, 0xd2, 0x02, 0xc3, 0xc0, 0x97, 0x05, 0x80,
    0x27, 0x00, 0x92, 0x08, 0xc0, 0x99, 0x62, 0x08,
    0xc0, 0x99, 0xa2, 0xc0, 0x97, 0xcf, 0xe7, 0x07,
    0x00, 0x00, 0x8c, 0x08, 0xc0, 0xdf, 0x97, 0xcf,
    0xc8, 0x09, 0x52, 0x08, 0x08, 0x62, 0x02, 0xc0,
    0x10, 0x64, 0x07, 0xc1, 0xe7, 0x07, 0x00, 0x00,
    0x4c, 0x08, 0xe7, 0x07, 0xc8, 0x05, 0x24, 0x00,
    0x97, 0xcf, 0x27, 0x04, 0x52, 0x08, 0xc8, 0x17,
    0x0e, 0x00, 0x27, 0x02, 0x4c, 0x08, 0xe7, 0x07,
    0xd6, 0x05, 0x24, 0x00, 0x97, 0xcf, 0xd7, 0x09,
    0x00, 0xc0, 0xc1, 0xdf, 0xe7, 0x57, 0x00, 0x00,
    0x40, 0x08, 0x13, 0xc1, 0x9f, 0xaf, 0x60, 0x03,
    0xe7, 0x57, 0x00, 0x00, 0x4c, 0x08, 0x13, 0xc0,
    0xe7, 0x09, 0x4c, 0x08, 0x30, 0x01, 0xe7, 0x07,
    0xf2, 0x05, 0x32, 0x01, 0xe7, 0x07, 0x10, 0x00,
    0x96, 0xc0, 0xe7, 0x09, 0x4c, 0x08, 0x40, 0x08,
    0x04, 0xcf, 0xe7, 0x57, 0x00, 0x00, 0x4c, 0x08,
    0x02, 0xc1, 0x9f, 0xaf, 0x60, 0x03, 0xe7, 0x05,
    0x00, 0xc0, 0x97, 0xcf, 0xd7, 0x09, 0x00, 0xc0,
    0xc1, 0xdf, 0x08, 0x92, 0xe7, 0x57, 0x02, 0x00,
    0x5a, 0x08, 0x02, 0xcb, 0xc8, 0x09, 0x52, 0x08,
    0x27, 0x02, 0x56, 0x08, 0x08, 0x62, 0x03, 0xc1,
    0xe7, 0x05, 0x00, 0xc0, 0x97, 0xcf, 0x27, 0x04,
    0x52, 0x08, 0xe7, 0x05, 0x00, 0xc0, 0xf0, 0x07,
    0x40, 0x00, 0x08, 0x00, 0xf0, 0x07, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x02, 0xc0, 0x17, 0x0c, 0x00,
    0x30, 0x00, 0x06, 0x00, 0xf0, 0x07, 0x50, 0x01,
    0x0a, 0x00, 0xc8, 0x17, 0x04, 0x00, 0xc1, 0x07,
    0x02, 0x00, 0x51, 0xaf, 0x97, 0xcf, 0xe7, 0x57,
    0x00, 0x00, 0x46, 0x08, 0x97, 0xc0, 0xc1, 0xdf,
    0xc8, 0x09, 0x46, 0x08, 0x27, 0x04, 0x46, 0x08,
    0x27, 0x52, 0x48, 0x08, 0x03, 0xc1, 0xe7, 0x07,
    0x46, 0x08, 0x48, 0x08, 0xc0, 0xdf, 0x17, 0x02,
    0xc8, 0x17, 0x0e, 0x00, 0x9f, 0xaf, 0x14, 0x05,
    0xc8, 0x05, 0x00, 0x60, 0x03, 0xc0, 0x9f, 0xaf,
    0x7e, 0x04, 0x97, 0xcf, 0x9f, 0xaf, 0x62, 0x04,
    0x97, 0xcf, 0x57, 0x02, 0xc9, 0x07, 0x52, 0x08,
    0xd7, 0x09, 0x00, 0xc0, 0xc1, 0xdf, 0x08, 0x62,
    0x1b, 0xc0, 0x50, 0x04, 0x11, 0x02, 0xe7, 0x05,
    0x00, 0xc0, 0xc9, 0x05, 0x97, 0xcf, 0x97, 0x02,
    0xca, 0x09, 0x8a, 0x08, 0xf2, 0x17, 0x01, 0x00,
    0x04, 0x00, 0xf2, 0x27, 0x00, 0x00, 0x06, 0x00,
    0xca, 0x17, 0x2c, 0x00, 0xf8, 0x77, 0x01, 0x00,
    0x0e, 0x00, 0x06, 0xc0, 0xca, 0xd9, 0xf8, 0x57,
    0xff, 0x00, 0x0e, 0x00, 0x01, 0xc1, 0xca, 0xd9,
    0x22, 0x1c, 0x0c, 0x00, 0xe2, 0x27, 0x00, 0x00,
    0xe2, 0x17, 0x01, 0x00, 0xe2, 0x27, 0x00, 0x00,
    0xca, 0x05, 0x00, 0x0c, 0x0c, 0x00, 0xc0, 0x17,
    0x41, 0x00, 0xc0, 0x67, 0xc0, 0xff, 0x30, 0x00,
    0x08, 0x00, 0x00, 0x02, 0xc0, 0x17, 0x0c, 0x00,
    0x30, 0x00, 0x06, 0x00, 0xf0, 0x07, 0xe4, 0x00,
    0x0a, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x0c, 0x08, 0x00, 0x40, 0xd1, 0x01, 0x00,
    0xc0, 0x19, 0x84, 0x08, 0xc0, 0x59, 0x78, 0x08,
    0x04, 0xc9, 0x49, 0xaf, 0x9f, 0xaf, 0xf6, 0x00,
    0x4a, 0xaf, 0x67, 0x10, 0x84, 0x08, 0xc8, 0x17,
    0x04, 0x00, 0xc1, 0x07, 0x01, 0x00, 0xd7, 0x09,
    0x00, 0xc0, 0xc1, 0xdf, 0x50, 0xaf, 0xe7, 0x05,
    0x00, 0xc0, 0x97, 0xcf, 0xc0, 0x07, 0x01, 0x00,
    0xc1, 0x09, 0x5c, 0x08, 0xc1, 0x77, 0x01, 0x00,
    0x97, 0xc1, 0xd8, 0x77, 0x01, 0x00, 0x12, 0xc0,
    0xc9, 0x07, 0x20, 0x08, 0x9f, 0xaf, 0x62, 0x05,
    0x04, 0xc1, 0xc1, 0x77, 0x08, 0x00, 0x13, 0xc0,
    0x97, 0xcf, 0xc1, 0x77, 0x02, 0x00, 0x97, 0xc1,
    0xc1, 0x77, 0x10, 0x00, 0x0c, 0xc0, 0x9f, 0xaf,
    0x86, 0x05, 0x97, 0xcf, 0xc1, 0x77, 0x04, 0x00,
    0x06, 0xc0, 0xc9, 0x07, 0x5e, 0x08, 0x9f, 0xaf,
    0x62, 0x05, 0x97, 0xc0, 0x00, 0xcf, 0x00, 0x90,
    0x97, 0xcf, 0x50, 0x54, 0x97, 0xc1, 0x70, 0x5c,
    0x02, 0x00, 0x02, 0x00, 0x97, 0xc1, 0x70, 0x5c,
    0x04, 0x00, 0x04, 0x00, 0x97, 0xcf, 0x80, 0x01,
    0xc0, 0x00, 0x60, 0x00, 0x30, 0x00, 0x18, 0x00,
    0x0c, 0x00, 0x06, 0x00, 0x00, 0x00, 0xcb, 0x09,
    0x68, 0x08, 0xcc, 0x09, 0x6a, 0x08, 0x0b, 0x53,
    0x11, 0xc0, 0xc9, 0x02, 0xca, 0x07, 0x76, 0x05,
    0x9f, 0xaf, 0x62, 0x05, 0x97, 0xc0, 0x0a, 0xc8,
    0x82, 0x08, 0x0a, 0xcf, 0x82, 0x08, 0x9f, 0xaf,
    0x62, 0x05, 0x97, 0xc0, 0x05, 0xc2, 0x89, 0x30,
    0x82, 0x60, 0x78, 0xc1, 0x00, 0x90, 0x97, 0xcf,
    0x89, 0x10, 0x09, 0x53, 0x79, 0xc2, 0x89, 0x30,
    0x82, 0x08, 0x7a, 0xcf, 0xc0, 0xdf, 0x97, 0xcf,
    0xe7, 0x09, 0x96, 0xc0, 0x42, 0x08, 0xe7, 0x09,
    0x98, 0xc0, 0x44, 0x08, 0x0f, 0xcf, 0xe7, 0x09,
    0x96, 0xc0, 0x42, 0x08, 0xe7, 0x09, 0x98, 0xc0,
    0x44, 0x08, 0xe7, 0x09, 0x4c, 0x08, 0x30, 0x01,
    0xe7, 0x07, 0xf2, 0x05, 0x32, 0x01, 0xe7, 0x07,
    0x10, 0x00, 0x96, 0xc0, 0xd7, 0x09, 0x00, 0xc0,
    0x17, 0x02, 0xc8, 0x09, 0x40, 0x08, 0xc8, 0x37,
    0x0e, 0x00, 0xe7, 0x77, 0x2a, 0x00, 0x42, 0x08,
    0x30, 0xc0, 0x97, 0x02, 0xca, 0x09, 0x8a, 0x08,
    0xe7, 0x77, 0x20, 0x00, 0x42, 0x08, 0x0e, 0xc0,
    0xf2, 0x17, 0x01, 0x00, 0x10, 0x00, 0xf2, 0x27,
    0x00, 0x00, 0x12, 0x00, 0xe7, 0x77, 0x0a, 0x00,
    0x42, 0x08, 0xca, 0x05, 0x1e, 0xc0, 0x97, 0x02,
    0xca, 0x09, 0x8a, 0x08, 0xf2, 0x17, 0x01, 0x00,
    0x0c, 0x00, 0xf2, 0x27, 0x00, 0x00, 0x0e, 0x00,
    0xe7, 0x77, 0x02, 0x00, 0x42, 0x08, 0x07, 0xc0,
    0xf2, 0x17, 0x01, 0x00, 0x44, 0x00, 0xf2, 0x27,
    0x00, 0x00, 0x46, 0x00, 0x06, 0xcf, 0xf2, 0x17,
    0x01, 0x00, 0x60, 0x00, 0xf2, 0x27, 0x00, 0x00,
    0x62, 0x00, 0xca, 0x05, 0x9f, 0xaf, 0x62, 0x04,
    0x0f, 0xcf, 0x57, 0x02, 0x09, 0x02, 0xf1, 0x09,
    0x44, 0x08, 0x0c, 0x00, 0xf1, 0xda, 0x0c, 0x00,
    0xc8, 0x09, 0x48, 0x08, 0x50, 0x02, 0x67, 0x02,
    0x48, 0x08, 0xd1, 0x07, 0x00, 0x00, 0xc9, 0x05,
    0xe7, 0x09, 0x4c, 0x08, 0x40, 0x08, 0xe7, 0x57,
    0x00, 0x00, 0x40, 0x08, 0x02, 0xc0, 0x9f, 0xaf,
    0x60, 0x03, 0xc8, 0x05, 0xe7, 0x05, 0x00, 0xc0,
    0xc0, 0xdf, 0x97, 0xcf, 0xd7, 0x09, 0x00, 0xc0,
    0x17, 0x00, 0x17, 0x02, 0x97, 0x02, 0xc0, 0x09,
    0x92, 0xc0, 0xe7, 0x57, 0x00, 0x00, 0x5a, 0x08,
    0x02, 0xc0, 0x27, 0xda, 0x5a, 0x08, 0xe7, 0x07,
    0x04, 0x00, 0x90, 0xc0, 0xca, 0x09, 0x8a, 0x08,
    0xe7, 0x07, 0x00, 0x00, 0x58, 0x08, 0xe7, 0x07,
    0x56, 0x03, 0x02, 0x00, 0xc0, 0x77, 0x02, 0x00,
    0x10, 0xc0, 0xef, 0x57, 0x00, 0x00, 0xe2, 0x09,
    0x04, 0xc0, 0x9f, 0xaf, 0xc8, 0x02, 0x9f, 0xcf,
    0xe6, 0x07, 0xf2, 0x17, 0x01, 0x00, 0x50, 0x00,
    0xf2, 0x27, 0x00, 0x00, 0x52, 0x00, 0x9f, 0xcf,
    0xe6, 0x07, 0xef, 0x57, 0x00, 0x00, 0xe2, 0x09,
    0x08, 0xc0, 0xe7, 0x57, 0x00, 0x00, 0x94, 0x08,
    0xe7, 0x07, 0x00, 0x00, 0x94, 0x08, 0x0a, 0xc0,
    0x03, 0xcf, 0xc0, 0x77, 0x10, 0x00, 0x06, 0xc0,
    0xf2, 0x17, 0x01, 0x00, 0x58, 0x00, 0xf2, 0x27,
    0x00, 0x00, 0x5a, 0x00, 0xc0, 0x77, 0x80, 0x00,
    0x06, 0xc0, 0xf2, 0x17, 0x01, 0x00, 0x70, 0x00,
    0xf2, 0x27, 0x00, 0x00, 0x72, 0x00, 0xc0, 0x77,
    0x08, 0x00, 0x1d, 0xc1, 0xf2, 0x17, 0x01, 0x00,
    0x08, 0x00, 0xf2, 0x27, 0x00, 0x00, 0x0a, 0x00,
    0xc0, 0x77, 0x00, 0x02, 0x06, 0xc0, 0xf2, 0x17,
    0x01, 0x00, 0x64, 0x00, 0xf2, 0x27, 0x00, 0x00,
    0x66, 0x00, 0xc0, 0x77, 0x40, 0x00, 0x06, 0xc0,
    0xf2, 0x17, 0x01, 0x00, 0x5c, 0x00, 0xf2, 0x27,
    0x00, 0x00, 0x5e, 0x00, 0xc0, 0x77, 0x01, 0x00,
    0x01, 0xc0, 0x37, 0xcf, 0x36, 0xcf, 0xf2, 0x17,
    0x01, 0x00, 0x00, 0x00, 0xf2, 0x27, 0x00, 0x00,
    0x02, 0x00, 0xef, 0x57, 0x00, 0x00, 0xe2, 0x09,
    0x18, 0xc0, 0xe7, 0x57, 0x01, 0x00, 0x8e, 0x08,
    0x0e, 0xc2, 0x07, 0xc8, 0xf2, 0x17, 0x01, 0x00,
    0x50, 0x00, 0xf2, 0x27, 0x00, 0x00, 0x52, 0x00,
    0x06, 0xcf, 0xf2, 0x17, 0x01, 0x00, 0x54, 0x00,
    0xf2, 0x27, 0x00, 0x00, 0x56, 0x00, 0xe7, 0x07,
    0x00, 0x00, 0x8e, 0x08, 0xe7, 0x07, 0x01, 0x00,
    0x90, 0x08, 0xc8, 0x09, 0x34, 0x01, 0xca, 0x17,
    0x14, 0x00, 0xd8, 0x77, 0x01, 0x00, 0x05, 0xc0,
    0xca, 0xd9, 0xd8, 0x57, 0xff, 0x00, 0x01, 0xc0,
    0xca, 0xd9, 0xe2, 0x19, 0x94, 0xc0, 0xe2, 0x27,
    0x00, 0x00, 0xe2, 0x17, 0x01, 0x00, 0xe2, 0x27,
    0x00, 0x00, 0x9f, 0xaf, 0x02, 0x08, 0x9f, 0xaf,
    0xce, 0x01, 0xe7, 0x57, 0x00, 0x00, 0x88, 0x08,
    0x9f, 0xa1, 0xde, 0x0b, 0xca, 0x05, 0xc8, 0x05,
    0xc0, 0x05, 0xe7, 0x05, 0x00, 0xc0, 0xc0, 0xdf,
    0x97, 0xcf, 0xc8, 0x09, 0x4e, 0x08, 0x08, 0x62,
    0x97, 0xc0, 0x27, 0x04, 0x4e, 0x08, 0x27, 0x52,
    0x50, 0x08, 0x03, 0xc1, 0xe7, 0x07, 0x4e, 0x08,
    0x50, 0x08, 0x9f, 0xaf, 0x62, 0x04, 0x97, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x33, 0xcc, 0x00, 0x00, 0x09, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xfb, 0x13, 0xe7, 0x57,
    0x00, 0x80, 0xb2, 0x00, 0x06, 0xc2, 0xe7, 0x07,
    0x42, 0x0e, 0x12, 0x00, 0xe7, 0x07, 0x88, 0x0e,
    0xb2, 0x00, 0xe7, 0x07, 0x94, 0x09, 0xf2, 0x02,
    0xc8, 0x09, 0xb4, 0x00, 0xf8, 0x07, 0x02, 0x00,
    0x0d, 0x00, 0xd7, 0x09, 0x0e, 0xc0, 0xe7, 0x07,
    0x00, 0x00, 0x0e, 0xc0, 0xc8, 0x09, 0xde, 0x00,
    0xc8, 0x17, 0x09, 0x00, 0xc9, 0x07, 0x9a, 0x08,
    0xc0, 0x07, 0x04, 0x00, 0x68, 0x0a, 0x00, 0xda,
    0x7d, 0xc1, 0xe7, 0x09, 0xc0, 0x00, 0x2c, 0x08,
    0xe7, 0x09, 0xbe, 0x00, 0x28, 0x08, 0xe7, 0x09,
    0x10, 0x00, 0x72, 0x08, 0xc8, 0x07, 0xa4, 0x09,
    0x9f, 0xaf, 0x7c, 0x09, 0x9f, 0xaf, 0xd0, 0x0b,
    0xc8, 0x09, 0xde, 0x00, 0x00, 0x0e, 0x0f, 0x00,
    0x41, 0x90, 0x9f, 0xde, 0x06, 0x00, 0x44, 0xaf,
    0x27, 0x00, 0x68, 0x08, 0x27, 0x00, 0x6a, 0x08,
    0x27, 0x00, 0x6c, 0x08, 0xc0, 0x07, 0x74, 0x00,
    0x44, 0xaf, 0x27, 0x00, 0x8a, 0x08, 0x08, 0x00,
    0x00, 0x90, 0xc1, 0x07, 0x3a, 0x00, 0x20, 0x00,
    0x01, 0xda, 0x7d, 0xc1, 0x9f, 0xaf, 0x8a, 0x0b,
    0xc0, 0x07, 0x44, 0x00, 0x48, 0xaf, 0x27, 0x00,
    0x2a, 0x08, 0x9f, 0xaf, 0x66, 0x0c, 0xe7, 0x07,
    0x01, 0x00, 0x76, 0x08, 0xef, 0x57, 0x00, 0x00,
    0xe2, 0x09, 0x03, 0xc0, 0xe7, 0x07, 0x01, 0x00,
    0x1c, 0xc0, 0xe7, 0x05, 0x0e, 0xc0, 0x97, 0xcf,
    0x49, 0xaf, 0xe7, 0x87, 0x43, 0x00, 0x0e, 0xc0,
    0xe7, 0x07, 0xff, 0xff, 0x74, 0x08, 0x9f, 0xaf,
    0x7e, 0x0c, 0xc0, 0x07, 0x01, 0x00, 0x60, 0xaf,
    0x4a, 0xaf, 0x97, 0xcf, 0x00, 0x08, 0x09, 0x08,
    0x11, 0x08, 0x00, 0xda, 0x7c, 0xc1, 0x97, 0xcf,
    0x67, 0x04, 0xcc, 0x02, 0xc0, 0xdf, 0x51, 0x94,
    0xb1, 0xaf, 0x06, 0x00, 0xc1, 0xdf, 0xc9, 0x09,
    0xcc, 0x02, 0x49, 0x62, 0x75, 0xc1, 0xc0, 0xdf,
    0xa7, 0xcf, 0xd6, 0x02, 0x0e, 0x00, 0x24, 0x00,
    0xd6, 0x05, 0x22, 0x00, 0xa4, 0x06, 0xd0, 0x00,
    0xde, 0x0b, 0xaa, 0x00, 0x00, 0x0a, 0xbe, 0x00,
    0x1a, 0x0c, 0x10, 0x00, 0x20, 0x00, 0x04, 0x00,
    0xc4, 0x05, 0x02, 0x00, 0x56, 0x03, 0x06, 0x00,
    0x00, 0x00, 0x24, 0xc0, 0x04, 0x04, 0x28, 0xc0,
    0xfe, 0xfb, 0x1e, 0xc0, 0x00, 0x04, 0x22, 0xc0,
    0xff, 0xf4, 0xc0, 0x00, 0x60, 0x0b, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x26, 0x0a,
    0x30, 0x0a, 0xa0, 0x0a, 0xaa, 0x0a, 0xd0, 0x0a,
    0xd4, 0x0a, 0xd8, 0x0a, 0x02, 0x0b, 0x12, 0x0b,
    0x20, 0x0b, 0x22, 0x0b, 0x2a, 0x0b, 0x2a, 0x0b,
    0x27, 0x02, 0x80, 0x08, 0x97, 0xcf, 0xe7, 0x07,
    0x00, 0x00, 0x80, 0x08, 0x0a, 0x0e, 0x01, 0x00,
    0xca, 0x57, 0x0e, 0x00, 0x9f, 0xc3, 0x2a, 0x0b,
    0xca, 0x37, 0x00, 0x00, 0x9f, 0xc2, 0x2a, 0x0b,
    0x0a, 0xd2, 0xb2, 0xcf, 0xe6, 0x09, 0xc8, 0x09,
    0xde, 0x00, 0x07, 0x06, 0x9f, 0xcf, 0x3c, 0x0b,
    0x17, 0x02, 0xc8, 0x09, 0xde, 0x00, 0x00, 0x0e,
    0x0f, 0x00, 0x41, 0x90, 0x9f, 0xde, 0x06, 0x00,
    0xc8, 0x05, 0x30, 0x50, 0x06, 0x00, 0x9f, 0xc8,
    0x2a, 0x0b, 0x27, 0x0c, 0x02, 0x00, 0x66, 0x08,
    0xc0, 0x09, 0x68, 0x08, 0x27, 0x00, 0x6a, 0x08,
    0xe7, 0x07, 0x00, 0x00, 0x64, 0x08, 0x27, 0x00,
    0x30, 0x08, 0x00, 0x1c, 0x06, 0x00, 0x27, 0x00,
    0x6c, 0x08, 0x41, 0x90, 0x67, 0x50, 0x66, 0x08,
    0x0d, 0xc0, 0x67, 0x00, 0x2e, 0x08, 0x27, 0x0c,
    0x06, 0x00, 0x32, 0x08, 0xe7, 0x07, 0x8c, 0x0a,
    0x34, 0x08, 0xc8, 0x07, 0x2e, 0x08, 0x41, 0x90,
    0x51, 0xaf, 0x97, 0xcf, 0x9f, 0xaf, 0x9c, 0x0e,
    0xe7, 0x09, 0x6c, 0x08, 0x6a, 0x08, 0xe7, 0x09,
    0x66, 0x08, 0x64, 0x08, 0x59, 0xaf, 0x97, 0xcf,
    0x27, 0x0c, 0x02, 0x00, 0x5c, 0x08, 0x59, 0xaf,
    0x97, 0xcf, 0x09, 0x0c, 0x02, 0x00, 0x09, 0xda,
    0x49, 0xd2, 0xc9, 0x19, 0x8a, 0x08, 0xc8, 0x07,
    0x2e, 0x08, 0xe0, 0x07, 0x00, 0x00, 0x60, 0x02,
    0xe0, 0x07, 0x04, 0x00, 0xd0, 0x07, 0x9c, 0x0a,
    0x48, 0xdb, 0x41, 0x90, 0x50, 0xaf, 0x97, 0xcf,
    0x59, 0xaf, 0x97, 0xcf, 0x59, 0xaf, 0x97, 0xcf,
    0xf0, 0x57, 0x06, 0x00, 0x06, 0x00, 0x25, 0xc1,
    0xe7, 0x07, 0x5e, 0x08, 0x30, 0x08, 0x41, 0x90,
    0x67, 0x00, 0x2e, 0x08, 0x27, 0x0c, 0x06, 0x00,
    0x32, 0x08, 0xe7, 0x07, 0x5c, 0x0b, 0x34, 0x08,
    0xc8, 0x07, 0x2e, 0x08, 0x41, 0x90, 0x51, 0xaf,
    0x97, 0xcf, 0x07, 0x0c, 0x06, 0x00, 0xc7, 0x57,
    0x06, 0x00, 0x0f, 0xc1, 0xc8, 0x07, 0x5e, 0x08,
    0x15, 0xcf, 0x00, 0x0c, 0x02, 0x00, 0x00, 0xda,
    0x40, 0xd1, 0x27, 0x00, 0x78, 0x08, 0x1e, 0xcf,
    0x1d, 0xcf, 0x27, 0x0c, 0x02, 0x00, 0x82, 0x08,
    0x19, 0xcf, 0x27, 0x02, 0x20, 0x01, 0xe7, 0x07,
    0x08, 0x00, 0x22, 0x01, 0xe7, 0x07, 0x13, 0x00,
    0xb0, 0xc0, 0x97, 0xcf, 0x41, 0x90, 0x67, 0x00,
    0x2e, 0x08, 0xe7, 0x01, 0x32, 0x08, 0x27, 0x02,
    0x30, 0x08, 0xe7, 0x07, 0x5c, 0x0b, 0x34, 0x08,
    0xc8, 0x07, 0x2e, 0x08, 0xc1, 0x07, 0x00, 0x80,
    0x50, 0xaf, 0x97, 0xcf, 0x59, 0xaf, 0x97, 0xcf,
    0x00, 0x60, 0x05, 0xc0, 0xe7, 0x07, 0x00, 0x00,
    0x7a, 0x08, 0xa7, 0xcf, 0x2c, 0x08, 0x9f, 0xaf,
    0xd0, 0x0b, 0xe7, 0x07, 0x01, 0x00, 0x7a, 0x08,
    0x49, 0xaf, 0xd7, 0x09, 0x00, 0xc0, 0x07, 0xaf,
    0xe7, 0x05, 0x00, 0xc0, 0x4a, 0xaf, 0xa7, 0xcf,
    0x2c, 0x08, 0xc0, 0x07, 0xfe, 0x7f, 0x44, 0xaf,
    0x40, 0x00, 0xc0, 0x37, 0x00, 0x01, 0x41, 0x90,
    0xc0, 0x37, 0x08, 0x00, 0xdf, 0xde, 0x50, 0x06,
    0xc0, 0x57, 0x10, 0x00, 0x02, 0xc2, 0xc0, 0x07,
    0x10, 0x00, 0x27, 0x00, 0x4a, 0x08, 0x41, 0x90,
    0x9f, 0xde, 0x40, 0x06, 0x44, 0xaf, 0x27, 0x00,
    0x54, 0x08, 0xc0, 0x09, 0x4a, 0x08, 0x41, 0x90,
    0x00, 0xd2, 0x00, 0xd8, 0x9f, 0xde, 0x08, 0x00,
    0x44, 0xaf, 0x27, 0x00, 0x7e, 0x08, 0x97, 0xcf,
    0xe7, 0x87, 0x00, 0x84, 0x28, 0xc0, 0xe7, 0x67,
    0xff, 0xfb, 0x24, 0xc0, 0x97, 0xcf, 0xe7, 0x87,
    0x01, 0x00, 0x88, 0x08, 0xe7, 0x57, 0x00, 0x00,
    0x58, 0x08, 0x97, 0xc1, 0x9f, 0xaf, 0xd0, 0x0b,
    0xe7, 0x87, 0x00, 0x06, 0x22, 0xc0, 0xe7, 0x07,
    0x00, 0x00, 0x90, 0xc0, 0xe7, 0x67, 0xfe, 0xff,
    0x3e, 0xc0, 0xe7, 0x07, 0x2e, 0x00, 0x0a, 0xc0,
    0xe7, 0x87, 0x01, 0x00, 0x3e, 0xc0, 0xe7, 0x07,
    0xff, 0xff, 0x74, 0x08, 0x9f, 0xaf, 0xe0, 0x0c,
    0x97, 0xcf, 0x17, 0x00, 0xa7, 0xaf, 0x28, 0x08,
    0xc0, 0x05, 0x27, 0x00, 0x26, 0x08, 0xe7, 0x87,
    0x01, 0x00, 0x88, 0x08, 0x9f, 0xaf, 0xd0, 0x0b,
    0xe7, 0x07, 0x0c, 0x00, 0x40, 0xc0, 0x9f, 0xaf,
    0xe0, 0x0c, 0x00, 0x90, 0x27, 0x00, 0x56, 0x08,
    0x27, 0x00, 0x5a, 0x08, 0xe7, 0x09, 0x68, 0x08,
    0x6a, 0x08, 0x27, 0x00, 0x64, 0x08, 0x27, 0x00,
    0x5c, 0x08, 0x9f, 0xaf, 0x7e, 0x0c, 0xc0, 0x07,
    0x00, 0x00, 0x27, 0x00, 0xb2, 0x02, 0x27, 0x00,
    0xb4, 0x02, 0x27, 0x00, 0x3e, 0x08, 0xc0, 0x07,
    0x06, 0x00, 0xc8, 0x09, 0xde, 0x00, 0xc8, 0x17,
    0x03, 0x00, 0xc9, 0x07, 0x5e, 0x08, 0x29, 0x0a,
    0x00, 0xda, 0x7d, 0xc1, 0x97, 0xcf, 0xd7, 0x09,
    0x00, 0xc0, 0xc1, 0xdf, 0x00, 0x90, 0x27, 0x00,
    0x46, 0x08, 0xe7, 0x07, 0x46, 0x08, 0x48, 0x08,
    0x27, 0x00, 0x4e, 0x08, 0xe7, 0x07, 0x4e, 0x08,
    0x50, 0x08, 0x27, 0x00, 0x56, 0x08, 0x27, 0x00,
    0x40, 0x08, 0x27, 0x00, 0x4c, 0x08, 0xc8, 0x09,
    0x54, 0x08, 0xc1, 0x09, 0x4a, 0x08, 0xc9, 0x07,
    0x52, 0x08, 0x11, 0x02, 0x09, 0x02, 0xc8, 0x17,
    0x40, 0x06, 0x01, 0xda, 0x7a, 0xc1, 0x51, 0x94,
    0xc8, 0x09, 0x7e, 0x08, 0xc9, 0x07, 0x7c, 0x08,
    0xc1, 0x09, 0x4a, 0x08, 0x11, 0x02, 0x09, 0x02,
    0xc8, 0x17, 0x08, 0x00, 0x01, 0xda, 0x7a, 0xc1,
    0x51, 0x94, 0xe7, 0x05, 0x00, 0xc0, 0x97, 0xcf,
    0xe7, 0x57, 0x00, 0x00, 0x26, 0x08, 0x97, 0xc0,
    0x9f, 0xaf, 0x04, 0x00, 0xe7, 0x09, 0x74, 0x08,
    0x70, 0x08, 0xe7, 0x57, 0xff, 0xff, 0x70, 0x08,
    0x04, 0xc1, 0xe7, 0x07, 0xe0, 0x0c, 0x6e, 0x08,
    0x97, 0xcf, 0xe7, 0x17, 0x32, 0x00, 0x70, 0x08,
    0xe7, 0x67, 0xff, 0x07, 0x70, 0x08, 0xe7, 0x07,
    0x16, 0x0d, 0x6e, 0x08, 0x97, 0xcf, 0xd7, 0x09,
    0x00, 0xc0, 0xc1, 0xdf, 0xe7, 0x57, 0x00, 0x00,
    0x76, 0x08, 0x23, 0xc0, 0xe7, 0x07, 0x04, 0x00,
    0x90, 0xc0, 0xe7, 0x07, 0x00, 0x80, 0x80, 0xc0,
    0xe7, 0x07, 0x00, 0x00, 0x80, 0xc0, 0xe7, 0x07,
    0x00, 0x80, 0x80, 0xc0, 0xc0, 0x07, 0x00, 0x00,
    0xc0, 0x07, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00,
    0xe7, 0x07, 0x00, 0x00, 0x80, 0xc0, 0xe7, 0x07,
    0x00, 0x80, 0x80, 0xc0, 0xe7, 0x07, 0x00, 0x80,
    0x40, 0xc0, 0xc0, 0x07, 0x00, 0x00, 0xe7, 0x07,
    0x00, 0x00, 0x40, 0xc0, 0xe7, 0x07, 0x00, 0x00,
    0x80, 0xc0, 0xef, 0x57, 0x00, 0x00, 0xe3, 0x09,
    0x9f, 0xa0, 0xb0, 0x0d, 0xe7, 0x07, 0x04, 0x00,
    0x90, 0xc0, 0xe7, 0x07, 0x00, 0x02, 0x40, 0xc0,
    0xe7, 0x07, 0x0c, 0x02, 0x40, 0xc0, 0xe7, 0x07,
    0x00, 0x00, 0x76, 0x08, 0xe7, 0x07, 0x00, 0x00,
    0x6e, 0x08, 0xe7, 0x07, 0x00, 0x00, 0x88, 0x08,
    0xd7, 0x09, 0x00, 0xc0, 0xc1, 0xdf, 0x9f, 0xaf,
    0x8e, 0x03, 0xe7, 0x05, 0x00, 0xc0, 0x9f, 0xaf,
    0xce, 0x01, 0xe7, 0x05, 0x00, 0xc0, 0x97, 0xcf,
    0x9f, 0xaf, 0xce, 0x0d, 0xef, 0x77, 0x00, 0x00,
    0xe3, 0x09, 0x97, 0xc1, 0x9f, 0xaf, 0xce, 0x0d,
    0xef, 0x77, 0x00, 0x00, 0xe3, 0x09, 0x97, 0xc1,
    0xef, 0x07, 0x01, 0x00, 0xe3, 0x09, 0xe7, 0x87,
    0x00, 0x08, 0x1e, 0xc0, 0xe7, 0x87, 0x00, 0x08,
    0x22, 0xc0, 0xe7, 0x67, 0xff, 0xf7, 0x22, 0xc0,
    0xe7, 0x77, 0x00, 0x08, 0x20, 0xc0, 0x11, 0xc0,
    0xe7, 0x67, 0xff, 0xf7, 0x1e, 0xc0, 0xe7, 0x87,
    0x00, 0x08, 0x22, 0xc0, 0xe7, 0x67, 0xff, 0xf7,
    0x22, 0xc0, 0xe7, 0x77, 0x00, 0x08, 0x20, 0xc0,
    0x04, 0xc1, 0xe7, 0x87, 0x00, 0x08, 0x22, 0xc0,
    0x97, 0xcf, 0xe7, 0x07, 0x01, 0x01, 0xe2, 0x09,
    0xef, 0x57, 0x18, 0x00, 0xfe, 0xff, 0x97, 0xc2,
    0xef, 0x07, 0x00, 0x00, 0xe2, 0x09, 0x97, 0xcf,
    0xd7, 0x09, 0x00, 0xc0, 0x17, 0x00, 0x17, 0x02,
    0x97, 0x02, 0xe7, 0x57, 0x00, 0x00, 0x58, 0x08,
    0x06, 0xc0, 0xc0, 0x09, 0x92, 0xc0, 0xc0, 0x77,
    0x09, 0x02, 0x9f, 0xc1, 0xb2, 0x06, 0x9f, 0xcf,
    0xf4, 0x07, 0xd7, 0x09, 0x0e, 0xc0, 0xe7, 0x07,
    0x00, 0x00, 0x0e, 0xc0, 0x9f, 0xaf, 0x56, 0x0e,
    0xe7, 0x05, 0x0e, 0xc0, 0x97, 0xcf, 0xd7, 0x09,
    0x00, 0xc0, 0x17, 0x02, 0xc8, 0x09, 0xb0, 0xc0,
    0xe7, 0x67, 0xfe, 0x7f, 0xb0, 0xc0, 0xc8, 0x77,
    0x00, 0x20, 0x9f, 0xc1, 0x64, 0xeb, 0xe7, 0x57,
    0x00, 0x00, 0xc8, 0x02, 0x9f, 0xc1, 0x80, 0xeb,
    0xc8, 0x99, 0xca, 0x02, 0xc8, 0x67, 0x04, 0x00,
    0x9f, 0xc1, 0x96, 0xeb, 0x9f, 0xcf, 0x4c, 0xeb,
    0xe7, 0x07, 0x00, 0x00, 0xa6, 0xc0, 0xe7, 0x09,
    0xb0, 0xc0, 0xc8, 0x02, 0xe7, 0x07, 0x03, 0x00,
    0xb0, 0xc0, 0x97, 0xcf, 0xc0, 0x09, 0x66, 0x08,
    0xc0, 0x37, 0x01, 0x00, 0x97, 0xc9, 0xc9, 0x09,
    0x68, 0x08, 0x02, 0x00, 0x41, 0x90, 0x48, 0x02,
    0xc9, 0x17, 0x06, 0x00, 0x9f, 0xaf, 0x62, 0x05,
    0x9f, 0xa2, 0xc6, 0x0e, 0x02, 0xda, 0x77, 0xc1,
    0x41, 0x60, 0x71, 0xc1, 0x97, 0xcf, 0x17, 0x02,
    0x57, 0x02, 0x43, 0x04, 0x21, 0x04, 0xe0, 0x00,
    0x43, 0x04, 0x21, 0x04, 0xe0, 0x00, 0x43, 0x04,
    0x21, 0x04, 0xe0, 0x00, 0xc1, 0x07, 0x01, 0x00,
    0xc9, 0x05, 0xc8, 0x05, 0x97, 0xcf, 0xe7, 0x07,
    0x01, 0x00, 0x3e, 0x08, 0xc8, 0x07, 0x36, 0x08,
    0xe7, 0x07, 0x00, 0x00, 0x36, 0x08, 0xe7, 0x07,
    0xde, 0x09, 0x38, 0x08, 0xe7, 0x07, 0x04, 0x00,
    0x3a, 0x08, 0xe7, 0x07, 0x10, 0x0f, 0x3c, 0x08,
    0xc1, 0x07, 0x03, 0x80, 0x50, 0xaf, 0x97, 0xcf,
    0xe7, 0x07, 0x00, 0x00, 0x3e, 0x08, 0x97, 0xcf,
    0,    0 // all communications with chip terminate with two zero bytes
};
UCHAR gKawaFWfix[] = 
{
    0xB6, 0xC3,   // signature
    0xCD, 0x02,   // length = sizeof(gKawaFWfix) - 7
    0x03,         // type = fixup interrupt vector code with this data
    0x64,         // interrupt
    0x02, 0x00, 0x08, 0x00, 0x28, 0x00, 0x2c, 0x00,
    0x34, 0x00, 0x3c, 0x00, 0x40, 0x00, 0x48, 0x00,
    0x54, 0x00, 0x58, 0x00, 0x5e, 0x00, 0x64, 0x00,
    0x68, 0x00, 0x6e, 0x00, 0x6c, 0x00, 0x72, 0x00,
    0x76, 0x00, 0x7c, 0x00, 0x80, 0x00, 0x86, 0x00,
    0x8a, 0x00, 0x90, 0x00, 0x94, 0x00, 0x98, 0x00,
    0x9e, 0x00, 0xa6, 0x00, 0xaa, 0x00, 0xb0, 0x00,
    0xb4, 0x00, 0xb8, 0x00, 0xc0, 0x00, 0xc6, 0x00,
    0xca, 0x00, 0xd0, 0x00, 0xd4, 0x00, 0xda, 0x00,
    0xde, 0x00, 0xe2, 0x00, 0xea, 0x00, 0xe8, 0x00,
    0xf2, 0x00, 0xfa, 0x00, 0x06, 0x01, 0x0e, 0x01,
    0x14, 0x01, 0x22, 0x01, 0x2c, 0x01, 0x32, 0x01,
    0x44, 0x01, 0x48, 0x01, 0x88, 0x01, 0xa2, 0x01,
    0xa6, 0x01, 0xac, 0x01, 0xb6, 0x01, 0xbc, 0x01,
    0xc4, 0x01, 0xca, 0x01, 0xd2, 0x01, 0xda, 0x01,
    0xe0, 0x01, 0xfa, 0x01, 0xfe, 0x01, 0x04, 0x02,
    0x0a, 0x02, 0x16, 0x02, 0x1a, 0x02, 0x5c, 0x02,
    0x7e, 0x02, 0x88, 0x02, 0x90, 0x02, 0x96, 0x02,
    0xaa, 0x02, 0xb6, 0x02, 0xbe, 0x02, 0xd8, 0x02,
    0xde, 0x02, 0xe4, 0x02, 0xe8, 0x02, 0xfa, 0x02,
    0x00, 0x03, 0x0a, 0x03, 0x0e, 0x03, 0x1a, 0x03,
    0x1e, 0x03, 0x24, 0x03, 0x2a, 0x03, 0x34, 0x03,
    0x3e, 0x03, 0x4a, 0x03, 0x4e, 0x03, 0x5a, 0x03,
    0x62, 0x03, 0x70, 0x03, 0x74, 0x03, 0x7c, 0x03,
    0x84, 0x03, 0x88, 0x03, 0x98, 0x03, 0x9e, 0x03,
    0xa4, 0x03, 0xaa, 0x03, 0xbe, 0x03, 0xbc, 0x03,
    0xc6, 0x03, 0xcc, 0x03, 0xe0, 0x03, 0xe6, 0x03,
    0xea, 0x03, 0xf8, 0x03, 0x16, 0x04, 0x2a, 0x04,
    0x32, 0x04, 0x36, 0x04, 0x3a, 0x04, 0x42, 0x04,
    0x40, 0x04, 0x4e, 0x04, 0x58, 0x04, 0x5e, 0x04,
    0x66, 0x04, 0x82, 0x04, 0xd6, 0x04, 0xea, 0x04,
    0xee, 0x04, 0xf6, 0x04, 0xfc, 0x04, 0x1a, 0x05,
    0x2a, 0x05, 0x2e, 0x05, 0x48, 0x05, 0x54, 0x05,
    0x58, 0x05, 0x88, 0x05, 0x8c, 0x05, 0x96, 0x05,
    0x9a, 0x05, 0xa8, 0x05, 0xcc, 0x05, 0xd2, 0x05,
    0xda, 0x05, 0xe0, 0x05, 0xe4, 0x05, 0xfc, 0x05,
    0x06, 0x06, 0x0e, 0x06, 0x14, 0x06, 0x28, 0x06,
    0x32, 0x06, 0x44, 0x06, 0x66, 0x06, 0x70, 0x06,
    0x7a, 0x06, 0x80, 0x06, 0x8c, 0x06, 0x8a, 0x06,
    0x92, 0x06, 0x98, 0x06, 0xb6, 0x06, 0xbc, 0x06,
    0xc6, 0x06, 0xcc, 0x06, 0xd0, 0x06, 0xde, 0x06,
    0xe4, 0x06, 0xe8, 0x06, 0xf8, 0x06, 0xfe, 0x06,
    0x06, 0x07, 0x0c, 0x07, 0x86, 0x07, 0x8e, 0x07,
    0xb2, 0x07, 0xb8, 0x07, 0xe4, 0x07, 0xe8, 0x07,
    0xee, 0x07, 0xf2, 0x07, 0x04, 0x08, 0x0c, 0x08,
    0x10, 0x08, 0x18, 0x08, 0x16, 0x08, 0x1c, 0x08,
    0xa8, 0x08, 0xae, 0x08, 0xb4, 0x08, 0xd6, 0x08,
    0xe6, 0x08, 0xec, 0x08, 0xf2, 0x08, 0xf6, 0x08,
    0xfa, 0x08, 0xfe, 0x08, 0x12, 0x09, 0x16, 0x09,
    0x1a, 0x09, 0x24, 0x09, 0x36, 0x09, 0x3a, 0x09,
    0x40, 0x09, 0x44, 0x09, 0x4a, 0x09, 0x50, 0x09,
    0x6c, 0x09, 0x70, 0x09, 0xa8, 0x09, 0xac, 0x09,
    0xb0, 0x09, 0xb4, 0x09, 0xb8, 0x09, 0xbc, 0x09,
    0xc0, 0x09, 0xc4, 0x09, 0xdc, 0x09, 0xe6, 0x09,
    0xe8, 0x09, 0xea, 0x09, 0xec, 0x09, 0xee, 0x09,
    0xf0, 0x09, 0xf2, 0x09, 0xf4, 0x09, 0xf6, 0x09,
    0xf8, 0x09, 0xfa, 0x09, 0xfc, 0x09, 0xfe, 0x09,
    0x02, 0x0a, 0x0a, 0x0a, 0x16, 0x0a, 0x1e, 0x0a,
    0x24, 0x0a, 0x2e, 0x0a, 0x48, 0x0a, 0x4e, 0x0a,
    0x52, 0x0a, 0x56, 0x0a, 0x5c, 0x0a, 0x60, 0x0a,
    0x68, 0x0a, 0x6e, 0x0a, 0x74, 0x0a, 0x7a, 0x0a,
    0x80, 0x0a, 0x7e, 0x0a, 0x84, 0x0a, 0x8e, 0x0a,
    0x94, 0x0a, 0x92, 0x0a, 0x9a, 0x0a, 0x98, 0x0a,
    0xa4, 0x0a, 0xb4, 0x0a, 0xb8, 0x0a, 0xc6, 0x0a,
    0xe4, 0x0a, 0xe2, 0x0a, 0xea, 0x0a, 0xf0, 0x0a,
    0xf6, 0x0a, 0xf4, 0x0a, 0xfa, 0x0a, 0x0e, 0x0b,
    0x1c, 0x0b, 0x26, 0x0b, 0x40, 0x0b, 0x44, 0x0b,
    0x48, 0x0b, 0x4e, 0x0b, 0x4c, 0x0b, 0x52, 0x0b,
    0x68, 0x0b, 0x6c, 0x0b, 0x70, 0x0b, 0x76, 0x0b,
    0x88, 0x0b, 0xac, 0x0b, 0xb8, 0x0b, 0xbc, 0x0b,
    0xcc, 0x0b, 0xe2, 0x0b, 0xe8, 0x0b, 0xee, 0x0b,
    0x12, 0x0c, 0x16, 0x0c, 0x1e, 0x0c, 0x24, 0x0c,
    0x2a, 0x0c, 0x2e, 0x0c, 0x38, 0x0c, 0x3e, 0x0c,
    0x42, 0x0c, 0x48, 0x0c, 0x46, 0x0c, 0x4c, 0x0c,
    0x50, 0x0c, 0x54, 0x0c, 0x64, 0x0c, 0x74, 0x0c,
    0x88, 0x0c, 0x8e, 0x0c, 0x8c, 0x0c, 0x92, 0x0c,
    0x98, 0x0c, 0x96, 0x0c, 0x9c, 0x0c, 0xa0, 0x0c,
    0xa4, 0x0c, 0xa8, 0x0c, 0xac, 0x0c, 0xb0, 0x0c,
    0xc2, 0x0c, 0xc6, 0x0c, 0xca, 0x0c, 0xe4, 0x0c,
    0xea, 0x0c, 0xf0, 0x0c, 0xee, 0x0c, 0xf6, 0x0c,
    0xfe, 0x0c, 0xfc, 0x0c, 0x06, 0x0d, 0x0c, 0x0d,
    0x12, 0x0d, 0x10, 0x0d, 0x20, 0x0d, 0x6e, 0x0d,
    0x72, 0x0d, 0x8a, 0x0d, 0x90, 0x0d, 0x96, 0x0d,
    0xa0, 0x0d, 0xa8, 0x0d, 0xb2, 0x0d, 0xb8, 0x0d,
    0xbe, 0x0d, 0xc4, 0x0d, 0xcc, 0x0d, 0x0e, 0x0e,
    0x1c, 0x0e, 0x2e, 0x0e, 0x3c, 0x0e, 0x40, 0x0e,
    0x4e, 0x0e, 0x9e, 0x0e, 0xa8, 0x0e, 0xb6, 0x0e,
    0xba, 0x0e, 0xea, 0x0e, 0xee, 0x0e, 0xf4, 0x0e,
    0xfa, 0x0e, 0xf8, 0x0e, 0x00, 0x0f, 0x06, 0x0f,
    0x04, 0x0f, 0x14, 0x0f,
    0,    0 // all communications with chip terminate with two zero bytes
};
UCHAR gKawaFWtrigger[] = 
{
   0xB6, 0xC3,   // signature
   0x01, 0x00,   // length = sizeof(gKawaFWtrigger) - 7
   0x06,         // type = force interrupt call
   0x64,         // interrupt
   0,    0       // all communications with chip terminate with two zero bytes
};
////////////////////////////////////////////////////
#ifdef   DEBUG
USHORT   gETHRmsg = DBG_CRITICAL; //debug message level
#endif
///////////////////////////////////////////////////////////////////////////
// INIT DATA INIT DATA INIT DATA INIT DATA INIT DATA INIT DATA INIT DATA //
///////////////////////////////////////////////////////////////////////////
BYTE     gInitDataStart = 0;
IDCTABLE gIDCTable = {{ 0, 0, 0}, 0, 0}; // structure used by DevHelp_AttachDD
USHORT   gVerbose       = 0;
USHORT   gMessageCount  = 0;
USHORT   gMessageIDs[MAX_INIT_MESSAGE_COUNT];
PSZ      gVMessages[] =
{  //                                                   DDName
   "IUSBETHR.OS2: USB ETHeRnet DD v%dd.%dd installed as $$$$$$$$",
   "EUSBETHR.OS2: USB Driver not found",
   "EUSBETHR.OS2: Register with Protocol Manager driver failed",
   "EUSBETHR.OS2: Invalid parameter in CONFIG.SYS line at column %dd",
   "EUSBETHR.OS2: Invalid numeric value in CONFIG.SYS line at column %dd"
};
MSGTABLE gInitMsg = {MSG_REPLACEMENT_STRING, 1, 0}; // structure used to write out message during initialization
/*
    Resource Manager (RM) Data.
    The RMCALLS.LIB references the following four variables:
     
PFN   Device_Help = NULL; // see above
*/
ULONG RMFlags  = 0UL;
PFN   RM_Help0 = NULL;
PFN   RM_Help3 = NULL;

DRIVERSTRUCT gDriverStruct =
{
   gDDFileName,            // pointer to Name of File of Device Driver (ETHRSTRS.C)
   gDDDescr,               // pointer to Description of Device Driver (ETHRSTRS.C)
   gVendorName,            // pointer to Vendor Name (ETHRSTRS.C)
   MAJOR_USBETHR_VERSION,  //CMVERSION_MAJOR,  // Major Version of the Resource Manager services
   MINOR_USBETHR_VERSION,  //CMVERSION_MINOR,  // Minor Version of the Resource Manager services
                           //    Note: this is NOT the version of the driver!???
   2000,8,31,               // date (year, month, day) to identify the version of the driver
   DRF_STATIC,             // DriveR attribute Flags: Staic driver is loaded when the OS/2 is restored
   DRT_NETWORK,            // DriveR Type: conforms to the Network Driver Interface Specification v2.0.1
   DRS_UNDEFINED,          // DriveR Subtype: Undefined
   0UL                     // driver callback: not implemented in v1.1 of RM, must be NULL
};
HADAPTER      ghAdapter = 0;     // handle to Adapter
ADAPTERSTRUCT gAdapterStruct =
{
   gAdapterName,              // pointer to Name of Adapter (ETHRSTRS.C)
   AS_NO16MB_ADDRESS_LIMIT,   // adapter attribute flags
   AS_BASE_NETWORK,           // adapter Base type: Network adapter
   AS_SUB_ETHERNET,           // adapter Subtype: Ethernet adapter
   AS_INTF_GENERIC,           // Interface type: Generic - can be used by any subtype
   AS_HOSTBUS_PCI,            // Host Bus type: PCI(-USB-network adapter)
   AS_BUSWIDTH_64BIT,         // host Bus Width: 64-bit, though it is usually implemented as a 32-bit
   &gAdjunct,                 // pointer to a linked list of adjunct data structures
   0UL                        // reserved
};
ADJUNCT     gAdjunct;            // init in RegisterDriver function (ETHSTRAT.C)
AHRESOURCE  gResourceList = {0}; // number of resource handles
/*
   Protocol Manager (PM) Data
*/
HFILE ghPM = 0;   // handle to PM

BYTE  gKeyword[MAX_ETHR_KEY][16] = {ETHR_VENDORID_KEY, ETHR_PRODUCTID_KEY};

