/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = TDIDATA.C
 *
 * DESCRIPTIVE NAME = Touch dd, data seg
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/30/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Includes
*/

#define  INCL_OS2STD
#define  INCL_DOSINFOSEG

/* #define INCL_DOSSESMGR */
#include <os2.h>
#include "toudefs.h"
#include "reqblk.h"
#include "toutypes.h"
#include "devhlp.h"

/*
** Global Variables
**
**      Header must be the first declaration in the data segment.
**
**      Initialised strings must not be declared as pointers as
**      the data will be inserted at the begining of this segment,
**      rather than at the place they are declared. This will stop
**      the header being the first data in this segment.
**
**      Do not use:
**              char *  String = "text";
**
**      Instead use:
**              char    String[] = "text";
*/

/*
** declared here as NEAR to init Header, should only be called as FAR
*/

extern NDDENTRY StratEntry(USHORT reg);

extern NDDENTRY IdcEntry(USHORT reg);
DEVHDR NEAR Header =
{
  (PDEVHDR)-1,
  HDR_CHR | HDR_IDC | HDR_OPN | (DD_LEVEL << HDR_LVL_SHFT),
  (NPDDENTRY)StratEntry,
  (NPDDENTRY)IdcEntry,
  "TOUCH$  "
} ;


static char Copyright[] =
"Copyright (C) International Business Machines Corp. 1991. \
All rights reserved. Version - " VERSION;


SGCB NEAR InitSgcb  = {{{0}}};
SGCB NEAR ShellSgcb = {0, {0}};
SGCB NEAR PopupSgcb = {0};


/* ?? check that all vars are initialised where neccessary                   */
FWORD TouVddEntry   = {0l, 0};            /* 16:32 address                   */


VOID(FAR PASCAL *NEAR DevHlp_Entry)() = NULL;
/* VOID (FAR PASCAL * DevHlp_Entry)() = NULL;                                */

ULONG NEAR      CmdSem          = 0l;
PSGCB NEAR      pFgndSgcb       = &ShellSgcb;
USHORT NEAR     SemPid          = 0;
USHORT NEAR     ShellPid        = 0;
USHORT NEAR     CallPid         = 0;
USHORT NEAR     SQPid           = 0;
USHORT NEAR     MaxEQLen        = 10;     /* multiple of EVENT, not bytes    */
/* USHORT NEAR  IntNestLvl      = 0;                                         */
/* USHORT NEAR  StratNestLvl    = 0;                                         */
PGINFOSEG NEAR  pGlobalInfoSeg  = NULL;
USHORT NEAR     NumButtons      = 0;
USHORT NEAR     InitStage       = 0;
USHORT NEAR     EMaskMax        = 0;
USHORT NEAR     fVdmEnabled     = 0;
UCHAR NEAR      CurrCmd         = 0;
UCHAR NEAR      CurrReq         = 0;
UCHAR NEAR      CurrSess        = 0;
USHORT NEAR     FgndSess        = 1;
UCHAR NEAR      fDeInstall      = 0;
UCHAR NEAR      DefaultEmul     = 1;      /* ?? temp, set from config line   */
/* UCHAR NEAR   fDetached       = -1;                                        */
UCHAR NEAR      NumSess         = 0;
UCHAR NEAR      fPtrOveride     = -1;
CONFDAT NEAR    DevData         = { sizeof(CONFDAT) };
MONREC NEAR     TouEvent        = {0};
MONREC NEAR     LastEvent       = {0};
IDC NEAR        DD_Idc          = {0};
IDC NEAR        SQ_Idc          = {0};
INTPKT NEAR     IntPkt          = {0};
ICB NEAR        ICB_In          = {0};
UCHAR NEAR      fCalibrated     = 0;
UCHAR NEAR      fExclAccess     = 0;      /* exclusive touch access flag     */
TDISELMETHOD NEAR DefSelm       = { 0,40,3,5};  /* default selection method  */
USHORT NEAR     DefQSize        = 10;     /* default qsize                   */
VOID FAR * NEAR pEventQueue     = 0;      /* ?? TEMP ??                      */
PSGCB           pCurrSgcb       = {0};    /* init to keep out of far_bss     */


CBTAB NEAR FsCbTable[FSG_MAX] =
{
  0, 1, & InitSgcb, 0l,                   /* Initialisation                  */
  1, 1, & ShellSgcb, 0l,                  /* Shell                           */
  0, 0, NULL, 0l,                         /* Old real DOS                    */
  3, 1, & PopupSgcb, 0l                   /* Pop up                          */
} ;

CBTAB NEAR OtherCbTable[VSG_BLK] = {0};

/*
** The data segment is shrunk some where in the next array,
**      depending how many sgcbs are needed & the max size of an event.
**
** Consequently the rest of the segment is lost after
**      stage 1 init is complete.
**
** Including any data that might have been added in by other modules???
**      ???Wont the data seg combine type take care of this, dgroup ...
**
** Could put default eqs in sep seg & combine them at end of dseg so data
** in other modules can still be defined
**
*/

/*
** default EQs for Init, Shell & PopUp SGCBs (3 off)
*/
EVENT NEAR DfltEQs[EQ_MAX *3]   = {0};

/*
** end
*/
