/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/


#ifndef  TOUDEFS_INCLUDED              /* stop multiple inclusion            */
#define  TOUDEFS_INCLUDED

#include "tdicalls.h"            /* device independant sub-system dll stuff  */

/*
** defines
*/
#define  SETQ                          /* ???TEMP                            */

#define  VERSION              "2.00.06"

#ifndef  DD_LEVEL
#define  DD_LEVEL             2        /* Device Driver IOCTL Function Level */
#endif

#ifndef  DDNAME
#define  DDNAME               "TOUCH"  /* Device Driver Name                 */
#endif

#ifndef  OS_VER
#define  OS_VER               20       /* Operating System Version           */
#endif

#define  SESN_INIT            0
#define  SESN_SHELL           1
#define  SESN_POPUP           3
#define  EQ_MAX               100      /* event queue max elements           */
#define  FSG_MAX              16       /* max number full screen groups      */
#define  VSG_BLK              5        /* number virtual screen groups in a
                                          block                              */

/*
** ??? pass across in int packet or config data
*/
#define  X_MAX                4095     /* device x range                     */
#define  Y_MAX                4095     /* device y range                     */
#define  Z_MAX                255      /* device z range                     */

#define  OK                   0
#define  ERROR                1

#define  SAVEREGS             _saveregs
#define  LOADDS               _loadds
#define  CDECL                _cdecl
#define  REG                  register
#define  public

#define  TDI_SEL_MMAX         5        /* max allowed method value           */
#define  TDI_SEL_PMAX         40       /* max allowed num points             */
#define  TDI_SEL_TMAX         4095     /* max allowed tolerance value        */
#define  TDI_SEL_SMAX         40       /* max allowed search limit           */
#define  TDI_MASK_BITS        0x803f   /* allowed bits                       */
#define  TDI_READ_BITS        3        /* allowed bits                       */
#define  TDI_EMUL_MAX         1
#define  TDI_QSIZE_MAX        100

/*
** messages
*/
#pragma  message("*** Version " VERSION)

#ifdef   DEBUG
#pragma  message("*** DEBUG Enabled")
#define  STATIC
#else
#define  STATIC                        /* static                             */
#endif


#endif                                 /* TOUDEFS_INCLUDED                   */

/*
** end
*/
