/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME: PRTPCI.H                                               */
/*                                                                            */
/*   DESCRIPTIVE NAME: PRinTer device driver PCI support Header file          */
/*                                                                            */
/*   FUNCTION: Header file to provide PCI support in the parallel port device */
/*             driver.                                                        */
/*                                                                            */
/*   NOTES:                                                                   */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: None                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES: None                                                */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          01/02/12  LR              PCI support                             */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#define  INCL_NOPMAPI
#define  INCL_DOSDEVICES
#define  INCL_DOSDEVIOCTL
#define  INCL_NOXLATE_DOS16
#include <os2.h>
#include <dhcalls.h>
#include <devcmd.h>
#include <strat2.h>
#include <reqpkt.h>

#define  PCI_PP_MAX       3   // MAXimum number of PCI Parallel Ports supported
                              // = MAXPRINTERS in PRTDD.INC
#define  IRQ15           15   // MAXimum IRQ number

#define  PORTEXISTS  0x0400   // port hardware exists ((common)flags1)
#define  USEPOLLING  0x4000   // if set use task time polling ((common)flags)
#define  INT_PENDING   0x04   // mask for the interrupt pending bit in the PCI PP status register
/*
         OEMHLP PCI Interface Subfunctions
*/   
#define  OEMHLP_QUERY_PCI_BIOS      0x00
#define  OEMHLP_FIND_PCI_DEVICE     0x01
#define  OEMHLP_FIND_PCI_CLASS      0x02
#define  OEMHLP_READ_PCI_CONFIG     0x03
#define  OEMHLP_WRITE_PCI_CONFIG    0x04

#define  PCI_BIOS_VERSION     2
/*
         PCI Class Codes
*/
#define  PCI_CLASS_COM     0x07  // COMmunications controller
#define  PCI_SUBCL_PP      0x01  // Parallel Port
#define  PCI_INTERF_SPP    0x00  // Standard Parallel Port
#define  PCI_INTERF_BIDIR  0x01  // Bi-Directional parallel port
#define  PCI_INTERF_ECP    0x02  // Extended Capabilities parallel Port
#define  PCI_INTERF_1284   0x03  // IEEE1284 controller
#define  PCI_INTERF_MAX    PCI_INTERF_1284+1
/*
         PCI Configuration Space Header registers
*/
#define  PCI_CONFIG_CMD    0x04  // Command
#define  PCI_CONFIG_BASE0  0x10  // Base address
#define  PCI_CONFIG_BASE5  0x24
#define  PCI_CONFIG_INTRPT 0x3C  // Interrupt

#define  PCI_CONFIG_BASE_IO   1UL   // I/O Base address indicator

#define  SET_SHARED_IRQ    0x011B   // shared IRQ, DevHlp_SetIRQ in DEVHLP.INC

struct   PCIPP          // PCI Parallel Port
{                       // -----------------
   UCHAR    interface;
   UCHAR    bus;
   UCHAR    devfunc;    // device (upper 5 bits) and function (lower 3 bits)
   UCHAR    irq;        // interrupt line
   UCHAR    irqpendpin; // high nibble = interrupt pending bit when an interrupt has NOT occurred
                        // low  nibble = interrupt pin
   USHORT   base;       // i/o base address
};
struct   PCIPPs         // PCI Parallel Ports
{                       // ==================   
   UCHAR        number; // of PCI parallel ports
   UCHAR        next;
   struct PCIPP pp[PCI_PP_MAX];
};
struct   OEMHLPCIParam     // OEMHLP PCI Parameter packet
{                          // ===========================
   UCHAR subfunc;          // subfunction number
   union 
   {
      struct
      {                    
         USHORT device;
         USHORT vendor;
                           // subfunction = OEMHLP_FIND_PCI_DEVICE 
      } id;                //  identification
      struct
      {
         UCHAR bus;        //    bus number
         UCHAR devfunc;    //    device (upper 5 bits) and function (lower 3 bits)
         UCHAR reg;        //    configuration register
         UCHAR size;       //    size in bytes (1, 2, 4)
                           // subfunction = OEMHLP_READ_PCI_CONFIG, OEMHLP_WRITE_PCI_CONFIG
      } conf;              //  configuration space
                           // subfunction = OEMHLP_FIND_PCI_CLASS
      ULONG class;         //  class code (base Class, Sub-class, Interface)
   };                      //  in lower 3 bytes (0x00CCSSII)
   union
   {
      UCHAR index;         // zero-based index to find identical devices
      ULONG data;          // data to be written to configuration register
   };
};
struct   OEMHLPCIData   // OEMHLP PCI Data packet
{                       // ======================
   UCHAR rc;            // return code
   union
   {
      struct
      {
         UCHAR mech;    //    hardware mechanism
         UCHAR majorV;
         UCHAR minorV;
         UCHAR bus;     //    number of last bus
                        // subfunction = OEMHLP_QUERY_PCI_BIOS
      } info;           //  information specific to the installed PCI BIOS
      struct
      {
         UCHAR bus;     //    bus number
         UCHAR devfunc; //    device (upper 5 bits) and function (lower 3 bits)
                        // subfunction = OEMHLP_FIND_PCI_DEVICE, OEMHLP_FIND_PCI_CLASS
      } loc;            //  location of device
                        // subfunction = OEMHLP_READ_PCI_CONFIG
      ULONG data;       //  data read from configuration space
   };
};
/*
   PRinTer database (printer_database in PRTDD.INC)
   
   NOTE: The following holes must be exactly enough to
         overlay the printer_database vars in PRTDD.INC.
*/
struct PRTdb
{
   UCHAR    hole0[34];
   USHORT   deviceAddr;
   UCHAR    hole1[10];
   UCHAR    intLevel;
   UCHAR    hole2[2];
   UCHAR    intP;
   USHORT   intRoutine;
   UCHAR    hole3[6];
   UCHAR    shareInt;
   UCHAR    hole4[41];
   USHORT   flags;      // commonflags
   USHORT   flags1;     // commonflags1
   UCHAR    hole5[18];
};
/*
   External data declarations
*/
extern   PFN          Device_Help;        // in PRTRM.C
                                          // in PRTEISAI.ASM
extern   IDCTABLE     OEMinfo;            //  DevHlp_AttachDD return info
extern   RP_GENIOCTL  OEMpkt;             //  IOCtl packet for OEMHLP
extern   USHORT       gPCISR[PCI_PP_MAX]; //  PCI Interrupt Service Routines (Eisa_int_routines)
                                          // in PRTDDTSK.ASM
extern   UCHAR        gNPRTs;             //  Number of PRinTers installed (numofprts)
extern   struct PRTdb gPerPRT[PCI_PP_MAX];//  Per PRinTer database (perprtarea)

