
; SCCSID = @(#)prtdd2.inc       6.17 92/01/07
;/**********************************************************************
;/*                                                                    *
;/*                       IBM/Microsoft Confidential                   *
;/*                                                                    *
;/*                 Copyright (c) IBM Corporation  1987, 1990          *
;/*                 Copyright (c) Microsoft Corp.  1987, 1990          *
;/*                           All Rights Reserved                      *
;/*                                                                    *
;/**********************************************************************
;/********************** START OF SPECIFICATIONS ***********************/
;/*                                                                    */
;/* SUBROUTINE NAME: PRTDATA                                           */
;/*                                                                    */
;/* DESCRIPTIVE NAME: PRINTER DEVICE DRIVER EQUATES AND STRUCTURES     */
;/*                                                                    */
;/*********************** END OF SPECIFICATIONS ************************/
;
; EQUATES FOR PS /2 DEVICE DRIVER
;
; FLAG2 EQUATES
PDDABIOSPS2FIX  EQU     01H             ; ABIOS SUPPORT PS/2 FIX
NEEDIRQ         EQU     02H             ; NEED TO DO SETIRQ FLAG

START_EPT       EQU     0               ; ABIOS START ENTRY POINT
INTERRUPT_EPT   EQU     1               ; ABIOS INTERRUPT ENTRY POINT
TIMEOUT_EPT     EQU     2               ; ABIOS TIMEOUT ENTRY POINT
DEVICESTATE     EQU     0               ; USED WITH GETLIDENTRY

DMAREQ          EQU     02H             ; ABIOS USING DMA ON PRTBLK REQ
;
; LID FLAGS - RETURN LID PARAMETERS
;
DMA32BIT        EQU     20H             ; 32 BIT DMA SUPPORTED (4 GB)

;
; SUPPLEMENTATL FLAGS - READ DEVICE PARMS
;
DMAPRESENT      EQU     80H             ; DMA IS AVAILABLE

;
; REQUEST FLAGS - PRINT BLOCK
;
ARBDEALLOC      EQU     80h             ; DEALLOCATE ARBITRATION LEVEL
ARBNODEALLOC    EQU     7Fh             ; DO NOT DEALLOCATE ARBITRATION LEVEL

; ABIOS FUNCTION CODES

RESUMEPRTBLK    EQU     0EH             ; RESUME PRINT BLOCK
RETDYNSTAT      EQU     0DH             ; RETURN DYNAMIC STATUS
RETPRTSTAT      EQU     0CH             ; RETURN PRINTER STATUS ABIOS FUNC
CANPRTBLK       EQU     0BH             ; CANCEL PRINT BLOCK ABIOS FUNC
PRTBLK          EQU     09H             ; PRINT BLOCK ABIOS FUNC
RESETINIT       EQU     05H             ; INITIALIZE PRINTER ABIOS FUNC
READDEVPARMS    EQU     03H             ; READ DEVICE PARAMETERS
RETLIDPARMS     EQU     01H             ; RETURN LID PARAMETERS
DEFAULTINT      EQU     00H             ; DEFAULT INTERRUPT HANDLER

; ABIOS RETURN CODES

COMPLETEDOK     EQU     0000H           ; COMPLETED OK
STAGEONINT      EQU     0001H           ; STAGE ON INT
STAGEONTIME     EQU     0002H           ; STAGE ON TIME
NOTMYINT        EQU     0005H           ; NOT MY INT
DEVICEINUSE     EQU     8000H           ; DEVICE IN USE
PRTDEVBUSY      EQU     8001H           ; DEVICE BUSY
DEVICEERROR     EQU     9000H           ; DEVICE ERROR

; DMA ABIOS RETURN CODES

DMANOTSUPP      EQU     8008H           ; DMA NOT SUPPORTED
ARBNOTAVAIL     EQU     8081H           ; ARBITRATION LEVEL NOT AVAILABLE
ARBNOTALLOC     EQU     8082H           ; ARBITRATION LEVEL NOT ALLOCATED
ARBDISABLED     EQU     8083H           ; ARBITRATION LEVEL DISABLED
TRANSINPROG     EQU     8084H           ; TRANSFER IN PROGRESS
NOTRANSINPROG   EQU     8085H           ; NO TRANSFER IN PROGRESS
NODMACHANNL     EQU     8086H           ; NO DMA CHANNEL AVAILABLE
ARBNOTDISABLED  EQU     8087H           ; ARBITRATION LEVEL NOT DISABLED
INVALIDPTRS     EQU     0C007H          ; INVALID DATA POINTERS

;
; STRUCTURES FOR PS /2 DEVICE DRIVER
;

; Functional parameters of the ABIOS request block

requestblk      STRUC
rblength        dw      0               ; LENGTH OF REQUEST BLOCK
logicalid       dw      0               ; DEVICE ADDRESSED BY REQUEST
unit            dw      0               ; COUNT OF UNITS ATTACHED
function        dw      0               ; REQUESTED OPERATION
rbflags         dw      0               ; ABIOS CALL INFORMATION
elaoffset       dw      0               ; ERROR LOGGING AREA OFFSET
retcode         dw      0               ; RESULT OF CURRENT STAGE
timeout         dw      0               ; EXPECTED DURATION OF INT (SECS)
srvspec         db      36 DUP (0)      ; SERVICE SPECIFIC INFO
requestblk      ENDS

; Service specific for function 'return LID parameters'

returnlidparms  STRUC
                db      16 DUP (?)      ; FUNCTIONAL PARAMETERS
intlvl          db      ?               ; HARDWARE INT LEVEL
                db      ?               ; ARBITRATION LEVEL
devidnum        dw      ?               ; DEVICE ID
                dw      ?               ; UNITS PER LID
lidflags        dw      ?               ; LID BIT LEVEL INFO
rblen           dw      ?               ; REQUEST BLOCK LENGTH
subid           db      ?               ; SUB DEVICE IDENTIFIER
revnum          db      ?               ; REVISION NUMBER
                db      4 dup (?)       ; RESERVED
returnlidparms  ENDS

; Service specific for function 'read device parameters'

readevparms     STRUC
                db      22 dup (?)      ; FUNCTIONAL PARAMETERS
suppflags       db      ?               ; SUPPLEMENTAL FLAGS
                db      9 dup (?)       ; WORK AREA
inittime        dd      ?               ; DEVICE INITIALIZATION TIME
                db      6 DUP (?)       ; WORK AREA
tovalue         dw      ?               ; TIMEOUT VALUE
                db      8 DUP (?)       ; WORK AREA
readevparms     ENDS

; Service specific for function 'initialize printer'

initprt         STRUC
                db      32 DUP (?)      ; FUNCTIONAL PARAMETERS
init_time_l     dw      ?               ; INITIALIZATION WAIT TIME LOW
init_time_h     dw      ?               ; INITIALIZATION WAIT TIME HIGH
                db      4 DUP (?)       ; RESERVED
initstatus      db      ?               ; PRINTER STATUS
                db      11 DUP (?)      ; RESERVED
initprt         ENDS

; Service specific for function 'print block'

printblk        STRUC
                db      16 DUP (?)      ; FUNCTIONAL PARAMETERS
dataoff32       dw      ?               ; 32 BIT OFFSET ENABLED
dataoff         dw      ?               ; DATA POINTER OFFSET
dataseg         dw      ?               ; DATA POINTER SEGMENT
reqflags        db      ?               ; REQUEST FLAGS
                db      3 DUP (?)       ; RESERVED
dataoff1        dw      ?               ; DMA DATA POINTER OFFSET
dataseg1        dw      ?               ; DMA DATA POINTER SEGMENT
                db      6 DUP (?)       ; RESERVED
count           dw      ?               ; # OF BYTES TO PRINT
countsent       dw      ?               ; # OF BYTES PRINTED
blkstatus       db      ?               ; PRINTER PORT STATUS
                db      3 DUP (?)       ; RESERVED
errlength       db      ?               ; ERROR LOGGING AREA LENGTH
prtint          db      ?               ; HARDWARE INT LEVEL
prtarb          db      ?               ; ARBITRATION LEVEL
prtdevid        dw      ?               ; DEVICE ID
prtdiag1        db      ?               ; PRINTER STATUS PORT STATUS
                db      2 DUP (?)       ; WORK AREA
printblk        ENDS

; Service specific for function 'return printer status'

retstatus       STRUC
                db      40 DUP (?)      ; FUNCTIONAL PARAMETERS
returnstatus    db      ?               ; PRINTER PORT STATUS
                db      11 DUP (?)      ; RESERVED
retstatus       ENDS

hardware_specific       STRUC           ; HARDWARE SPECIFIC DATA AREA

;*****************************************************************************
;*  N O T E !!!!: The following DUP must be exactly enough to "overlay"      *
;*                the printer_database common vars in prtdd.inc              *
;*****************************************************************************

                db      40 DUP (0)      ; DEVICE DRIVER INDEPENDENT VARAIBLES

;*****************************************************************************
;*  N O T E !!!!: Do not add any members below without checking that it      *
;*                does not "overflow" the hardware_specific "hole" in        *
;*                prtdd.inc's printer_database structure                     *
;*****************************************************************************

nextppda        dw      0               ; NEXT PERPRTDATA AREA
abiosrb_off     dw      0               ; OFFSET OF ABIOS REQUEST BLOCK
initialcount    dw      0               ; INITIAL COUNT OF CHARACTERS TO PRINT
printedcnt      dw      0               ; # OF CHARACTERS PRINTED
intlevel        db      0               ; HARDWARE INTERRUPT LEVEL
                db      0               ; FUTURE USE - KEEPS WORD ALIGNMENT
retryctr        dw      0               ; RETRY IF DEVICE IS BUSY
kstimercnt      dw      0               ; WAIT COUNT BEFORE LOST IRQ7
inittime_lo     dw      0               ; LOW WORD DEVICE INITIALIZE TIME IN MS
inittime_hi     dw      0               ; HIGH WORD DEVICE INITIALIZE TIME IN MS
prfvw_off       dw      0               ; OFFSET OF PERFVIEW COUNTERS
hardware_specific       ENDS

