;******************************************************************************
;*
;*                              File SSPCIC.INC
;*
;*                           PCIC related definitions
;*
;*            Copyright (c) Award Software International Inc., 1994
;*
;*
;******************************************************************************

ifndef   __SSPCIC_INC_
__SSPCIC_INC_    equ     1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                            Description of Windows
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PCIC_MEMWIN_PER_SKT     equ     5
PCIC_IOWIN_PER_SKT      equ     2
PCIC_WIN_PER_SKT        equ     PCIC_MEMWIN_PER_SKT + PCIC_IOWIN_PER_SKT

VLSI_SOCKET0            equ     000h        ; Slot A start register
VLSI_SOCKET1            equ     080h        ; Slot B start register
VLSI_SOCKET2            equ     000h        ; Slot C start register
VLSI_SOCKET3            equ     080h        ; Slot D start register
VLSI_SKTINC             equ     80h         ; VLSI Socket Offset Increment
PCIC_SKTINC             equ     40h         ; PCIC Socket Offset Increment

;------------------------------ Window management -----------------------------

PCIC_WINDOW             equ     6           ; PCIC Window control
PCIC_WINDOW_A23A12      equ     00100000b   ; Decode A23-A12

;---------------------------- Windows Capabilities ----------------------------

PCIC_MEMWINCAPS         equ     WC_COMMON OR WC_ATTRIBUTE OR WC_WAIT
PCIC_IOWINCAPS          equ     WC_IO OR WC_WAIT

PCIC_IWCAP              equ     WC_BALIGN OR WC_16BIT OR WC_8BIT OR WC_WENABLE OR WC_SIZE OR WC_BASE
PCIC_MWCAP              equ     WC_WP OR WC_16BIT OR WC_8BIT OR WC_WENABLE OR WC_SIZE OR WC_BASE

PCIC_MGRAN              equ     S4K         ; All Values below expressed
                                            ; as multiples of 4K.


PCIC_MADDR_F            equ     S64K /PCIC_MGRAN    ; First Addressable Byte (64 KB)
VLSI_MADDR_L            equ     (S64M-PCIC_MGRAN)/PCIC_MGRAN  ; Last  Addressable Byte (16 MB - 1)
PCIC_MSIZE_MIN          equ     S4K / PCIC_MGRAN    ; Minimum window size (4 KB)
VLSI_MSIZE_MAX          equ     (S64M - S64K)/PCIC_MGRAN    ; Maximum window size (16 MB - 64 KB)
PCIC_MREQGRAN           equ     S4K/PCIC_MGRAN      ; Required window size granularity (4 KB)
PCIC_MBASE              equ     S4K/PCIC_MGRAN      ; Required base address alignment (4 KB)
PCIC_MOFFSET            equ     S4K/PCIC_MGRAN      ; Required card offset alignment (4 KB)

PCIC_IADDR_F            equ     100h        ; First addressable byte
PCIC_IADDR_L            equ     0FFFFh      ; Last  addressable byte
PCIC_ISIZE_MIN          equ     1           ; Minimum window size
PCIC_ISIZE_MAX          equ     400h        ; Maximum window size
PCIC_IREQGRAN           equ     1           ; Required window size granularity
PCIC_IADDLINES          equ     16          ; Number of address line decoded (Sixteen)
PCIC_IEISA              equ     0           ; Upper byte of EISA I/O addr lines (N/A)

;------------------------------- Memory Windows -------------------------------

PCIC_MEMWIN0            equ     10h         ; First Memory Window offset
PCIC_MEMWININC          equ     8           ; Memory Window Offset inc.

PCIC_MEMWIN_STR_H       equ     01h         ; Start Address High byte
PCIC_MEMWIN_STR_L       equ     00h         ; Start Address Low byte
PCIC_MEMWIN_END_H       equ     03h         ; End Address High byte
PCIC_MEMWIN_END_L       equ     02h         ; End Address Low byte
PCIC_MEMWIN_OFF_H       equ     05h         ; Offset Address High byte
PCIC_MEMWIN_OFF_L       equ     04h         ; Offset Address Low byte

PCIC_MEMWIN_M16         equ     10000000b   ; Use 16-bit access
PCIC_MEMWIN_0WS         equ     01000000b   ; Assert 0 WS for 8 bit window
PCIC_MEMWIN_WS          equ     11000000b   ; Wait state mask
PCIC_MEMWIN_ATTR        equ     01000000b   ; Attribute memory window
PCIC_MEMWIN_WP          equ     10000000b   ; Window is write protected

PCIC_MEMWIN_MSK         equ     0FFFh       ; Address mask in registers
VLSI_MEMWIN_MSK         equ     3FFFh       ; Address mask in registers
PCIC_MEMWIN_OMSK        equ     3FFFh       ; Address mask on the card

;--------------------------------- I/O Windows --------------------------------

PCIC_IOWIN_CTRL         equ     07h         ; I/O windows control base
PCIC_IOWIN0             equ     08h         ; First Memory Window offset
PCIC_IOWININC           equ     4           ; Memory Window Offset inc.

PCIC_IOWIN_STR_H        equ     01h         ; Start Address High byte
PCIC_IOWIN_STR_L        equ     00h         ; Start Address Low byte
PCIC_IOWIN_END_H        equ     03h         ; End Address High byte
PCIC_IOWIN_END_L        equ     02h         ; End Address Low byte

PCIC_IOWIN_WS           equ     00001000b   ; Mask wait states
PCIC_IOWIN_0WS          equ     00000100b   ; Assert 0 WS
PCIC_IOWIN_IO16SR       equ     00000010b   ; If 1 -IOCS16 generated based on
                                            ; Card -IOIS16 signel. Otherwise
                                            ; based on value of
                                            ; PCIC_IOWIN_IO16 bit
PCIC_IOWIN_IO16         equ     00000001b   ; Mask I/O 16 bit

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                Description of sockets and adapter
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;----------------------------- Socket capabilities ----------------------------

PCIC_SKT_SCI_CAP        equ     SBM_CD OR SBM_RDYBSY OR SBM_BVD2 OR SBM_BVD1
                                            ; Status Change Interrupt Caps
                                            ; SBM_CD:     Card Detect
                                            ; SBM_RDYBSY: Ready/Busy
                                            ; SBM_BVDx:   Battery Voltage
PCIC_SKT_SCR_CAP        equ     SBM_CD OR SBM_RDYBSY OR SBM_BVD2 OR SBM_BVD1 OR SBM_WP
                                            ; Status Change Reporting Caps
                                            ; SBM_WP:     Write Protect
PCIC_SKT_CI_CAP         equ     00h         ; Control and Indicators Caps

PCIC_SC_IRQSH           equ     1101111010111000b   ; Valid Status change IRQ's (High)
PCIC_SK_IRQSH           equ     1101111010111000b   ; Valid Socket IRQ's        (High)
PCIC_SC_IRQSL           equ     0           ; Valid Status change IRQ's (Low)
PCIC_SK_IRQSL           equ     0           ; Valid Socket IRQ's        (Low)

;-------------------------------- Default State -------------------------------

PCIC_DEF_SCIRQ          equ     0h OR IRQ_HIGH  ; IRQ is not selected


PCIC_DEF_IRQ            equ     0h OR IRQ_HIGH  ; IRQ is not selected
PCIC_DEF_CTLIND         equ     0           ; Nothing

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                     Intel PCIC Step C Compatibility Level
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;------------------------- Identification and revision ------------------------

PCIC_IDENT              equ     0           ; Identification & Revision reg

PCIC_IDENT_REVMASK      equ     00001111b   ; Revision mask
PCIC_IDENT_CARDMASK     equ     11000000b   ; Card type ID mask

PCIC_IDENT_CARD_IO      equ     00000000b   ; I/O Card only
PCIC_IDENT_CARD_MEM     equ     01000000b   ; Memory card only
PCIC_IDENT_CARD_MEMIO   equ     10000000b   ; Memory and I/O card

;------------------------------ Interface Status ------------------------------

PCIC_IFSTAT             equ     1           ; Interface Status Register

PCIC_IFSTAT_BVDMASK     equ     00000011b   ; Battery voltage detect
PCIC_IFSTAT_CDMASK      equ     00001100b   ; Card detect
PCIC_IFSTAT_WP          equ     00010000b   ; Memory write protected
PCIC_IFSTAT_RDYBSY      equ     00100000b   ; Ready/Busy
PCIC_IFSTAT_POWERACT    equ     01000000b   ; Power active
PCIC_IFSTAT_GPI         equ     10000000b   ; General purposes Input

;-------------------------------- Power control -------------------------------

PCIC_POWER              equ     2           ; Power control register

PCIC_POWER_VPPMASK      equ     00000011b   ; Vpp1 mask
PCIC_POWER_GP_OUTPUT    equ     00000100b   ; General purpose output
PCIC_POWER_VCCMASK      equ     00011000b   ; Card Power enable
PCIC_POWER_AUTO         equ     00100000b   ; Auto power switch enabled
PCIC_POWER_DISRESET     equ     01000000b   ; Disable RESETDRV
PCIC_POWER_ENOUTPUT     equ     10000000b   ; Output enabled

PCIC_MAX_PWR_ENTRIES    equ     4           ; Number of Power levels supported
                                            ; by PCIC step C

PCIC_POWER_VCC_5V       equ     00010000b   ; 5V Interface
PCIC_POWER_VCC_3V       equ     00011000b   ; 3.3V Interface

PCIC_POWER_VPP_0V       equ     00000000b   ; Vpp = 0V
PCIC_POWER_VPPEQVCC     equ     00000001b   ; Vpp = Vcc
PCIC_POWER_VPP_12V      equ     00000010b   ; Vpp = 12V

;------------------------ Interrupt and General control -----------------------

PCIC_INTER              equ     3           ; Interrupt & General control

PCIC_INTER_SKIRQ        equ     00001111b   ; Socket IRQ
PCIC_INTER_INTR         equ     00010000b   ; INTR Enable
PCIC_INTER_CARDIO       equ     00100000b   ; PC Card Type
PCIC_INTER_RESET        equ     01000000b   ; PC Card RESET
PCIC_INTER_RING         equ     10000000b   ; Ring Indicate Enable

PCIC_RESET_PULSE        equ     1           ; Minimum Reset pulse width mSecs

;------------------------- Card Status Change register ------------------------

PCIC_STATE              equ     4           ; Card Status Change register

PCIC_STATE_BATDEAD      equ     00000001b   ; Battery Dead
PCIC_STATE_BATWARN      equ     00000010b   ; Battery warning
PCIC_STATE_READY        equ     00000100b   ; Ready change
PCIC_STATE_CD           equ     00001000b   ; Card detect change
PCIC_STATE_GPI          equ     00010000b   ; GPI Change

;------------------------ Card Status Change Interrupt ------------------------

PCIC_SCINT              equ     5           ; Card Status Change Interrupt

PCIC_SCINT_BATDEAD      equ     00000001b   ; Battery dead enabled
PCIC_SCINT_BATWARN      equ     00000010b   ; Battery warn enabled
PCIC_SCINT_READY        equ     00000100b   ; Ready change enabled
PCIC_SCINT_CD           equ     00001000b   ; Card detect enabled
PCIC_SCINT_IRQ          equ     11110000b   ; Status change IRQ for the socket

;--------------------- Card Detect and General Control Reg --------------------

PCIC_CDGCR              equ     16h         ; Card Detect and General Control Reg

PCIC_CDGCR_16BITMDI     equ     00000001b   ; 16-bit Memory Delay Inhibit
PCIC_CDGCR_REMRESET     equ     00000010b   ; Card Removal reset
PCIC_CDGCR_GPIEN        equ     00000100b   ; GPI Enable
PCIC_CDGCR_GPECTL       equ     00001000b   ; GPI Control
PCIC_CDGCR_CDRES        equ     00010000b   ; Card Detect resume
PCIC_CDGCR_SWCDINT      equ     00100000b   ; Software Card Detect Interrupt

;----------------------------- Global Control Reg  ----------------------------

PCIC_GLOBL              equ     1Eh         ; Global control register
PCIC_GLOBL_PWRDN        equ     00000001b   ; Power down mode
PCIC_GLOBL_CSCMODE      equ     00000010b   ; Level mode interrupt enable
PCIC_GLOBL_CSCIAK       equ     00000100b   ; Explicit write back PCIC_STATE Reg
PCIC_GLOBL_IRQA         equ     00001000b   ; Sock A: EISA Level triggered mode
PCIC_GLOBL_IRQB         equ     00010000b   ; Sock B: EISA Level triggered mode

; VLSI Registers:
;
; ͻ
;  Slot  Index  Data  Ind. Range  Ext. Index  Ext. Data  Ext. Range 
; ͹
;   0     3E0   3E1    00 - 3F       83E0       83E1      00 - 7F   
; Ķ
;   1     3E4   3E5    80 - BF       83E4       83E5      80 - FF   
; Ķ
;   2     3E2   3E3    00 - 3F       83E2       83E3      00 - 7F   
; Ķ
;   3     3E6   3E7    80 - BF       83E6       83E7      80 - BF   
; ͼ

PCIC_VLSI_EXTBASE_SHIFT equ     8000h       ; Shift from Base to extended base

;-------------------- Exetended address register 0, 2, 3 ---------------------

PCIC_VLSI_EADD0         equ     0           ; Exetended address register 0
PCIC_VLSI_EADD1         equ     1           ; Exetended address register 1
PCIC_VLSI_EADD2         equ     2           ; Exetended address register 2

PCIC_VLSI_EADDR_STOP    equ     00000011b   ; Window n Stop  A24, A25
PCIC_VLSI_EADDR_START   equ     00001100b   ; Window n Start A24, A25
PCIC_VLSI_EADD2_ENABLE  equ     00010000b   ; Extended address enabled

;----------------------- SCLK and Chip Select control ------------------------

PCIC_VLSI_CHSEL         equ     3           ; SCLK and Chip Select control

PCIC_VLSI_CHSEL_CLKSEL  equ     00000001b   ; Serial Bus Clock (SINTCLK) Divisor
                                            ; If   set PCMCIA CLK = SINTCLK/2
                                            ; If reset PCMCIA CLK = SINTCLK/3
PCIC_VLSI_CHSEL_CS      equ     00000010b   ; Chip select: if 0 - normal mode
                                            ; If 1, chip is capable to enter
                                            ; into low power mode while Vcc is
                                            ; still on
PCIC_VLSI_CHSEL_VS1     equ     00000100b   ; Voltage sense signal 1: will be
                                            ; low for a 3.3V card resides in
                                            ; mixed voltage socket. Otherwise:
                                            ; high
PCIC_VLSI_CHSEL_LBADLY  equ     00001000b   ; MLLBA# Delay select

;----------------------- Card status change SMI config -----------------------

PCIC_VLSI_CSSMI         equ     4           ; Card status change SMI config

PCIC_VLSI_CSSMI_BD_EN   equ     00000001    ; Battery Dead    enabled
PCIC_VLSI_CSSMI_BW_EN   equ     00000010    ; Battery Warning enabled
PCIC_VLSI_CSSMI_RDYEN   equ     00000100    ; Ready detect    enabled
PCIC_VLSI_CSSMI_CD_EN   equ     00001000    ; Card Detect     enabled
PCIC_VLSI_CSSMI_SMIEN   equ     00010000    ; SMI             enabled

;------------------------ Programmable I/O registers -------------------------

PCIC_VLSI_PIOAA         equ     5           ; Programmable I/O register: PIOAA
                                            ; I/O Address bits 15 - 08
PCIC_VLSI_PIOAB         equ     6           ; Programmable I/O register: PIOAB
                                            ; I/O Address bits 07 - 00
PCIC_VLSI_PIODM         equ     7           ; Programmable I/O register: PIODM
                                            ; Data mask
;------------------------------ Adapter structure -----------------------------

MAX_ADAPTERS    equ     4                   ; Max adapters supported
MAX_SOCKETS     equ     4                   ; Max sockets supported (Per
                                            ; adapter)

ADP_DATA        STRUCT                      ; Adapter data

wBasePort       dw      ?                   ; Base address of PCIC
wNumEDCs        dw      ?                   ; Number of EDC generators on adapter
bNumWindows     db      ?                   ; Number of windows on adapter
bNumSockets     db      ?                   ; Number of sockets on adapter
bSCIRQLevel     db      ?                   ; Status change interrupt routing
bCntrlInd       db      ?                   ; Control and Indicators (sharable)
bInstState      db      MAX_SOCKETS DUP (?) ; Saved instantaneous card state
                                            ; This storage collect most recent
                                            ; socket state
bSktChanges     db      MAX_SOCKETS DUP (?) ; Pending socket state (per socket)
                                            ; This storage collect socket
                                            ; state changes
bSCIRQMask      db      MAX_SOCKETS DUP (?) ; Socket reporting mask
bSktIRQLevel    db      MAX_SOCKETS DUP (?) ; IREQ routing (per socket)
bSktIFType      db      MAX_SOCKETS DUP (?) ; Interface Type
ADP_DATA        ENDS

;-------------------------- Stack arguments structure -------------------------

ARGS            STRUCT                      ; Entry/Exit stack frame

bSocketIdx      BYTE    ?                   ; Index for indirectly addressed
                                            ; registers
bWindowIdx      BYTE    ?                   ; Index for indirectly addressed
                                            ; registers
bSocketNum      BYTE    ?                   ; Appropriate socket for specified
                                            ; window
bWindowNum      BYTE    ?                   ; Window number on socket (base
                                            ; zero)
bWindowType     BYTE    ?                   ; WIN_MEM or WIN_IO

DYN_SIZE        =       $                   ; Dynamic data per request

BPReg           WORD    ?                   ; Registers on stack
ESReg           WORD    ?
DSReg           WORD    ?
DIReg           WORD    ?
SIReg           WORD    ?
                UNION
   DXReg        WORD    ?
   STRUCT
     DLReg      BYTE    ?
     DHReg      BYTE    ?
   ENDS
                ENDS
                UNION
   CXReg        WORD    ?
   STRUCT
     CLReg      BYTE    ?
     CHReg      BYTE    ?
   ENDS
                ENDS
                UNION
   BXReg        WORD    ?
   STRUCT
     BLReg      BYTE    ?
     BHReg      BYTE    ?
   ENDS
                ENDS
                UNION
   AXReg        WORD    ?
   STRUCT
     ALReg      BYTE    ?
     AHReg      BYTE    ?
   ENDS
                ENDS

ARGS            ENDS

;-------------------------------- Timer control -------------------------------

TIMER0          equ     40h
TIM_CTL         equ     43h

;------------------------- Socket reporting capacities ------------------------

SKT_CAP         STRUCT
SCIntCaps       BYTE    ?                   ; Events, which can trigger SC int.
SCRptCaps       BYTE    ?                   ; Status change events, which
                                            ; could be reported
SCIndCaps       BYTE    ?                   ; Control and indicatior capabilities
SKT_CAP         ENDS

WIN_MEM         equ     0
WIN_IO          equ     1

;--------------------------------- Constantes ---------------------------------

; On some controllers (e.g. IBM ThinkPad 750Cs) power on and power up produce
; some of strange side effects. In order to avoid this, we switch interrupts
; off before operation and switch them back after small delay.


POWER_DEAD_TIME equ     2                   ; Note: Our test shows, that 1 ms is
                                            ; enough. We put 2 for additional
                                            ; security
MSG_ON          equ     1
MSG_OFF         equ     0

;---------------------------- PCIC Public Functions ---------------------------

EXTERNDEF  couDelay:near                    ; Insert Delay in ms
EXTERNDEF  couIsValidSpeed:near             ; Check, if speed is valid
EXTERNDEF  couCompSpeed:near                ; Compare 2 speeds
EXTERNDEF  couCopyInfo:near                 ; Copy info to user buffer
EXTERNDEF  couStrLen:near                   ; Put in cx length of es:di ASCIIZ
EXTERNDEF  couGetHex:near                   ; Return Hex parameter value
EXTERNDEF  couGetToken:near                 ; Return next command line Token
                                            ; (Vcc = Vpp = 5V) to power indexes

EXTERNDEF  codCommon16:far                  ; Common 16-bit entry point
EXTERNDEF  codRM_Entry:far                  ; 16:16 mode entry point

EXTERNDEF  AdjustIndx:near                  ; Adjust socket index and base port
EXTERNDEF  GetReg:near                      ; Get register
EXTERNDEF  SetReg:near                      ; Set register
EXTERNDEF  GetInstSktState:near             ; Return socket state
EXTERNDEF  PowerTable:word                  ; Adapter power table
EXTERNDEF  GetAdapterCnt:near               ; PCMCIA Defined Function
EXTERNDEF  GetSSInfo:near                   ; PCMCIA Defined Function
EXTERNDEF  GetVendorInfo:near               ; PCMCIA Defined Function
EXTERNDEF  AckInterrupt:near                ; PCMCIA Defined Function
EXTERNDEF  ValidateArgs:near                ; PCMCIA Defined Function
EXTERNDEF  ValidateIRQ:NEAR                 ; PCMCIA Defined Function
EXTERNDEF  InquireAdapter:near              ; PCMCIA Defined Function
EXTERNDEF  InquireSocket:near               ; PCMCIA Defined Function
EXTERNDEF  GetAccessOffs:near               ; PCMCIA Defined Function
EXTERNDEF  GetAdapter:near                  ; PCMCIA Defined Function
EXTERNDEF  SetAdapter:near                  ; PCMCIA Defined Function
EXTERNDEF  GetSocket:near                   ; PCMCIA Defined Function
EXTERNDEF  SetSocket:near                   ; PCMCIA Defined Function
EXTERNDEF  GetStatus:near                   ; PCMCIA Defined Function
EXTERNDEF  ResetSocket:near                 ; PCMCIA Defined Function

EXTERNDEF  Adapters:ADP_DATA                ; Area of adapter structures
EXTERNDEF  bFirstAdapter:byte               ; First adapter number
EXTERNDEF  bNumAdapters:byte                ; Number of adapters
EXTERNDEF  bTotAdapters:byte                ; Total adapters in system
EXTERNDEF  bLastAdapter:byte                ; Last adapter handled by this SS

EXTERNDEF  covValidateIRQ:near              ; Validate IRQ level
EXTERNDEF  covValidatePw:near               ; Validate Power level
EXTERNDEF  covValidateIFt:near              ; Validate Interface type

EXTERNDEF  coiInitSS:far                    ; Adapter specific INIT

EXTERNDEF  cowIsWinEnabled:near             ; Return NZ, if window enabled
EXTERNDEF  cowDisableWindow:near            ; Disable Window
EXTERNDEF  cowEnableWindow:near             ; Enable  Window
EXTERNDEF  CalcWndIndex:near                ; Calculate Window Index
EXTERNDEF  InquireWindow:near               ; PCMCIA Defined Function
EXTERNDEF  GetWindow:near                   ; PCMCIA Defined Function
EXTERNDEF  SetWindow:near                   ; PCMCIA Defined Function
EXTERNDEF  GetPage:near                     ; PCMCIA Defined Function
EXTERNDEF  SetPage:near                     ; PCMCIA Defined Function

EXTERNDEF  _osPrintString:near              ; Print NULL terminated string
EXTERNDEF  _osPrintChar:near                ; Print character

EXTERNDEF  osOKtoLoad:near                  ; Check, if SS could be load

EXTERNDEF  GetSetSSAddr:near                ; PCMCIA Defined Function
EXTERNDEF  GetSetPrior:near                 ; PCMCIA Defined Function

EXTERNDEF  osMsgFlag:byte                   ; Screen output


endif                                       ; __SSPCIC_INC_
