/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CONFIG.C
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION =
 *
 * DATE
 *
 * DESCRIPTION This file contains routines that process and store configuration
 *             info for the system.
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "types.h"
#include "config.h"

    /*
    ** private function prototypes
    */
short store_socket_assignments(char far *, USHORT far *,
                               USHORT far *, USHORT, USHORT);

    /*
    ** external global variables
    */
CONFIG_INFO Config_info;


/****************************************************************************
 *
 * FUNCTION NAME = store_config_info
 *
 * DESCRIPTION   = This function checks the syntax of the command line
 *                 arguments and stores configuration information.
 *                 The parameter 'argc' contains the number of arguments
 *                 on the command line and the parameter 'argv' contains a
 *                 pointer to an array of pointers to null terminated ascii
 *                 strings containing the arguments.
 *                 The function returns 0 if successful. Otherwise, a value
 *                 less than 0 is returned indicating the error condition.
 *
 * INPUT         =
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 ****************************************************************************/

short store_config_info(short argc, char **argv,  USHORT num_of_sockets)
{
    USHORT i;
    USHORT io_address[MAX_NUM_IO_ADDRESSES];
    USHORT irq_num[MAX_NUM_IO_ADDRESSES];

        /* set up default modem type - intel compatable - isa bus - no
        ** socket assignments
        */
    for (i = 0; i <= MAX_NUM_IO_ADDRESSES - 1; i++)
    {
        Config_info.com_port_num[i] = 0;
        Config_info.io_address[i] = 0;
        Config_info.irq_num[i] = 0;
    }

        /* get io addresses and irq numbers based on bus type
        */
    io_address[0] = 0x3f8;
    irq_num[0] = 4;
    io_address[1] = 0x2f8;
    irq_num[1] = 3;
    io_address[2] = 0x3e8;
    irq_num[2] = 4;
    io_address[3] = 0x2e8;
    irq_num[3] = 3;
    Config_info.num_of_io_addresses = 4;

        /* get io addresses and irq numbers based on bus type
        */
    io_address[0] = 0x3f8;
    irq_num[0] = 4;
    io_address[1] = 0x2f8;
    irq_num[1] = 3;
    io_address[2] = 0x3e8;
    irq_num[2] = 4;
    io_address[3] = 0x2e8;
    irq_num[3] = 3;
    Config_info.num_of_io_addresses = 4;

        /* return failure if too many or too few arguments
        */
    if ((argc != 2))
        return(-1);

        /* store socket assignment info
        */
    return(store_socket_assignments((char far *) argv[1],
                                    (USHORT far *) io_address,
                                    (USHORT far *) irq_num,
                                    Config_info.num_of_io_addresses,
                                    num_of_sockets));
}

/****************************************************************************
 *
 * FUNCTION NAME = short store_socket_assignments
 *
 * DESCRIPTION   = This function stores io address, irq number, and com port
 *                 number information based on the information in the socket
 *                 socket assignment string.
 *                 The parameter 'strP' contains a pointer to a null terminated
 *                 string containing the socket assignment information. The
 *                 parameter 'io_addressP' is the address of an array containing
 *                 i/o addresses for the present configuration. The parameter
 *                 'irq_numP' is the address of an array containing the irq
 *                 numbers for the present configuratuion. The parameter
 *                 'num_of_io_addresses' contains the number of io addresses
 *                 for the present configuration.
 *                 The function returns 0 if successful. Otherwise, a value
 *                 less than 0 is returned indicating the error condition.
 *
 * INPUT         =
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 ****************************************************************************/

static short store_socket_assignments(char far *strP,
                                      USHORT far *io_addressP,
                                      USHORT far *irq_numP,
                                      USHORT num_of_io_addresses,
                                      USHORT num_of_sockets)

{
    USHORT i, socket_num, com_port_num;

    while (1)
    {
        for (i = 1; i <= 4; i++)
        {
            switch (i)
            {
                case 1:
                    if ((*strP != 'S') && (*strP != 's'))
                        return(-1);
                    strP++;
                    break;
                case 2:
                    socket_num = *strP - '0';
                    if ((socket_num < 1) || (socket_num > num_of_sockets))
                        return(-1);
                    strP++;
                    break;
                case 3:
                    if ((*strP != 'C') && (*strP != 'c'))
                        return(-1);
                    strP++;
                    break;
                case 4:
                    com_port_num = *strP - '0';
                    if ((com_port_num < 1) ||
                                (com_port_num > num_of_io_addresses))
                        return(-1);
                    Config_info.com_port_num[socket_num - 1] = com_port_num;
                    Config_info.io_address[socket_num - 1] =
                                          *(io_addressP + com_port_num - 1);
                    Config_info.irq_num[socket_num - 1] =
                                          *(irq_numP + com_port_num - 1);
                    strP++;
                    break;
            }
        }
        if (*strP == '\0')
            return(0);
        if (*strP != ',')
            return(-1);
        strP++;
    }
}
