/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CARD_ID
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION =
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "types.h"
#include "card_id.h"

   /*
   ** private global variables
   */
static UCHAR modem_id[CARD_ID_LEN] = {0x49, 0x6e, 0x74, 0x65, 0x6c, 0x00,
                                      0x4d, 0x4f, 0x44, 0x45, 0x4d, 0x20,
                                      0x32, 0x34, 0x30, 0x30, 0x2b, 0x00,
                                      0x69, 0x4e, 0x43, 0x31, 0x31, 0x30,
                                      0x55, 0x53, 0x00, 0x43, 0x4f, 0x4d,
                                      0x50, 0x41, 0x54, 0x49, 0x42, 0x4c,
                                      0x45, 0x20, 0x49, 0x42, 0x4d, 0x20,
                                      0x43, 0x6f, 0x72, 0x70, 0x2e};


/****************************************************************************
 *
 * FUNCTION NAME = correct_card_id
 *
 * DESCRIPTION   =
 *
 * INPUT         =
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 ****************************************************************************/

BOOL correct_card_id(UCHAR far *dataP)
{
    USHORT i;

    for (i = 0; i <= CARD_ID_LEN - 1; i++)
    {
        if (*(dataP + i) != modem_id[i])
            break;
    }

    if (i == CARD_ID_LEN)
        return(TRUE);

    return(FALSE);
}
