/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/parallel/par1284/parstate.h, par1284, c.basedd, 10.030 98/09/16" */
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  PARSTATE.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  PARALLEL port device driver state machine include     */
/*                      file.                                                 */
/*                                                                            */
/*   FUNCTION: This module is the PARALLEL port device driver state machine   */
/*             include file. This module contains states for the inner and    */
/*             outer state machines and defines the ADD internal return codes.*/
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/03/01  Frank Schroeder                                         */
/* 203787   98/09/16  Vince Rapp      Added new negotiation state to prevent  */
/*                                    a hang during init on non-par1284 hw.   */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/*-------------------*/
/* states - parneg.c */
/*-------------------*/
typedef enum
{
  NEGS_INIT,
  NEGS_RESET1284_0,
  NEGS_RESET1284_1,
  NEGS_RESET1284_2,
  NEGS_RESET1284_3,
  NEGS_START,
  NEGS_WAIT_CLKREADY,                    // 203798
  NEGS_ACK1284,
  NEGS_RESPONSE,
  NEGS_ECP_SETUP,
  NEGS_WAIT_ACKREVERSE_HIGH,
  NEGS_STATE_0,
  NEGS_COMPLETE

} neg_states_t;

/*-------------------*/
/* states - parspp.c */
/*-------------------*/
typedef enum
{
  WSPP_INIT,
  WSPP_INTERRUPT,
  WSPP_POLLED,
  WSPP_COMPLETE

} spp_write_states_t;

/*-------------------*/
/* states - parfpp.c */
/*-------------------*/
typedef enum
{
  RNS_INITIAL,
  RNS_WAIT_DATAAVAIL,
  RNS_SET_HOSTBUSY_HIGH,
  RNS_SET_HOSTBUSY_LOW,
  RNS_WAIT_PTRCLK_LOW,
  RNS_WAIT_PTRCLK_HIGH,
  RNS_COMPLETE

} nibble_read_states_t;

typedef enum
{
  WFPP_INIT,
  WFPP_INTERRUPT,
  WFPP_POLLED,
  WFPP_WAIT_FIFO_EMPTY,
  WFPP_TIMEOUT,
  WFPP_COMPLETE

} fpp_write_states_t;

/*-------------------*/
/* states - parecp.c */
/*-------------------*/
typedef enum
{
  RECP_INIT,
  RECP_WAIT_REVERSE0,
  RECP_WAIT_REVERSE,
  RECP_REV_IDLE,
  RECP_INTERRUPT,
  RECP_POLLED,
  RECP_XFER_COMPLETE,
  RECP_WAIT_FORWARD,
  RECP_COMPLETE

} ecp_read_states_t;

typedef enum
{
  WECP_INIT,
  WECP_MODE3_XFER,
  WECP_INTERRUPT,
  WECP_POLLED,
  WECP_WAIT_FIFO_EMPTY,
  WECP_RLE_SCAN,
  WECP_SEND_RLE_COUNT,
  WECP_SEND_RLE_DATA,
  WECP_SEND_DATA,
  WECP_TIMEOUT,
  WECP_COMPLETE

} ecp_write_states_t;

/*-------------------*/
/* states - parepp.c */
/*-------------------*/
typedef enum
{
  REPP_INIT,
  REPP_DO_READ,
  REPP_COMPLETE

} epp_read_states_t;

typedef enum
{
  WEPP_INIT,
  WEPP_DO_WRITE,
  WEPP_COMPLETE

} epp_write_states_t;

/*---------------------*/
/* states - parioctl.c */
/*---------------------*/
typedef enum
{
  RST_INIT,
  RST_WAIT_READY,
  RST_COMPLETE

} rst_states_t;

/*--------------*/
/* return codes */
/*--------------*/
typedef enum
{
  RC_SUCCESS,
  RC_TIMEOUT,
  RC_CANCELLED,
  RC_UNKNOWN_DEVICE,
  RC_NOT_1284_DEVICE,
  RC_INVALID_MODE,
  RC_NO_MORE_DEVICES,
  RC_DEVICE_IN_USE,
  RC_INVALID_DEVICE_HANDLE,
  RC_INVALID_PARM

} return_code_t;

#define PAR_INVALID_COMM_MODE           0xFE

#define MAX_PARALLEL_CMD                0x1F
#define MAX_VIDC_CMD                    0x04
