/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/parallel/par1284/parregs.h, par1284, c.basedd 97/02/04" */
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  PARREGS.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  PARALLEL port register definitions.                   */
/*                                                                            */
/*   FUNCTION: This module is the PARALLEL port device driver register        */
/*             definitions include file.                                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/03/01  Frank Schroeder                                         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/*--------------------------------------------------------------*/
/*                                                              */
/* Note: PAR_IORANGE_1 is normally located at PAR_IORANGE_0+400 */
/*                                                              */
/* The add driver treats each port range as a separate 0-based  */
/* PIO object so the 0x0400 offset between the two ranges is    */
/* not applied.                                                 */
/*                                                              */
/* For the primary parallel port, the PIO objects should map to */
/* the following x86 IO Ports:                                  */
/*                                                              */
/* PAR_IORANGE_0  - 0x3BC to 0x3BF                              */
/* PAR_IORANGE_1  - 0x7BC to 0x7BF                              */
/*                                                              */
/*--------------------------------------------------------------*/
#define PAR_IORANGE_0   0x0
#define PAR_IORANGE_1   0x0

/*----------------------------------*/
/* Compatibility Parallel Port Regs */
/*      (ECR Mode 1,2)              */
/*----------------------------------*/
#define SPP_DATA_REG            (PAR_IORANGE_0+0)

#define SPP_STATUS_REG          (PAR_IORANGE_0+1)
/*----------------------------------------*/
/* Compatibility Mode status signals      */
/*----------------------------------------*/
#define SPP_STATUS_BUSY         0x80
#define SPP_STATUS_ACK          0x40
#define SPP_STATUS_PE           0x20
#define SPP_STATUS_SELECT       0x10
#define SPP_STATUS_FAULT        0x08
#define SPP_STATUS_IRQ          0x04
#define SPP_STATUS_EPPTIMEOUT   0x01

/*---------------------------------------------*/
/* Convert negative active signals to positive */
/* active logic for driver usage.              */
/*---------------------------------------------*/
#define SPP_STATUS_INVERT       (SPP_STATUS_BUSY  | SPP_STATUS_ACK | \
                                 SPP_STATUS_FAULT | SPP_STATUS_IRQ )

#define SPP_CONTROL_REG         (PAR_IORANGE_0+2)
/*----------------------------------------*/
/* Compatibility Mode control signals     */
/*----------------------------------------*/
#define SPP_CONTROL_RESERVED    0xC0
#define SPP_CONTROL_DIR         0x20
#define SPP_CONTROL_ACKIRQ      0x10
#define SPP_CONTROL_SELECT      0x08
#define SPP_CONTROL_INIT        0x04
#define SPP_CONTROL_AFD         0x02
#define SPP_CONTROL_STROBE      0x01

/*---------------------------------------------*/
/* Convert negative active signals to positive */
/* active logic for driver usage.              */
/*---------------------------------------------*/
#define SPP_CONTROL_INVERT      (SPP_CONTROL_INIT)

/*----------------------------------------*/
/* Byte/Nibble Mode status signal aliases */
/*----------------------------------------*/

#define SPP_STATUS_ACKDATAREQ   SPP_STATUS_PE
#define SPP_STATUS_PTRCLK       SPP_STATUS_ACK
#define SPP_STATUS_DATAAVAIL    SPP_STATUS_FAULT
#define SPP_STATUS_XFLAG        SPP_STATUS_SELECT
#define SPP_STATUS_PTRBUSY      SPP_STATUS_BUSY

/*---------------------------------------------*/
/* Convert negative active signals to positive */
/* active logic for driver usage.              */
/*---------------------------------------------*/
#define SPP1284_STATUS_INVERT   (SPP_STATUS_BUSY | SPP_STATUS_FAULT)

/*-----------------------------------------*/
/* Byte/Nibble Mode control signal aliases */
/*-----------------------------------------*/

#define SPP_CONTROL_1284ACTIVE  SPP_CONTROL_SELECT
#define SPP_CONTROL_HOSTBUSY    SPP_CONTROL_AFD
#define SPP_CONTROL_HOSTCLK     SPP_CONTROL_STROBE

/*---------------------------------------------*/
/* Convert negative active signals to positive */
/* active logic for driver usage.              */
/*---------------------------------------------*/
#define SPP1284_CONTROL_INVERT (SPP_CONTROL_SELECT | SPP_CONTROL_AFD | \
                                SPP_CONTROL_INIT   | SPP_CONTROL_STROBE)

/*--------------------------------*/
/* ECP Mode status signal aliases */
/*--------------------------------*/

#define SPP_STATUS_ACKREVERSE   SPP_STATUS_PE
#define SPP_STATUS_PERIPHCLK    SPP_STATUS_ACK
#define SPP_STATUS_PERIPHACK    SPP_STATUS_BUSY
#define SPP_STATUS_PERIPHREQ    SPP_STATUS_FAULT

#define SPP1284_ECP_STATUS_INVERT  (SPP_STATUS_BUSY | SPP_STATUS_FAULT | \
                                    SPP_STATUS_PE )

/*---------------------------------*/
/* ECP Mode control signal aliases */
/*---------------------------------*/

#define SPP_CONTROL_HOSTACK     SPP_CONTROL_AFD
#define SPP_CONTROL_REVERSEREQ  SPP_CONTROL_INIT
#define SPP_CONTROL_TWOHIGHBITS 0xC0

/*-----------------------------------*/
/* Enhanced Parallel Port (EPP) Mode */
/*-----------------------------------*/
#define EPP_STATUS_REG          (PAR_IORANGE_0+1)
#define EPP_STATUS_TIMEOUT      0x01

#define EPP_ADDR_REG            (PAR_IORANGE_0+3)  /* EPP Addr Cycle             */
#define EPP_DATA_REG            (PAR_IORANGE_0+4)  /* EPP Data Cycle 8,16,32 Bit */

/*--------------------------------*/
/* FIFO Mode                      */
/*        (ECR Mode 2 only)       */
/*--------------------------------*/
#define SPP_DFIFO_REG           (PAR_IORANGE_1+0)  /* ECR Mode 2 Only            */

/*---------------------------------------*/
/* Extended Capabilities Port (ECP) Mode */
/*          (ECR Mode 3)                 */
/*---------------------------------------*/
#define ECP_AFIFO_REG           (PAR_IORANGE_0+0)  /* ECP Addr Cycle             */
#define ECP_DFIFO_REG           (PAR_IORANGE_1+0)  /* ECP Data Cycle             */

/*---------------------------------------*/
/* Extended Capabilities Port (ECP) Mode */
/*          (ECR Mode 6)                 */
/*---------------------------------------*/
#define ECP_TFIFO_REG           (PAR_IORANGE_1+0)  /* Test Data Cycle            */

/*----------------------------------*/
/* Configuration Mode Registers     */
/*          (ECR Mode 7)            */
/*----------------------------------*/
#define ECP_CFGA_REG            (PAR_IORANGE_1+0)
#define ECP_SUPPORTED           0x10

#define ECP_CFGB_REG            (PAR_IORANGE_1+1)
#define ECP_CFGB_HWCMP          0x80
#define ECP_CFGB_IRQ            0x40

/*----------------------------------*/
/* Extended Control Reg (All Modes) */
/*----------------------------------*/
#define EXT_CONTROL_REG         (PAR_IORANGE_1+2)

#define EXT_CONTROL_MODE        0xE0            /* Ext Mode Mask              */
#define EXT_CONTROL_MODE0       (0 << 5)        /* CPP Mode                   */
#define EXT_CONTROL_MODE1       (1 << 5)        /* Ext CPP (Bi-Di) Mode       */
#define EXT_CONTROL_MODE2       (2 << 5)        /* Ext CPP Mode w/FIFO        */
#define EXT_CONTROL_MODE3       (3 << 5)        /* ECP Mode                   */
#define EXT_CONTROL_MODE4       (4 << 5)        /*                            */
#define EXT_CONTROL_MODE5       (5 << 5)        /* Reserved                   */
#define EXT_CONTROL_MODE6       (6 << 5)        /* Test Mode                  */
#define EXT_CONTROL_MODE7       (7 << 5)        /* Config Mode                */

#define EXT_CONTROL_NOERRIRQ    0x10
#define EXT_CONTROL_DMA         0x08
#define EXT_CONTROL_FIFOIRQ     0x04
#define EXT_CONTROL_FIFOFULL    0x02
#define EXT_CONTROL_FIFOEMPTY   0x01

#define MAX_FIFO_DEPTH            64

#define EXT_CONTROL_INVERT      EXT_CONTROL_FIFOIRQ

/*----------------------------------*/
/* Delays are in milliseconds       */
/*----------------------------------*/
#define DELAY_OS_MIN            32         /* OS/2 WARP V4.0 minimum is 32ms. */
#define DELAY1284_TL            35
#define DELAY1284_SETUP         100
#define DELAY1284_TP            500
#define DELAY1284_TH            1000


#define MAX_RESET_TIMEOUT_MS    (10*1000L)      /* 10s   */
#define MAX_BUSY_WAIT_NS        (500*1000L)     /* 500us */
#define MAX_BUSY_WAIT_500NS_COUNT 1000L

#define NEGOTIATE_NIBBLE_MODE   0x00
#define NEGOTIATE_BYTE_MODE     0x01
#define NEGOTIATE_DEVICE_ID     0x04
#define NEGOTIATE_ECP_MODE      0x10
#define NEGOTIATE_ECP_RLE_MODE  0x30
#define NEGOTIATE_EPP_MODE      0x40
